/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.text.internal.ui.dialogs;

import com.deltawalker.ContentTypeEntry;
import com.deltawalker.DocType;
import com.deltawalker.text.internal.TextMsg;
import com.deltopia.StringUtil;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ContentTypeEntryDialog
extends TrayDialog {
    private Combo cbDocType;
    private ContentTypeEntry entry;
    private Text txtExtension;

    public ContentTypeEntryDialog(Shell shell, ContentTypeEntry contentTypeEntry) {
        super(shell);
        this.entry = contentTypeEntry;
        this.setHelpAvailable(false);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.getEntry() == null ? TextMsg.ContentTypeEntryDialog_addShellText : TextMsg.ContentTypeEntryDialog_editShellText);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout((Layout)gridLayout);
        composite3.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(composite3, 0);
        label.setLayoutData((Object)new GridData(16384, 4, false, true));
        label.setText(TextMsg.ContentTypeEntryDialog_extensionLabel);
        this.txtExtension = new Text(composite3, 2048);
        this.txtExtension.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label label2 = new Label(composite3, 0);
        label2.setLayoutData((Object)new GridData(16384, 4, false, true));
        label2.setText(TextMsg.ContentTypeEntryDialog_typeLabel);
        this.cbDocType = new Combo(composite3, 12);
        this.cbDocType.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        for (DocType docType : DocType.orderedTypes()) {
            String string = docType.contentDisplayName();
            if (string.isEmpty()) continue;
            this.cbDocType.add(string);
        }
        this.txtExtension.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                Button button = ContentTypeEntryDialog.this.getButton(0);
                if (button != null) {
                    button.setEnabled(ContentTypeEntryDialog.this.isValidExtension(ContentTypeEntryDialog.this.txtExtension.getText()));
                }
            }
        });
        if (this.entry == null) {
            this.txtExtension.setText("");
            this.cbDocType.select(0);
        } else {
            this.txtExtension.setText(this.entry.extension());
            this.cbDocType.select(this.entry.docType().index());
        }
        ContentTypeEntryDialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    public ContentTypeEntry getEntry() {
        return this.entry;
    }

    private boolean isValidExtension(String string) {
        return !StringUtil.isEmpty((String)string);
    }

    protected void okPressed() {
        String string = this.txtExtension.getText();
        DocType docType = DocType.fromIndex((int)this.cbDocType.getSelectionIndex());
        if (this.isValidExtension(string)) {
            this.entry = new ContentTypeEntry(string, docType, "");
            super.okPressed();
        } else {
            this.getButton(0).setEnabled(false);
        }
    }
}

