/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.text.internal.ui.actions;

import com.deltawalker.script.Role;
import com.deltawalker.text.ITextDoc;
import com.deltawalker.text.internal.TextPlugin;
import com.deltawalker.text.ui.TextDiffView;
import com.deltawalker.ui.actions.ResourceAction;
import com.deltopia.io.xml.XmlTransformer;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformXmlAction
extends ResourceAction {
    private static final Logger LOG = LoggerFactory.getLogger(TransformXmlAction.class);
    private TextDiffView tdView;
    private final XmlTransformer.Op xmlOp;

    public TransformXmlAction(ResourceBundle resourceBundle, TextDiffView textDiffView, XmlTransformer.Op op) {
        super(TextPlugin.getPluginId(), resourceBundle, op == XmlTransformer.Op.PRETTIFY ? "PrettifyXmlAction." : "CanonicalizeXmlAction.", 1);
        this.tdView = textDiffView;
        this.xmlOp = op;
        this.setId(op == XmlTransformer.Op.PRETTIFY ? "prettifyXml" : "canonicalizeXml");
    }

    public void run() {
        Role role = this.tdView.getFocusRole();
        if (role == null) {
            assert (false);
            return;
        }
        ITextDoc iTextDoc = (ITextDoc)this.tdView.getInput().doc(0, role);
        try {
            String string = iTextDoc.document().get();
            string = XmlTransformer.transform((String)string, (XmlTransformer.Op)this.xmlOp);
            iTextDoc.document().set(string);
        }
        catch (Throwable throwable) {
            iTextDoc.setUriInfoError(throwable);
            LOG.error(throwable.getMessage());
        }
    }
}

