/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.text.internal.ui.actions;

import com.deltawalker.script.Role;
import com.deltawalker.text.ITextDoc;
import com.deltawalker.text.TextDoc;
import com.deltawalker.text.internal.TextPlugin;
import com.deltawalker.text.internal.ui.dialogs.SelectEncodingDialog;
import com.deltawalker.text.ui.TextDiffView;
import com.deltawalker.ui.EncodingChooser;
import com.deltawalker.ui.IApplyListener;
import com.deltawalker.ui.actions.ResourceAction;
import java.util.ResourceBundle;
import org.eclipse.ui.texteditor.IUpdate;

public class ReopenWithEncodingAction
extends ResourceAction
implements IUpdate {
    private TextDiffView tdView;

    public ReopenWithEncodingAction(ResourceBundle resourceBundle, TextDiffView textDiffView) {
        super(TextPlugin.getPluginId(), resourceBundle, null, 1);
        this.tdView = textDiffView;
        this.setId("setEncoding");
        this.setActionDefinitionId("com.deltawalker.text.ui.file.setEncoding");
    }

    public void run() {
        final Role role = this.tdView.getFocusRole();
        assert (false);
        IApplyListener iApplyListener = new IApplyListener(){

            public void applyPressed(EncodingChooser encodingChooser) {
                TextDoc textDoc = (TextDoc)ReopenWithEncodingAction.this.tdView.doc(role);
                if (encodingChooser.isCharsetSelected()) {
                    textDoc.setEncoding(encodingChooser.getSelectedEncoding(false), true);
                } else {
                    textDoc.setLocale(encodingChooser.getSelectedLocale(), true);
                }
            }
        };
        ITextDoc iTextDoc = (ITextDoc)this.tdView.doc(role);
        SelectEncodingDialog selectEncodingDialog = new SelectEncodingDialog(this.tdView.getControl().getShell(), iTextDoc.getEncoding(), iTextDoc.getLocale(), iApplyListener, iTextDoc.preferences());
        selectEncodingDialog.open();
        this.tdView.setFocus(role);
    }

    public void update() {
        Role role = this.tdView.getFocusRole();
        if (role == null) {
            this.setEnabled(false);
            return;
        }
        ITextDoc iTextDoc = (ITextDoc)this.tdView.doc(role);
        this.setEnabled(iTextDoc.resource() != null);
    }
}

