/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.text.internal.ui.actions;

import com.deltawalker.LineEndingUtil;
import com.deltawalker.text.ITextDoc;
import com.deltawalker.text.internal.TextMsg;
import com.deltawalker.ui.DiffView;
import com.deltopia.util.OS;
import org.eclipse.jface.action.Action;

public class ConvertLineEndingsAction
extends Action {
    private final String ending;
    private final DiffView view;

    public ConvertLineEndingsAction(String string, DiffView diffView) {
        this.ending = LineEndingUtil.nameFromEnding((String)string);
        if ("\r\n".equals(string)) {
            this.setId("convertLineEndingsToWindows");
            this.setActionDefinitionId("com.deltawalker.text.ui.file.convertLineEndingsToWindows");
        } else if ("\n".equals(string)) {
            this.setId("convertLineEndingsToUnix");
            this.setActionDefinitionId("com.deltawalker.text.ui.file.convertLineEndingsToUnix");
        } else if ("\r".equals(string)) {
            this.setId("convertLineEndingsToMacOS9");
            this.setActionDefinitionId("com.deltawalker.text.ui.file.convertLineEndingsToMacOS9");
        } else assert (false);
        this.view = diffView;
    }

    public String getText() {
        if (OS.WIN) {
            if (this.getId().equals("convertLineEndingsToWindows")) {
                return String.valueOf(TextMsg.ConvertLineEndingsAction_menuItem_label_windows) + ' ' + TextMsg.ConvertLineEndingsAction_menuItem_label_suffix;
            }
        } else if (this.getId().equals("convertLineEndingsToUnix")) {
            return String.valueOf(TextMsg.ConvertLineEndingsAction_menuItem_label_unix) + ' ' + TextMsg.ConvertLineEndingsAction_menuItem_label_suffix;
        }
        return super.getText();
    }

    public void run() {
        ITextDoc iTextDoc = (ITextDoc)this.view.doc(this.view.getFocusRole());
        iTextDoc.setLineEnding(this.ending);
    }
}

