/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.text.internal.ui;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.JFaceTextUtil;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;

public final class TextViewerUtil {
    private static final boolean USE_STYLED_TEXT = false;

    public static Point lineIndexRangeFromPosition(ITextViewer iTextViewer, Position position) {
        int n;
        if (iTextViewer == null) {
            throw new NullPointerException("tViewer");
        }
        if (position == null) {
            return new Point(0, 0);
        }
        Point point = new Point(0, 0);
        IDocument iDocument = iTextViewer.getDocument();
        int n2 = iDocument.getLength();
        if (n2 == 0) {
            return point;
        }
        if (position.offset == n2) {
            int n3;
            int n4;
            try {
                n4 = iDocument.getLineOfOffset(position.offset);
                if (position.offset == iDocument.getLineOffset(n4)) {
                    n3 = 1;
                } else {
                    ++n4;
                    n3 = 0;
                }
            }
            catch (BadLocationException badLocationException) {
                n4 = iDocument.getNumberOfLines();
                n3 = 0;
            }
            point.x = n4;
            point.y = n3;
            return point;
        }
        if (position.offset < 0 || n2 < position.offset) {
            return point;
        }
        try {
            n = iDocument.getLineOfOffset(position.offset);
        }
        catch (BadLocationException badLocationException) {
            n = 0;
        }
        int n5 = 0;
        if (position.length > 0) {
            int n6;
            try {
                int n7 = position.offset + position.length;
                if (n7 <= 0) {
                    return point;
                }
                if (n7 < n2) {
                    n6 = iDocument.getLineOfOffset(n7);
                } else {
                    int n8 = iDocument.getNumberOfLines();
                    n6 = n7 == n2 && (n8 == 0 || iDocument.getLineLength(n8 - 1) == 0) ? iDocument.getLineOfOffset(n7) : n8;
                }
            }
            catch (BadLocationException badLocationException) {
                n6 = n;
            }
            n5 = n6 - n;
        }
        point.x = n;
        point.y = n5;
        return point;
    }

    public static Point linePixelRangeFromPosition(ITextViewer iTextViewer, Position position) {
        Point point = TextViewerUtil.lineIndexRangeFromPosition(iTextViewer, position);
        if (point.x == -1 && point.y == -1) {
            return point;
        }
        StyledText styledText = iTextViewer.getTextWidget();
        int n = point.x;
        int n2 = point.y;
        point.x = styledText.getLinePixel(n);
        if (point.y > 0) {
            point.y = styledText.getLinePixel(n + n2) - point.x;
        }
        return point;
    }

    public static int positionHeight(ITextViewer iTextViewer, Position position) {
        if (iTextViewer.getTextWidget().getWordWrap()) {
            return TextViewerUtil.linePixelRangeFromPosition((ITextViewer)iTextViewer, (Position)position).y;
        }
        return TextViewerUtil.lineIndexRangeFromPosition((ITextViewer)iTextViewer, (Position)position).y;
    }

    public static int visibleLineCount(ITextViewer iTextViewer) {
        int n = 0;
        ILineRange iLineRange = JFaceTextUtil.getVisibleModelLines((ITextViewer)iTextViewer);
        if (iLineRange != null) {
            n = iLineRange.getNumberOfLines();
        }
        return n;
    }

    public static Point visibleLinePixelRange(ITextViewer iTextViewer) {
        Point point = new Point(0, 0);
        ILineRange iLineRange = JFaceTextUtil.getVisibleModelLines((ITextViewer)iTextViewer);
        if (iLineRange == null) {
            return point;
        }
        StyledText styledText = iTextViewer.getTextWidget();
        int n = iLineRange.getStartLine();
        int n2 = iLineRange.getNumberOfLines();
        point.x = styledText.getLinePixel(n);
        if (n2 > 0) {
            point.y = styledText.getLinePixel(n + n2) - point.x;
        }
        return point;
    }

    private TextViewerUtil() {
    }
}

