/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.text.internal.ui;

import com.deltawalker.differencer.range.DiffRange;
import com.deltawalker.interfaces.ITextDiffModel;
import com.deltawalker.script.Delta;
import com.deltawalker.script.Role;
import com.deltawalker.text.internal.ui.TextViewerUtil;
import com.deltawalker.text.ui.TextDiffView;
import com.deltawalker.ui.DeltaPart;
import com.deltawalker.ui.DiffView;
import com.deltawalker.ui.Sash;
import com.deltopia.ui.Direction;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;

public class TextSash
extends Sash {
    private static final boolean SPLINE_CONNECTED_CENTER = true;
    private double[] baseCenterCurve;
    private int baseCenterCurveWidth;
    private final Role[] roles;
    private boolean useSingleLine = true;
    protected final DiffView view;

    public TextSash(Composite composite, DiffView diffView, Set<Role> set, EnumSet<Direction> enumSet, boolean bl, Sash sash) {
        super(composite, 0x20000000, diffView, enumSet, bl, sash);
        this.view = diffView;
        this.roles = set.toArray(new Role[set.size()]);
    }

    private double[] getBaseCenterCurve(int n) {
        if (this.baseCenterCurve == null || this.baseCenterCurveWidth != n) {
            int n2 = this.width();
            this.baseCenterCurve = new double[n2];
            double d = n;
            int n3 = 0;
            while (n3 < n2) {
                this.baseCenterCurve[n3] = Math.cos(Math.PI * (double)n3 / d);
                ++n3;
            }
        }
        return this.baseCenterCurve;
    }

    private int[] getCenterCurvePoints(int n, int n2, int n3, int n4) {
        int n5 = n3 - n;
        double[] dArray = this.getBaseCenterCurve(n5);
        double d = (double)(n4 - n2) / 2.0;
        int[] nArray = new int[n5];
        int n6 = 0;
        while (n6 < n5) {
            nArray[n6] = (int)(-d * dArray[n6] + d + (double)n2);
            ++n6;
        }
        return nArray;
    }

    private int getCenterMarginWidth() {
        return 3;
    }

    private Position[] getPositions(DiffRange diffRange) {
        Position[] positionArray = new Position[]{diffRange.position(this.roles[0]), diffRange.position(this.roles[1])};
        return positionArray;
    }

    public boolean getUseSingleLine() {
        return this.useSingleLine;
    }

    protected void paint(PaintEvent paintEvent) {
        super.paint(paintEvent);
        GC gC = paintEvent.gc;
        TextDiffView textDiffView = (TextDiffView)this.view;
        ITextDiffModel iTextDiffModel = textDiffView.deltaModel();
        if (!textDiffView.isSyncedVScrolling()) {
            return;
        }
        ISourceViewer iSourceViewer = textDiffView.viewer(this.roles[0]);
        ISourceViewer iSourceViewer2 = textDiffView.viewer(this.roles[1]);
        List list = iTextDiffModel.getDeltas();
        int n = 4 * (paintEvent.y + paintEvent.height);
        int n2 = this.getCenterMarginWidth();
        Point point = TextViewerUtil.visibleLinePixelRange((ITextViewer)iSourceViewer);
        Point point2 = TextViewerUtil.visibleLinePixelRange((ITextViewer)iSourceViewer2);
        for (DiffRange diffRange : list) {
            Position[] positionArray;
            if (diffRange.isSame()) continue;
            Position position = diffRange.position(this.roles[0]);
            Position position2 = diffRange.position(this.roles[1]);
            if (position == null || position.offset < point.x || position2 == null || position2.offset < point2.x || (positionArray = this.getPositions(diffRange)).length == 0) continue;
            Point point3 = TextViewerUtil.linePixelRangeFromPosition((ITextViewer)iSourceViewer, positionArray[0]);
            int n3 = point3.x;
            int n4 = point3.y;
            Point point4 = TextViewerUtil.linePixelRangeFromPosition((ITextViewer)iSourceViewer2, positionArray[1]);
            int n5 = point4.x;
            int n6 = point4.y;
            if (n3 >= n || n5 >= n) break;
            Color color = iSourceViewer.getTextWidget().getBackground();
            Color color2 = textDiffView.getColor((Delta)diffRange, DeltaPart.BORDER);
            boolean bl = diffRange.shouldSkipPaint(this.roles[0]);
            boolean bl2 = diffRange.shouldSkipPaint(this.roles[1]);
            this.paintCenter(gC, color, color2, paintEvent.x, paintEvent.width, n2, n3, n4, n5, n6, bl, bl2);
        }
    }

    private void paintCenter(GC gC, Color color, Color color2, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, boolean bl2) {
        block6: {
            block5: {
                if (bl2) {
                    gC.setBackground(color);
                    gC.fillRectangle(0, n4, n3, n5);
                    gC.setLineWidth(1);
                    gC.setForeground(color2);
                    gC.drawRectangle(-1, n4, n3, n5);
                    return;
                }
                if (!this.useSingleLine) break block5;
                gC.setBackground(color);
                if (!bl) {
                    gC.fillRectangle(0, n4, n3, n5);
                }
                gC.fillRectangle(n2 - n3, n6, n3, n7);
                gC.setLineWidth(1);
                gC.setForeground(color2);
                if (!bl) {
                    gC.drawRectangle(-1, n4, n3, n5);
                }
                gC.drawRectangle(n2 - n3, n6, n3, n7);
                int[] nArray = this.getCenterCurvePoints(n3, n4 + n5 / 2, n2 - n3, n6 + n7 / 2);
                if (bl) break block6;
                int n8 = 1;
                while (n8 < nArray.length) {
                    gC.drawLine(n3 + n8 - 1, nArray[n8 - 1], n3 + n8, nArray[n8]);
                    ++n8;
                }
                break block6;
            }
            int[] nArray = new int[]{n, n4, n2, n6, n2, n6 + n7, n, n4 + n5};
            gC.setBackground(color);
            gC.setLineWidth(1);
            gC.setForeground(color2);
            int[] nArray2 = this.getCenterCurvePoints(nArray[0], nArray[1], nArray[2], nArray[3]);
            int[] nArray3 = this.getCenterCurvePoints(nArray[6], nArray[7], nArray[4], nArray[5]);
            gC.setForeground(color);
            gC.drawLine(0, nArray3[0], 0, nArray2[0]);
            int n9 = 1;
            while (n9 < nArray3.length) {
                gC.setForeground(color);
                gC.drawLine(n9, nArray3[n9], n9, nArray2[n9]);
                gC.setForeground(color2);
                gC.drawLine(n9 - 1, nArray2[n9 - 1], n9, nArray2[n9]);
                gC.drawLine(n9 - 1, nArray3[n9 - 1], n9, nArray3[n9]);
                ++n9;
            }
        }
    }

    public void setUseSingleLine(boolean bl) {
        if (this.useSingleLine != bl) {
            this.useSingleLine = bl;
            this.redraw();
        }
    }
}

