/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.text.internal.ui;

import com.deltawalker.differencer.range.DiffRange;
import com.deltawalker.script.Delta;
import com.deltawalker.script.Role;
import com.deltawalker.text.ui.TextDiffView;
import com.deltawalker.ui.DeltaColor;
import com.deltawalker.ui.DeltaPart;
import com.deltawalker.ui.DiffView;
import com.deltawalker.ui.printing.DiffViewPrintOp;
import com.deltawalker.ui.printing.HeaderFooterPrintOp;
import com.deltawalker.ui.printing.IPrinter;
import com.deltopia.util.Checker;
import com.deltopia.util.OS;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.editors.text.EditorsUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextPrintOp
extends DiffViewPrintOp {
    private static final Logger LOG = LoggerFactory.getLogger(TextPrintOp.class);
    private static final int LINE_NUMBER_COL_SPACING = 10;
    private static final int UNKNOWN_LINE_NUMBER = 0;
    private int lnNumColSpace;
    private final TextDiffView tdView;

    public TextPrintOp(TextDiffView textDiffView, IPrinter iPrinter, IProgressMonitor iProgressMonitor) {
        super((DiffView)textDiffView, iPrinter, iProgressMonitor);
        this.tdView = textDiffView;
        final Display display = textDiffView.getControl().getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                TextPrintOp.this.setFontData(TextPrintOp.this.tdView.viewer(Role.REF).getTextWidget().getFont().getFontData()[0]);
                TextPrintOp.this.lnNumColSpace = ((TextPrintOp)TextPrintOp.this).toPrinterSize((Point)display.getDPI(), (int)10, (int)0).x;
            }
        });
    }

    private void drawLineNumbers(DiffLayout diffLayout, int n, int n2, int n3) {
        if (diffLayout.lnNumColWidth > 0) {
            TextLayout textLayout = diffLayout.txLayout;
            int n4 = 0;
            int n5 = diffLayout.lnNumColWidth - this.lnNumColSpace;
            int n6 = 0;
            int n7 = n;
            while (n2 > 0) {
                int n8;
                int n9;
                n6 = diffLayout.getLineLength(n7);
                n2 -= n6;
                boolean bl = false;
                if (!OS.GTK) {
                    bl = true;
                    String string = diffLayout.getLine(n7);
                    n9 = string.length();
                    int n10 = 0;
                    while (n10 < n9) {
                        char c = string.charAt(n10);
                        if (c != '\r' && c != '\n') {
                            bl = false;
                            break;
                        }
                        ++n10;
                    }
                }
                if (!bl && (n8 = diffLayout.getLineNumber(n7)) != 0) {
                    n9 = n7 == n ? 0 : textLayout.getLineBounds((int)n7).y - n4;
                    this.drawText(Integer.toString(n8), diffLayout.x, n3 + n9, n5, -1, 131072);
                }
                if (n7 == n) {
                    n4 = textLayout.getLineBounds((int)n7).y;
                }
                ++n7;
            }
        }
    }

    protected int getCenterWidth() {
        final int[] nArray = new int[1];
        this.tdView.getControl().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                int n;
                Composite composite = TextPrintOp.this.tdView.getControl();
                if (composite != null && !composite.isDisposed() && (n = composite.getSize().x) > 0) {
                    nArray[0] = TextPrintOp.this.tdView.getSashWidth() * ((TextPrintOp)TextPrintOp.this).getPrintableArea().width / n;
                    return;
                }
                nArray[0] = Math.round(0.5f * (float)((TextPrintOp)TextPrintOp.this).getPrinterDPI().x);
            }
        });
        return nArray[0];
    }

    private int getLineNumberRulerColumnWidth(Role role) {
        if (EditorsUI.getPreferenceStore().getBoolean("lineNumberRuler")) {
            int n = this.tdView.viewer(role).getDocument().getNumberOfLines();
            return this.textExtent((String)Integer.toString((int)n)).x + this.lnNumColSpace;
        }
        return 0;
    }

    private String getVisibleContent(DiffLayout diffLayout, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        TextLayout textLayout = diffLayout.txLayout;
        String string = textLayout.getText();
        int[] nArray = diffLayout.getLineOffsets();
        int n3 = diffLayout.lnHeight;
        int n4 = 0;
        int n5 = n;
        while (n5 < nArray.length - 1) {
            String string2 = string.substring(nArray[n5], nArray[n5 + 1]);
            boolean bl = true;
            boolean bl2 = false;
            int n6 = string2.length();
            int n7 = 0;
            while (n7 < n6) {
                char c = string2.charAt(n7);
                if (c != '\r' && c != '\n') {
                    bl = false;
                    break;
                }
                ++n7;
            }
            if (!bl2) {
                if (bl) {
                    n7 = textLayout.getLineBounds((int)n5).height;
                } else if (n3 == 0) {
                    n7 = n3 = textLayout.getLineBounds((int)n5).height;
                    diffLayout.lnHeight = n3;
                } else {
                    n7 = n3;
                }
                if ((n4 += n7) > n2) break;
            }
            stringBuffer.append(string2);
            ++n5;
        }
        return stringBuffer.toString();
    }

    protected HeaderFooterPrintOp newInstance(IPrinter iPrinter, IProgressMonitor iProgressMonitor) {
        return new TextPrintOp(this.tdView, iPrinter, iProgressMonitor);
    }

    private int print(DiffLayout[] diffLayoutArray, boolean bl, int n, Color color, Color color2) {
        DiffLayout diffLayout;
        int n2 = diffLayoutArray.length;
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        int[][] nArrayArray = new int[n2][];
        int n3 = 0;
        while (n3 < n2) {
            diffLayout = diffLayoutArray[n3];
            nArray[n3] = diffLayout.txLayout.getText().length();
            nArrayArray[n3] = diffLayout.getLineOffsets();
            ++n3;
        }
        boolean[] blArray = new boolean[n2];
        diffLayout = this.getPrintableArea();
        while (true) {
            int n4;
            int n5;
            int n6;
            DiffLayout diffLayout2;
            Object object;
            boolean bl2 = true;
            int n7 = 0;
            while (n7 < n2) {
                blArray[n7] = nArray[n7] - nArrayArray[n7][nArray2[n7]] > 0;
                if (blArray[n7]) {
                    bl2 = false;
                }
                ++n7;
            }
            if (bl2) break;
            if (n == ((Rectangle)diffLayout).y && !this.startPage()) {
                return Integer.MIN_VALUE;
            }
            Point[] pointArray = new Point[n2];
            int n8 = 0;
            while (n8 < n2) {
                if (blArray[n8]) {
                    DiffLayout diffLayout3 = diffLayoutArray[n8];
                    object = this.getVisibleContent(diffLayout3, nArray2[n8], ((Rectangle)diffLayout).height + ((Rectangle)diffLayout).y - n);
                    if (((String)object).isEmpty()) {
                        this.endPage();
                        n = ((Rectangle)diffLayout).y;
                        break;
                    }
                    int n9 = diffLayout3.textWidth;
                    pointArray[n8] = this.textExtent((String)object, n9);
                    diffLayout2 = pointArray[n8];
                    n6 = diffLayout3.textX;
                    if (color != null) {
                        this.fillRectangle(n6, n, n9, ((Point)diffLayout2).y, color);
                    }
                    this.drawText((String)object, n6, n, n9);
                    n5 = nArray2[n8];
                    n4 = ((String)object).length();
                    this.drawLineNumbers(diffLayout3, n5, n4, n);
                    this.drawRectangle(diffLayout3.x, n, diffLayout3.width, ((Point)diffLayout2).y, color2, 0);
                    int[] nArray3 = nArrayArray[n8];
                    int n10 = nArray3[n5] + n4;
                    nArray2[n8] = n10 == nArray[n8] ? nArray3.length - 1 : diffLayout3.txLayout.getLineIndex(n10);
                }
                ++n8;
            }
            n8 = 0;
            int n11 = 0;
            while (n11 < n2) {
                object = pointArray[n11];
                if (object != null && n8 < ((Point)object).y) {
                    n8 = ((Point)object).y;
                }
                ++n11;
            }
            if (bl && n8 != 0) {
                n11 = n2 - 1;
                int n12 = 0;
                while (n12 < n2) {
                    Point point = pointArray[n12];
                    diffLayout2 = diffLayoutArray[n12];
                    n6 = diffLayout2.x;
                    n5 = n;
                    n4 = diffLayout2.width;
                    if (point == null) {
                        this.drawLine(n6, n5, n6 + n4, n5, color2);
                    } else {
                        n5 += point.y / 2;
                    }
                    if (n12 != n11) {
                        int n13 = n12 + 1;
                        DiffLayout diffLayout4 = diffLayoutArray[n13];
                        Point point2 = pointArray[n13];
                        int n14 = n;
                        if (point2 != null) {
                            n14 += point2.y / 2;
                        }
                        this.drawLine(n6 + n4, n5, diffLayout4.x, n14, color2);
                    }
                    ++n12;
                }
            }
            n += n8;
        }
        return n;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int print(DiffRange var1_1, int[] var2_2, int var3_3, int var4_4, int var5_5) {
        Checker.notNull((Object)var1_1, (String)"delta");
        Checker.notNull((Object)var2_2, (String)"roleAreaXX");
        var6_6 = this.roles.length;
        if (var2_2.length < var6_6) {
            throw new IllegalArgumentException("roleAreaXX " + var2_2.length + " shorter than roles count " + var6_6);
        }
        var7_7 = this.diffColor();
        var8_8 = var7_7.colorFromRgb(DeltaColor.getColor((Delta)var1_1, (DeltaPart)DeltaPart.BG, (boolean)false));
        var9_9 = var7_7.colorFromRgb(DeltaColor.getColor((Delta)var1_1, (DeltaPart)DeltaPart.FG, (boolean)false));
        var10_10 = new DiffLayout[var6_6];
        try {
            var11_11 = 0;
            while (var11_11 < var6_6) {
                var10_10[var11_11] = new DiffLayout(var1_1, this.roles[var11_11], var2_2[var11_11], var4_4, var5_5);
                ++var11_11;
            }
            var13_12 = this.print(var10_10, var1_1.isSame() == false, var3_3, var8_8, var9_9);
            return var13_12;
        }
        finally {
            var14_13 = 0;
            ** while (var14_13 < var10_10.length)
        }
lbl-1000:
        // 1 sources

        {
            var15_15 = var10_10[var14_13];
            try {
                var15_15.dispose();
            }
            catch (Exception v0) {
                TextPrintOp.LOG.warn("Failed to dispose layout for role " + var14_13);
            }
            ++var14_13;
            continue;
        }
lbl31:
        // 1 sources

        return var13_12;
    }

    protected void print(Rectangle rectangle, int[] nArray, int n) {
        int n2;
        int n3 = this.roles.length;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n3) {
            n2 = this.getLineNumberRulerColumnWidth(this.roles[n5]);
            if (n4 < n2) {
                n4 = n2;
            }
            ++n5;
        }
        n2 = n - n4;
        List<DiffRange> list = this.tdView.getDeltas();
        int n6 = rectangle.y;
        for (DiffRange diffRange : list) {
            if (this.pm.isCanceled()) {
                return;
            }
            if ((n6 = this.print(diffRange, nArray, n6, n4, n2)) != Integer.MIN_VALUE) continue;
            return;
        }
    }

    private class DiffLayout {
        private final IDocument document;
        public int lnHeight;
        public final int lnNumColWidth;
        private int[] lnOffsets;
        private final Position position;
        public final int textWidth;
        public final int textX;
        public final TextLayout txLayout;
        public final int width;
        public final int x;

        public DiffLayout(DiffRange diffRange, Role role, int n, int n2, int n3) {
            this.x = n;
            this.lnNumColWidth = n2;
            this.textWidth = n3;
            this.document = TextPrintOp.this.tdView.viewer(role).getDocument();
            this.position = diffRange.position(role);
            String string = this.getContent(this.document, this.position);
            this.txLayout = TextPrintOp.this.createTextLayout(string, n3);
            this.textX = n + n2;
            this.width = n2 + n3;
        }

        public void dispose() {
            TextPrintOp.this.disposeTextLayout(this.txLayout);
        }

        private String getContent(IDocument iDocument, Position position) {
            String string;
            try {
                string = iDocument.get(position.offset, position.length);
                if (string.isEmpty()) {
                    return string;
                }
            }
            catch (BadLocationException badLocationException) {
                return "";
            }
            string = string.replaceAll("\\t", " ");
            return string;
        }

        public String getLine(int n) {
            int[] nArray = this.getLineOffsets();
            if (n == nArray.length - 1) {
                return "";
            }
            int n2 = nArray[n];
            try {
                return this.document.get(this.position.offset + n2, nArray[n + 1] - n2);
            }
            catch (BadLocationException badLocationException) {
                throw new IllegalArgumentException("lineIx");
            }
        }

        public int getLineLength(int n) {
            int[] nArray = this.getLineOffsets();
            return n == nArray.length - 1 ? 0 : nArray[n + 1] - nArray[n];
        }

        public int getLineNumber(int n) {
            int n2;
            int[] nArray = this.getLineOffsets();
            int n3 = this.position.offset + nArray[n];
            if (n3 > 0 && n < nArray.length - 1) {
                try {
                    n2 = this.document.getChar(n3);
                }
                catch (BadLocationException badLocationException) {
                    throw new IllegalArgumentException("lineIx");
                }
                if (n2 == 10) {
                    char c;
                    try {
                        c = this.document.getChar(n3 - 1);
                    }
                    catch (BadLocationException badLocationException) {
                        throw new IllegalStateException(badLocationException);
                    }
                    if (c == '\r') {
                        ++n3;
                    }
                }
            }
            try {
                n2 = this.document.getLineOfOffset(n3);
                if (this.document.getLineOffset(n2) == n3) {
                    return n2 + 1;
                }
                return 0;
            }
            catch (BadLocationException badLocationException) {
                throw new IllegalArgumentException("lineIx");
            }
        }

        public int[] getLineOffsets() {
            if (this.lnOffsets == null) {
                this.lnOffsets = this.txLayout.getLineOffsets();
            }
            return this.lnOffsets;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("position=" + this.position);
            stringBuilder.append(" textX=" + this.textX);
            stringBuilder.append(" textWidth=" + this.textWidth);
            stringBuilder.append(" width=" + this.width);
            stringBuilder.append(" txLayout=" + this.txLayout);
            return stringBuilder.toString();
        }
    }
}

