/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.text.internal.ui;

import com.deltawalker.Relation;
import com.deltawalker.differencer.range.DiffRange;
import com.deltawalker.script.Delta;
import com.deltawalker.script.Role;
import com.deltawalker.text.internal.ui.TextViewerUtil;
import com.deltawalker.text.ui.TextDiffView;
import com.deltawalker.ui.DeltaPart;
import com.deltawalker.ui.Margin;
import java.util.List;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextMargin
extends Margin {
    private static final Logger LOG = LoggerFactory.getLogger(Margin.class);
    private final Role role;
    protected final TextDiffView tdView;

    public TextMargin(Composite composite, TextDiffView textDiffView, Role role) {
        super(composite);
        this.tdView = textDiffView;
        this.role = role;
        final StyledText styledText = textDiffView.viewer(role).getTextWidget();
        textDiffView.editor(role).sourceViewer().getTextWidget().addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent controlEvent) {
            }

            public void controlResized(ControlEvent controlEvent) {
                if (styledText.getWordWrap()) {
                    TextMargin.this.redraw();
                }
            }
        });
    }

    protected void paint(PaintEvent paintEvent) {
        boolean bl = this.tdView.isThreeWay();
        if (!bl && this.role == Role.TWO) {
            return;
        }
        Role role = Relation.lastRole((boolean)bl);
        boolean bl2 = this.role == role ? this.tdView.getOrientation() != 256 : false;
        List list = this.tdView.deltaModel().getDeltas();
        ITextViewer iTextViewer = this.tdView.contentArea(this.role).sourceViewer();
        GC gC = paintEvent.gc;
        gC.setBackground(this.getParent().getBackground());
        gC.fillRectangle(paintEvent.x, paintEvent.y, paintEvent.width, paintEvent.height);
        int n = paintEvent.y + paintEvent.height;
        Point point = TextViewerUtil.visibleLinePixelRange(iTextViewer);
        for (DiffRange diffRange : list) {
            Position position = diffRange.position(this.role);
            if (position.offset < point.x || diffRange.shouldSkipPaint(this.role)) continue;
            Point point2 = TextViewerUtil.linePixelRangeFromPosition(iTextViewer, position);
            int n2 = point2.x + 1;
            int n3 = point2.y;
            if (n2 + n3 <= 0) continue;
            if (n2 >= n) break;
            gC.setBackground(this.tdView.getColor((Delta)diffRange, DeltaPart.BG));
            gC.fillRectangle(bl2 ? 0 : 0, n2, 3, n3);
            gC.setLineWidth(1);
            gC.setForeground(this.tdView.getColor((Delta)diffRange, DeltaPart.BORDER));
            gC.drawRectangle(bl2 ? -1 : 0, n2 - 1, 3, n3);
        }
    }
}

