/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.text.internal.ui;

import com.deltawalker.App;
import com.deltawalker.DiffModelEvent;
import com.deltawalker.ScriptBoss;
import com.deltawalker.differencer.range.DiffRange;
import com.deltawalker.interfaces.ITextDiffModel;
import com.deltawalker.text.ui.TextDiffView;
import com.deltawalker.ui.DiffModelListener;
import com.deltawalker.ui.DiffView;
import java.util.List;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextDiffModelListener
extends DiffModelListener {
    private Boolean selectFirstDelta;
    private static final Logger LOG = LoggerFactory.getLogger(TextDiffModelListener.class);

    public TextDiffModelListener(TextDiffView textDiffView) {
        super((DiffView)textDiffView);
    }

    public void handleEvent(DiffModelEvent diffModelEvent) {
        Composite composite = this.dView.getControl();
        if (composite.isDisposed()) {
            return;
        }
        Display display = composite.getDisplay();
        final long l = System.currentTimeMillis();
        if (!Thread.currentThread().equals(display.getThread())) {
            display.syncExec(new Runnable((Control)composite, diffModelEvent){
                private final /* synthetic */ Control val$ctlView;
                private final /* synthetic */ DiffModelEvent val$event;
                {
                    this.val$ctlView = control;
                    this.val$event = diffModelEvent;
                }

                @Override
                public void run() {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Something running on the UI thread took: " + (System.currentTimeMillis() - l));
                    }
                    if (!this.val$ctlView.isDisposed()) {
                        TextDiffModelListener.this.uiHandleEvent(this.val$event);
                    }
                }
            });
        } else {
            this.uiHandleEvent(diffModelEvent);
        }
    }

    protected void onBeginCompare(Job job) {
        super.onBeginCompare(job);
        if (this.selectFirstDelta == null) {
            this.selectFirstDelta = true;
        }
        this.dView.redrawCenters();
        App.instance().scriptBoss().fireEvent(ScriptBoss.Event.COMPARE_STARTED, null, this.dView.getInput());
    }

    protected void onEndCompare() {
        super.onEndCompare();
        TextDiffView textDiffView = this.textView();
        ITextDiffModel iTextDiffModel = textDiffView.deltaModel();
        textDiffView.clearStyleBackground();
        if (this.selectFirstDelta != null && this.selectFirstDelta.booleanValue()) {
            List list = iTextDiffModel.getDeltas(true);
            for (DiffRange diffRange : list) {
                if (diffRange.isSame()) continue;
                iTextDiffModel.selectDelta(diffRange, true, true);
                this.selectFirstDelta = false;
                break;
            }
        }
        textDiffView.redrawControls(true);
        this.dView.fireDeltasChanged();
        App.instance().scriptBoss().fireEvent(ScriptBoss.Event.COMPARE_ENDED, null, this.dView.getInput());
    }

    private TextDiffView textView() {
        return (TextDiffView)this.dView;
    }

    protected boolean uiHandleEvent(DiffModelEvent diffModelEvent) {
        if (super.uiHandleEvent(diffModelEvent)) {
            return true;
        }
        boolean bl = false;
        DiffModelEvent.Type type = diffModelEvent.getType();
        switch (type) {
            case INLINE_DIFFS_CHANGED: {
                List list = (List)diffModelEvent.getDetail();
                TextDiffView textDiffView = this.textView();
                textDiffView.redrawDeltas(list, false);
                bl = true;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return bl;
    }
}

