/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.text.internal.ui;

import com.deltawalker.DocType;
import com.deltawalker.PrefKey;
import com.deltawalker.text.internal.ui.TextPrefsExpandable;
import com.deltawalker.ui.DashboardCenter;
import com.deltawalker.ui.DiffView;
import com.deltopia.interfaces.IMvcController;
import com.deltopia.interfaces.IMvcModel;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.editors.text.EditorsUI;

public class TextDashboardCenter
extends DashboardCenter {
    private TextPrefsExpandable expSettings;

    public TextDashboardCenter(Composite composite, int n, DiffView diffView) {
        super(composite, n, diffView);
    }

    public void connect(IMvcModel iMvcModel, IMvcController iMvcController) {
        if (this.deltaView().docType() == DocType.PREVIEW) {
            return;
        }
        super.connect(iMvcModel, iMvcController);
        this.createSettingsExpandable();
        this.expSettings.connect(iMvcModel, iMvcController);
        EditorsUI.getPreferenceStore().addPropertyChangeListener(this.onProp);
    }

    public void createSettingsExpandable() {
        if (this.expSettings != null) {
            return;
        }
        this.expSettings = new TextPrefsExpandable((Composite)this, this.deltaView());
    }

    public void disconnect() {
        this.expSettings.disconnect();
        EditorsUI.getPreferenceStore().removePropertyChangeListener(this.onProp);
        super.disconnect();
    }

    public void dispose() {
        try {
            this.disconnect();
            if (this.expSettings != null) {
                this.expSettings.dispose();
                this.expSettings = null;
            }
        }
        finally {
            super.dispose();
        }
    }

    protected boolean prefChanged(IPreferenceStore iPreferenceStore, String string) {
        if (this.expSettings == null || this.expSettings.isDisposed()) {
            return false;
        }
        boolean bl = true;
        if (string.equals(PrefKey.T_EXPAND_SETTINGS.toString())) {
            this.expSettings.setExpanded(iPreferenceStore.getBoolean(PrefKey.T_EXPAND_SETTINGS.toString()));
        } else {
            bl = this.expSettings.prefChanged(iPreferenceStore, string);
        }
        return bl;
    }
}

