/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.text.internal.ui;

import com.deltawalker.DocType;
import com.deltawalker.PrefKey;
import com.deltawalker.Relation;
import com.deltawalker.differencer.range.DiffRange;
import com.deltawalker.interfaces.ITextDiffModel;
import com.deltawalker.script.Delta;
import com.deltawalker.script.Role;
import com.deltawalker.text.TextDoc;
import com.deltawalker.text.internal.TextContextId;
import com.deltawalker.text.internal.TextMsg;
import com.deltawalker.text.internal.ui.DeltaSourceViewer;
import com.deltawalker.text.internal.ui.TextViewerUtil;
import com.deltawalker.text.internal.ui.editor.TextEditor;
import com.deltawalker.text.internal.ui.editor.TextEditorSite;
import com.deltawalker.text.ui.TextDiffView;
import com.deltawalker.ui.ContentArea;
import com.deltawalker.ui.ControlUtil;
import com.deltawalker.ui.DeltaPart;
import com.deltawalker.ui.DiffView;
import com.deltawalker.ui.Sash;
import com.deltawalker.ui.UIUtil;
import com.deltopia.ui.swt.IFocusNotifier;
import com.deltopia.util.OS;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextContentArea
extends ContentArea
implements IFocusNotifier {
    private static final Logger LOG = LoggerFactory.getLogger(TextContentArea.class);
    private static final boolean MEASURE_PAINT = false;
    private boolean editable = true;
    private List<FocusListener> focusListeners;
    private TextDoc textDoc;
    private TextEditor textEditor;
    private List<TraverseListener> traverseListeners;

    public TextContentArea(Composite composite, int n, TextDiffView textDiffView, Role role) {
        super(composite, n, (DiffView)textDiffView, role);
    }

    public void addFocusListener(FocusListener focusListener) {
        if (focusListener == null) {
            throw new NullPointerException("onFocus");
        }
        if (this.textEditor != null) {
            this.textEditor.sourceViewer().getTextWidget().addFocusListener(focusListener);
        } else {
            if (this.focusListeners == null) {
                this.focusListeners = new LinkedList<FocusListener>();
            }
            this.focusListeners.add(focusListener);
        }
    }

    public void addTraverseListener(TraverseListener traverseListener) {
        if (this.textEditor != null) {
            this.sourceViewer().getTextWidget().addTraverseListener(traverseListener);
        } else {
            if (this.traverseListeners == null) {
                this.traverseListeners = new LinkedList<TraverseListener>();
            }
            this.traverseListeners.add(traverseListener);
        }
    }

    private boolean confirmReadOnlyFileEditing(ISourceViewer iSourceViewer) {
        if (iSourceViewer.getTextWidget().getCharCount() <= 0 || iSourceViewer.isEditable()) {
            return false;
        }
        boolean bl = MessageDialog.openQuestion((Shell)UIUtil.getActiveWindowShell(), (String)TextMsg.TextView_promptBox_title, (String)TextMsg.TextView_promptBox_msg);
        if (bl) {
            this.deltaView().getInput().preferences().setValue(PrefKey.F_ALLOW_READONLY_EDIT.toString(), true);
            return true;
        }
        return false;
    }

    private void connectGlobalEditorActions(Role role, boolean bl) {
        IEditorSite iEditorSite = this.deltaView().getEditorSite();
        if (iEditorSite != null) {
            IEditorActionBarContributor iEditorActionBarContributor = iEditorSite.getActionBarContributor();
            iEditorActionBarContributor.setActiveEditor(bl ? this.deltaView().editor(role) : null);
        }
    }

    private void createTextEditor() {
        TextDiffView textDiffView = this.deltaView();
        this.textEditor = new TextEditor(textDiffView, this.role);
        TextEditorSite textEditorSite = this.deltaView().getEditorSite() != null ? this.deltaView().getEditorSite() : new TextEditorSite();
        try {
            this.textEditor.init(textEditorSite, (IEditorInput)this.deltaView().doc(this.role));
        }
        catch (PartInitException partInitException) {
            LOG.error(null, (Throwable)partInitException);
            this.textEditor.dispose();
            this.textEditor = null;
        }
        this.textEditor.createPartControl((Composite)this);
        textDiffView.getEditTracker().trackViewer(this.textEditor.sourceViewer());
    }

    protected TextDiffView deltaView() {
        return (TextDiffView)super.deltaView();
    }

    public void dispose() {
        if (this.textEditor != null) {
            this.textEditor.dispose();
        }
        this.textDoc = null;
        super.dispose();
    }

    private void drawDiffLines(Event event, ITextViewer iTextViewer) {
        TextDiffView textDiffView = this.deltaView();
        boolean bl = textDiffView.isThreeWay();
        if (!bl && this.role == Role.TWO) {
            return;
        }
        Caret caret = iTextViewer.getTextWidget().getCaret();
        Point point = caret.getSize();
        if (event.width == point.x && event.height == point.y) {
            return;
        }
        ITextDiffModel iTextDiffModel = textDiffView.deltaModel();
        GC gC = event.gc;
        List list = iTextDiffModel.getDeltas();
        boolean bl2 = textDiffView.shouldDoInlineDeltas();
        int n = event.y + event.height;
        Point point2 = TextViewerUtil.visibleLinePixelRange(iTextViewer);
        for (DiffRange diffRange : list) {
            Position position;
            if (diffRange.shouldSkipPaint(this.role) || (position = diffRange.position(this.role)) == null || position.offset < point2.x) continue;
            Point point3 = TextViewerUtil.linePixelRangeFromPosition(iTextViewer, diffRange.position(this.role));
            int n2 = point3.x + point3.y;
            if (n2 < 0) continue;
            if (point3.x > n) break;
            Color color = textDiffView.getColor((Delta)diffRange, DeltaPart.FG);
            gC.setForeground(color);
            gC.drawLine(0, point3.x, event.width, point3.x);
            gC.drawLine(0, n2, event.width, n2);
            if (!bl2) continue;
            iTextDiffModel.beginGetInlineDeltas(diffRange);
        }
    }

    public TextEditor getEditor() {
        if (this.textEditor == null) {
            StyledText styledText;
            this.populate();
            this.postPopulate();
            ITextViewer iTextViewer = this.sourceViewer();
            iTextViewer.setEditable(this.editable);
            if (this.textDoc != null) {
                try {
                    this.textEditor.setInput((IEditorInput)this.textDoc);
                }
                finally {
                    this.textDoc = null;
                }
            }
            if (this.traverseListeners != null) {
                styledText = iTextViewer.getTextWidget();
                for (TraverseListener traverseListener : this.traverseListeners) {
                    styledText.addTraverseListener(traverseListener);
                }
                this.traverseListeners.clear();
                this.traverseListeners = null;
            }
            if (this.focusListeners != null) {
                styledText = iTextViewer.getTextWidget();
                for (FocusListener focusListener : this.focusListeners) {
                    styledText.addFocusListener(focusListener);
                }
                this.focusListeners.clear();
                this.focusListeners = null;
            }
        }
        return this.textEditor;
    }

    public TextEditor getEditor(boolean bl) {
        if (bl) {
            return this.getEditor();
        }
        return this.textEditor;
    }

    protected String getHelpContextId() {
        return TextContextId.TEXT_COMPARISON_WINDOW;
    }

    private void handleMouseMove(ITextViewer iTextViewer, Event event) {
        TextDiffView textDiffView = this.deltaView();
        boolean bl = textDiffView.isThreeWay();
        if (iTextViewer == textDiffView.viewer(Role.REF)) {
            Relation relation = bl ? Relation.REF_TWO : Relation.REF_ONE;
            Sash sash = textDiffView.verticalSash(relation);
            Event event2 = ControlUtil.translateEvent((Event)event, (Control)sash);
            event2.x = 0;
            sash.notifyListeners(event.type, event2);
        } else if (iTextViewer == textDiffView.viewer(Role.ONE)) {
            Relation relation = Relation.ONE_REF;
            Sash sash = textDiffView.verticalSash(relation);
            Event event3 = ControlUtil.translateEvent((Event)event, (Control)sash);
            event3.x = 0;
            sash.notifyListeners(event.type, event3);
        } else if (iTextViewer == textDiffView.viewer(Role.TWO)) {
            Sash sash = textDiffView.verticalSash(Relation.REF_TWO);
            if (sash == null) {
                return;
            }
            Event event4 = ControlUtil.translateEvent((Event)event, (Control)sash);
            event4.x = sash.getSize().x;
            sash.notifyListeners(event.type, event4);
        }
    }

    public boolean isFocusControl() {
        StyledText styledText;
        ISourceViewer iSourceViewer;
        if (this.textEditor != null && (iSourceViewer = this.textEditor.sourceViewer()) != null && (styledText = iSourceViewer.getTextWidget()) != null && !styledText.isDisposed()) {
            return styledText.isFocusControl();
        }
        return false;
    }

    public boolean isHScrollBarVisible() {
        ISourceViewer iSourceViewer = this.textEditor.sourceViewer();
        if (iSourceViewer instanceof DeltaSourceViewer) {
            return ((DeltaSourceViewer)iSourceViewer).isHScrollbarVisible();
        }
        return false;
    }

    public int marginTop() {
        return 1;
    }

    private void populate() {
        this.createTextEditor();
        final ISourceViewer iSourceViewer = this.textEditor.sourceViewer();
        StyledText styledText = iSourceViewer.getTextWidget();
        Font font = JFaceResources.getFont((String)"com.deltawalker.ui.editorFont");
        if (font != null && iSourceViewer instanceof DeltaSourceViewer) {
            ((DeltaSourceViewer)iSourceViewer).setFont(font);
        }
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                TextDiffView textDiffView = TextContentArea.this.deltaView();
                if (textDiffView.docType() == DocType.PREVIEW && event.type != 9) {
                    return;
                }
                switch (event.type) {
                    case 15: {
                        TextContentArea.this.connectGlobalEditorActions(TextContentArea.this.role, true);
                        break;
                    }
                    case 16: {
                        TextContentArea.this.connectGlobalEditorActions(TextContentArea.this.role, false);
                        break;
                    }
                    case 1: {
                        boolean bl = textDiffView.getInput().doc(0, TextContentArea.this.role).canEverWrite();
                        if (bl && !textDiffView.getCanEditReadOnly()) {
                            textDiffView.setCanEditReadOnly(TextContentArea.this.confirmReadOnlyFileEditing(iSourceViewer));
                        }
                    }
                    case 3: {
                        Role role = TextContentArea.this.role != null ? TextContentArea.this.role : Relation.firstRole((boolean)textDiffView.isThreeWay());
                        DiffRange diffRange = textDiffView.getDeltaFromCursor(role);
                        textDiffView.deltaModel().selectDelta(diffRange, false, true);
                        break;
                    }
                    case 5: {
                        TextContentArea.this.handleMouseMove((ITextViewer)iSourceViewer, event);
                        break;
                    }
                    case 11: {
                        TextContentArea.this.deltaView().redrawContentAreas();
                        break;
                    }
                    case 9: {
                        long l = 0L;
                        TextContentArea.this.drawDiffLines(event, (ITextViewer)iSourceViewer);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
        };
        styledText.addListener(9, listener);
        styledText.addListener(1, listener);
        styledText.addListener(3, listener);
        styledText.addListener(5, listener);
        styledText.addListener(15, listener);
        styledText.addListener(16, listener);
        if (OS.WIN) {
            styledText.addListener(11, listener);
        }
        iSourceViewer.addViewportListener(new IViewportListener(){

            public void viewportChanged(int n) {
                TextContentArea.this.deltaView().syncViewport((ITextViewer)iSourceViewer, n);
            }
        });
    }

    public void removeFocusListener(FocusListener focusListener) {
        if (focusListener == null) {
            throw new NullPointerException("onFocus");
        }
        if (this.textEditor != null) {
            this.textEditor.sourceViewer().getTextWidget().removeFocusListener(focusListener);
        } else if (this.focusListeners != null) {
            this.focusListeners.remove(focusListener);
        }
    }

    public void removeTraverseListener(TraverseListener traverseListener) {
        if (traverseListener == null) {
            throw new NullPointerException("onTraverse");
        }
        if (this.textEditor != null) {
            this.textEditor.sourceViewer().getTextWidget().removeTraverseListener(traverseListener);
        } else if (this.traverseListeners != null) {
            this.traverseListeners.remove(traverseListener);
        }
    }

    public Scrollable scrollable() {
        return this.sourceViewer().getTextWidget();
    }

    public void setEditable(boolean bl) {
        if (this.textEditor != null) {
            this.sourceViewer().setEditable(bl);
        } else {
            this.editable = bl;
        }
    }

    public void setInput(TextDoc textDoc) {
        if (this.textEditor != null) {
            this.textDoc = null;
            this.textEditor.setInput((IEditorInput)textDoc);
        } else {
            this.textDoc = textDoc;
        }
    }

    protected void setupSyncedScroll(boolean bl) {
        if (bl) {
            return;
        }
        super.setupSyncedScroll(bl);
        final TextViewer textViewer = (TextViewer)this.textEditor.sourceViewer();
        textViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                StyledText styledText = textViewer.getTextWidget();
                if (styledText == null || styledText.isDisposed()) {
                    return;
                }
                ScrollBar scrollBar = styledText.getHorizontalBar();
                if (scrollBar == null || scrollBar.isDisposed()) {
                    return;
                }
                scrollBar.notifyListeners(13, null);
            }
        });
    }

    public ITextViewer sourceViewer() {
        return this.getEditor().sourceViewer();
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + " " + this.role;
    }
}

