/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.text.internal.ui;

import com.deltawalker.Delta;
import com.deltawalker.Relation;
import com.deltawalker.differencer.range.DiffRange;
import com.deltawalker.interfaces.ITextDiffDoc;
import com.deltawalker.script.Role;
import com.deltawalker.text.ui.TextDiffView;
import com.deltawalker.ui.BirdsEye;
import com.deltawalker.ui.DeltaPart;
import com.deltawalker.ui.DiffView;
import com.deltawalker.ui.UIMsg;
import com.deltopia.StringUtil;
import com.deltopia.ui.concurrency.GuiExecutor;
import com.deltopia.util.Const;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;

public class TextBirdsEye
extends BirdsEye {
    static final int TOOLTIP_ROLE_LINE_MAX_LENGTH = 1024;

    public TextBirdsEye(Composite composite, TextDiffView textDiffView) {
        super(composite, (DiffView)textDiffView);
    }

    protected void cacheHeight() {
        super.cacheHeight();
        this.height -= 3;
        this.height = Math.max(1, this.height);
        TextDiffView textDiffView = this.view();
        boolean bl = textDiffView.isSyncedVScrolling();
        int n = bl ? textDiffView.computeTotalDeltaHeight() : textDiffView.computeTotalDeltaHeight(Role.REF);
        int n2 = n * textDiffView.viewer(Role.REF).getTextWidget().getLineHeight();
        if (n > 0) {
            this.scale = (float)(this.height < n2 ? this.height : n2) / (float)n;
        }
    }

    protected List<BirdsEye.Marker> createMarkers() {
        final TextDiffView textDiffView = this.view();
        List<DiffRange> list = textDiffView.getDeltas();
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        if (!this.shouldRecreateMarkers()) {
            return this.markers;
        }
        this.clearMarkers();
        final boolean bl = textDiffView.isSyncedVScrolling();
        int n = 0;
        ArrayList<TextMarker> arrayList = new ArrayList<TextMarker>();
        final Role role = Relation.lastRole((boolean)this.view().isThreeWay());
        for (final DiffRange diffRange : list) {
            final int[] nArray = new int[1];
            GuiExecutor.instance().execute(new Runnable(){

                @Override
                public void run() {
                    if (!TextBirdsEye.this.isDisposed()) {
                        nArray[0] = bl ? textDiffView.getMaxDeltaHeight(diffRange) : textDiffView.getDeltaHeight(role, diffRange);
                    }
                }
            });
            int n2 = (int)Math.floor((float)nArray[0] * this.scale);
            if (!diffRange.isSame()) {
                BirdsEye.Marker marker;
                TextMarker textMarker = new TextMarker(diffRange, (int)Math.floor((float)n * this.scale), n2);
                boolean bl2 = false;
                int n3 = arrayList.size();
                if (n3 > 0 && (marker = (BirdsEye.Marker)arrayList.get(n3 - 1)).canMergeWith((BirdsEye.Marker)textMarker)) {
                    marker.mergeWith((BirdsEye.Marker)textMarker);
                    bl2 = true;
                }
                if (!bl2) {
                    arrayList.add(textMarker);
                }
            }
            n += nArray[0];
        }
        this.markers.addAll(arrayList);
        return this.markers;
    }

    public Color getColor(BirdsEye.Marker marker, DeltaPart deltaPart, boolean bl) {
        DiffRange diffRange = this.view().deltaModel().getSelected();
        DiffRange diffRange2 = bl ? diffRange : ((TextMarker)marker).delta();
        return this.view().getColor((com.deltawalker.script.Delta)diffRange2, deltaPart);
    }

    protected String getToolTipText(Event event, Color[] colorArray) {
        ITextDiffDoc iTextDiffDoc = this.view().getInput();
        BirdsEye.Marker marker = this.hitTest(event.y);
        if (marker != null) {
            TextMarker textMarker = (TextMarker)marker;
            colorArray[0] = this.view().getColor((com.deltawalker.script.Delta)marker.delta(), DeltaPart.BG);
            DiffRange diffRange = textMarker.delta();
            StringBuilder stringBuilder = new StringBuilder();
            Set set = Relation.roles((boolean)iTextDiffDoc.isThreeWay());
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Role role = (Role)iterator.next();
                try {
                    String string;
                    IDocument iDocument = iTextDiffDoc.document(role);
                    int n = diffRange.offset(role);
                    int n2 = iDocument.getLineOfOffset(n);
                    String string2 = iDocument.getLineDelimiter(++n2);
                    int n3 = diffRange.length(role) - StringUtil.makeSafe((String)string2).length();
                    if (n3 > 1024) {
                        string = iDocument.get(n, 1024);
                        int n4 = string.lastIndexOf(string2);
                        if (n4 > 0) {
                            string = string.substring(0, n4);
                            string = String.valueOf(string) + Const.LINE_ENDING + "...";
                        }
                    } else {
                        string = iDocument.get(n, n3);
                    }
                    stringBuilder.append(String.valueOf(n2) + ": ");
                    stringBuilder.append(string);
                    if (!iterator.hasNext()) continue;
                    stringBuilder.append(Const.LINE_ENDING);
                }
                catch (BadLocationException badLocationException) {}
            }
            return stringBuilder.toString();
        }
        return UIMsg.BirdsEye_toolTip;
    }

    public boolean isMarkerSelected(BirdsEye.Marker marker) {
        DiffRange diffRange = this.view().deltaModel().getSelected();
        return marker.containsDelta((Delta)diffRange);
    }

    protected void select(Delta delta) {
        this.view().deltaModel().selectDelta((DiffRange)delta, true, true);
        this.redraw();
    }

    protected TextDiffView view() {
        return (TextDiffView)super.view();
    }

    private class TextMarker
    extends BirdsEye.Marker {
        private Set<DiffRange> deltas;

        public TextMarker(DiffRange diffRange, int n, int n2) {
            super((BirdsEye)TextBirdsEye.this, n, n2);
            this.deltas = new HashSet<DiffRange>();
            if (diffRange == null) {
                throw new NullPointerException("delta");
            }
            this.deltas.add(diffRange);
            this.delta = diffRange;
        }

        public boolean containsDelta(Delta delta) {
            return this.deltas.contains(delta);
        }

        public DiffRange delta() {
            return (DiffRange)super.delta();
        }

        public void dispose() {
            this.deltas.clear();
        }

        public boolean isUpToDate() {
            for (DiffRange diffRange : this.deltas) {
                if (diffRange.isOverallKind((com.deltawalker.script.Delta)this.delta)) continue;
                return false;
            }
            return true;
        }

        public void mergeWith(BirdsEye.Marker marker) {
            super.mergeWith(marker);
            DiffRange diffRange = (DiffRange)marker.delta();
            this.deltas.add(diffRange);
            this.delta = diffRange;
        }
    }
}

