/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.text.internal.ui;

import java.util.List;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;

public final class StyleRangeUtil {
    private static void applyStyle(StyleRange styleRange, StyleRange styleRange2, boolean bl) {
        if (bl) {
            if (styleRange.font != null) {
                styleRange2.font = styleRange.font;
            }
            styleRange2.fontStyle |= styleRange.fontStyle;
            if (styleRange.metrics != null) {
                styleRange2.metrics = styleRange.metrics;
            }
            if (styleRange.foreground != null || styleRange.underlineStyle == 4) {
                styleRange2.foreground = styleRange.foreground;
            }
            if (styleRange.background != null) {
                styleRange2.background = styleRange.background;
            }
            styleRange2.strikeout |= styleRange.strikeout;
            if (styleRange.strikeoutColor != null) {
                styleRange2.strikeoutColor = styleRange.strikeoutColor;
            }
            styleRange2.underline |= styleRange.underline;
            if (styleRange.underlineStyle != 0 && styleRange2.underlineStyle != 4) {
                styleRange2.underlineStyle = styleRange.underlineStyle;
            }
            if (styleRange.underlineColor != null) {
                styleRange2.underlineColor = styleRange.underlineColor;
            }
            if (styleRange.borderStyle != 0) {
                styleRange2.borderStyle = styleRange.borderStyle;
            }
            if (styleRange.borderColor != null) {
                styleRange2.borderColor = styleRange.borderColor;
            }
        } else {
            styleRange2.font = styleRange.font;
            styleRange2.fontStyle = styleRange.fontStyle;
            styleRange2.metrics = styleRange.metrics;
            styleRange2.foreground = styleRange.foreground;
            styleRange2.background = styleRange.background;
            styleRange2.strikeout = styleRange.strikeout;
            styleRange2.strikeoutColor = styleRange.strikeoutColor;
            styleRange2.underline = styleRange.underline;
            styleRange2.underlineStyle = styleRange.underlineStyle;
            styleRange2.underlineColor = styleRange.underlineColor;
            styleRange2.borderStyle = styleRange.borderStyle;
            styleRange2.borderColor = styleRange.borderColor;
        }
    }

    public static void applyStyleRange(List<StyleRange> list, StyleRange styleRange, StyleRange styleRange2, boolean bl) {
        if (styleRange.length == 0) {
            return;
        }
        StyleRangeUtil.checkConsistency(styleRange, styleRange2);
        int n = styleRange.start;
        int n2 = styleRange.length;
        int n3 = n + n2;
        if (list.size() == 0) {
            if (styleRange2 == null) {
                styleRange2 = styleRange;
            }
            styleRange2.start = n;
            styleRange2.length = n2;
            StyleRangeUtil.applyStyle(styleRange, styleRange2, bl);
            list.add(styleRange2);
        } else {
            Region region = new Region(n, n2);
            int n4 = StyleRangeUtil.getFirstIndexInWindow(list, (IRegion)region);
            if (n4 == list.size()) {
                if (styleRange2 == null) {
                    styleRange2 = styleRange;
                }
                styleRange2.start = n;
                styleRange2.length = n2;
                StyleRangeUtil.applyStyle(styleRange, styleRange2, bl);
                list.add(styleRange2);
                return;
            }
            int n5 = StyleRangeUtil.getFirstIndexAfterWindow(list, (IRegion)region);
            int n6 = n4;
            while (n6 < n5 && n2 > 0) {
                StyleRange styleRange3 = list.get(n6);
                int n7 = styleRange3.start;
                int n8 = n7 + styleRange3.length;
                if (n3 <= n7) {
                    list.add(n6, styleRange);
                    return;
                }
                if (n < n8) {
                    StyleRange styleRange4 = null;
                    if (n3 < n8) {
                        styleRange4 = (StyleRange)styleRange3.clone();
                    }
                    if (n < n7) {
                        if (styleRange2 == null) {
                            styleRange2 = new StyleRange();
                        }
                        styleRange2.start = n;
                        styleRange2.length = n7 - n;
                        StyleRangeUtil.applyStyle(styleRange, styleRange2, bl);
                        list.add(n6, styleRange2);
                        ++n6;
                        ++n5;
                        styleRange3.length = Math.min(n3, n8) - n7;
                        StyleRangeUtil.applyStyle(styleRange, styleRange3, bl);
                    }
                    if (n >= n7) {
                        styleRange3.length = n - n7;
                        if (styleRange3.length > 0) {
                            styleRange3 = (StyleRange)styleRange3.clone();
                            ++n5;
                            list.add(++n6, styleRange3);
                        }
                        StyleRangeUtil.applyStyle(styleRange, styleRange3, bl);
                        styleRange3.start = n;
                        styleRange3.length = Math.min(n3, n8) - n;
                    }
                    if (n3 < n8) {
                        styleRange4.start = n3;
                        styleRange4.length = n8 - n3;
                        ++n5;
                        list.add(++n6, styleRange4);
                    }
                    styleRange.start = n8;
                    styleRange.length = Math.max(n3 - n8, 0);
                    n = styleRange.start;
                    n2 = styleRange.length;
                }
                ++n6;
            }
            if (n2 > 0) {
                if (styleRange2 == null) {
                    styleRange2 = styleRange;
                }
                styleRange2.start = n;
                styleRange2.length = n3 - n;
                StyleRangeUtil.applyStyle(styleRange, styleRange2, bl);
                list.add(n5, styleRange2);
            }
        }
    }

    private static void checkConsistency(StyleRange styleRange, StyleRange styleRange2) {
        if (styleRange == null) {
            throw new NullPointerException("range");
        }
        if (styleRange2 != null) {
            int n;
            int n2;
            if (styleRange.start < styleRange2.start) {
                styleRange.start = styleRange2.start;
            }
            if ((n2 = styleRange.start + styleRange.length) > (n = styleRange2.start + styleRange2.length)) {
                styleRange.length -= n2 - n;
            }
        }
    }

    public static void clearStyleBackground(StyledText styledText) {
        StyleRange[] styleRangeArray;
        StyleRange[] styleRangeArray2 = styleRangeArray = styledText.getStyleRanges();
        int n = styleRangeArray.length;
        int n2 = 0;
        while (n2 < n) {
            StyleRange styleRange = styleRangeArray2[n2];
            styleRange.background = null;
            ++n2;
        }
        styledText.setStyleRanges(styleRangeArray);
    }

    private static int getFirstIndexAfterWindow(List<StyleRange> list, IRegion iRegion) {
        if (iRegion != null) {
            int n = iRegion.getOffset() + iRegion.getLength();
            int n2 = -1;
            int n3 = list.size();
            while (n3 - n2 > 1) {
                int n4 = n2 + n3 >> 1;
                StyleRange styleRange = list.get(n4);
                if (styleRange.start < n) {
                    n2 = n4;
                    continue;
                }
                n3 = n4;
            }
            return n3;
        }
        return list.size();
    }

    private static int getFirstIndexInWindow(List<StyleRange> list, IRegion iRegion) {
        if (iRegion != null) {
            int n = iRegion.getOffset();
            int n2 = -1;
            int n3 = list.size();
            while (n3 - n2 > 1) {
                int n4 = n2 + n3 >> 1;
                StyleRange styleRange = list.get(n4);
                if (styleRange.start + styleRange.length > n) {
                    n3 = n4;
                    continue;
                }
                n2 = n4;
            }
            return n3;
        }
        return 0;
    }

    private StyleRangeUtil() {
    }
}

