/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.text.internal.ui;

import com.deltawalker.script.Role;
import com.deltawalker.text.internal.ui.MergeUndoContext;
import com.deltawalker.text.internal.ui.editor.TextEditor;
import com.deltawalker.text.ui.TextDiffView;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.IUpdate;

public class OperationHistoryHandler {
    private final IOperationHistoryListener onOpHistory = new IOperationHistoryListener(){

        public void historyNotification(OperationHistoryEvent operationHistoryEvent) {
            if (OperationHistoryHandler.this.tdView != null) {
                OperationHistoryHandler.this.historyNotification(operationHistoryEvent);
            }
        }
    };
    private IOperationHistory opHistory;
    private TextDiffView tdView;

    public OperationHistoryHandler(TextDiffView textDiffView) {
        if (textDiffView == null) {
            throw new NullPointerException("tdView");
        }
        this.tdView = textDiffView;
        this.opHistory = OperationHistoryFactory.getOperationHistory();
        this.opHistory.addOperationHistoryListener(this.onOpHistory);
    }

    public void clear() {
        this.opHistory.dispose((IUndoContext)new MergeUndoContext(this.tdView), true, true, true);
    }

    public void dispose() {
        if (this.opHistory != null) {
            if (this.tdView != null) {
                this.clear();
            }
            this.opHistory.removeOperationHistoryListener(this.onOpHistory);
            this.opHistory = null;
        }
        this.tdView = null;
    }

    private void historyNotification(OperationHistoryEvent operationHistoryEvent) {
        IUndoableOperation iUndoableOperation = operationHistoryEvent.getOperation();
        IUndoContext[] iUndoContextArray = iUndoableOperation.getContexts();
        ISourceViewer iSourceViewer = null;
        IUndoContext[] iUndoContextArray2 = iUndoContextArray;
        int n = iUndoContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            IUndoContext iUndoContext = iUndoContextArray2[n2];
            iSourceViewer = MergeUndoContext.getViewer(this.tdView, iUndoContext);
            if (iSourceViewer != null) break;
            ++n2;
        }
        if (iSourceViewer == null) {
            return;
        }
        int n3 = operationHistoryEvent.getEventType();
        if (n3 == 5) {
            iUndoableOperation.addContext((IUndoContext)new MergeUndoContext(this.tdView));
        } else if (n3 == 8) {
            iUndoableOperation.removeContext((IUndoContext)new MergeUndoContext(this.tdView));
        }
        Role role = this.tdView.getFocusRole();
        if (role != null) {
            TextEditor textEditor = this.tdView.editor(role);
            IUndoContext[] iUndoContextArray3 = iUndoContextArray2 = new IAction[]{textEditor.getAction(ITextEditorActionConstants.REDO), textEditor.getAction(ITextEditorActionConstants.UNDO)};
            int n4 = iUndoContextArray2.length;
            int n5 = 0;
            while (n5 < n4) {
                IUndoContext iUndoContext = iUndoContextArray3[n5];
                if (iUndoContext instanceof IUpdate) {
                    ((IUpdate)iUndoContext).update();
                }
                ++n5;
            }
        }
    }
}

