/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.text.internal.ui;

import com.deltawalker.DocType;
import com.deltawalker.Relation;
import com.deltawalker.differencer.range.DiffRange;
import com.deltawalker.script.Role;
import com.deltawalker.text.MergeOp;
import com.deltawalker.text.internal.ui.MergeArrowImage;
import com.deltawalker.text.ui.TextDiffView;
import com.deltawalker.ui.ControlUtil;
import com.deltawalker.ui.IDeltaListener;
import com.deltawalker.ui.UIMsg;
import com.deltopia.ui.swt.ImageCanvas;
import com.deltopia.util.OS;
import java.util.Arrays;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class MergeOverlayArrow
extends ImageCanvas {
    public static final int DEFAULT_HEIGHT = 10;
    private DiffRange delta;
    private IDeltaListener onDelta = new IDeltaListener(){

        public void deltasChanged() {
            MergeOverlayArrow.this.internalUpdate();
        }

        public void selectionChanged(boolean bl) {
            MergeOverlayArrow.this.internalUpdate();
        }
    };
    private Listener onKeyMouse = new Listener(){

        public void handleEvent(Event event) {
            MergeOverlayArrow.this.ptCursor = ((Control)event.widget).toDisplay(event.x, event.y);
            MergeOverlayArrow.this.handleEvent(event);
        }
    };
    private TypedMouseListener onMouseRuler = new TypedMouseListener();
    private IViewportListener onViewport = new IViewportListener(){

        public void viewportChanged(int n) {
            MergeOverlayArrow.this.internalUpdate();
        }
    };
    private Point ptCursor = new Point(0, 0);
    private Point ptCursorRuler = new Point(0, 0);
    private final TextDiffView tdView;
    private final boolean toRight;
    private final ITextViewer tViewer;
    private final int width;
    private final int x;

    public MergeOverlayArrow(TextDiffView textDiffView, ITextViewer iTextViewer, Composite composite, int n, int n2, int n3, boolean bl) {
        super(composite, n | 0x40000000 | 0x40000 | 0x80000);
        this.tdView = textDiffView;
        this.tViewer = iTextViewer;
        this.x = n2;
        this.width = n3;
        this.toRight = bl;
        this.setCursor(textDiffView.getCursor(21));
        String string = OS.mod1Key();
        String string2 = NLS.bind((String)UIMsg.MergeArrow_toolTipText, (Object)string, (Object)string);
        if (OS.OSX) {
            DefaultToolTip defaultToolTip = new DefaultToolTip((Control)this, 2, false);
            defaultToolTip.setText(string2);
            defaultToolTip.setShift(new Point(0, 16));
        } else {
            this.setToolTipText(string2);
        }
        this.setVisible(false);
        this.installListeners(true);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
            }
        });
    }

    private Rectangle getHotSpotArea() {
        Rectangle rectangle = this.getParent().getClientArea();
        int n = this.x == -1 ? rectangle.x : this.x;
        int n2 = this.width == -1 ? rectangle.width : this.width;
        Rectangle rectangle2 = new Rectangle(n, rectangle.y, n2, rectangle.height);
        return rectangle2;
    }

    private Event getUntypedEvent(int n, MouseEvent mouseEvent) {
        this.updateCachedCursorPositions(mouseEvent);
        Event event = new Event();
        event.button = mouseEvent.button;
        event.count = mouseEvent.count;
        event.data = mouseEvent.data;
        event.display = mouseEvent.display;
        event.stateMask = mouseEvent.stateMask;
        event.time = mouseEvent.time;
        event.type = n;
        event.widget = mouseEvent.widget;
        event.x = mouseEvent.x;
        event.y = mouseEvent.y;
        return event;
    }

    private void handleEvent(Event event) {
        Relation relation;
        if (this.tdView.docType() == DocType.PREVIEW) {
            return;
        }
        Composite composite = this.getParent();
        Point point = new Point(0, 0);
        DiffRange diffRange = this.tdView.getHitDelta(this.tViewer, this.ptCursor.y, point);
        if (diffRange != null && diffRange.isDisposed()) {
            diffRange = null;
        }
        if ((relation = this.tdView.getRelation(this.tViewer, this.toRight)) == null) {
            diffRange = null;
        }
        Rectangle rectangle = this.getHotSpotArea();
        switch (event.type) {
            case 1: 
            case 2: {
                this.handleKeyEvent(event);
                return;
            }
            case 3: {
                this.delta = diffRange;
                this.handleMouseDown(event);
                break;
            }
            case 7: {
                if (!rectangle.contains(composite.toControl(this.ptCursor))) {
                    diffRange = null;
                }
            }
            case 5: 
            case 6: {
                if (diffRange == null) {
                    this.setVisible(false);
                    this.getParent().redraw();
                    break;
                }
                boolean bl = this.isCursorOverArrow();
                Image image = MergeArrowImage.getImage(diffRange.getKinds(), MergeOp.getOperation((int)event.stateMask), this.toRight, bl);
                this.setImage(image);
                Point point2 = this.getSize();
                int n = this.toRight ? rectangle.width - point2.x - 2 : 0;
                int n2 = point.x + 1;
                if (n2 < 0) {
                    n2 = 0;
                }
                int n3 = rectangle.x + 1 + n;
                this.setLocation(n3, n2);
                this.setVisible(true);
                break;
            }
            default: {
                assert (false) : "event.type";
                return;
            }
        }
        this.delta = diffRange;
    }

    private void handleKeyEvent(Event event) {
        if ((event.keyCode == SWT.MOD1 || event.keyCode == SWT.MOD2) && this.isVisible() && this.delta != null) {
            int n = event.stateMask;
            switch (event.type) {
                case 1: {
                    n |= event.keyCode;
                    break;
                }
                case 2: {
                    n &= ~event.keyCode;
                    break;
                }
                default: {
                    assert (false) : "event.type";
                    return;
                }
            }
            boolean bl = this.isCursorOverArrow();
            this.setImage(MergeArrowImage.getImage(this.delta.getKinds(), MergeOp.getOperation((int)n), this.toRight, bl));
        }
    }

    private void handleMouseDown(Event event) {
        Relation relation = this.tdView.getRelation(this.tViewer, this.toRight);
        if (relation == null) {
            return;
        }
        Composite composite = this.getParent();
        if (event.widget == this && this.delta != null && !this.delta.isSame()) {
            this.tdView.deltaModel().selectDelta(this.delta, false, false);
            Point point = composite.toControl(this.ptCursor);
            Rectangle rectangle = this.getHotSpotArea();
            if (rectangle.x <= point.x && point.x <= rectangle.width) {
                MergeOp mergeOp = MergeOp.getOperation((int)event.stateMask);
                Role role = this.toRight ? relation.firstRole() : relation.lastRole();
                Role role2 = this.toRight ? relation.lastRole() : relation.firstRole();
                try {
                    this.tdView.deltaModel().merge(mergeOp, Arrays.asList(this.delta), role, role2, null);
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        } else if (event.widget == composite) {
            composite.setFocus();
        }
    }

    private void installListeners(boolean bl) {
        Composite composite = this.getParent();
        if (bl) {
            composite.addMouseListener((MouseListener)this.onMouseRuler);
            composite.addMouseTrackListener((MouseTrackListener)this.onMouseRuler);
            composite.addMouseMoveListener((MouseMoveListener)this.onMouseRuler);
            this.addListener(1, this.onKeyMouse);
            this.addListener(2, this.onKeyMouse);
            this.addListener(3, this.onKeyMouse);
            this.addListener(6, this.onKeyMouse);
            this.addListener(7, this.onKeyMouse);
            this.addListener(5, this.onKeyMouse);
        } else {
            if (composite != null && !composite.isDisposed()) {
                composite.removeMouseListener((MouseListener)this.onMouseRuler);
                composite.removeMouseTrackListener((MouseTrackListener)this.onMouseRuler);
                composite.removeMouseMoveListener((MouseMoveListener)this.onMouseRuler);
            }
            this.removeListener(1, this.onKeyMouse);
            this.removeListener(2, this.onKeyMouse);
            this.removeListener(3, this.onKeyMouse);
            this.removeListener(6, this.onKeyMouse);
            this.removeListener(7, this.onKeyMouse);
            this.removeListener(5, this.onKeyMouse);
        }
        StyledText styledText = this.tViewer.getTextWidget();
        if (styledText != null && !styledText.isDisposed()) {
            Control[] controlArray;
            Control[] controlArray2 = controlArray = ControlUtil.getChildren((Control)styledText.getParent(), Widget.class);
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray2[n2];
                if (control != composite && !(control instanceof ImageCanvas)) {
                    if (bl) {
                        control.addListener(6, this.onKeyMouse);
                        control.addListener(7, this.onKeyMouse);
                        control.addListener(5, this.onKeyMouse);
                    } else {
                        control.removeListener(6, this.onKeyMouse);
                        control.removeListener(7, this.onKeyMouse);
                        control.removeListener(5, this.onKeyMouse);
                    }
                }
                ++n2;
            }
        }
        this.tViewer.addViewportListener(this.onViewport);
        this.tdView.addDeltaListener(this.onDelta);
    }

    private void internalUpdate() {
        StyledText styledText = this.tViewer.getTextWidget();
        Point point = styledText.toControl(styledText.getDisplay().getCursorLocation());
        Event event = new Event();
        event.type = styledText.getClientArea().contains(point) ? 5 : 7;
        event.widget = styledText;
        event.x = point.x;
        event.y = point.y;
        this.handleEvent(event);
    }

    private boolean isCursorOverArrow() {
        Rectangle rectangle = this.getBounds();
        boolean bl = rectangle.contains(this.getParent().toControl(this.ptCursorRuler));
        return bl;
    }

    public void setImage(Image image) {
        super.setImage(image);
        if (!this.isDisposed()) {
            Rectangle rectangle = image.getBounds();
            this.setSize(rectangle.width, rectangle.height);
        }
    }

    private void updateCachedCursorPositions(MouseEvent mouseEvent) {
        this.ptCursorRuler = ((Control)mouseEvent.widget).toDisplay(mouseEvent.x, mouseEvent.y);
        this.ptCursor = ((Control)mouseEvent.widget).toDisplay(mouseEvent.x, mouseEvent.y);
    }

    private class TypedMouseListener
    implements MouseListener,
    MouseMoveListener,
    MouseTrackListener {
        private TypedMouseListener() {
        }

        public void mouseDoubleClick(MouseEvent mouseEvent) {
        }

        public void mouseDown(MouseEvent mouseEvent) {
            MergeOverlayArrow.this.updateCachedCursorPositions(mouseEvent);
        }

        public void mouseEnter(MouseEvent mouseEvent) {
            MergeOverlayArrow.this.handleEvent(MergeOverlayArrow.this.getUntypedEvent(6, mouseEvent));
        }

        public void mouseExit(MouseEvent mouseEvent) {
            MergeOverlayArrow.this.handleEvent(MergeOverlayArrow.this.getUntypedEvent(7, mouseEvent));
        }

        public void mouseHover(MouseEvent mouseEvent) {
        }

        public void mouseMove(MouseEvent mouseEvent) {
            MergeOverlayArrow.this.handleEvent(MergeOverlayArrow.this.getUntypedEvent(5, mouseEvent));
        }

        public void mouseUp(MouseEvent mouseEvent) {
        }
    }
}

