/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.text.internal.ui;

import com.deltawalker.script.Role;
import com.deltawalker.text.internal.ui.DeltaSourceViewer;
import com.deltawalker.ui.IEditIterator;
import com.deltopia.eclipse.util.Goto;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.custom.StyledText;

public final class EditTracker
implements IEditIterator {
    private int selEditIndex = -1;
    private final IDocument[] documents;
    private List<EditInfo> editCache = new ArrayList<EditInfo>();
    private final List<List<EditInfo>> history = new ArrayList<List<EditInfo>>();
    private final InternalListener[] listeners;
    private boolean nextEditRequired;
    private final ISourceViewer[] viewers;

    private static boolean listEquals(List<EditInfo> list, List<EditInfo> list2) {
        int n = list.size();
        if (n != list2.size()) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (!list.get(n2).equals(list2.get(n2))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public EditTracker() {
        int n = Role.count();
        this.viewers = new SourceViewer[n];
        this.documents = new Document[n];
        this.listeners = new InternalListener[n];
    }

    private void addEditToCache(int n, int n2, EditInfo editInfo) {
        int n3;
        this.manageCache(n3, new EditInfo(editInfo, (n3 = n - n2) >= 0 ? 1 : -1));
    }

    /*
     * Unable to fully structure code
     */
    private void addEditToCacheSortWay(EditInfo var1_1) {
        block28: {
            block33: {
                block31: {
                    block32: {
                        block29: {
                            block30: {
                                block27: {
                                    var2_2 = this.editCache.size();
                                    if (var2_2 != 0) break block27;
                                    this.editCache.add(var1_1);
                                    break block28;
                                }
                                var3_3 = this.editCache.toArray();
                                var4_4 = EditsBlock.getEditsBlock(Role.REF, this.editCache);
                                var5_5 = EditsBlock.getEditsBlock(Role.ONE, this.editCache);
                                var6_6 = EditsBlock.getEditsBlock(Role.TWO, this.editCache);
                                if (var1_1.role != Role.REF) break block29;
                                if (var4_4 == null) break block30;
                                var7_7 = var4_4.startIndex;
                                while (var7_7 <= var4_4.endIndex) {
                                    if (var1_1.offset >= ((EditInfo)var3_3[var7_7]).offset) ** GOTO lbl24
                                    var8_10 = var7_7 - 1;
                                    if (var8_10 >= var4_4.startIndex) {
                                        if (var1_1.offset > ((EditInfo)var3_3[var8_10]).offset) {
                                            this.editCache.add(var7_7, var1_1);
                                            return;
                                        }
                                    } else {
                                        this.editCache.add(var7_7, var1_1);
                                        return;
lbl24:
                                        // 1 sources

                                        var8_10 = var7_7 + 1;
                                        if (var8_10 <= var4_4.endIndex) {
                                            if (var1_1.offset < ((EditInfo)var3_3[var8_10]).offset) {
                                                this.editCache.add(var8_10, var1_1);
                                                return;
                                            }
                                        } else {
                                            this.editCache.add(var8_10, var1_1);
                                            return;
                                        }
                                    }
                                    ++var7_7;
                                }
                                break block28;
                            }
                            if (var5_5 != null) {
                                this.editCache.add(var5_5.startIndex, var1_1);
                            } else {
                                this.editCache.add(var6_6.startIndex, var1_1);
                            }
                            break block28;
                        }
                        if (var1_1.role != Role.ONE) break block31;
                        if (var5_5 == null) break block32;
                        var7_8 = var5_5.startIndex;
                        while (var7_8 <= var5_5.endIndex) {
                            if (var1_1.offset >= ((EditInfo)var3_3[var7_8]).offset) ** GOTO lbl55
                            var8_11 = var7_8 - 1;
                            if (var8_11 >= var5_5.startIndex) {
                                if (var1_1.offset > ((EditInfo)var3_3[var8_11]).offset) {
                                    this.editCache.add(var7_8, var1_1);
                                    return;
                                }
                            } else {
                                this.editCache.add(var7_8, var1_1);
                                return;
lbl55:
                                // 1 sources

                                var8_11 = var7_8 + 1;
                                if (var8_11 <= var5_5.endIndex) {
                                    if (var1_1.offset < ((EditInfo)var3_3[var8_11]).offset) {
                                        this.editCache.add(var8_11, var1_1);
                                        return;
                                    }
                                } else {
                                    this.editCache.add(var8_11, var1_1);
                                    return;
                                }
                            }
                            ++var7_8;
                        }
                        break block28;
                    }
                    if (var6_6 != null) {
                        this.editCache.add(var6_6.startIndex, var1_1);
                    } else {
                        this.editCache.add(var4_4.endIndex + 1, var1_1);
                    }
                    break block28;
                }
                if (var6_6 == null) break block33;
                var7_9 = var6_6.startIndex;
                while (var7_9 <= var6_6.endIndex) {
                    if (var1_1.offset >= ((EditInfo)var3_3[var7_9]).offset) ** GOTO lbl85
                    var8_12 = var7_9 - 1;
                    if (var8_12 >= var6_6.startIndex) {
                        if (var1_1.offset > ((EditInfo)var3_3[var8_12]).offset) {
                            this.editCache.add(var7_9, var1_1);
                            return;
                        }
                    } else {
                        this.editCache.add(var7_9, var1_1);
                        return;
lbl85:
                        // 1 sources

                        var8_12 = var7_9 + 1;
                        if (var8_12 <= var6_6.endIndex) {
                            if (var1_1.offset < ((EditInfo)var3_3[var8_12]).offset) {
                                this.editCache.add(var8_12, var1_1);
                                return;
                            }
                        } else {
                            this.editCache.add(var8_12, var1_1);
                            return;
                        }
                    }
                    ++var7_9;
                }
                break block28;
            }
            if (var5_5 != null) {
                this.editCache.add(var5_5.endIndex + 1, var1_1);
            } else {
                this.editCache.add(var4_4.endIndex + 1, var1_1);
            }
        }
    }

    public void dispose() {
        int n = 0;
        while (n < this.viewers.length) {
            if (this.documents[n] != null) {
                this.documents[n].removeDocumentListener((IDocumentListener)this.listeners[n]);
                this.documents[n] = null;
            }
            if (this.viewers[n] != null) {
                this.viewers[n].removeTextListener((ITextListener)this.listeners[n]);
                this.viewers[n] = null;
            }
            this.listeners[n] = null;
            ++n;
        }
        this.editCache.clear();
        this.history.clear();
    }

    private ISourceViewer getFocusedViewer() {
        int n = 0;
        while (n < this.viewers.length) {
            StyledText styledText;
            ISourceViewer iSourceViewer = this.viewers[n];
            if (iSourceViewer != null && (styledText = iSourceViewer.getTextWidget()) != null && !styledText.isDisposed() && styledText.isFocusControl()) {
                return iSourceViewer;
            }
            ++n;
        }
        return null;
    }

    private Role getNextRole(Role role, Goto goto_) {
        int n = role.toInt() + (goto_ == Goto.NEXT ? 1 : -1);
        if (n < 0 || n >= Role.count()) {
            return null;
        }
        return Role.fromInt((int)n);
    }

    private List<EditInfo> getPreviousStateFromHistory(List<EditInfo> list) {
        Iterator<List<EditInfo>> iterator = this.history.iterator();
        while (iterator.hasNext()) {
            List<EditInfo> list2 = iterator.next();
            if (!EditTracker.listEquals(list2, list)) continue;
            iterator.remove();
            return list2;
        }
        return null;
    }

    public boolean hasNextEdit() {
        return this.hasNextEdit(Goto.NEXT);
    }

    private boolean hasNextEdit(Goto goto_) {
        if (this.editCache.size() == 1) {
            return goto_ == Goto.PREVIOUS ? this.nextEditRequired : !this.nextEditRequired;
        }
        return this.synchronizeWithCaret(goto_) != -1;
    }

    public boolean hasPreviousEdit() {
        return this.hasNextEdit(Goto.PREVIOUS);
    }

    private void manageCache(int n, EditInfo editInfo) {
        for (EditInfo editInfo2 : this.editCache) {
            if (editInfo2.offset <= editInfo.offset + editInfo.selectionLength || editInfo2.role != editInfo.role) continue;
            editInfo2.offset += n;
        }
        this.mergeEditsInCache(editInfo);
    }

    private void mergeEditsInCache(EditInfo editInfo) {
        Iterator<EditInfo> iterator = this.editCache.iterator();
        while (iterator.hasNext()) {
            List<EditInfo> list;
            boolean bl;
            boolean bl2;
            EditInfo editInfo2 = iterator.next();
            if (editInfo2.role != editInfo.role) continue;
            boolean bl3 = editInfo.offset < editInfo2.offset && editInfo.offset + editInfo.selectionLength < editInfo2.offset + editInfo2.length && editInfo2.offset < editInfo.offset + editInfo.length;
            boolean bl4 = editInfo2.offset < editInfo.offset && editInfo2.offset + editInfo2.length < editInfo.offset + editInfo.selectionLength && editInfo.offset < editInfo2.offset + editInfo2.length;
            boolean bl5 = editInfo.offset >= editInfo2.offset && editInfo2.offset + editInfo2.length >= editInfo.offset + editInfo.selectionLength;
            boolean bl6 = bl2 = editInfo2.offset >= editInfo.offset && editInfo.offset + editInfo.selectionLength >= editInfo2.offset + editInfo2.length;
            if (!bl3 && !bl4 && !bl5 && !bl2) continue;
            boolean bl7 = false;
            switch (editInfo.type) {
                case 1: {
                    if (editInfo.insertionLength != 0) {
                        if (bl3) {
                            editInfo2.length -= editInfo.offset + editInfo.selectionLength - editInfo2.offset;
                            editInfo.length += editInfo2.length;
                            bl7 = true;
                            break;
                        }
                        if (bl2) {
                            bl7 = true;
                            break;
                        }
                        if (bl4) {
                            editInfo2.length -= editInfo2.offset + editInfo2.length - editInfo.offset;
                            editInfo2.length += editInfo.length;
                            break;
                        }
                        if (!bl5) break;
                        editInfo2.length -= editInfo.selectionLength;
                        editInfo2.length += editInfo.length;
                        break;
                    }
                    if (bl2) {
                        editInfo.length += editInfo2.length;
                        bl7 = true;
                        break;
                    }
                    if (!bl5) break;
                    editInfo2.length += editInfo.length;
                    break;
                }
                case -1: {
                    if (editInfo.insertionLength != 0) {
                        if (bl3) {
                            editInfo2.length -= editInfo.offset + editInfo.selectionLength - editInfo2.offset;
                            editInfo.length += editInfo2.length;
                            bl7 = true;
                            break;
                        }
                        if (bl2) {
                            bl7 = true;
                            break;
                        }
                        if (bl4) {
                            editInfo2.length -= editInfo2.offset + editInfo2.length - editInfo.offset;
                            editInfo2.length += editInfo.length;
                            break;
                        }
                        if (!bl5) break;
                        editInfo2.length -= editInfo.selectionLength;
                        editInfo2.length += editInfo.length;
                        break;
                    }
                    if (bl2) {
                        bl7 = true;
                        break;
                    }
                    if (!bl5) break;
                    editInfo2.length -= editInfo.selectionLength;
                    break;
                }
                default: {
                    assert (false) : "The type of edit is not specified or has incorrect value";
                    break;
                }
            }
            if (!bl7) {
                editInfo.offset = editInfo2.offset;
                editInfo.length = editInfo2.length;
            }
            iterator.remove();
            boolean bl8 = bl = editInfo.offset == editInfo2.offset && editInfo.offset + editInfo.selectionLength == editInfo2.offset + editInfo2.length;
            if (!bl || (list = this.getPreviousStateFromHistory(this.editCache)) == null) continue;
            this.editCache = list;
            return;
        }
        this.addEditToCacheSortWay(editInfo);
        this.history.add(new ArrayList<EditInfo>(this.editCache));
    }

    public void nextEdit() {
        this.nextEdit(Goto.NEXT);
    }

    private void nextEdit(Goto goto_) {
        if (this.editCache.size() == 0) {
            return;
        }
        int n = this.synchronizeWithCaret(goto_);
        if (n != -1) {
            this.selEditIndex = n;
        } else if (--this.selEditIndex < 0) {
            this.selEditIndex = 0;
        }
        this.setFocusToCurrentEdit();
        if (this.editCache.size() == 1) {
            this.nextEditRequired = goto_ == Goto.NEXT;
        }
    }

    public void previousEdit() {
        this.nextEdit(Goto.PREVIOUS);
    }

    private void removeEditsBlock(Role role) {
        EditsBlock editsBlock = EditsBlock.getEditsBlock(role, this.editCache);
        if (editsBlock != null) {
            int n = editsBlock.startIndex;
            while (n <= editsBlock.endIndex) {
                this.editCache.remove(editsBlock.startIndex);
                ++n;
            }
        }
        this.selEditIndex = -1;
        this.nextEditRequired = false;
    }

    private void setDocument(IDocument iDocument, IDocument iDocument2, Role role, EditInfo editInfo) {
        boolean bl;
        int n = role.toInt();
        this.documents[n].removeDocumentListener((IDocumentListener)this.listeners[n]);
        boolean bl2 = iDocument2 == null ? this.documents[n].getLength() != 0 : (bl = this.documents[n].getLength() != 0 || iDocument2.getLength() != 0);
        if (bl && editInfo != null) {
            this.addEditToCache(this.documents[n].getLength(), iDocument2.getLength(), editInfo);
        }
        this.documents[n] = iDocument;
        this.documents[n].addDocumentListener((IDocumentListener)this.listeners[n]);
    }

    private void setFocusToCurrentEdit() {
        EditInfo editInfo = this.editCache.get(this.selEditIndex);
        Role role = editInfo.role;
        StyledText styledText = this.viewers[role.toInt()].getTextWidget();
        styledText.setFocus();
        styledText.setSelection(editInfo.offset + editInfo.length, editInfo.offset);
    }

    private int synchronizeWithCaret(Goto goto_) {
        EditsBlock editsBlock;
        ISourceViewer iSourceViewer = this.getFocusedViewer();
        if (iSourceViewer == null && !(iSourceViewer instanceof DeltaSourceViewer)) {
            return -1;
        }
        Role role = ((DeltaSourceViewer)iSourceViewer).role();
        StyledText styledText = iSourceViewer.getTextWidget();
        EditsBlock editsBlock2 = EditsBlock.getEditsBlock(role, this.editCache);
        int n = this.synchronizeWithCaretInBlock(goto_, editsBlock2, styledText);
        if (n != -1) {
            return n;
        }
        Role role2 = this.getNextRole(role, goto_);
        if (role2 != null && (editsBlock = EditsBlock.getEditsBlock(role2, this.editCache)) != null) {
            return goto_ == Goto.NEXT ? editsBlock.startIndex : editsBlock.endIndex;
        }
        return -1;
    }

    private int synchronizeWithCaretInBlock(Goto goto_, EditsBlock editsBlock, StyledText styledText) {
        block6: {
            if (editsBlock == null) break block6;
            int n = styledText.getLineAtOffset(styledText.getCaretOffset());
            if (goto_ == Goto.NEXT) {
                int n2 = editsBlock.startIndex;
                while (n2 <= editsBlock.endIndex) {
                    EditInfo editInfo = this.editCache.get(n2);
                    int n3 = editInfo.offset;
                    int n4 = styledText.getCharCount();
                    n3 = n3 <= n4 ? n3 : n4;
                    int n5 = styledText.getLineAtOffset(n3);
                    if (n < n5) {
                        return n2;
                    }
                    ++n2;
                }
            } else {
                int n6 = editsBlock.endIndex;
                while (n6 >= editsBlock.startIndex) {
                    EditInfo editInfo = this.editCache.get(n6);
                    int n7 = editInfo.offset + editInfo.length;
                    int n8 = styledText.getCharCount();
                    n7 = n7 <= n8 ? n7 : n8;
                    int n9 = styledText.getLineAtOffset(n7);
                    if (n > n9) {
                        return n6;
                    }
                    --n6;
                }
            }
        }
        return -1;
    }

    public void trackViewer(ISourceViewer iSourceViewer) {
        if (!(iSourceViewer instanceof DeltaSourceViewer)) {
            return;
        }
        Role role = ((DeltaSourceViewer)iSourceViewer).role();
        int n = role.toInt();
        this.viewers[n] = iSourceViewer;
        this.listeners[n] = new InternalListener(role);
        this.viewers[n].addTextListener((ITextListener)this.listeners[n]);
        this.documents[n] = this.viewers[n].getDocument();
        this.documents[n].addDocumentListener((IDocumentListener)this.listeners[n]);
    }

    private static final class EditInfo {
        public static final int ADDITION = 1;
        public static final int SUBTRACTION = -1;
        public int insertionLength;
        public int length;
        public int offset;
        public final Role role;
        public int selectionLength;
        public final int type;

        public EditInfo(EditInfo editInfo, int n) {
            this(editInfo.offset, editInfo.length, editInfo.insertionLength, editInfo.role, n);
        }

        public EditInfo(int n, int n2, int n3, Role role) {
            this(n, n2, n3, role, 0);
        }

        private EditInfo(int n, int n2, int n3, Role role, int n4) {
            this.offset = n;
            this.length = n2;
            this.selectionLength = n2;
            this.insertionLength = n3;
            this.role = role;
            this.type = n4;
            switch (this.type) {
                case 1: {
                    this.length = n2 >= n3 ? n2 : n3;
                    break;
                }
                case -1: {
                    int n5 = n2 <= n3 ? n2 : n3;
                    this.length = n3 == 0 ? 0 : n5;
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    assert (false) : "The mask of edit is not specified or has incorrect value";
                    break;
                }
            }
        }

        public boolean equals(Object object) {
            if (object instanceof EditInfo) {
                EditInfo editInfo = (EditInfo)object;
                return this.length == editInfo.length && this.offset == editInfo.offset;
            }
            return false;
        }
    }

    private static final class EditsBlock {
        public final int endIndex;
        public final int startIndex;

        public static EditsBlock getEditsBlock(Role role, List<EditInfo> list) {
            int n = -1;
            int n2 = -1;
            int n3 = 0;
            int n4 = list.size();
            while (n3 < n4) {
                EditInfo editInfo = list.get(n3);
                if (editInfo.role == role) {
                    if (n == -1) {
                        n = n3;
                    }
                    n2 = n3;
                }
                ++n3;
            }
            return n == -1 ? null : new EditsBlock(n, n2);
        }

        private EditsBlock(int n, int n2) {
            this.startIndex = n;
            this.endIndex = n2;
        }
    }

    private class InternalListener
    implements ITextListener,
    IDocumentListener {
        private boolean firstEditHandled;
        private IDocument oldDocument = new Document();
        private boolean preventDuplicationEdit;
        private final Role role;

        public InternalListener(Role role) {
            this.role = role;
        }

        public void documentAboutToBeChanged(DocumentEvent documentEvent) {
            this.oldDocument = new Document(documentEvent.getDocument().get());
        }

        public void documentChanged(DocumentEvent documentEvent) {
            if (!this.firstEditHandled) {
                EditInfo editInfo = new EditInfo(documentEvent.fOffset, documentEvent.fLength, documentEvent.fText.length(), this.role);
                EditTracker.this.setDocument(documentEvent.getDocument(), this.oldDocument, this.role, editInfo);
                this.preventDuplicationEdit = true;
                this.firstEditHandled = true;
            }
        }

        public void textChanged(TextEvent textEvent) {
            if (textEvent.getDocumentEvent() == null) {
                EditTracker.this.removeEditsBlock(this.role);
                EditTracker.this.setDocument(EditTracker.this.viewers[this.role.toInt()].getDocument(), null, this.role, null);
            } else if (!this.preventDuplicationEdit) {
                EditInfo editInfo = new EditInfo(textEvent.getOffset(), textEvent.getLength(), textEvent.getText().length(), this.role);
                EditTracker.this.setDocument(textEvent.getDocumentEvent().fDocument, this.oldDocument, this.role, editInfo);
            } else {
                this.preventDuplicationEdit = false;
            }
        }
    }
}

