/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.text.internal.ui;

import com.deltawalker.PrefKey;
import com.deltawalker.differencer.range.DiffRange;
import com.deltawalker.script.Delta;
import com.deltawalker.script.Role;
import com.deltawalker.text.MergeOp;
import com.deltawalker.text.internal.ui.LineBackgroundListenerProxy;
import com.deltawalker.text.ui.TextDiffView;
import com.deltawalker.ui.DeltaPart;
import com.deltopia.ui.swt.KeyUtil;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.CursorLinePainter;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerExtension;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.LineBackgroundEvent;
import org.eclipse.swt.custom.LineBackgroundListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;

public class DeltaSourceViewer
extends SourceViewer {
    private LineBackgroundListener onLineBg;
    private LineBackgroundListenerProxy onLineBgProxy;
    private final Role role;
    private TextDiffView tdView;

    public DeltaSourceViewer(Composite composite, IVerticalRuler iVerticalRuler, int n, TextDiffView textDiffView, Role role) {
        super(composite, (IVerticalRuler)(iVerticalRuler == null ? new CompositeRuler() : iVerticalRuler), n == 0 ? 768 : n);
        Control control;
        this.tdView = textDiffView;
        this.role = role;
        iVerticalRuler = this.getVerticalRuler();
        if (iVerticalRuler != null && (control = iVerticalRuler.getControl()) instanceof Composite) {
            textDiffView.createMergeArrow((ITextViewer)this, (Composite)control, 0, -1, false);
        }
        textDiffView.createMergeArrow((ITextViewer)this, (Composite)this.getTextWidget(), -1, -1, true);
        boolean bl = textDiffView.getInput().preferences().getBoolean(PrefKey.T_WRAP_LINES.toString());
        StyledText styledText = this.getTextWidget();
        styledText.setWordWrap(bl);
        styledText.setKeyBinding(0x1000002 | SWT.MOD1, 0);
        styledText.setKeyBinding(0x1000001 | SWT.MOD1, 0);
    }

    protected StyledText createTextWidget(Composite composite, int n) {
        this.onLineBg = new LineBackgroundListener(){

            public void lineGetBackground(LineBackgroundEvent lineBackgroundEvent) {
                DeltaSourceViewer.this.onLineGetBackground(lineBackgroundEvent);
            }
        };
        StyledText styledText = new StyledText(composite, n){
            private boolean noMouseWheel;
            {
                this.noMouseWheel = true;
            }

            public void addLineBackgroundListener(LineBackgroundListener lineBackgroundListener) {
                if (lineBackgroundListener == DeltaSourceViewer.this.onLineBg || lineBackgroundListener instanceof CursorLinePainter) {
                    if (DeltaSourceViewer.this.onLineBgProxy == null) {
                        DeltaSourceViewer.this.onLineBgProxy = new LineBackgroundListenerProxy();
                        DeltaSourceViewer.this.onLineBgProxy.setBackgroundLineColor(this.getBackground());
                        DeltaSourceViewer.this.onLineBgProxy.addLineBackgroundListener(lineBackgroundListener);
                        DeltaSourceViewer.this.onLineBgProxy.addLineBackgroundListener(DeltaSourceViewer.this.onLineBg);
                        super.addLineBackgroundListener((LineBackgroundListener)DeltaSourceViewer.this.onLineBgProxy);
                    } else {
                        DeltaSourceViewer.this.onLineBgProxy.addLineBackgroundListener(lineBackgroundListener);
                    }
                } else {
                    super.addLineBackgroundListener(lineBackgroundListener);
                }
            }

            public void addListener(int n, Listener listener) {
                if (n == 37 && this.noMouseWheel) {
                    this.noMouseWheel = false;
                    return;
                }
                super.addListener(n, listener);
            }

            public void setBackground(Color color) {
                super.setBackground(color);
                if (DeltaSourceViewer.this.onLineBgProxy != null) {
                    DeltaSourceViewer.this.onLineBgProxy.setBackgroundLineColor(this.getBackground());
                }
            }
        };
        styledText.addLineBackgroundListener(this.onLineBg);
        styledText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                DeltaSourceViewer.this.handleKeyDown(keyEvent);
            }
        });
        return styledText;
    }

    protected void handleDispose() {
        List<LineBackgroundListener> list = this.onLineBgProxy.listeners();
        StyledText styledText = this.getTextWidget();
        for (LineBackgroundListener lineBackgroundListener : list) {
            styledText.removeLineBackgroundListener(lineBackgroundListener);
        }
        this.onLineBgProxy.removeLineBackgroundListener(this.onLineBg);
        this.onLineBgProxy.dispose();
        this.tdView = null;
        super.handleDispose();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleKeyDown(KeyEvent keyEvent) {
        Role role;
        MergeOp mergeOp = null;
        switch (keyEvent.keyCode) {
            case 103: {
                if (!KeyUtil.hasMask((KeyEvent)keyEvent, (int)262144)) break;
                mergeOp = MergeOp.REPLACE;
                break;
            }
            case 104: {
                if (KeyUtil.hasMask((KeyEvent)keyEvent, (int)393216)) {
                    mergeOp = MergeOp.DELETE;
                    break;
                }
                if (!KeyUtil.hasMask((KeyEvent)keyEvent, (int)262144)) break;
                mergeOp = MergeOp.APPEND;
            }
        }
        if (mergeOp == null) return;
        if (this.tdView.isThreeWay()) {
            if (768 == this.tdView.getOrientation()) {
                if (Role.ONE == this.role) {
                    role = Role.TWO;
                } else {
                    if (Role.TWO != this.role) return;
                    role = Role.ONE;
                }
            } else {
                if (this.role == Role.REF) return;
                role = Role.REF;
            }
        } else {
            role = Role.ONE == this.role ? Role.TWO : Role.ONE;
        }
        DiffRange diffRange = this.tdView.deltaModel().getSelected();
        try {
            this.tdView.deltaModel().merge(mergeOp, Arrays.asList(diffRange), this.role, role, null);
            return;
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    public boolean isHScrollbarVisible() {
        Control control = this.getVerticalRuler().getControl();
        return control.getSize().y != this.getControl().getSize().y;
    }

    private void onLineGetBackground(LineBackgroundEvent lineBackgroundEvent) {
        boolean bl = this.tdView.isThreeWay();
        if (!bl && this.role == Role.TWO) {
            return;
        }
        DiffRange diffRange = this.tdView.getHitDelta((ITextViewer)this, lineBackgroundEvent.lineOffset, lineBackgroundEvent.lineOffset);
        if (diffRange != null && !diffRange.shouldSkipPaint(this.role)) {
            Color color = this.tdView.getColor((Delta)diffRange, DeltaPart.BG);
            assert (color != null);
            lineBackgroundEvent.lineBackground = color;
            return;
        }
        lineBackgroundEvent.lineBackground = this.getTextWidget().getBackground();
    }

    public void redraw() {
        this.getControl().redraw();
    }

    public Role role() {
        return this.role;
    }

    public void setFont(Font font) {
        Control control;
        IVerticalRuler iVerticalRuler;
        StyledText styledText = this.getTextWidget();
        if (styledText != null) {
            styledText.setFont(font);
        }
        if ((iVerticalRuler = this.getVerticalRuler()) instanceof IVerticalRulerExtension) {
            ((IVerticalRulerExtension)iVerticalRuler).setFont(font);
        }
        if ((control = this.getControl()) instanceof Composite) {
            ((Composite)control).layout();
        }
    }

    public String toString() {
        return "DeltaSourceViewer for role " + this.role;
    }
}

