/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.text.internal;

import com.deltawalker.text.internal.TextPlugin;
import com.deltopia.io.ByteBuffer;
import com.deltopia.io.ByteSequenceInputStream;
import com.deltopia.io.IByteSequence;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class SnapshotStorage
implements IEncodedStorage {
    private static final int BUFFER_SIZE = 4096;
    private String charset;
    private IByteSequence contents;
    private final IStorage storage;

    public SnapshotStorage(IStorage iStorage) {
        Assert.isNotNull((Object)iStorage);
        this.storage = iStorage;
    }

    public Object getAdapter(Class clazz) {
        return this.storage.getAdapter(clazz);
    }

    public String getCharset() throws CoreException {
        this.runPendingTakeSnapshot();
        return this.charset;
    }

    public InputStream getContents() throws CoreException {
        this.runPendingTakeSnapshot();
        return new ByteSequenceInputStream(this.contents);
    }

    public IPath getFullPath() {
        return this.storage.getFullPath();
    }

    public String getName() {
        return this.storage.getName();
    }

    public boolean isReadOnly() {
        return this.storage.isReadOnly();
    }

    private synchronized void runPendingTakeSnapshot() throws CoreException {
        if (this.contents == null) {
            this.takeSnapshot();
        }
    }

    private void takeSnapshot() throws CoreException {
        try {
            ByteBuffer byteBuffer = new ByteBuffer();
            try (InputStream inputStream = this.storage.getContents();){
                int n;
                byte[] byArray = new byte[4096];
                while ((n = inputStream.read(byArray)) != -1) {
                    byteBuffer.append(byArray, 0, n);
                }
            }
            this.contents = byteBuffer;
        }
        catch (IOException iOException) {
            throw new CoreException((IStatus)new Status(4, TextPlugin.getPluginId(), 4, iOException.getLocalizedMessage(), (Throwable)iOException));
        }
        if (this.storage instanceof IEncodedStorage) {
            this.charset = ((IEncodedStorage)this.storage).getCharset();
        }
    }
}

