/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.text;

import com.deltawalker.App;
import com.deltawalker.Doc;
import com.deltawalker.DocReaderFactory;
import com.deltawalker.DocType;
import com.deltawalker.EncodingUtil;
import com.deltawalker.IPersistable;
import com.deltawalker.IStreamContentAccessor;
import com.deltawalker.InputStreamUtil;
import com.deltawalker.PrefKey;
import com.deltawalker.SaveAs;
import com.deltawalker.UriInfo;
import com.deltawalker.interfaces.IDiffDoc;
import com.deltawalker.interfaces.IDocReaderFactory;
import com.deltawalker.interfaces.IEncodedStreamContentAccessor;
import com.deltawalker.resources.IPersistableResource;
import com.deltawalker.resources.IResource;
import com.deltawalker.resources.IResourceFactory;
import com.deltawalker.resources.ResourceFactory;
import com.deltawalker.script.Role;
import com.deltawalker.text.ITextDoc;
import com.deltawalker.text.internal.SnapshotStorage;
import com.deltawalker.text.internal.StreamContentAccessorStorage;
import com.deltawalker.text.source.LineEndingStrategy;
import com.deltawalker.ui.FileFilterUtil;
import com.deltawalker.ui.UIMsg;
import com.deltawalker.ui.UIUtil;
import com.deltawalker.ui.dialogs.FileDialogEx;
import com.deltawalker.ui.dialogs.ILocalResourceDialog;
import com.deltawalker.ui.dialogs.IResourceDialog;
import com.deltopia.ObjectUtil;
import com.deltopia.StringUtil;
import com.deltopia.io.BomHeader;
import com.deltopia.io.ByteBuffer;
import com.deltopia.io.ByteSequenceInputStream;
import com.deltopia.io.ContentType;
import com.deltopia.io.FileUtil;
import com.deltopia.io.IByteSequence;
import com.deltopia.io.StreamUtil;
import com.deltopia.io.TextEncoding;
import com.deltopia.io.UriInfoKey;
import com.deltopia.util.Checker;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ConcurrentModificationException;
import java.util.Locale;
import java.util.Objects;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextDoc
extends Doc
implements ITextDoc,
IPersistable,
IStorageEditorInput,
IEncodedStreamContentAccessor {
    private static final Logger LOG = LoggerFactory.getLogger(TextDoc.class);
    private static long MAX_SIZE_FOR_UNDO = 0xA00000L;
    private IDocument document;
    private String initialContent = "";
    private boolean modified;
    private final IDocumentListener onDocument = new IDocumentListener(){

        public void documentAboutToBeChanged(DocumentEvent documentEvent) {
        }

        public void documentChanged(DocumentEvent documentEvent) {
            TextDoc.this.setModified(!TextDoc.this.document().get().equals(TextDoc.this.initialContent));
        }
    };

    public TextDoc(IDiffDoc iDiffDoc, Role role, IResource iResource, ContentType contentType) {
        super(iDiffDoc, role, iResource, contentType);
        boolean bl;
        boolean bl2 = bl = iResource != null && iResource.getSize() <= App.instance().contentTypeBoss().textCompareMaxFileSize();
        if (!contentType.isBinary() && bl) {
            this.document();
        }
    }

    public void clear() {
        if (this.document != null) {
            this.document.set("");
        }
        this.initialContent = "";
        this.modified = false;
        super.clear();
    }

    private boolean confirmFileOverwrite(String string, boolean bl) {
        if (!bl && this.isModifiable()) {
            return true;
        }
        Shell shell = UIUtil.getActiveWindowShell();
        MessageBox messageBox = new MessageBox(shell, 196);
        messageBox.setText(UIMsg.DiffView_ResourceAttrDlgBox_title);
        messageBox.setMessage(NLS.bind((String)UIMsg.DiffView_ResourceAttrDlgBox_msg, (Object)string));
        return messageBox.open() == 64;
    }

    public void dispose() {
        try {
            if (this.document != null) {
                this.document.removeDocumentListener(this.onDocument);
                this.document = null;
            }
        }
        finally {
            super.dispose();
        }
    }

    public DocType docType() {
        return DocType.TEXT;
    }

    public IDocument document() {
        if (this.document == null) {
            this.document = new Document();
            if (this.resource() != null && !this.contentType().isBinary()) {
                this.doLoad(null, null);
            }
            this.document.addDocumentListener(this.onDocument);
        }
        return this.document;
    }

    /*
     * Unable to fully structure code
     */
    public void doLoad(String var1_1, IProgressMonitor var2_2) {
        block18: {
            var3_3 = null;
            var4_4 = null;
            var5_5 = this.resource();
            if (!this.isModified() || var5_5 == null) ** GOTO lbl17
            var6_7 = new IByteSequence[]{"Save", IDialogConstants.CANCEL_LABEL, "Don't Save"};
            var7_8 = UIUtil.showConfirmActionPrompt(null, (String)NLS.bind((String)"''{0}'' has changed.\n\nDo you want to save your changes before continuing?", (Object)var5_5.getUri()), (String[])var6_7);
            if (var7_8 != 1) break block18;
            StreamUtil.closeSilently((Closeable)var3_3);
            return;
        }
        try {
            try {
                if (var7_8 == 0) {
                    this.doSave(null);
                }
lbl17:
                // 4 sources

                if (var1_1 != null && var5_5 instanceof IPersistableResource) {
                    var6_7 = ((IPersistableResource)var5_5).load(var1_1, var2_2);
                } else if (var5_5 instanceof IStreamContentAccessor) {
                    var3_3 = ((IStreamContentAccessor)var5_5).getContents();
                    var6_7 = var3_3 instanceof ByteSequenceInputStream ? ((ByteSequenceInputStream)var3_3).getSequence() : InputStreamUtil.readStream((InputStream)var3_3, (ByteBuffer)new ByteBuffer());
                } else if (var1_1 == null && var5_5 instanceof IPersistableResource) {
                    var6_7 = ((IPersistableResource)var5_5).load(var1_1, var2_2);
                } else {
                    throw new IOException("Cannot acquire file content");
                }
                var7_9 = var5_5.getParent();
                if (var7_9 == null && (var8_10 = super.docType()).isCompoundDoc()) {
                    var4_4 = this.loadCompoundDoc(var6_7, var3_3);
                }
                if (var4_4 == null) {
                    var8_10 = this.uriInfo();
                    var9_11 = var8_10.textEncoding();
                    if (var9_11 == null) {
                        var9_11 = this.getEncoding();
                    }
                    var10_12 = 0;
                    var11_13 = var5_5.getSize();
                    if (var3_3 != null) {
                        var10_12 = App.instance().contentTypeBoss().getBOMLength(var3_3, var11_13);
                    }
                    try {
                        var4_4 = var6_7.toString(var9_11.charset(), var10_12);
                        this.setEncoding(var9_11, false);
                    }
                    catch (UnsupportedEncodingException var13_14) {
                        TextDoc.LOG.warn("Couldn't convert bytes to String: " + var9_11, (Object)var13_14.getMessage());
                        var4_4 = var6_7.toString(var10_12);
                    }
                }
                this.initialize(var4_4);
            }
            catch (IOException var5_6) {
                this.setUriInfoError(var5_6);
                StreamUtil.closeSilently(var3_3);
            }
        }
        catch (Throwable var14_15) {
            StreamUtil.closeSilently(var3_3);
            throw var14_15;
        }
        StreamUtil.closeSilently((Closeable)var3_3);
    }

    public boolean doSave(IProgressMonitor iProgressMonitor) throws IOException {
        return this.save(iProgressMonitor, false, SaveAs.PRESERVE);
    }

    public boolean doSave(UriInfo uriInfo, IProgressMonitor iProgressMonitor) throws IOException {
        BomHeader bomHeader;
        byte[] byArray;
        TextEncoding textEncoding;
        TextEncoding textEncoding2;
        Job job = App.instance().jobBoss().runningJob();
        if (job != null) {
            String string = job.getName();
            throw new ConcurrentModificationException(NLS.bind((String)"A ''{0}'' operation is underway. Wait for it to end before saving this file.", (Object)string));
        }
        if (!ObjectUtil.areEqual((Object)uriInfo.uri(), (Object)this.uriInfo().uri())) {
            this.setResource(ResourceFactory.staticCreateResource((UriInfo)uriInfo, (boolean)true, (boolean)false));
        }
        String string = this.document().get();
        if (!StringUtil.isEmpty((String)uriInfo.lineEnding())) {
            string = LineEndingStrategy.replaceAllByName((String)string, (String)uriInfo.lineEnding());
        }
        if ((textEncoding2 = (textEncoding = uriInfo.textEncoding())) == null) {
            textEncoding2 = this.getEncoding();
        }
        try {
            byArray = string.getBytes(textEncoding2.charset());
            if (textEncoding2 != null && (bomHeader = textEncoding2.bom()) != null) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(bomHeader.length() + byArray.length);
                bomHeader.writeTo((OutputStream)byteArrayOutputStream);
                byteArrayOutputStream.write(byArray);
                byArray = byteArrayOutputStream.toByteArray();
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            textEncoding2 = null;
            byArray = string.getBytes();
        }
        bomHeader = this.saveByteResourceOpt(uriInfo, byArray, iProgressMonitor);
        if (textEncoding == null) {
            uriInfo = uriInfo.cloneUpdateEncoding(textEncoding2);
        }
        boolean bl = bomHeader == null;
        this.setUriInfo(uriInfo, bl);
        this.initialize(string);
        this.getName();
        return true;
    }

    public boolean doSaveAs(SaveAs saveAs) throws IOException {
        return this.save((IProgressMonitor)new NullProgressMonitor(), true, saveAs);
    }

    public boolean exists() {
        return false;
    }

    public Object getAdapter(Class clazz) {
        if (IDocument.class.equals((Object)clazz)) {
            return this.document();
        }
        return null;
    }

    public InputStream getContents() throws IOException {
        String string = this.document().get();
        return new ByteArrayInputStream(string.getBytes(this.getEncoding().charset()));
    }

    public TextEncoding getEncoding() {
        TextEncoding textEncoding = this.uriInfo().textEncoding();
        if (this.hasResource()) {
            IResource iResource = this.resource();
            long l = iResource.getSize();
            if (textEncoding == null && l > 0L) {
                try {
                    textEncoding = App.instance().contentTypeBoss().detectEncoding(iResource);
                    if (textEncoding != null) {
                        this.setEncoding(textEncoding, false);
                    }
                }
                catch (IOException iOException) {
                    LOG.info("Couldn't detect encoding. ", (Object)iOException.getMessage());
                }
            }
        }
        if (textEncoding == null) {
            textEncoding = EncodingUtil.getTextEncoding((IPreferenceStore)this.preferences());
        }
        return textEncoding;
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageDescriptor.getMissingImageDescriptor();
    }

    public Locale getLocale() {
        return this.uriInfo().locale();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public IStorage getStorage() throws CoreException {
        if (this.shouldOfferQuickDiffs()) {
            return new SnapshotStorage((IStorage)new StreamContentAccessorStorage((IStreamContentAccessor)this){

                @Override
                public Object getAdapter(Class clazz) {
                    if (String.class.equals((Object)clazz)) {
                        return StringUtil.makeSafe((String)TextDoc.this.initialContent);
                    }
                    return super.getAdapter(clazz);
                }
            });
        }
        return null;
    }

    public String getToolTipText() {
        return null;
    }

    public void initialize(String string) {
        if (!(this.document() == null || string == null || this.document.getLength() == string.length() && this.document.get().equals(string))) {
            this.document.set(string);
        }
        if (this.shouldOfferQuickDiffs()) {
            this.initialContent = string;
        }
        this.setModified(false);
    }

    public boolean isModified() {
        return this.modified;
    }

    private String loadCompoundDoc(IByteSequence iByteSequence, InputStream inputStream) {
        IPreferenceStore iPreferenceStore = this.preferences();
        final String[] stringArray = new String[1];
        ByteSequenceInputStream byteSequenceInputStream = new ByteSequenceInputStream(iByteSequence);
        final DocType docType = super.docType();
        BusyIndicator.showWhile(null, (Runnable)new Runnable((InputStream)byteSequenceInputStream, iPreferenceStore){
            private final /* synthetic */ InputStream val$bsis;
            private final /* synthetic */ IPreferenceStore val$prefs;
            {
                this.val$bsis = inputStream;
                this.val$prefs = iPreferenceStore;
            }

            @Override
            public void run() {
                try {
                    IDocReaderFactory iDocReaderFactory;
                    if (docType.isCompoundDoc() && (iDocReaderFactory = DocReaderFactory.getFactory((String)"com.deltawalker.vfs.compoundDocReaderFactory")) != null) {
                        boolean bl;
                        stringArray[0] = iDocReaderFactory.createReader().extractText(this.val$bsis, TextDoc.this.contentType());
                        if (docType != DocType.PDF && (bl = this.val$prefs.getBoolean(PrefKey.T_BREAK_AT_POSITION_ON.toString()))) {
                            stringArray[0] = LineEndingStrategy.insertLineDelimiters((String)stringArray[0], (int)this.val$prefs.getInt(PrefKey.T_BREAK_AT_POSITION.toString()));
                        }
                    }
                }
                catch (Throwable throwable) {
                    LOG.error(NLS.bind((String)"Couldn''t parse ''{0}'': {1}", (Object)TextDoc.this.uriInfo().uri(), (Object)throwable), throwable);
                    TextDoc.this.setUriInfoError(throwable);
                }
            }
        });
        return stringArray[0];
    }

    private UriInfo prepareForSaving(boolean bl, SaveAs saveAs) throws IOException {
        IResource iResource;
        block13: {
            UriInfo uriInfo = this.getMergedUriInfo();
            if (uriInfo != null && !uriInfo.isEmpty()) {
                this.setResource(ResourceFactory.staticCreateResource((UriInfo)uriInfo, (boolean)true, (boolean)false));
                return uriInfo;
            }
            if (!(!this.hasResource() || (iResource = this.resource()).factory().resourceExists(this.uriInfo()) && iResource.canEverWrite())) {
                bl = true;
            }
            if (!bl && !this.confirmFileOverwrite(this.getName(), false)) {
                return null;
            }
            this.resource();
            if (!this.hasResource() || bl) {
                UriInfo uriInfo2 = this.uriInfo();
                String string = uriInfo2.uri();
                if (this.hasResource() && this.resource().contentType().isCompoundDoc()) {
                    string = FileUtil.replaceExtension((String)string, (String)"txt");
                }
                if ((iResource = this.showSaveDialog(uriInfo2.cloneUpdateUri(string, false), saveAs)) == null) {
                    return null;
                }
                IResource iResource2 = this.hasResource() ? this.resource() : null;
                IResource iResource3 = null;
                try {
                    this.setResource(null);
                    try {
                        iResource3 = ResourceFactory.staticCreateResource((UriInfo)iResource, (boolean)true, (boolean)false);
                    }
                    catch (IOException iOException) {
                        iResource = iResource.cloneUpdateError((Throwable)iOException);
                    }
                    if (iResource3 != null && !iResource3.isWritable() && !this.confirmFileOverwrite(iResource3.getName(), true)) {
                        iResource3 = null;
                        return null;
                    }
                    break block13;
                }
                finally {
                    if (iResource3 == null) {
                        iResource3 = iResource2;
                    }
                    this.setResource(iResource3);
                }
            }
            iResource = this.uriInfo();
        }
        return iResource;
    }

    private boolean save(IProgressMonitor iProgressMonitor, boolean bl, SaveAs saveAs) throws IOException {
        UriInfo uriInfo = this.prepareForSaving(bl, saveAs);
        if (uriInfo == null) {
            return false;
        }
        return this.doSave(uriInfo, iProgressMonitor);
    }

    public void setEncoding(String string, boolean bl) {
        this.setEncoding(TextEncoding.fromCharset((String)string), bl);
    }

    public void setEncoding(TextEncoding textEncoding, boolean bl) {
        Checker.notNull((Object)textEncoding, (String)"encoding");
        UriInfo uriInfo = this.uriInfo();
        if (!Objects.equals(textEncoding, uriInfo.textEncoding())) {
            IDiffDoc iDiffDoc = this.deltaDoc();
            Role role = this.role();
            iDiffDoc.updateUriInfo(role, UriInfo.Field.ENCODING, (Object)textEncoding);
            if (bl) {
                this.doLoad(null, null);
            }
        }
    }

    public void setLineEnding(String string) {
        if (StringUtil.isEmpty((String)string)) {
            throw new IllegalArgumentException("lineEnding");
        }
        UriInfo uriInfo = this.uriInfo();
        if (!ObjectUtil.areEqual((Object)uriInfo.lineEnding(), (Object)string)) {
            String string2 = this.document().get();
            if (!string2.isEmpty()) {
                string2 = LineEndingStrategy.replaceAllByName((String)string2, (String)string);
                this.document.set(string2);
            }
            this.deltaDoc().updateUriInfo(this.role(), UriInfo.Field.LINE_ENDING, (Object)string);
            this.fireUriInfoChanged("LINE_ENDING");
        }
    }

    public void setLocale(Locale locale, boolean bl) {
        UriInfo uriInfo = this.uriInfo();
        if (!ObjectUtil.areEqual((Object)uriInfo.locale(), (Object)locale)) {
            this.deltaDoc().updateUriInfo(this.role(), UriInfo.Field.LOCALE, (Object)locale);
            if (bl) {
                this.doLoad(null, null);
            }
        }
    }

    public void setModified(boolean bl) {
        boolean bl2 = this.modified;
        this.modified = bl;
        this.firePropertyChanged("MODIFIED", bl2, bl);
    }

    private void setUriInfo(UriInfo uriInfo, boolean bl) {
        boolean bl2;
        UriInfo uriInfo2 = uriInfo;
        UriInfo uriInfo3 = this.uriInfo();
        boolean bl3 = this.hasResource() ? this.resource().factory().isCaseSensitive() : true;
        boolean bl4 = bl3 ? uriInfo3.uri().equals(uriInfo2.uri()) : uriInfo3.uri().equalsIgnoreCase(uriInfo2.uri());
        boolean bl5 = bl2 = bl ? true : ObjectUtil.areEqual((Object)uriInfo3.lineEnding(), (Object)uriInfo2.lineEnding());
        if (bl4 && bl2) {
            return;
        }
        this.deltaDoc().updateUriInfo(this.role(), UriInfo.Field.ALL, (Object)uriInfo);
        String string = "";
        if (bl || !bl4) {
            string = "URI";
        } else if (!bl2) {
            string = "LINE_ENDING";
        }
        if (!StringUtil.isEmpty((String)string)) {
            this.fireUriInfoChanged(string);
        }
    }

    private boolean shouldOfferQuickDiffs() {
        IResource iResource = this.resource();
        if (iResource != null) {
            long l = iResource != null ? iResource.getSize() : 0L;
            boolean bl = !this.contentType().isBinary() && l < MAX_SIZE_FOR_UNDO;
            return bl;
        }
        return true;
    }

    private UriInfo showSaveDialog(UriInfo uriInfo, SaveAs saveAs) {
        IResourceFactory iResourceFactory = saveAs == SaveAs.PRESERVE && this.hasResource() ? this.resource().factory() : ResourceFactory.getFactory((String)(saveAs == SaveAs.REMOTE ? "com.deltawalker.vfs.vfsResourceFactory" : "com.deltawalker.localResourceFactory"));
        IPreferenceStore iPreferenceStore = this.preferences();
        String string = this.role().getDisplayName(this.deltaDoc().isThreeWay());
        IResourceDialog iResourceDialog = iResourceFactory.createResourceWindow(this.role(), true, false, string, iPreferenceStore, uriInfo);
        if (iResourceFactory.isLocal()) {
            ILocalResourceDialog iLocalResourceDialog = (ILocalResourceDialog)iResourceDialog;
            iLocalResourceDialog.setFilterPath(FileDialogEx.chooseFilterPath((UriInfo)uriInfo, (String)this.role().toString(), (IPreferenceStore)iPreferenceStore));
            iLocalResourceDialog.setFilterNames(FileFilterUtil.getDefaultFilterNames());
            iLocalResourceDialog.setFilterExtensions(FileFilterUtil.getDefaultFilterExtensions());
            UriInfo uriInfo2 = this.uriInfo();
            Locale locale = (Locale)uriInfo2.property(UriInfoKey.LOCALE, null);
            if (locale != null) {
                iLocalResourceDialog.setSelectedLocale(locale);
            } else {
                iLocalResourceDialog.setSelectedEncoding(this.getEncoding());
            }
            String string2 = (String)uriInfo2.property(UriInfoKey.LINE_ENDING, null);
            iLocalResourceDialog.setSelectedLineEnding(string2);
        }
        uriInfo = iResourceDialog.show();
        return uriInfo;
    }
}

