/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.wavelet.synthesis;

import java.awt.Point;
import jj2000.j2k.decoder.DecoderSpecs;
import jj2000.j2k.wavelet.synthesis.InvWT;
import jj2000.j2k.wavelet.synthesis.MultiResImgData;
import jj2000.j2k.wavelet.synthesis.SubbandSyn;

public abstract class InvWTAdapter
implements InvWT {
    protected DecoderSpecs decSpec;
    protected MultiResImgData mressrc;
    protected int reslvl;
    protected int maxImgRes;

    protected InvWTAdapter(MultiResImgData multiResImgData, DecoderSpecs decoderSpecs) {
        this.mressrc = multiResImgData;
        this.decSpec = decoderSpecs;
        this.maxImgRes = decoderSpecs.dls.getMin();
    }

    @Override
    public void setImgResLevel(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Resolution level index cannot be negative.");
        }
        this.reslvl = n;
    }

    @Override
    public int getTileWidth() {
        int n = this.getTileIdx();
        int n2 = 10000;
        int n3 = this.mressrc.getNumComps();
        int n4 = 0;
        while (n4 < n3) {
            int n5 = this.mressrc.getSynSubbandTree((int)n, (int)n4).resLvl;
            if (n5 < n2) {
                n2 = n5;
            }
            ++n4;
        }
        return this.mressrc.getTileWidth(n2);
    }

    @Override
    public int getTileHeight() {
        int n = this.getTileIdx();
        int n2 = 10000;
        int n3 = this.mressrc.getNumComps();
        int n4 = 0;
        while (n4 < n3) {
            int n5 = this.mressrc.getSynSubbandTree((int)n, (int)n4).resLvl;
            if (n5 < n2) {
                n2 = n5;
            }
            ++n4;
        }
        return this.mressrc.getTileHeight(n2);
    }

    @Override
    public int getNomTileWidth() {
        return this.mressrc.getNomTileWidth();
    }

    @Override
    public int getNomTileHeight() {
        return this.mressrc.getNomTileHeight();
    }

    @Override
    public int getImgWidth() {
        return this.mressrc.getImgWidth(this.reslvl);
    }

    @Override
    public int getImgHeight() {
        return this.mressrc.getImgHeight(this.reslvl);
    }

    @Override
    public int getNumComps() {
        return this.mressrc.getNumComps();
    }

    @Override
    public int getCompSubsX(int n) {
        return this.mressrc.getCompSubsX(n);
    }

    @Override
    public int getCompSubsY(int n) {
        return this.mressrc.getCompSubsY(n);
    }

    @Override
    public int getTileCompWidth(int n, int n2) {
        int n3 = this.mressrc.getSynSubbandTree((int)n, (int)n2).resLvl;
        return this.mressrc.getTileCompWidth(n, n2, n3);
    }

    @Override
    public int getTileCompHeight(int n, int n2) {
        int n3 = this.mressrc.getSynSubbandTree((int)n, (int)n2).resLvl;
        return this.mressrc.getTileCompHeight(n, n2, n3);
    }

    @Override
    public int getCompImgWidth(int n) {
        int n2 = this.decSpec.dls.getMinInComp(n);
        return this.mressrc.getCompImgWidth(n, n2);
    }

    @Override
    public int getCompImgHeight(int n) {
        int n2 = this.decSpec.dls.getMinInComp(n);
        return this.mressrc.getCompImgHeight(n, n2);
    }

    @Override
    public void setTile(int n, int n2) {
        this.mressrc.setTile(n, n2);
    }

    @Override
    public void nextTile() {
        this.mressrc.nextTile();
    }

    @Override
    public Point getTile(Point point) {
        return this.mressrc.getTile(point);
    }

    @Override
    public int getTileIdx() {
        return this.mressrc.getTileIdx();
    }

    @Override
    public int getCompULX(int n) {
        int n2 = this.getTileIdx();
        int n3 = this.mressrc.getSynSubbandTree((int)n2, (int)n).resLvl;
        return this.mressrc.getResULX(n, n3);
    }

    @Override
    public int getCompULY(int n) {
        int n2 = this.getTileIdx();
        int n3 = this.mressrc.getSynSubbandTree((int)n2, (int)n).resLvl;
        return this.mressrc.getResULY(n, n3);
    }

    @Override
    public int getImgULX() {
        return this.mressrc.getImgULX(this.reslvl);
    }

    @Override
    public int getImgULY() {
        return this.mressrc.getImgULY(this.reslvl);
    }

    @Override
    public int getTilePartULX() {
        return this.mressrc.getTilePartULX();
    }

    @Override
    public int getTilePartULY() {
        return this.mressrc.getTilePartULY();
    }

    @Override
    public Point getNumTiles(Point point) {
        return this.mressrc.getNumTiles(point);
    }

    @Override
    public int getNumTiles() {
        return this.mressrc.getNumTiles();
    }

    public SubbandSyn getSynSubbandTree(int n, int n2) {
        return this.mressrc.getSynSubbandTree(n, n2);
    }
}

