/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.wavelet.analysis;

import jj2000.j2k.wavelet.Subband;
import jj2000.j2k.wavelet.WaveletFilter;
import jj2000.j2k.wavelet.analysis.AnWTFilter;

public class SubbandAn
extends Subband {
    public SubbandAn parent = null;
    public SubbandAn subb_LL;
    public SubbandAn subb_HL;
    public SubbandAn subb_LH;
    public SubbandAn subb_HH;
    public AnWTFilter hFilter;
    public AnWTFilter vFilter;
    public float l2Norm = -1.0f;
    public float stepWMSE;

    public SubbandAn() {
    }

    public SubbandAn(int n, int n2, int n3, int n4, int n5, WaveletFilter[] waveletFilterArray, WaveletFilter[] waveletFilterArray2) {
        super(n, n2, n3, n4, n5, waveletFilterArray, waveletFilterArray2);
        this.calcL2Norms();
    }

    @Override
    public Subband getParent() {
        return this.parent;
    }

    @Override
    public Subband getLL() {
        return this.subb_LL;
    }

    @Override
    public Subband getHL() {
        return this.subb_HL;
    }

    @Override
    public Subband getLH() {
        return this.subb_LH;
    }

    @Override
    public Subband getHH() {
        return this.subb_HH;
    }

    @Override
    protected Subband split(WaveletFilter waveletFilter, WaveletFilter waveletFilter2) {
        if (this.isNode) {
            throw new IllegalArgumentException();
        }
        this.isNode = true;
        this.hFilter = (AnWTFilter)waveletFilter;
        this.vFilter = (AnWTFilter)waveletFilter2;
        this.subb_LL = new SubbandAn();
        this.subb_LH = new SubbandAn();
        this.subb_HL = new SubbandAn();
        this.subb_HH = new SubbandAn();
        this.subb_LL.parent = this;
        this.subb_HL.parent = this;
        this.subb_LH.parent = this;
        this.subb_HH.parent = this;
        this.initChilds();
        return this.subb_LL;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void calcBasisWaveForms(float[][] fArray) {
        if (!(this.l2Norm < 0.0f)) throw new Error("You have found a bug in JJ2000!");
        if (this.isNode) {
            if (this.subb_LL.l2Norm < 0.0f) {
                this.subb_LL.calcBasisWaveForms(fArray);
                fArray[0] = this.hFilter.getLPSynWaveForm(fArray[0], null);
                fArray[1] = this.vFilter.getLPSynWaveForm(fArray[1], null);
                return;
            } else if (this.subb_HL.l2Norm < 0.0f) {
                this.subb_HL.calcBasisWaveForms(fArray);
                fArray[0] = this.hFilter.getHPSynWaveForm(fArray[0], null);
                fArray[1] = this.vFilter.getLPSynWaveForm(fArray[1], null);
                return;
            } else if (this.subb_LH.l2Norm < 0.0f) {
                this.subb_LH.calcBasisWaveForms(fArray);
                fArray[0] = this.hFilter.getLPSynWaveForm(fArray[0], null);
                fArray[1] = this.vFilter.getHPSynWaveForm(fArray[1], null);
                return;
            } else {
                if (!(this.subb_HH.l2Norm < 0.0f)) throw new Error("You have found a bug in JJ2000!");
                this.subb_HH.calcBasisWaveForms(fArray);
                fArray[0] = this.hFilter.getHPSynWaveForm(fArray[0], null);
                fArray[1] = this.vFilter.getHPSynWaveForm(fArray[1], null);
            }
            return;
        } else {
            fArray[0] = new float[1];
            fArray[0][0] = 1.0f;
            fArray[1] = new float[1];
            fArray[1][0] = 1.0f;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void assignL2Norm(float f) {
        if (!(this.l2Norm < 0.0f)) throw new Error("You have found a bug in JJ2000!");
        if (this.isNode) {
            if (this.subb_LL.l2Norm < 0.0f) {
                this.subb_LL.assignL2Norm(f);
                return;
            } else if (this.subb_HL.l2Norm < 0.0f) {
                this.subb_HL.assignL2Norm(f);
                return;
            } else if (this.subb_LH.l2Norm < 0.0f) {
                this.subb_LH.assignL2Norm(f);
                return;
            } else {
                if (!(this.subb_HH.l2Norm < 0.0f)) throw new Error("You have found a bug in JJ2000!");
                this.subb_HH.assignL2Norm(f);
                if (!(this.subb_HH.l2Norm >= 0.0f)) return;
                this.l2Norm = 0.0f;
            }
            return;
        } else {
            this.l2Norm = f;
        }
    }

    private void calcL2Norms() {
        float[][] fArrayArray = new float[2][];
        while (this.l2Norm < 0.0f) {
            this.calcBasisWaveForms(fArrayArray);
            double d = 0.0;
            int n = fArrayArray[0].length - 1;
            while (n >= 0) {
                d += (double)(fArrayArray[0][n] * fArrayArray[0][n]);
                --n;
            }
            float f = (float)Math.sqrt(d);
            d = 0.0;
            n = fArrayArray[1].length - 1;
            while (n >= 0) {
                d += (double)(fArrayArray[1][n] * fArrayArray[1][n]);
                --n;
            }
            fArrayArray[0] = null;
            fArrayArray[1] = null;
            this.assignL2Norm(f *= (float)Math.sqrt(d));
        }
    }

    @Override
    public WaveletFilter getHorWFilter() {
        return this.hFilter;
    }

    @Override
    public WaveletFilter getVerWFilter() {
        return this.hFilter;
    }
}

