/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.wavelet.analysis;

import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageWriteParamJava;
import java.awt.Point;
import jj2000.j2k.IntegerSpec;
import jj2000.j2k.entropy.CBlkSizeSpec;
import jj2000.j2k.entropy.PrecinctSizeSpec;
import jj2000.j2k.image.BlkImgDataSrc;
import jj2000.j2k.image.DataBlk;
import jj2000.j2k.image.DataBlkFloat;
import jj2000.j2k.image.DataBlkInt;
import jj2000.j2k.util.MathUtil;
import jj2000.j2k.wavelet.Subband;
import jj2000.j2k.wavelet.analysis.AnWTFilter;
import jj2000.j2k.wavelet.analysis.AnWTFilterSpec;
import jj2000.j2k.wavelet.analysis.CBlkWTData;
import jj2000.j2k.wavelet.analysis.CBlkWTDataFloat;
import jj2000.j2k.wavelet.analysis.CBlkWTDataInt;
import jj2000.j2k.wavelet.analysis.ForwardWT;
import jj2000.j2k.wavelet.analysis.SubbandAn;

public class ForwWTFull
extends ForwardWT {
    private boolean intData;
    private SubbandAn[][] subbTrees;
    private BlkImgDataSrc src;
    private int cb0x;
    private int cb0y;
    private IntegerSpec dls;
    private AnWTFilterSpec filters;
    private CBlkSizeSpec cblks;
    private PrecinctSizeSpec pss;
    private DataBlk[] decomposedComps;
    private int[] lastn;
    private int[] lastm;
    SubbandAn[] currentSubband;
    Point ncblks;

    public ForwWTFull(BlkImgDataSrc blkImgDataSrc, J2KImageWriteParamJava j2KImageWriteParamJava, int n, int n2) {
        super(blkImgDataSrc);
        this.src = blkImgDataSrc;
        this.cb0x = this.cb0x;
        this.cb0y = this.cb0y;
        this.dls = j2KImageWriteParamJava.getDecompositionLevel();
        this.filters = j2KImageWriteParamJava.getFilters();
        this.cblks = j2KImageWriteParamJava.getCodeBlockSize();
        this.pss = j2KImageWriteParamJava.getPrecinctPartition();
        int n3 = blkImgDataSrc.getNumComps();
        int n4 = blkImgDataSrc.getNumTiles();
        this.currentSubband = new SubbandAn[n3];
        this.decomposedComps = new DataBlk[n3];
        this.subbTrees = new SubbandAn[n4][n3];
        this.lastn = new int[n3];
        this.lastm = new int[n3];
    }

    @Override
    public int getImplementationType(int n) {
        return 2;
    }

    @Override
    public int getDecompLevels(int n, int n2) {
        return (Integer)this.dls.getTileCompVal(n, n2);
    }

    @Override
    public int getDecomp(int n, int n2) {
        return 0;
    }

    @Override
    public AnWTFilter[] getHorAnWaveletFilters(int n, int n2) {
        return this.filters.getHFilters(n, n2);
    }

    @Override
    public AnWTFilter[] getVertAnWaveletFilters(int n, int n2) {
        return this.filters.getVFilters(n, n2);
    }

    @Override
    public boolean isReversible(int n, int n2) {
        return this.filters.isReversible(n, n2);
    }

    @Override
    public int getCbULX() {
        return this.cb0x;
    }

    @Override
    public int getCbULY() {
        return this.cb0y;
    }

    @Override
    public int getFixedPoint(int n) {
        return this.src.getFixedPoint(n);
    }

    @Override
    public CBlkWTData getNextInternCodeBlock(int n, CBlkWTData cBlkWTData) {
        block13: {
            boolean bl = this.intData = this.filters.getWTDataType(this.tIdx, n) == 3;
            if (this.decomposedComps[n] == null) {
                int n2;
                DataBlk dataBlk;
                int n3 = this.getTileCompWidth(this.tIdx, n);
                int n4 = this.getTileCompHeight(this.tIdx, n);
                if (this.intData) {
                    this.decomposedComps[n] = new DataBlkInt(0, 0, n3, n4);
                    dataBlk = new DataBlkInt();
                } else {
                    this.decomposedComps[n] = new DataBlkFloat(0, 0, n3, n4);
                    dataBlk = new DataBlkFloat();
                }
                Object object = this.decomposedComps[n].getData();
                dataBlk.ulx = n2 = this.getCompULX(n);
                dataBlk.w = n3;
                dataBlk.h = 1;
                int n5 = this.getCompULY(n);
                int n6 = 0;
                while (n6 < n4) {
                    dataBlk.uly = n5++;
                    dataBlk.ulx = n2;
                    dataBlk = this.src.getInternCompData(dataBlk, n);
                    System.arraycopy(dataBlk.getData(), dataBlk.offset, object, n6 * n3, n3);
                    ++n6;
                }
                this.waveletTreeDecomposition(this.decomposedComps[n], this.getAnSubbandTree(this.tIdx, n), n);
                this.currentSubband[n] = this.getNextSubband(n);
                this.lastn[n] = -1;
                this.lastm[n] = 0;
            }
            do {
                this.ncblks = this.currentSubband[n].numCb;
                int n7 = n;
                this.lastn[n7] = this.lastn[n7] + 1;
                if (this.lastn[n] == this.ncblks.x) {
                    this.lastn[n] = 0;
                    int n8 = n;
                    this.lastm[n8] = this.lastm[n8] + 1;
                }
                if (this.lastm[n] < this.ncblks.y) break block13;
                this.currentSubband[n] = this.getNextSubband(n);
                this.lastn[n] = -1;
                this.lastm[n] = 0;
            } while (this.currentSubband[n] != null);
            this.decomposedComps[n] = null;
            return null;
        }
        int n9 = this.cb0x;
        int n10 = this.cb0y;
        switch (this.currentSubband[n].sbandIdx) {
            case 0: {
                break;
            }
            case 1: {
                n9 = 0;
                break;
            }
            case 2: {
                n10 = 0;
                break;
            }
            case 3: {
                n9 = 0;
                n10 = 0;
                break;
            }
            default: {
                throw new Error("Internal JJ2000 error");
            }
        }
        if (cBlkWTData == null) {
            cBlkWTData = this.intData ? new CBlkWTDataInt() : new CBlkWTDataFloat();
        }
        int n11 = this.lastn[n];
        int n12 = this.lastm[n];
        SubbandAn subbandAn = this.currentSubband[n];
        cBlkWTData.n = n11;
        cBlkWTData.m = n12;
        cBlkWTData.sb = subbandAn;
        int n13 = (subbandAn.ulcx - n9 + subbandAn.nomCBlkW) / subbandAn.nomCBlkW - 1;
        int n14 = (subbandAn.ulcy - n10 + subbandAn.nomCBlkH) / subbandAn.nomCBlkH - 1;
        cBlkWTData.ulx = n11 == 0 ? subbandAn.ulx : (n13 + n11) * subbandAn.nomCBlkW - (subbandAn.ulcx - n9) + subbandAn.ulx;
        cBlkWTData.uly = n12 == 0 ? subbandAn.uly : (n14 + n12) * subbandAn.nomCBlkH - (subbandAn.ulcy - n10) + subbandAn.uly;
        cBlkWTData.w = n11 < this.ncblks.x - 1 ? (n13 + n11 + 1) * subbandAn.nomCBlkW - (subbandAn.ulcx - n9) + subbandAn.ulx - cBlkWTData.ulx : subbandAn.ulx + subbandAn.w - cBlkWTData.ulx;
        cBlkWTData.h = n12 < this.ncblks.y - 1 ? (n14 + n12 + 1) * subbandAn.nomCBlkH - (subbandAn.ulcy - n10) + subbandAn.uly - cBlkWTData.uly : subbandAn.uly + subbandAn.h - cBlkWTData.uly;
        cBlkWTData.wmseScaling = 1.0f;
        cBlkWTData.offset = cBlkWTData.uly * this.decomposedComps[n].w + cBlkWTData.ulx;
        cBlkWTData.scanw = this.decomposedComps[n].w;
        cBlkWTData.setData(this.decomposedComps[n].getData());
        return cBlkWTData;
    }

    @Override
    public CBlkWTData getNextCodeBlock(int n, CBlkWTData cBlkWTData) {
        this.intData = this.filters.getWTDataType(this.tIdx, n) == 3;
        Object object = null;
        if (cBlkWTData != null) {
            object = cBlkWTData.getData();
        }
        if ((cBlkWTData = this.getNextInternCodeBlock(n, cBlkWTData)) == null) {
            return null;
        }
        if (this.intData) {
            int[] nArray = (int[])object;
            if (nArray == null || nArray.length < cBlkWTData.w * cBlkWTData.h) {
                object = new int[cBlkWTData.w * cBlkWTData.h];
            }
        } else {
            float[] fArray = (float[])object;
            if (fArray == null || fArray.length < cBlkWTData.w * cBlkWTData.h) {
                object = new float[cBlkWTData.w * cBlkWTData.h];
            }
        }
        Object object2 = cBlkWTData.getData();
        int n2 = cBlkWTData.w;
        int n3 = n2 * (cBlkWTData.h - 1);
        int n4 = cBlkWTData.offset + (cBlkWTData.h - 1) * cBlkWTData.scanw;
        while (n3 >= 0) {
            System.arraycopy(object2, n4, object, n3, n2);
            n3 -= n2;
            n4 -= cBlkWTData.scanw;
        }
        cBlkWTData.setData(object);
        cBlkWTData.offset = 0;
        cBlkWTData.scanw = n2;
        return cBlkWTData;
    }

    @Override
    public int getDataType(int n, int n2) {
        return this.filters.getWTDataType(n, n2);
    }

    private SubbandAn getNextSubband(int n) {
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = bl;
        SubbandAn subbandAn = this.currentSubband[n];
        if (subbandAn == null) {
            subbandAn = this.getAnSubbandTree(this.tIdx, n);
            if (!subbandAn.isNode) {
                return subbandAn;
            }
        }
        while (subbandAn != null) {
            if (!subbandAn.isNode) {
                switch (subbandAn.orientation) {
                    case 3: {
                        subbandAn = (SubbandAn)subbandAn.getParent().getLH();
                        bl3 = bl;
                        break;
                    }
                    case 2: {
                        subbandAn = (SubbandAn)subbandAn.getParent().getHL();
                        bl3 = bl;
                        break;
                    }
                    case 1: {
                        subbandAn = (SubbandAn)subbandAn.getParent().getLL();
                        bl3 = bl;
                        break;
                    }
                    case 0: {
                        subbandAn = (SubbandAn)subbandAn.getParent();
                        bl3 = bl2;
                    }
                }
            } else if (subbandAn.isNode) {
                if (bl3 == bl) {
                    subbandAn = (SubbandAn)subbandAn.getHH();
                } else if (bl3 == bl2) {
                    switch (subbandAn.orientation) {
                        case 3: {
                            subbandAn = (SubbandAn)subbandAn.getParent().getLH();
                            bl3 = bl;
                            break;
                        }
                        case 2: {
                            subbandAn = (SubbandAn)subbandAn.getParent().getHL();
                            bl3 = bl;
                            break;
                        }
                        case 1: {
                            subbandAn = (SubbandAn)subbandAn.getParent().getLL();
                            bl3 = bl;
                            break;
                        }
                        case 0: {
                            subbandAn = (SubbandAn)subbandAn.getParent();
                            bl3 = bl2;
                        }
                    }
                }
            }
            if (subbandAn != null && subbandAn.isNode) continue;
        }
        return subbandAn;
    }

    private void waveletTreeDecomposition(DataBlk dataBlk, SubbandAn subbandAn, int n) {
        if (!subbandAn.isNode) {
            return;
        }
        this.wavelet2DDecomposition(dataBlk, subbandAn, n);
        this.waveletTreeDecomposition(dataBlk, (SubbandAn)subbandAn.getHH(), n);
        this.waveletTreeDecomposition(dataBlk, (SubbandAn)subbandAn.getLH(), n);
        this.waveletTreeDecomposition(dataBlk, (SubbandAn)subbandAn.getHL(), n);
        this.waveletTreeDecomposition(dataBlk, (SubbandAn)subbandAn.getLL(), n);
    }

    private void wavelet2DDecomposition(DataBlk dataBlk, SubbandAn subbandAn, int n) {
        if (subbandAn.w == 0 || subbandAn.h == 0) {
            return;
        }
        int n2 = subbandAn.ulx;
        int n3 = subbandAn.uly;
        int n4 = subbandAn.w;
        int n5 = subbandAn.h;
        int n6 = this.getTileCompWidth(this.tIdx, n);
        this.getTileCompHeight(this.tIdx, n);
        if (this.intData) {
            int n7;
            int n8;
            int n9;
            int[] nArray = new int[Math.max(n4, n5)];
            int[] nArray2 = ((DataBlkInt)dataBlk).getDataInt();
            if (subbandAn.ulcy % 2 == 0) {
                n9 = 0;
                while (n9 < n4) {
                    n8 = n3 * n6 + n2 + n9;
                    n7 = 0;
                    while (n7 < n5) {
                        nArray[n7] = nArray2[n8 + n7 * n6];
                        ++n7;
                    }
                    subbandAn.vFilter.analyze_lpf(nArray, 0, n5, 1, nArray2, n8, n6, nArray2, n8 + (n5 + 1) / 2 * n6, n6);
                    ++n9;
                }
            } else {
                n9 = 0;
                while (n9 < n4) {
                    n8 = n3 * n6 + n2 + n9;
                    n7 = 0;
                    while (n7 < n5) {
                        nArray[n7] = nArray2[n8 + n7 * n6];
                        ++n7;
                    }
                    subbandAn.vFilter.analyze_hpf(nArray, 0, n5, 1, nArray2, n8, n6, nArray2, n8 + n5 / 2 * n6, n6);
                    ++n9;
                }
            }
            if (subbandAn.ulcx % 2 == 0) {
                n7 = 0;
                while (n7 < n5) {
                    n8 = (n3 + n7) * n6 + n2;
                    n9 = 0;
                    while (n9 < n4) {
                        nArray[n9] = nArray2[n8 + n9];
                        ++n9;
                    }
                    subbandAn.hFilter.analyze_lpf(nArray, 0, n4, 1, nArray2, n8, 1, nArray2, n8 + (n4 + 1) / 2, 1);
                    ++n7;
                }
            } else {
                n7 = 0;
                while (n7 < n5) {
                    n8 = (n3 + n7) * n6 + n2;
                    n9 = 0;
                    while (n9 < n4) {
                        nArray[n9] = nArray2[n8 + n9];
                        ++n9;
                    }
                    subbandAn.hFilter.analyze_hpf(nArray, 0, n4, 1, nArray2, n8, 1, nArray2, n8 + n4 / 2, 1);
                    ++n7;
                }
            }
        } else {
            int n10;
            int n11;
            int n12;
            float[] fArray = new float[Math.max(n4, n5)];
            float[] fArray2 = ((DataBlkFloat)dataBlk).getDataFloat();
            if (subbandAn.ulcy % 2 == 0) {
                n12 = 0;
                while (n12 < n4) {
                    n11 = n3 * n6 + n2 + n12;
                    n10 = 0;
                    while (n10 < n5) {
                        fArray[n10] = fArray2[n11 + n10 * n6];
                        ++n10;
                    }
                    subbandAn.vFilter.analyze_lpf(fArray, 0, n5, 1, fArray2, n11, n6, fArray2, n11 + (n5 + 1) / 2 * n6, n6);
                    ++n12;
                }
            } else {
                n12 = 0;
                while (n12 < n4) {
                    n11 = n3 * n6 + n2 + n12;
                    n10 = 0;
                    while (n10 < n5) {
                        fArray[n10] = fArray2[n11 + n10 * n6];
                        ++n10;
                    }
                    subbandAn.vFilter.analyze_hpf(fArray, 0, n5, 1, fArray2, n11, n6, fArray2, n11 + n5 / 2 * n6, n6);
                    ++n12;
                }
            }
            if (subbandAn.ulcx % 2 == 0) {
                n10 = 0;
                while (n10 < n5) {
                    n11 = (n3 + n10) * n6 + n2;
                    n12 = 0;
                    while (n12 < n4) {
                        fArray[n12] = fArray2[n11 + n12];
                        ++n12;
                    }
                    subbandAn.hFilter.analyze_lpf(fArray, 0, n4, 1, fArray2, n11, 1, fArray2, n11 + (n4 + 1) / 2, 1);
                    ++n10;
                }
            } else {
                n10 = 0;
                while (n10 < n5) {
                    n11 = (n3 + n10) * n6 + n2;
                    n12 = 0;
                    while (n12 < n4) {
                        fArray[n12] = fArray2[n11 + n12];
                        ++n12;
                    }
                    subbandAn.hFilter.analyze_hpf(fArray, 0, n4, 1, fArray2, n11, 1, fArray2, n11 + n4 / 2, 1);
                    ++n10;
                }
            }
        }
    }

    @Override
    public void setTile(int n, int n2) {
        super.setTile(n, n2);
        if (this.decomposedComps != null) {
            int n3 = this.decomposedComps.length - 1;
            while (n3 >= 0) {
                this.decomposedComps[n3] = null;
                this.currentSubband[n3] = null;
                --n3;
            }
        }
    }

    @Override
    public void nextTile() {
        super.nextTile();
        if (this.decomposedComps != null) {
            int n = this.decomposedComps.length - 1;
            while (n >= 0) {
                this.decomposedComps[n] = null;
                this.currentSubband[n] = null;
                --n;
            }
        }
    }

    @Override
    public SubbandAn getAnSubbandTree(int n, int n2) {
        if (this.subbTrees[n][n2] == null) {
            this.subbTrees[n][n2] = new SubbandAn(this.getTileCompWidth(this.tIdx, n2), this.getTileCompHeight(this.tIdx, n2), this.getCompULX(n2), this.getCompULY(n2), this.getDecompLevels(n, n2), this.getHorAnWaveletFilters(n, n2), this.getVertAnWaveletFilters(n, n2));
            this.initSubbandsFields(n, n2, this.subbTrees[n][n2]);
        }
        return this.subbTrees[n][n2];
    }

    private void initSubbandsFields(int n, int n2, Subband subband) {
        int n3 = this.cblks.getCBlkWidth((byte)3, n, n2);
        int n4 = this.cblks.getCBlkHeight((byte)3, n, n2);
        if (!subband.isNode) {
            int n5 = this.pss.getPPX(n, n2, subband.resLvl);
            int n6 = this.pss.getPPY(n, n2, subband.resLvl);
            if (n5 != 65535 || n6 != 65535) {
                int n7 = MathUtil.log2(n5);
                int n8 = MathUtil.log2(n6);
                int n9 = MathUtil.log2(n3);
                int n10 = MathUtil.log2(n4);
                switch (subband.resLvl) {
                    case 0: {
                        subband.nomCBlkW = n9 < n7 ? 1 << n9 : 1 << n7;
                        subband.nomCBlkH = n10 < n8 ? 1 << n10 : 1 << n8;
                        break;
                    }
                    default: {
                        subband.nomCBlkW = n9 < n7 - 1 ? 1 << n9 : 1 << n7 - 1;
                        subband.nomCBlkH = n10 < n8 - 1 ? 1 << n10 : 1 << n8 - 1;
                        break;
                    }
                }
            } else {
                subband.nomCBlkW = n3;
                subband.nomCBlkH = n4;
            }
            if (subband.numCb == null) {
                subband.numCb = new Point();
            }
            if (subband.w != 0 && subband.h != 0) {
                int n11 = this.cb0x;
                int n12 = this.cb0y;
                switch (subband.sbandIdx) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        n11 = 0;
                        break;
                    }
                    case 2: {
                        n12 = 0;
                        break;
                    }
                    case 3: {
                        n11 = 0;
                        n12 = 0;
                        break;
                    }
                    default: {
                        throw new Error("Internal JJ2000 error");
                    }
                }
                if (subband.ulcx - n11 < 0 || subband.ulcy - n12 < 0) {
                    throw new IllegalArgumentException("Invalid code-blocks partition origin or image offset in the reference grid.");
                }
                int n13 = subband.ulcx - n11 + subband.nomCBlkW;
                subband.numCb.x = (n13 + subband.w - 1) / subband.nomCBlkW - (n13 / subband.nomCBlkW - 1);
                n13 = subband.ulcy - n12 + subband.nomCBlkH;
                subband.numCb.y = (n13 + subband.h - 1) / subband.nomCBlkH - (n13 / subband.nomCBlkH - 1);
            } else {
                subband.numCb.y = 0;
                subband.numCb.x = 0;
            }
        } else {
            this.initSubbandsFields(n, n2, subband.getLL());
            this.initSubbandsFields(n, n2, subband.getHL());
            this.initSubbandsFields(n, n2, subband.getLH());
            this.initSubbandsFields(n, n2, subband.getHH());
        }
    }
}

