/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.wavelet.analysis;

import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageWriteParamJava;
import java.util.StringTokenizer;
import jj2000.j2k.ModuleSpec;
import jj2000.j2k.quantization.QuantTypeSpec;
import jj2000.j2k.wavelet.analysis.AnWTFilter;
import jj2000.j2k.wavelet.analysis.AnWTFilterFloatLift9x7;
import jj2000.j2k.wavelet.analysis.AnWTFilterIntLift5x3;

public class AnWTFilterSpec
extends ModuleSpec {
    private static final String REV_FILTER_STR = "w5x3";
    private static final String NON_REV_FILTER_STR = "w9x7";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AnWTFilterSpec(int n, int n2, byte by, QuantTypeSpec quantTypeSpec, J2KImageWriteParamJava j2KImageWriteParamJava, String string) {
        super(n, n2, by);
        int n3;
        int n4;
        String string2 = this.specified = string;
        boolean bl = true;
        if (string == null) {
            bl = false;
            if (j2KImageWriteParamJava.getLossless()) {
                this.setDefault(this.parseFilters(REV_FILTER_STR));
                return;
            }
            int n5 = n - 1;
            while (n5 >= 0) {
                int n6 = n2 - 1;
                while (n6 >= 0) {
                    switch (quantTypeSpec.getSpecValType(n5, n6)) {
                        case 0: {
                            if (this.getDefault() == null) {
                                if (j2KImageWriteParamJava.getLossless()) {
                                    this.setDefault(this.parseFilters(REV_FILTER_STR));
                                }
                                if (((String)quantTypeSpec.getDefault()).equals("reversible")) {
                                    this.setDefault(this.parseFilters(REV_FILTER_STR));
                                } else {
                                    this.setDefault(this.parseFilters(NON_REV_FILTER_STR));
                                }
                            }
                            this.specValType[n5][n6] = 0;
                            break;
                        }
                        case 1: {
                            if (!this.isCompSpecified(n6)) {
                                if (((String)quantTypeSpec.getCompDef(n6)).equals("reversible")) {
                                    this.setCompDef(n6, this.parseFilters(REV_FILTER_STR));
                                } else {
                                    this.setCompDef(n6, this.parseFilters(NON_REV_FILTER_STR));
                                }
                            }
                            this.specValType[n5][n6] = 1;
                            break;
                        }
                        case 2: {
                            if (!this.isTileSpecified(n5)) {
                                if (((String)quantTypeSpec.getTileDef(n5)).equals("reversible")) {
                                    this.setTileDef(n5, this.parseFilters(REV_FILTER_STR));
                                } else {
                                    this.setTileDef(n5, this.parseFilters(NON_REV_FILTER_STR));
                                }
                            }
                            this.specValType[n5][n6] = 2;
                            break;
                        }
                        case 3: {
                            if (!this.isTileCompSpecified(n5, n6)) {
                                if (((String)quantTypeSpec.getTileCompVal(n5, n6)).equals("reversible")) {
                                    this.setTileCompVal(n5, n6, this.parseFilters(REV_FILTER_STR));
                                } else {
                                    this.setTileCompVal(n5, n6, this.parseFilters(NON_REV_FILTER_STR));
                                }
                            }
                            this.specValType[n5][n6] = 3;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unsupported specification type");
                        }
                    }
                    --n6;
                }
                --n5;
            }
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        int n7 = 0;
        boolean[] blArray = null;
        boolean[] blArray2 = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            switch (string3.charAt(0)) {
                case 'T': 
                case 't': {
                    blArray = AnWTFilterSpec.parseIdx(string3, this.nTiles);
                    if (n7 == 1) {
                        n7 = 3;
                        break;
                    }
                    n7 = 2;
                    break;
                }
                case 'C': 
                case 'c': {
                    blArray2 = AnWTFilterSpec.parseIdx(string3, this.nComp);
                    if (n7 == 2) {
                        n7 = 3;
                        break;
                    }
                    n7 = 1;
                    break;
                }
                case 'W': 
                case 'w': {
                    if (j2KImageWriteParamJava.getLossless() && string3.equalsIgnoreCase(NON_REV_FILTER_STR)) {
                        throw new IllegalArgumentException("Cannot use non reversible wavelet transform with '-lossless' option");
                    }
                    AnWTFilter[][] anWTFilterArray = this.parseFilters(string3);
                    if (n7 == 0) {
                        this.setDefault(anWTFilterArray);
                    } else if (n7 == 2) {
                        n4 = blArray.length - 1;
                        while (n4 >= 0) {
                            if (blArray[n4]) {
                                this.setTileDef(n4, anWTFilterArray);
                            }
                            --n4;
                        }
                    } else if (n7 == 1) {
                        n4 = blArray2.length - 1;
                        while (n4 >= 0) {
                            if (blArray2[n4]) {
                                this.setCompDef(n4, anWTFilterArray);
                            }
                            --n4;
                        }
                    } else {
                        n4 = blArray.length - 1;
                        while (n4 >= 0) {
                            n3 = blArray2.length - 1;
                            while (n3 >= 0) {
                                if (blArray[n4] && blArray2[n3]) {
                                    this.setTileCompVal(n4, n3, anWTFilterArray);
                                }
                                --n3;
                            }
                            --n4;
                        }
                    }
                    n7 = 0;
                    blArray = null;
                    blArray2 = null;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Bad construction for parameter: " + string3);
                }
            }
        }
        if (this.getDefault() == null) {
            n4 = 0;
            n3 = n - 1;
            while (n3 >= 0) {
                int n8 = n2 - 1;
                while (n8 >= 0) {
                    if (this.specValType[n3][n8] == 0) {
                        ++n4;
                    }
                    --n8;
                }
                --n3;
            }
            if (n4 != 0) {
                if (((String)quantTypeSpec.getDefault()).equals("reversible")) {
                    this.setDefault(this.parseFilters(REV_FILTER_STR));
                } else {
                    this.setDefault(this.parseFilters(NON_REV_FILTER_STR));
                }
            } else {
                this.setDefault(this.getTileCompVal(0, 0));
                switch (this.specValType[0][0]) {
                    case 2: {
                        n3 = n2 - 1;
                        while (n3 >= 0) {
                            if (this.specValType[0][n3] == 2) {
                                this.specValType[0][n3] = 0;
                            }
                            --n3;
                        }
                        this.tileDef[0] = null;
                        break;
                    }
                    case 1: {
                        n3 = n - 1;
                        while (n3 >= 0) {
                            if (this.specValType[n3][0] == 1) {
                                this.specValType[n3][0] = 0;
                            }
                            --n3;
                        }
                        this.compDef[0] = null;
                        break;
                    }
                    case 3: {
                        this.specValType[0][0] = 0;
                        this.tileCompVal.put("t0c0", null);
                    }
                }
            }
        }
        n4 = n - 1;
        while (n4 >= 0) {
            n3 = n2 - 1;
            while (n3 >= 0) {
                if (((String)quantTypeSpec.getTileCompVal(n4, n3)).equals("reversible")) {
                    if (!this.isReversible(n4, n3)) {
                        if (bl) throw new IllegalArgumentException("Filter of tile-component (" + n4 + "," + n3 + ") does" + " not allow " + "reversible " + "quantization. " + "Specify '-Qtype " + "expounded' or " + "'-Qtype derived'" + "in " + "the command line.");
                        this.setTileCompVal(n4, n3, this.parseFilters(REV_FILTER_STR));
                    }
                } else if (this.isReversible(n4, n3)) {
                    if (bl) throw new IllegalArgumentException("Filter of tile-component (" + n4 + "," + n3 + ") does" + " not allow " + "non-reversible " + "quantization. " + "Specify '-Qtype " + "reversible' in " + "the command line");
                    this.setTileCompVal(n4, n3, this.parseFilters(NON_REV_FILTER_STR));
                }
                --n3;
            }
            --n4;
        }
    }

    private AnWTFilter[][] parseFilters(String string) {
        AnWTFilter[][] anWTFilterArray = new AnWTFilter[2][1];
        if (string.equalsIgnoreCase(REV_FILTER_STR)) {
            anWTFilterArray[0][0] = new AnWTFilterIntLift5x3();
            anWTFilterArray[1][0] = new AnWTFilterIntLift5x3();
            return anWTFilterArray;
        }
        if (string.equalsIgnoreCase(NON_REV_FILTER_STR)) {
            anWTFilterArray[0][0] = new AnWTFilterFloatLift9x7();
            anWTFilterArray[1][0] = new AnWTFilterFloatLift9x7();
            return anWTFilterArray;
        }
        throw new IllegalArgumentException("Non JPEG 2000 part I filter: " + string);
    }

    public int getWTDataType(int n, int n2) {
        AnWTFilter[][] anWTFilterArray = (AnWTFilter[][])this.getSpec(n, n2);
        return anWTFilterArray[0][0].getDataType();
    }

    public AnWTFilter[] getHFilters(int n, int n2) {
        AnWTFilter[][] anWTFilterArray = (AnWTFilter[][])this.getSpec(n, n2);
        return anWTFilterArray[0];
    }

    public AnWTFilter[] getVFilters(int n, int n2) {
        AnWTFilter[][] anWTFilterArray = (AnWTFilter[][])this.getSpec(n, n2);
        return anWTFilterArray[1];
    }

    public String toString() {
        String string = "";
        string = String.valueOf(string) + "nTiles=" + this.nTiles + "\nnComp=" + this.nComp + "\n\n";
        int n = 0;
        while (n < this.nTiles) {
            int n2 = 0;
            while (n2 < this.nComp) {
                AnWTFilter[][] anWTFilterArray = (AnWTFilter[][])this.getSpec(n, n2);
                string = String.valueOf(string) + "(t:" + n + ",c:" + n2 + ")\n";
                string = String.valueOf(string) + "\tH:";
                int n3 = 0;
                while (n3 < anWTFilterArray[0].length) {
                    string = String.valueOf(string) + " " + anWTFilterArray[0][n3];
                    ++n3;
                }
                string = String.valueOf(string) + "\n\tV:";
                n3 = 0;
                while (n3 < anWTFilterArray[1].length) {
                    string = String.valueOf(string) + " " + anWTFilterArray[1][n3];
                    ++n3;
                }
                string = String.valueOf(string) + "\n";
                ++n2;
            }
            ++n;
        }
        return string;
    }

    public boolean isReversible(int n, int n2) {
        AnWTFilter[] anWTFilterArray = this.getHFilters(n, n2);
        AnWTFilter[] anWTFilterArray2 = this.getVFilters(n, n2);
        int n3 = anWTFilterArray.length - 1;
        while (n3 >= 0) {
            if (!anWTFilterArray[n3].isReversible() || !anWTFilterArray2[n3].isReversible()) {
                return false;
            }
            --n3;
        }
        return true;
    }
}

