/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.wavelet;

import java.awt.Point;
import jj2000.j2k.wavelet.WaveletFilter;

public abstract class Subband {
    public static final int WT_ORIENT_LL = 0;
    public static final int WT_ORIENT_HL = 1;
    public static final int WT_ORIENT_LH = 2;
    public static final int WT_ORIENT_HH = 3;
    public boolean isNode;
    public int orientation;
    public int level;
    public int resLvl;
    public Point numCb = null;
    public int anGainExp;
    public int sbandIdx = 0;
    public int ulcx;
    public int ulcy;
    public int ulx;
    public int uly;
    public int w;
    public int h;
    public int nomCBlkW;
    public int nomCBlkH;

    public abstract Subband getParent();

    public abstract Subband getLL();

    public abstract Subband getHL();

    public abstract Subband getLH();

    public abstract Subband getHH();

    protected abstract Subband split(WaveletFilter var1, WaveletFilter var2);

    protected void initChilds() {
        Subband subband = this.getLL();
        Subband subband2 = this.getHL();
        Subband subband3 = this.getLH();
        Subband subband4 = this.getHH();
        subband.level = this.level + 1;
        subband.ulcx = this.ulcx + 1 >> 1;
        subband.ulcy = this.ulcy + 1 >> 1;
        subband.ulx = this.ulx;
        subband.uly = this.uly;
        subband.w = (this.ulcx + this.w + 1 >> 1) - subband.ulcx;
        subband.h = (this.ulcy + this.h + 1 >> 1) - subband.ulcy;
        subband.resLvl = this.orientation == 0 ? this.resLvl - 1 : this.resLvl;
        subband.anGainExp = this.anGainExp;
        subband.sbandIdx = this.sbandIdx << 2;
        subband2.orientation = 1;
        subband2.level = subband.level;
        subband2.ulcx = this.ulcx >> 1;
        subband2.ulcy = subband.ulcy;
        subband2.ulx = this.ulx + subband.w;
        subband2.uly = this.uly;
        subband2.w = (this.ulcx + this.w >> 1) - subband2.ulcx;
        subband2.h = subband.h;
        subband2.resLvl = this.resLvl;
        subband2.anGainExp = this.anGainExp + 1;
        subband2.sbandIdx = (this.sbandIdx << 2) + 1;
        subband3.orientation = 2;
        subband3.level = subband.level;
        subband3.ulcx = subband.ulcx;
        subband3.ulcy = this.ulcy >> 1;
        subband3.ulx = this.ulx;
        subband3.uly = this.uly + subband.h;
        subband3.w = subband.w;
        subband3.h = (this.ulcy + this.h >> 1) - subband3.ulcy;
        subband3.resLvl = this.resLvl;
        subband3.anGainExp = this.anGainExp + 1;
        subband3.sbandIdx = (this.sbandIdx << 2) + 2;
        subband4.orientation = 3;
        subband4.level = subband.level;
        subband4.ulcx = subband2.ulcx;
        subband4.ulcy = subband3.ulcy;
        subband4.ulx = subband2.ulx;
        subband4.uly = subband3.uly;
        subband4.w = subband2.w;
        subband4.h = subband3.h;
        subband4.resLvl = this.resLvl;
        subband4.anGainExp = this.anGainExp + 2;
        subband4.sbandIdx = (this.sbandIdx << 2) + 3;
    }

    public Subband() {
    }

    public Subband(int n, int n2, int n3, int n4, int n5, WaveletFilter[] waveletFilterArray, WaveletFilter[] waveletFilterArray2) {
        this.w = n;
        this.h = n2;
        this.ulcx = n3;
        this.ulcy = n4;
        this.resLvl = n5;
        Subband subband = this;
        int n6 = 0;
        while (n6 < n5) {
            int n7 = subband.resLvl <= waveletFilterArray.length ? subband.resLvl - 1 : waveletFilterArray.length - 1;
            int n8 = subband.resLvl <= waveletFilterArray2.length ? subband.resLvl - 1 : waveletFilterArray2.length - 1;
            subband = subband.split(waveletFilterArray[n7], waveletFilterArray2[n8]);
            ++n6;
        }
    }

    /*
     * Unable to fully structure code
     */
    public Subband nextSubband() {
        if (this.isNode) {
            throw new IllegalArgumentException();
        }
        switch (this.orientation) {
            case 0: {
                var1_1 = this.getParent();
                if (var1_1 == null || var1_1.resLvl != this.resLvl) {
                    return null;
                }
                return var1_1.getHL();
            }
            case 1: {
                return this.getParent().getLH();
            }
            case 2: {
                return this.getParent().getHH();
            }
            case 3: {
                var1_2 = this;
                while (var1_2.orientation == 3) {
                    var1_2 = var1_2.getParent();
                }
                switch (var1_2.orientation) {
                    case 0: {
                        var1_2 = var1_2.getParent();
                        if (var1_2 == null || var1_2.resLvl != this.resLvl) {
                            return null;
                        }
                        var1_2 = var1_2.getHL();
                        ** GOTO lbl35
                    }
                    case 1: {
                        var1_2 = var1_2.getParent().getLH();
                        ** GOTO lbl35
                    }
                    case 2: {
                        var1_2 = var1_2.getParent().getHH();
                        if (true) ** GOTO lbl35
                    }
                    default: {
                        throw new Error("You have found a bug in JJ2000");
                    }
                }
                do {
                    var1_2 = var1_2.getLL();
lbl35:
                    // 4 sources

                } while (var1_2.isNode);
                return var1_2;
            }
        }
        throw new Error("You have found a bug in JJ2000");
    }

    public Subband getNextResLevel() {
        if (this.level == 0) {
            return null;
        }
        Subband subband = this;
        do {
            if ((subband = subband.getParent()) != null) continue;
            return null;
        } while (subband.resLvl == this.resLvl);
        subband = subband.getHL();
        while (subband.isNode) {
            subband = subband.getLL();
        }
        return subband;
    }

    public Subband getSubbandByIdx(int n, int n2) {
        Subband subband = this;
        if (n > subband.resLvl || n < 0) {
            throw new IllegalArgumentException("Resolution level index out of range");
        }
        if (n == subband.resLvl && n2 == subband.sbandIdx) {
            return subband;
        }
        if (subband.sbandIdx != 0) {
            subband = subband.getParent();
        }
        while (subband.resLvl > n) {
            subband = subband.getLL();
        }
        while (subband.resLvl < n) {
            subband = subband.getParent();
        }
        switch (n2) {
            default: {
                return subband;
            }
            case 1: {
                return subband.getHL();
            }
            case 2: {
                return subband.getLH();
            }
            case 3: 
        }
        return subband.getHH();
    }

    public Subband getSubband(int n, int n2) {
        if (n < this.ulx || n2 < this.uly || n >= this.ulx + this.w || n2 >= this.uly + this.h) {
            throw new IllegalArgumentException();
        }
        Subband subband = this;
        while (subband.isNode) {
            Subband subband2 = subband.getHH();
            if (n < subband2.ulx) {
                if (n2 < subband2.uly) {
                    subband = subband.getLL();
                    continue;
                }
                subband = subband.getLH();
                continue;
            }
            subband = n2 < subband2.uly ? subband.getHL() : subband.getHH();
        }
        return subband;
    }

    public String toString() {
        String string = "w=" + this.w + ", h=" + this.h + ", ulx=" + this.ulx + ", uly=" + this.uly + ", ulcx= " + this.ulcx + ", ulcy=" + this.ulcy + ", idx=" + this.sbandIdx + "\norient=" + this.orientation + ", node=" + this.isNode + ", level=" + this.level + ", resLvl=" + this.resLvl + ", nomCBlkW=" + this.nomCBlkW + ", nomCBlkH=" + this.nomCBlkH;
        return string;
    }

    public abstract WaveletFilter getHorWFilter();

    public abstract WaveletFilter getVerWFilter();
}

