/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.util;

import jj2000.j2k.util.FacilityManager;
import jj2000.j2k.util.NativeServices;

public class ThreadPool {
    public static final String CONCURRENCY_PROP_NAME = "jj2000.j2k.util.ThreadPool.concurrency";
    private ThreadPoolThread[] idle;
    private int nidle;
    private String poolName;
    private int poolPriority;
    private volatile Error targetE;
    private volatile RuntimeException targetRE;

    public ThreadPool(int n, int n2, String string) {
        if (n <= 0) {
            throw new IllegalArgumentException("Pool must be of positive size");
        }
        this.poolPriority = n2 < 1 ? Thread.currentThread().getPriority() : (n2 < 10 ? n2 : 10);
        this.poolName = string == null ? "Anonymous ThreadPool" : string;
        String string2 = null;
        try {
            string2 = System.getProperty(CONCURRENCY_PROP_NAME);
        }
        catch (SecurityException securityException) {}
        if (string2 != null) {
            int n3;
            try {
                n3 = Integer.parseInt(string2);
                if (n3 < 0) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Invalid concurrency level in property jj2000.j2k.util.ThreadPool.concurrency");
            }
            if (NativeServices.loadLibrary()) {
                FacilityManager.getMsgLogger().printmsg(1, "Changing thread concurrency level from " + NativeServices.getThreadConcurrency() + " to " + n3 + ".");
                NativeServices.setThreadConcurrency(n3);
            } else {
                FacilityManager.getMsgLogger().printmsg(2, "Native library to set thread concurrency level as specified by the jj2000.j2k.util.ThreadPool.concurrency property not found. Thread concurrency unchanged.");
            }
        }
        this.idle = new ThreadPoolThread[n];
        this.nidle = 0;
        int n4 = 0;
        while (n4 < n) {
            ThreadPoolThread threadPoolThread = new ThreadPoolThread(n4, String.valueOf(this.poolName) + "-" + n4);
            threadPoolThread.start();
            ++n4;
        }
    }

    public int getSize() {
        return this.idle.length;
    }

    public boolean runTarget(Runnable runnable, Object object) {
        return this.runTarget(runnable, object, false, false);
    }

    public boolean runTarget(Runnable runnable, Object object, boolean bl) {
        return this.runTarget(runnable, object, bl, false);
    }

    public boolean runTarget(Runnable runnable, Object object, boolean bl, boolean bl2) {
        ThreadPoolThread threadPoolThread = this.getIdle(bl);
        if (threadPoolThread == null) {
            return false;
        }
        threadPoolThread.setTarget(runnable, object, bl2);
        return true;
    }

    public void checkTargetErrors() {
        if (this.targetE != null) {
            throw this.targetE;
        }
        if (this.targetRE != null) {
            throw this.targetRE;
        }
    }

    public void clearTargetErrors() {
        this.targetE = null;
        this.targetRE = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putInIdleList(ThreadPoolThread threadPoolThread) {
        ThreadPoolThread[] threadPoolThreadArray = this.idle;
        synchronized (this.idle) {
            this.idle[this.nidle] = threadPoolThread;
            ++this.nidle;
            if (this.nidle == 1) {
                this.idle.notify();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ThreadPoolThread getIdle(boolean bl) {
        ThreadPoolThread[] threadPoolThreadArray = this.idle;
        synchronized (this.idle) {
            if (bl) {
                if (this.nidle == 0) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return null;
                }
            } else {
                while (this.nidle == 0) {
                    try {
                        this.idle.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return null;
                    }
                }
            }
            --this.nidle;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.idle[this.nidle];
        }
    }

    class ThreadPoolThread
    extends Thread {
        private Runnable target;
        private Object lock;
        private boolean doNotifyAll;

        public ThreadPoolThread(int n, String string) {
            super(string);
            this.setDaemon(true);
            this.setPriority(ThreadPool.this.poolPriority);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ThreadPool.this.putInIdleList(this);
            ThreadPoolThread threadPoolThread = this;
            synchronized (threadPoolThread) {
                block13: while (true) {
                    while (true) {
                        if (this.target == null) {
                            try {
                                this.wait();
                                continue block13;
                            }
                            catch (InterruptedException interruptedException) {}
                            continue;
                        }
                        try {
                            this.target.run();
                        }
                        catch (ThreadDeath threadDeath) {
                            FacilityManager.getMsgLogger().printmsg(2, "Thread.stop() called on a ThreadPool thread or ThreadDeath thrown. This is deprecated. Lock-up might occur.");
                            throw threadDeath;
                        }
                        catch (Error error) {
                            ThreadPool.this.targetE = error;
                        }
                        catch (RuntimeException runtimeException) {
                            ThreadPool.this.targetRE = runtimeException;
                        }
                        catch (Throwable throwable) {
                            ThreadPool.this.targetRE = new RuntimeException("Unchecked exception thrown by target's run() method in pool " + ThreadPool.this.poolName + ".");
                        }
                        ThreadPool.this.putInIdleList(this);
                        this.target = null;
                        if (this.lock != null) break;
                    }
                    Object object = this.lock;
                    synchronized (object) {
                        if (this.doNotifyAll) {
                            this.lock.notifyAll();
                        } else {
                            this.lock.notify();
                        }
                    }
                }
            }
        }

        synchronized void setTarget(Runnable runnable, Object object, boolean bl) {
            this.target = runnable;
            this.lock = object;
            this.doNotifyAll = bl;
            this.notify();
        }
    }
}

