/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.roi.encoder;

import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageWriteParamJava;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import jj2000.j2k.ModuleSpec;
import jj2000.j2k.image.DataBlkInt;
import jj2000.j2k.image.ImgDataAdapter;
import jj2000.j2k.image.input.ImgReaderPGM;
import jj2000.j2k.quantization.quantizer.CBlkQuantDataSrcEnc;
import jj2000.j2k.quantization.quantizer.Quantizer;
import jj2000.j2k.roi.MaxShiftSpec;
import jj2000.j2k.roi.encoder.ArbROIMaskGenerator;
import jj2000.j2k.roi.encoder.ROI;
import jj2000.j2k.roi.encoder.ROIMaskGenerator;
import jj2000.j2k.roi.encoder.RectROIMaskGenerator;
import jj2000.j2k.wavelet.analysis.CBlkWTData;
import jj2000.j2k.wavelet.analysis.SubbandAn;

public class ROIScaler
extends ImgDataAdapter
implements CBlkQuantDataSrcEnc {
    public static final char OPT_PREFIX = 'R';
    private static final String[][] pinfo;
    private int[][] maxMagBits;
    private boolean roi;
    private boolean blockAligned;
    private int useStartLevel;
    private ROIMaskGenerator mg;
    private DataBlkInt roiMask;
    private Quantizer src;

    static {
        String[][] stringArrayArray = new String[4][];
        String[] stringArray = new String[4];
        stringArray[0] = "Rroi";
        stringArray[1] = "[<component idx>] R <left> <top> <width> <height> or [<component idx>] C <centre column> <centre row> <radius> or [<component idx>] A <filename>";
        stringArray[2] = "Specifies ROIs shape and location. The shape can be either rectangular 'R', or circular 'C' or arbitrary 'A'. Each new occurrence of an 'R', a 'C' or an 'A' is a new ROI. For circular and rectangular ROIs, all values are given as their pixel values relative to the canvas origin. Arbitrary shapes must be included in a PGM file where non 0 values correspond to ROI coefficients. The PGM file must have the size as the image. The component idx specifies which components contain the ROI. The component index is specified as described by points 3 and 4 in the general comment on tile-component idx. If this option is used, the codestream is layer progressive by default unless it is overridden by the 'Aptype' option.";
        stringArrayArray[0] = stringArray;
        stringArrayArray[1] = new String[]{"Ralign", "[true|false]", "By specifying this argument, the ROI mask will be limited to covering only entire code-blocks. The ROI coding can then be performed without any actual scaling of the coefficients but by instead scaling the distortion estimates.", "false"};
        stringArrayArray[2] = new String[]{"Rstart_level", "<level>", "This argument forces the lowest <level> resolution levels to belong to the ROI. By doing this, it is possible to avoid only getting information for the ROI at an early stage of transmission.<level> = 0 means the lowest resolution level belongs to the ROI, 1 means the two lowest etc. (-1 deactivates the option)", "-1"};
        stringArrayArray[3] = new String[]{"Rno_rect", "[true|false]", "This argument makes sure that the ROI mask generation is not done using the fast ROI mask generation for rectangular ROIs regardless of whether the specified ROIs are rectangular or not", "false"};
        pinfo = stringArrayArray;
    }

    public ROIScaler(Quantizer quantizer, ROIMaskGenerator rOIMaskGenerator, boolean bl, int n, boolean bl2, J2KImageWriteParamJava j2KImageWriteParamJava) {
        super(quantizer);
        this.src = quantizer;
        this.roi = bl;
        this.useStartLevel = n;
        if (bl) {
            this.mg = rOIMaskGenerator;
            this.roiMask = new DataBlkInt();
            this.calcMaxMagBits(j2KImageWriteParamJava);
            this.blockAligned = bl2;
        }
    }

    @Override
    public boolean isReversible(int n, int n2) {
        return this.src.isReversible(n, n2);
    }

    @Override
    public SubbandAn getAnSubbandTree(int n, int n2) {
        return this.src.getAnSubbandTree(n, n2);
    }

    @Override
    public int getCbULX() {
        return this.src.getCbULX();
    }

    @Override
    public int getCbULY() {
        return this.src.getCbULY();
    }

    public static ROIScaler createInstance(Quantizer quantizer, J2KImageWriteParamJava j2KImageWriteParamJava) {
        Vector vector = new Vector();
        ROIMaskGenerator rOIMaskGenerator = null;
        String string = j2KImageWriteParamJava.getROIs().getSpecified();
        if (string == null) {
            return new ROIScaler(quantizer, null, false, -1, false, j2KImageWriteParamJava);
        }
        int n = j2KImageWriteParamJava.getStartLevelROI();
        boolean bl = j2KImageWriteParamJava.getAlignROI();
        boolean bl2 = false;
        ROIScaler.parseROIs(string, quantizer.getNumComps(), vector);
        Object[] objectArray = new ROI[vector.size()];
        vector.copyInto(objectArray);
        if (bl2) {
            int n2 = objectArray.length - 1;
            while (n2 >= 0) {
                if (!((ROI)objectArray[n2]).rect) {
                    bl2 = false;
                    break;
                }
                --n2;
            }
        }
        rOIMaskGenerator = bl2 ? new RectROIMaskGenerator((ROI[])objectArray, quantizer.getNumComps()) : new ArbROIMaskGenerator((ROI[])objectArray, quantizer.getNumComps(), quantizer);
        return new ROIScaler(quantizer, rOIMaskGenerator, true, n, bl, j2KImageWriteParamJava);
    }

    protected static Vector parseROIs(String string, int n, Vector vector) {
        boolean[] blArray = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        block16: while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            switch (string2.charAt(0)) {
                case 'c': {
                    blArray = ModuleSpec.parseIdx(string2, n);
                    break;
                }
                case 'R': {
                    ROI rOI;
                    int n2;
                    int n3;
                    int n4;
                    int n5;
                    int n6;
                    try {
                        string2 = stringTokenizer.nextToken();
                        n6 = new Integer(string2);
                        string2 = stringTokenizer.nextToken();
                        n5 = new Integer(string2);
                        string2 = stringTokenizer.nextToken();
                        n4 = new Integer(string2);
                        string2 = stringTokenizer.nextToken();
                        n3 = new Integer(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException("Bad parameter for '-Rroi R' option : " + string2);
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        throw new IllegalArgumentException("Wrong number of parameters for  h'-Rroi R' option.");
                    }
                    if (blArray != null) {
                        n2 = 0;
                        while (n2 < n) {
                            if (blArray[n2]) {
                                rOI = new ROI(n2, n6, n5, n4, n3);
                                vector.addElement(rOI);
                            }
                            ++n2;
                        }
                        continue block16;
                    }
                    n2 = 0;
                    while (n2 < n) {
                        rOI = new ROI(n2, n6, n5, n4, n3);
                        vector.addElement(rOI);
                        ++n2;
                    }
                    continue block16;
                }
                case 'C': {
                    int n7;
                    int n8;
                    int n9;
                    ROI rOI;
                    int n2;
                    try {
                        string2 = stringTokenizer.nextToken();
                        n9 = new Integer(string2);
                        string2 = stringTokenizer.nextToken();
                        n8 = new Integer(string2);
                        string2 = stringTokenizer.nextToken();
                        n7 = new Integer(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException("Bad parameter for '-Rroi C' option : " + string2);
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        throw new IllegalArgumentException("Wrong number of parameters for '-Rroi C' option.");
                    }
                    if (blArray != null) {
                        n2 = 0;
                        while (n2 < n) {
                            if (blArray[n2]) {
                                rOI = new ROI(n2, n9, n8, n7);
                                vector.addElement(rOI);
                            }
                            ++n2;
                        }
                        continue block16;
                    }
                    n2 = 0;
                    while (n2 < n) {
                        rOI = new ROI(n2, n9, n8, n7);
                        vector.addElement(rOI);
                        ++n2;
                    }
                    continue block16;
                }
                case 'A': {
                    int n10;
                    String string3;
                    ROI rOI;
                    ImgReaderPGM imgReaderPGM = null;
                    try {
                        string3 = stringTokenizer.nextToken();
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        throw new IllegalArgumentException("Wrong number of parameters for '-Rroi A' option.");
                    }
                    try {
                        imgReaderPGM = new ImgReaderPGM(string3);
                    }
                    catch (IOException iOException) {
                        throw new Error("Cannot read PGM file with ROI");
                    }
                    if (blArray != null) {
                        n10 = 0;
                        while (n10 < n) {
                            if (blArray[n10]) {
                                rOI = new ROI(n10, imgReaderPGM);
                                vector.addElement(rOI);
                            }
                            ++n10;
                        }
                        continue block16;
                    }
                    n10 = 0;
                    while (n10 < n) {
                        rOI = new ROI(n10, imgReaderPGM);
                        vector.addElement(rOI);
                        ++n10;
                    }
                    continue block16;
                }
                default: {
                    throw new Error("Bad parameters for ROI nr " + vector.size());
                }
            }
        }
        return vector;
    }

    @Override
    public CBlkWTData getNextCodeBlock(int n, CBlkWTData cBlkWTData) {
        return this.getNextInternCodeBlock(n, cBlkWTData);
    }

    @Override
    public CBlkWTData getNextInternCodeBlock(int n, CBlkWTData cBlkWTData) {
        int n2;
        DataBlkInt dataBlkInt = this.roiMask;
        int n3 = Integer.MAX_VALUE;
        int n4 = 0;
        int n5 = 0;
        cBlkWTData = this.src.getNextCodeBlock(n, cBlkWTData);
        if (!this.roi || cBlkWTData == null) {
            return cBlkWTData;
        }
        int[] nArray = (int[])cBlkWTData.getData();
        SubbandAn subbandAn = cBlkWTData.sb;
        int n6 = cBlkWTData.ulx;
        int n7 = cBlkWTData.uly;
        int n8 = cBlkWTData.w;
        int n9 = cBlkWTData.h;
        boolean bl = subbandAn.resLvl <= this.useStartLevel;
        int[] nArray2 = dataBlkInt.getDataInt();
        if (nArray2 == null || n8 * n9 > nArray2.length) {
            nArray2 = new int[n8 * n9];
            dataBlkInt.setDataInt(nArray2);
        } else {
            n2 = n8 * n9 - 1;
            while (n2 >= 0) {
                nArray2[n2] = 0;
                --n2;
            }
        }
        dataBlkInt.ulx = n6;
        dataBlkInt.uly = n7;
        dataBlkInt.w = n8;
        dataBlkInt.h = n9;
        SubbandAn subbandAn2 = this.src.getAnSubbandTree(this.tIdx, n);
        n4 = this.maxMagBits[this.tIdx][n];
        boolean bl2 = this.mg.getROIMask(dataBlkInt, subbandAn2, n4, n);
        if (!bl2 && !bl) {
            cBlkWTData.nROIbp = 0;
            return cBlkWTData;
        }
        cBlkWTData.nROIbp = cBlkWTData.magbits;
        if (bl) {
            cBlkWTData.wmseScaling *= (float)(1 << (n4 << 1));
            cBlkWTData.nROIcoeff = n8 * n9;
            return cBlkWTData;
        }
        if (this.blockAligned) {
            int n10 = cBlkWTData.scanw - n8;
            int n11 = n9 * n8 - 1;
            n2 = cBlkWTData.offset + cBlkWTData.scanw * (n9 - 1) + n8 - 1;
            int n12 = 0;
            int n13 = n9;
            while (n13 > 0) {
                int n14 = n8 - 1;
                while (n14 >= 0) {
                    if (nArray2[n11] != 0) {
                        ++n12;
                    }
                    --n14;
                    --n2;
                    --n11;
                }
                n2 -= n10;
                --n13;
            }
            if (n12 != 0) {
                cBlkWTData.wmseScaling *= (float)(1 << (n4 << 1));
                cBlkWTData.nROIcoeff = n8 * n9;
            }
            return cBlkWTData;
        }
        n3 = (1 << cBlkWTData.magbits) - 1 << 31 - cBlkWTData.magbits;
        int n15 = cBlkWTData.scanw - n8;
        int n16 = n9 * n8 - 1;
        n2 = cBlkWTData.offset + cBlkWTData.scanw * (n9 - 1) + n8 - 1;
        int n17 = n9;
        while (n17 > 0) {
            int n18 = n8;
            while (n18 > 0) {
                int n19 = nArray[n2];
                if (nArray2[n16] != 0) {
                    nArray[n2] = Integer.MIN_VALUE & n19 | n19 & n3;
                    ++n5;
                } else {
                    nArray[n2] = Integer.MIN_VALUE & n19 | (n19 & Integer.MAX_VALUE) >> n4;
                }
                --n18;
                --n2;
                --n16;
            }
            n2 -= n15;
            --n17;
        }
        cBlkWTData.magbits += n4;
        cBlkWTData.nROIcoeff = n5;
        return cBlkWTData;
    }

    public ROIMaskGenerator getROIMaskGenerator() {
        return this.mg;
    }

    public boolean getBlockAligned() {
        return this.blockAligned;
    }

    public boolean useRoi() {
        return this.roi;
    }

    public static String[][] getParameterInfo() {
        return pinfo;
    }

    @Override
    public void setTile(int n, int n2) {
        super.setTile(n, n2);
        if (this.roi) {
            this.mg.tileChanged();
        }
    }

    @Override
    public void nextTile() {
        super.nextTile();
        if (this.roi) {
            this.mg.tileChanged();
        }
    }

    private void calcMaxMagBits(J2KImageWriteParamJava j2KImageWriteParamJava) {
        MaxShiftSpec maxShiftSpec = j2KImageWriteParamJava.getROIs();
        int n = this.src.getNumTiles();
        int n2 = this.src.getNumComps();
        this.maxMagBits = new int[n][n2];
        this.src.setTile(0, 0);
        int n3 = 0;
        while (n3 < n) {
            int n4 = n2 - 1;
            while (n4 >= 0) {
                int n5;
                this.maxMagBits[n3][n4] = n5 = this.src.getMaxMagBits(n4);
                maxShiftSpec.setTileCompVal(n3, n4, new Integer(n5));
                --n4;
            }
            if (n3 < n - 1) {
                this.src.nextTile();
            }
            ++n3;
        }
        this.src.setTile(0, 0);
    }
}

