/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.roi.encoder;

import jj2000.j2k.image.DataBlkInt;
import jj2000.j2k.image.input.ImgReader;
import jj2000.j2k.image.input.ImgReaderPGM;
import jj2000.j2k.quantization.quantizer.Quantizer;
import jj2000.j2k.roi.encoder.ROI;
import jj2000.j2k.roi.encoder.ROIMaskGenerator;
import jj2000.j2k.wavelet.Subband;
import jj2000.j2k.wavelet.WaveletFilter;

public class ArbROIMaskGenerator
extends ROIMaskGenerator {
    private Quantizer src;
    private int[][] roiMask;
    private int[] maskLineLow;
    private int[] maskLineHigh;
    private int[] paddedMaskLine;
    private boolean roiInTile;

    public ArbROIMaskGenerator(ROI[] rOIArray, int n, Quantizer quantizer) {
        super(rOIArray, n);
        this.roiMask = new int[n][];
        this.src = quantizer;
    }

    @Override
    public boolean getROIMask(DataBlkInt dataBlkInt, Subband subband, int n, int n2) {
        int n3 = dataBlkInt.ulx;
        int n4 = dataBlkInt.uly;
        int n5 = dataBlkInt.w;
        int n6 = dataBlkInt.h;
        int n7 = subband.w;
        int cfr_ignored_0 = subband.h;
        int[] nArray = (int[])dataBlkInt.getData();
        if (!this.tileMaskMade[n2]) {
            this.makeMask(subband, n, n2);
            this.tileMaskMade[n2] = true;
        }
        if (!this.roiInTile) {
            return false;
        }
        int[] nArray2 = this.roiMask[n2];
        int n8 = (n4 + n6 - 1) * n7 + n3 + n5 - 1;
        int n9 = n5 * n6 - 1;
        int n10 = n7 - n5;
        int n11 = n6;
        while (n11 > 0) {
            int n12 = n5;
            while (n12 > 0) {
                nArray[n9] = nArray2[n8];
                --n12;
                --n8;
                --n9;
            }
            n8 -= n10;
            --n11;
        }
        return true;
    }

    public String toString() {
        return "Fast rectangular ROI mask generator";
    }

    @Override
    public void makeMask(Subband subband, int n, int n2) {
        int n3;
        int n4;
        int n5;
        Object object;
        int n6;
        int[] nArray;
        int n7;
        ROI[] rOIArray = this.rois;
        int n8 = subband.ulcx;
        int n9 = subband.ulcy;
        int n10 = subband.w;
        int n11 = subband.h;
        int n12 = n7 = n10 > n11 ? n10 : n11;
        if (this.roiMask[n2] == null || this.roiMask[n2].length < n10 * n11) {
            this.roiMask[n2] = new int[n10 * n11];
            nArray = this.roiMask[n2];
        } else {
            nArray = this.roiMask[n2];
            n6 = n10 * n11 - 1;
            while (n6 >= 0) {
                nArray[n6] = 0;
                --n6;
            }
        }
        if (this.maskLineLow == null || this.maskLineLow.length < (n7 + 1) / 2) {
            this.maskLineLow = new int[(n7 + 1) / 2];
        }
        if (this.maskLineHigh == null || this.maskLineHigh.length < (n7 + 1) / 2) {
            this.maskLineHigh = new int[(n7 + 1) / 2];
        }
        this.roiInTile = false;
        int n13 = rOIArray.length - 1;
        while (n13 >= 0) {
            if (rOIArray[n13].comp == n2) {
                int n14;
                int n15;
                int n16;
                int n17;
                int n18;
                int n19;
                int n20;
                int n21;
                int n22;
                int n23;
                int n24 = n;
                if (rOIArray[n13].arbShape) {
                    object = rOIArray[n13].maskPGM;
                    if (this.src.getImgWidth() != ((ImgReader)object).getImgWidth() || this.src.getImgHeight() != ((ImgReader)object).getImgHeight()) {
                        throw new IllegalArgumentException("Input image and ROI mask must have the same size");
                    }
                    n23 = this.src.getImgULX();
                    n22 = this.src.getImgULY();
                    n21 = n23 + this.src.getImgWidth() - 1;
                    n20 = n22 + this.src.getImgHeight() - 1;
                    if (n23 <= n8 + n10 && n22 <= n9 + n11 && n21 >= n8 && n20 >= n9) {
                        n23 -= n8;
                        n21 -= n8;
                        n22 -= n9;
                        n20 -= n9;
                        int n25 = 0;
                        n5 = 0;
                        if (n23 < 0) {
                            n25 = -n23;
                            n23 = 0;
                        }
                        if (n22 < 0) {
                            n5 = -n22;
                            n22 = 0;
                        }
                        n19 = n21 > n10 - 1 ? n10 - n23 : n21 + 1 - n23;
                        n18 = n20 > n11 - 1 ? n11 - n22 : n20 + 1 - n22;
                        DataBlkInt dataBlkInt = new DataBlkInt();
                        n4 = -ImgReaderPGM.DC_OFFSET;
                        n3 = 0;
                        dataBlkInt.ulx = n25;
                        dataBlkInt.w = n19;
                        dataBlkInt.h = 1;
                        n6 = (n22 + n18 - 1) * n10 + n23 + n19 - 1;
                        n17 = n19;
                        n16 = n10 - n17;
                        n15 = n18;
                        while (n15 > 0) {
                            dataBlkInt.uly = n5 + n15 - 1;
                            dataBlkInt = (DataBlkInt)((ImgReaderPGM)object).getInternCompData(dataBlkInt, 0);
                            int[] nArray2 = dataBlkInt.getDataInt();
                            n14 = n17;
                            while (n14 > 0) {
                                if (nArray2[n14 - 1] != n4) {
                                    nArray[n6] = n24;
                                    ++n3;
                                }
                                --n14;
                                --n6;
                            }
                            n6 -= n16;
                            --n15;
                        }
                        if (n3 != 0) {
                            this.roiInTile = true;
                        }
                    }
                } else if (rOIArray[n13].rect) {
                    n23 = rOIArray[n13].ulx;
                    n22 = rOIArray[n13].uly;
                    n21 = rOIArray[n13].w + n23 - 1;
                    n20 = rOIArray[n13].h + n22 - 1;
                    if (n23 <= n8 + n10 && n22 <= n9 + n11 && n21 >= n8 && n20 >= n9) {
                        this.roiInTile = true;
                        n23 = (n23 -= n8) < 0 ? 0 : n23;
                        n22 = n22 < 0 ? 0 : (n22 -= n9);
                        n19 = n21 > n10 - 1 ? n10 - n23 : (n21 -= n8) + 1 - n23;
                        n18 = n20 > n11 - 1 ? n11 - n22 : (n20 -= n9) + 1 - n22;
                        n6 = (n22 + n18 - 1) * n10 + n23 + n19 - 1;
                        n17 = n19;
                        n16 = n10 - n17;
                        n15 = n18;
                        while (n15 > 0) {
                            n14 = n17;
                            while (n14 > 0) {
                                nArray[n6] = n24;
                                --n14;
                                --n6;
                            }
                            n6 -= n16;
                            --n15;
                        }
                    }
                } else {
                    int n26 = rOIArray[n13].x - n8;
                    int n27 = rOIArray[n13].y - n9;
                    int n28 = rOIArray[n13].r;
                    n6 = n11 * n10 - 1;
                    n15 = n11 - 1;
                    while (n15 >= 0) {
                        n14 = n10 - 1;
                        while (n14 >= 0) {
                            if ((n14 - n26) * (n14 - n26) + (n15 - n27) * (n15 - n27) < n28 * n28) {
                                nArray[n6] = n24;
                                this.roiInTile = true;
                            }
                            --n14;
                            --n6;
                        }
                        --n15;
                    }
                }
            }
            --n13;
        }
        if (subband.isNode) {
            object = subband.getVerWFilter();
            WaveletFilter waveletFilter = subband.getHorWFilter();
            n5 = object.getSynLowNegSupport() + object.getSynLowPosSupport();
            int n29 = object.getSynHighNegSupport() + object.getSynHighPosSupport();
            n4 = waveletFilter.getSynLowNegSupport() + waveletFilter.getSynLowPosSupport();
            n3 = waveletFilter.getSynHighNegSupport() + waveletFilter.getSynHighPosSupport();
            n5 = n5 > n29 ? n5 : n29;
            n4 = n4 > n3 ? n4 : n3;
            n5 = n5 > n4 ? n5 : n4;
            this.paddedMaskLine = new int[n7 + n5];
            if (this.roiInTile) {
                this.decomp(subband, n10, n11, n2);
            }
        }
    }

    private void decomp(Subband subband, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10 = subband.ulx;
        int n11 = subband.uly;
        int n12 = subband.w;
        int n13 = subband.h;
        int n14 = 0;
        int n15 = 0;
        int[] nArray = this.roiMask[n3];
        int[] nArray2 = this.maskLineLow;
        int[] nArray3 = this.maskLineHigh;
        int[] nArray4 = this.paddedMaskLine;
        int n16 = 0;
        if (!subband.isNode) {
            return;
        }
        WaveletFilter waveletFilter = subband.getHorWFilter();
        int n17 = waveletFilter.getSynLowNegSupport();
        int n18 = waveletFilter.getSynHighNegSupport();
        int n19 = waveletFilter.getSynLowPosSupport();
        int n20 = waveletFilter.getSynHighPosSupport();
        int n21 = n17 + n19 + 1;
        int n22 = n18 + n20 + 1;
        n16 = subband.ulcx % 2;
        if (subband.w % 2 == 0) {
            n8 = n9 = n12 / 2 - 1;
        } else if (n16 == 0) {
            n9 = (n12 + 1) / 2 - 1;
            n8 = n12 / 2 - 1;
        } else {
            n8 = (n12 + 1) / 2 - 1;
            n9 = n12 / 2 - 1;
        }
        int n23 = n17 > n18 ? n17 : n18;
        int n24 = n19 > n20 ? n19 : n20;
        int n25 = n23 - 1;
        while (n25 >= 0) {
            nArray4[n25] = 0;
            --n25;
        }
        n25 = n23 + n12 - 1 + n24;
        while (n25 >= n12) {
            nArray4[n25] = 0;
            --n25;
        }
        int n26 = (n11 + n13) * n + n10 + n12 - 1;
        int n27 = n13 - 1;
        while (n27 >= 0) {
            n15 = n26 -= n;
            n7 = n12;
            n25 = n12 - 1 + n23;
            while (n7 > 0) {
                nArray4[n25] = nArray[n15];
                --n7;
                --n15;
                --n25;
            }
            n6 = n23 + n16 + 2 * n9 + n19;
            n7 = n9;
            while (n7 >= 0) {
                n25 = n6;
                n5 = n21;
                while (n5 > 0) {
                    n4 = nArray4[n25];
                    if (n4 > n14) {
                        n14 = n4;
                    }
                    --n5;
                    --n25;
                }
                nArray2[n7] = n14;
                n14 = 0;
                --n7;
                n6 -= 2;
            }
            n6 = n23 - n16 + 2 * n8 + 1 + n20;
            n7 = n8;
            while (n7 >= 0) {
                n25 = n6;
                n5 = n22;
                while (n5 > 0) {
                    n4 = nArray4[n25];
                    if (n4 > n14) {
                        n14 = n4;
                    }
                    --n5;
                    --n25;
                }
                nArray3[n7] = n14;
                n14 = 0;
                --n7;
                n6 -= 2;
            }
            n15 = n26;
            n7 = n8;
            while (n7 >= 0) {
                nArray[n15] = nArray3[n7];
                --n7;
                --n15;
            }
            n7 = n9;
            while (n7 >= 0) {
                nArray[n15] = nArray2[n7];
                --n7;
                --n15;
            }
            --n27;
        }
        waveletFilter = subband.getVerWFilter();
        n17 = waveletFilter.getSynLowNegSupport();
        n18 = waveletFilter.getSynHighNegSupport();
        n19 = waveletFilter.getSynLowPosSupport();
        n20 = waveletFilter.getSynHighPosSupport();
        n21 = n17 + n19 + 1;
        n22 = n18 + n20 + 1;
        n16 = subband.ulcy % 2;
        if (subband.h % 2 == 0) {
            n8 = n9 = n13 / 2 - 1;
        } else if (subband.ulcy % 2 == 0) {
            n9 = (n13 + 1) / 2 - 1;
            n8 = n13 / 2 - 1;
        } else {
            n8 = (n13 + 1) / 2 - 1;
            n9 = n13 / 2 - 1;
        }
        n23 = n17 > n18 ? n17 : n18;
        n24 = n19 > n20 ? n19 : n20;
        n25 = n23 - 1;
        while (n25 >= 0) {
            nArray4[n25] = 0;
            --n25;
        }
        n25 = n23 + n13 - 1 + n24;
        while (n25 >= n13) {
            nArray4[n25] = 0;
            --n25;
        }
        n26 = (n11 + n13 - 1) * n + n10 + n12;
        n27 = n12 - 1;
        while (n27 >= 0) {
            n15 = --n26;
            n7 = n13;
            n25 = n7 - 1 + n23;
            while (n7 > 0) {
                nArray4[n25] = nArray[n15];
                --n7;
                n15 -= n;
                --n25;
            }
            n6 = n23 + n16 + 2 * n9 + n19;
            n7 = n9;
            while (n7 >= 0) {
                n25 = n6;
                n5 = n21;
                while (n5 > 0) {
                    n4 = nArray4[n25];
                    if (n4 > n14) {
                        n14 = n4;
                    }
                    --n5;
                    --n25;
                }
                nArray2[n7] = n14;
                n14 = 0;
                --n7;
                n6 -= 2;
            }
            n6 = n23 - n16 + 2 * n8 + 1 + n20;
            n7 = n8;
            while (n7 >= 0) {
                n25 = n6;
                n5 = n22;
                while (n5 > 0) {
                    n4 = nArray4[n25];
                    if (n4 > n14) {
                        n14 = n4;
                    }
                    --n5;
                    --n25;
                }
                nArray3[n7] = n14;
                n14 = 0;
                --n7;
                n6 -= 2;
            }
            n15 = n26;
            n7 = n8;
            while (n7 >= 0) {
                nArray[n15] = nArray3[n7];
                --n7;
                n15 -= n;
            }
            n7 = n9;
            while (n7 >= 0) {
                nArray[n15] = nArray2[n7];
                --n7;
                n15 -= n;
            }
            --n27;
        }
        if (subband.isNode) {
            this.decomp(subband.getHH(), n, n2, n3);
            this.decomp(subband.getLH(), n, n2, n3);
            this.decomp(subband.getHL(), n, n2, n3);
            this.decomp(subband.getLL(), n, n2, n3);
        }
    }
}

