/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.quantization.dequantizer;

import jj2000.j2k.decoder.DecoderSpecs;
import jj2000.j2k.image.CompTransfSpec;
import jj2000.j2k.image.invcomptransf.InvCompTransf;
import jj2000.j2k.quantization.dequantizer.CBlkQuantDataSrcDec;
import jj2000.j2k.wavelet.synthesis.CBlkWTDataSrcDec;
import jj2000.j2k.wavelet.synthesis.MultiResImgDataAdapter;
import jj2000.j2k.wavelet.synthesis.SubbandSyn;
import jj2000.j2k.wavelet.synthesis.SynWTFilterSpec;

public abstract class Dequantizer
extends MultiResImgDataAdapter
implements CBlkWTDataSrcDec {
    public static final char OPT_PREFIX = 'Q';
    private static final String[][] pinfo = null;
    protected CBlkQuantDataSrcDec src;
    protected int[] rb = null;
    protected int[] utrb = null;
    private CompTransfSpec cts;
    private SynWTFilterSpec wfs;

    public Dequantizer(CBlkQuantDataSrcDec cBlkQuantDataSrcDec, int[] nArray, DecoderSpecs decoderSpecs) {
        super(cBlkQuantDataSrcDec);
        if (nArray.length != cBlkQuantDataSrcDec.getNumComps()) {
            throw new IllegalArgumentException();
        }
        this.src = cBlkQuantDataSrcDec;
        this.utrb = nArray;
        this.cts = decoderSpecs.cts;
        this.wfs = decoderSpecs.wfs;
    }

    @Override
    public int getNomRangeBits(int n) {
        return this.rb[n];
    }

    @Override
    public SubbandSyn getSynSubbandTree(int n, int n2) {
        return this.src.getSynSubbandTree(n, n2);
    }

    @Override
    public int getCbULX() {
        return this.src.getCbULX();
    }

    @Override
    public int getCbULY() {
        return this.src.getCbULY();
    }

    public static String[][] getParameterInfo() {
        return pinfo;
    }

    @Override
    public void setTile(int n, int n2) {
        this.src.setTile(n, n2);
        this.tIdx = this.getTileIdx();
        int n3 = 0;
        if ((Integer)this.cts.getTileDef(this.tIdx) == 0) {
            n3 = 0;
        } else {
            int n4 = this.src.getNumComps() > 3 ? 3 : this.src.getNumComps();
            int n5 = 0;
            int n6 = 0;
            while (n6 < n4) {
                n5 += this.wfs.isReversible(this.tIdx, n6) ? 1 : 0;
                ++n6;
            }
            if (n5 == 3) {
                n3 = 1;
            } else if (n5 == 0) {
                n3 = 2;
            } else {
                throw new IllegalArgumentException("Wavelet transformation and component transformation not coherent in tile" + this.tIdx);
            }
        }
        switch (n3) {
            case 0: {
                this.rb = this.utrb;
                break;
            }
            case 1: {
                this.rb = InvCompTransf.calcMixedBitDepths(this.utrb, 1, null);
                break;
            }
            case 2: {
                this.rb = InvCompTransf.calcMixedBitDepths(this.utrb, 2, null);
                break;
            }
            default: {
                throw new IllegalArgumentException("Non JPEG 2000 part I component transformation for tile: " + this.tIdx);
            }
        }
    }

    @Override
    public void nextTile() {
        this.src.nextTile();
        this.tIdx = this.getTileIdx();
        int n = (Integer)this.cts.getTileDef(this.tIdx);
        switch (n) {
            case 0: {
                this.rb = this.utrb;
                break;
            }
            case 1: {
                this.rb = InvCompTransf.calcMixedBitDepths(this.utrb, 1, null);
                break;
            }
            case 2: {
                this.rb = InvCompTransf.calcMixedBitDepths(this.utrb, 2, null);
                break;
            }
            default: {
                throw new IllegalArgumentException("Non JPEG 2000 part I component transformation for tile: " + this.tIdx);
            }
        }
    }
}

