/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.io;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import jj2000.j2k.io.BufferedRandomAccessFile;
import jj2000.j2k.io.EndianType;
import jj2000.j2k.io.RandomAccessIO;

public class BEBufferedRandomAccessFile
extends BufferedRandomAccessFile
implements RandomAccessIO,
EndianType {
    public BEBufferedRandomAccessFile(File file, String string, int n) throws IOException {
        super(file, string, n);
        this.byteOrdering = 0;
    }

    public BEBufferedRandomAccessFile(File file, String string) throws IOException {
        super(file, string);
        this.byteOrdering = 0;
    }

    public BEBufferedRandomAccessFile(String string, String string2, int n) throws IOException {
        super(string, string2, n);
        this.byteOrdering = 0;
    }

    public BEBufferedRandomAccessFile(String string, String string2) throws IOException {
        super(string, string2);
        this.byteOrdering = 0;
    }

    @Override
    public final void writeShort(int n) throws IOException {
        this.write(n >>> 8);
        this.write(n);
    }

    @Override
    public final void writeInt(int n) throws IOException {
        this.write(n >>> 24);
        this.write(n >>> 16);
        this.write(n >>> 8);
        this.write(n);
    }

    @Override
    public final void writeLong(long l) throws IOException {
        this.write((int)(l >>> 56));
        this.write((int)(l >>> 48));
        this.write((int)(l >>> 40));
        this.write((int)(l >>> 32));
        this.write((int)(l >>> 24));
        this.write((int)(l >>> 16));
        this.write((int)(l >>> 8));
        this.write((int)l);
    }

    @Override
    public final void writeFloat(float f) throws IOException {
        int n = Float.floatToIntBits(f);
        this.write(n >>> 24);
        this.write(n >>> 16);
        this.write(n >>> 8);
        this.write(n);
    }

    @Override
    public final void writeDouble(double d) throws IOException {
        long l = Double.doubleToLongBits(d);
        this.write((int)(l >>> 56));
        this.write((int)(l >>> 48));
        this.write((int)(l >>> 40));
        this.write((int)(l >>> 32));
        this.write((int)(l >>> 24));
        this.write((int)(l >>> 16));
        this.write((int)(l >>> 8));
        this.write((int)l);
    }

    @Override
    public final short readShort() throws IOException, EOFException {
        return (short)(this.read() << 8 | this.read());
    }

    @Override
    public final int readUnsignedShort() throws IOException, EOFException {
        return this.read() << 8 | this.read();
    }

    @Override
    public final int readInt() throws IOException, EOFException {
        return this.read() << 24 | this.read() << 16 | this.read() << 8 | this.read();
    }

    @Override
    public final long readUnsignedInt() throws IOException, EOFException {
        return this.read() << 24 | this.read() << 16 | this.read() << 8 | this.read();
    }

    @Override
    public final long readLong() throws IOException, EOFException {
        return (long)this.read() << 56 | (long)this.read() << 48 | (long)this.read() << 40 | (long)this.read() << 32 | (long)this.read() << 24 | (long)this.read() << 16 | (long)this.read() << 8 | (long)this.read();
    }

    @Override
    public final float readFloat() throws EOFException, IOException {
        return Float.intBitsToFloat(this.read() << 24 | this.read() << 16 | this.read() << 8 | this.read());
    }

    @Override
    public final double readDouble() throws IOException, EOFException {
        return Double.longBitsToDouble((long)this.read() << 56 | (long)this.read() << 48 | (long)this.read() << 40 | (long)this.read() << 32 | (long)this.read() << 24 | (long)this.read() << 16 | (long)this.read() << 8 | (long)this.read());
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + "\nBig-Endian ordering";
    }
}

