/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.image.input;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import jj2000.j2k.JJ2KExceptionHandler;
import jj2000.j2k.image.DataBlk;
import jj2000.j2k.image.DataBlkInt;
import jj2000.j2k.image.input.ImgReader;

public class ImgReaderPGM
extends ImgReader {
    public static int DC_OFFSET = 128;
    private RandomAccessFile in;
    private int offset;
    private int rb;
    private byte[] buf;
    private DataBlkInt intBlk;

    public ImgReaderPGM(File file) throws IOException {
        this(new RandomAccessFile(file, "r"));
    }

    public ImgReaderPGM(String string) throws IOException {
        this(new RandomAccessFile(string, "r"));
    }

    public ImgReaderPGM(RandomAccessFile randomAccessFile) throws EOFException, IOException {
        this.in = randomAccessFile;
        this.confirmFileType();
        this.skipCommentAndWhiteSpace();
        this.w = this.readHeaderInt();
        this.skipCommentAndWhiteSpace();
        this.h = this.readHeaderInt();
        this.skipCommentAndWhiteSpace();
        this.readHeaderInt();
        this.nc = 1;
        this.rb = 8;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.in = null;
    }

    @Override
    public int getNomRangeBits(int n) {
        if (n != 0) {
            throw new IllegalArgumentException();
        }
        return this.rb;
    }

    @Override
    public int getFixedPoint(int n) {
        if (n != 0) {
            throw new IllegalArgumentException();
        }
        return 0;
    }

    @Override
    public final DataBlk getInternCompData(DataBlk dataBlk, int n) {
        int[] nArray;
        if (n != 0) {
            throw new IllegalArgumentException();
        }
        if (dataBlk.getDataType() != 3) {
            if (this.intBlk == null) {
                this.intBlk = new DataBlkInt(dataBlk.ulx, dataBlk.uly, dataBlk.w, dataBlk.h);
            } else {
                this.intBlk.ulx = dataBlk.ulx;
                this.intBlk.uly = dataBlk.uly;
                this.intBlk.w = dataBlk.w;
                this.intBlk.h = dataBlk.h;
            }
            dataBlk = this.intBlk;
        }
        if ((nArray = (int[])dataBlk.getData()) == null || nArray.length < dataBlk.w * dataBlk.h) {
            nArray = new int[dataBlk.w * dataBlk.h];
            dataBlk.setData(nArray);
        }
        if (this.buf == null || this.buf.length < dataBlk.w) {
            this.buf = new byte[dataBlk.w];
        }
        try {
            int n2 = dataBlk.uly + dataBlk.h;
            int n3 = dataBlk.uly;
            while (n3 < n2) {
                this.in.seek(this.offset + n3 * this.w + dataBlk.ulx);
                this.in.read(this.buf, 0, dataBlk.w);
                int n4 = (n3 - dataBlk.uly) * dataBlk.w + dataBlk.w - 1;
                int n5 = dataBlk.w - 1;
                while (n5 >= 0) {
                    nArray[n4] = (this.buf[n5] & 0xFF) - DC_OFFSET;
                    --n5;
                    --n4;
                }
                ++n3;
            }
        }
        catch (IOException iOException) {
            JJ2KExceptionHandler.handleException(iOException);
        }
        dataBlk.progressive = false;
        dataBlk.offset = 0;
        dataBlk.scanw = dataBlk.w;
        return dataBlk;
    }

    @Override
    public DataBlk getCompData(DataBlk dataBlk, int n) {
        return this.getInternCompData(dataBlk, n);
    }

    private byte countedByteRead() throws IOException, EOFException {
        ++this.offset;
        return this.in.readByte();
    }

    private void confirmFileType() throws IOException, EOFException {
        byte[] byArray = new byte[]{80, 53};
        int n = 0;
        while (n < 2) {
            byte by = this.countedByteRead();
            if (by != byArray[n]) {
                if (n == 1 && by == 50) {
                    throw new IllegalArgumentException("JJ2000 does not support ascii-PGM files. Use  raw-PGM file instead. ");
                }
                throw new IllegalArgumentException("Not a raw-PGM file");
            }
            ++n;
        }
    }

    private void skipCommentAndWhiteSpace() throws IOException, EOFException {
        boolean bl = false;
        while (!bl) {
            byte by = this.countedByteRead();
            if (by == 35) {
                while (by != 10 && by != 13) {
                    by = this.countedByteRead();
                }
                continue;
            }
            if (by == 9 || by == 10 || by == 13 || by == 32) continue;
            bl = true;
        }
        --this.offset;
        this.in.seek(this.offset);
    }

    private int readHeaderInt() throws IOException, EOFException {
        int n = 0;
        byte by = 0;
        by = this.countedByteRead();
        while (by != 32 && by != 10 && by != 9 && by != 13) {
            n = n * 10 + by - 48;
            by = this.countedByteRead();
        }
        return n;
    }

    @Override
    public boolean isOrigSigned(int n) {
        if (n != 0) {
            throw new IllegalArgumentException();
        }
        return false;
    }

    public String toString() {
        return "ImgReaderPGM: WxH = " + this.w + "x" + this.h + ", Component = 0" + "\nUnderlying RandomAccessIO:\n" + this.in.toString();
    }
}

