/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.image;

import java.awt.Point;
import jj2000.j2k.NoNextElementException;
import jj2000.j2k.image.BlkImgDataSrc;
import jj2000.j2k.image.DataBlk;

public class ImgDataJoiner
implements BlkImgDataSrc {
    private int w;
    private int h;
    private int nc;
    private BlkImgDataSrc[] imageData;
    private int[] compIdx;
    private int[] subsX;
    private int[] subsY;

    public ImgDataJoiner(BlkImgDataSrc[] blkImgDataSrcArray, int[] nArray) {
        this.imageData = blkImgDataSrcArray;
        this.compIdx = nArray;
        if (this.imageData.length != this.compIdx.length) {
            throw new IllegalArgumentException("imD and cIdx must have the same length");
        }
        this.nc = blkImgDataSrcArray.length;
        this.subsX = new int[this.nc];
        this.subsY = new int[this.nc];
        int n = 0;
        while (n < this.nc) {
            if (blkImgDataSrcArray[n].getNumTiles() != 1 || blkImgDataSrcArray[n].getCompULX(nArray[n]) != 0 || blkImgDataSrcArray[n].getCompULY(nArray[n]) != 0) {
                throw new IllegalArgumentException("All input components must, not use tiles and must have the origin at the canvas origin");
            }
            ++n;
        }
        int n2 = 0;
        int n3 = 0;
        n = 0;
        while (n < this.nc) {
            if (blkImgDataSrcArray[n].getCompImgWidth(nArray[n]) > n2) {
                n2 = blkImgDataSrcArray[n].getCompImgWidth(nArray[n]);
            }
            if (blkImgDataSrcArray[n].getCompImgHeight(nArray[n]) > n3) {
                n3 = blkImgDataSrcArray[n].getCompImgHeight(nArray[n]);
            }
            ++n;
        }
        this.w = n2;
        this.h = n3;
        n = 0;
        while (n < this.nc) {
            this.subsX[n] = (n2 + blkImgDataSrcArray[n].getCompImgWidth(nArray[n]) - 1) / blkImgDataSrcArray[n].getCompImgWidth(nArray[n]);
            this.subsY[n] = (n3 + blkImgDataSrcArray[n].getCompImgHeight(nArray[n]) - 1) / blkImgDataSrcArray[n].getCompImgHeight(nArray[n]);
            if ((n2 + this.subsX[n] - 1) / this.subsX[n] != blkImgDataSrcArray[n].getCompImgWidth(nArray[n]) || (n3 + this.subsY[n] - 1) / this.subsY[n] != blkImgDataSrcArray[n].getCompImgHeight(nArray[n])) {
                throw new Error("Can not compute component subsampling factors: strange subsampling.");
            }
            ++n;
        }
    }

    @Override
    public int getTileWidth() {
        return this.w;
    }

    @Override
    public int getTileHeight() {
        return this.h;
    }

    @Override
    public int getNomTileWidth() {
        return this.w;
    }

    @Override
    public int getNomTileHeight() {
        return this.h;
    }

    @Override
    public int getImgWidth() {
        return this.w;
    }

    @Override
    public int getImgHeight() {
        return this.h;
    }

    @Override
    public int getNumComps() {
        return this.nc;
    }

    @Override
    public int getCompSubsX(int n) {
        return this.subsX[n];
    }

    @Override
    public int getCompSubsY(int n) {
        return this.subsY[n];
    }

    @Override
    public int getTileCompWidth(int n, int n2) {
        return this.imageData[n2].getTileCompWidth(n, this.compIdx[n2]);
    }

    @Override
    public int getTileCompHeight(int n, int n2) {
        return this.imageData[n2].getTileCompHeight(n, this.compIdx[n2]);
    }

    @Override
    public int getCompImgWidth(int n) {
        return this.imageData[n].getCompImgWidth(this.compIdx[n]);
    }

    @Override
    public int getCompImgHeight(int n) {
        return this.imageData[n].getCompImgHeight(this.compIdx[n]);
    }

    @Override
    public int getNomRangeBits(int n) {
        return this.imageData[n].getNomRangeBits(this.compIdx[n]);
    }

    @Override
    public int getFixedPoint(int n) {
        return this.imageData[n].getFixedPoint(this.compIdx[n]);
    }

    @Override
    public DataBlk getInternCompData(DataBlk dataBlk, int n) {
        return this.imageData[n].getInternCompData(dataBlk, this.compIdx[n]);
    }

    @Override
    public DataBlk getCompData(DataBlk dataBlk, int n) {
        return this.imageData[n].getCompData(dataBlk, this.compIdx[n]);
    }

    @Override
    public void setTile(int n, int n2) {
        if (n != 0 || n2 != 0) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void nextTile() {
        throw new NoNextElementException();
    }

    @Override
    public Point getTile(Point point) {
        if (point != null) {
            point.x = 0;
            point.y = 0;
            return point;
        }
        return new Point(0, 0);
    }

    @Override
    public int getTileIdx() {
        return 0;
    }

    @Override
    public int getCompULX(int n) {
        return 0;
    }

    @Override
    public int getCompULY(int n) {
        return 0;
    }

    @Override
    public int getTilePartULX() {
        return 0;
    }

    @Override
    public int getTilePartULY() {
        return 0;
    }

    @Override
    public int getImgULX() {
        return 0;
    }

    @Override
    public int getImgULY() {
        return 0;
    }

    @Override
    public Point getNumTiles(Point point) {
        if (point != null) {
            point.x = 1;
            point.y = 1;
            return point;
        }
        return new Point(1, 1);
    }

    @Override
    public int getNumTiles() {
        return 1;
    }

    public String toString() {
        String string = "ImgDataJoiner: WxH = " + this.w + "x" + this.h;
        int n = 0;
        while (n < this.nc) {
            string = String.valueOf(string) + "\n- Component " + n + " " + this.imageData[n];
            ++n;
        }
        return string;
    }
}

