/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.image;

import jj2000.j2k.image.BlkImgDataSrc;
import jj2000.j2k.image.DataBlk;
import jj2000.j2k.image.DataBlkInt;
import jj2000.j2k.image.ImgDataAdapter;

public class ImgDataConverter
extends ImgDataAdapter
implements BlkImgDataSrc {
    private DataBlk srcBlk = new DataBlkInt();
    private BlkImgDataSrc src;
    private int fp;

    public ImgDataConverter(BlkImgDataSrc blkImgDataSrc, int n) {
        super(blkImgDataSrc);
        this.src = blkImgDataSrc;
        this.fp = n;
    }

    public ImgDataConverter(BlkImgDataSrc blkImgDataSrc) {
        super(blkImgDataSrc);
        this.src = blkImgDataSrc;
        this.fp = 0;
    }

    @Override
    public int getFixedPoint(int n) {
        return this.fp;
    }

    @Override
    public DataBlk getCompData(DataBlk dataBlk, int n) {
        return this.getData(dataBlk, n, false);
    }

    @Override
    public final DataBlk getInternCompData(DataBlk dataBlk, int n) {
        return this.getData(dataBlk, n, true);
    }

    private DataBlk getData(DataBlk dataBlk, int n, boolean bl) {
        DataBlk dataBlk2;
        int n2 = dataBlk.getDataType();
        if (n2 == this.srcBlk.getDataType()) {
            dataBlk2 = dataBlk;
        } else {
            dataBlk2 = this.srcBlk;
            dataBlk2.ulx = dataBlk.ulx;
            dataBlk2.uly = dataBlk.uly;
            dataBlk2.w = dataBlk.w;
            dataBlk2.h = dataBlk.h;
        }
        this.srcBlk = bl ? this.src.getInternCompData(dataBlk2, n) : this.src.getCompData(dataBlk2, n);
        if (this.srcBlk.getDataType() == n2) {
            return this.srcBlk;
        }
        int n3 = this.srcBlk.w;
        int n4 = this.srcBlk.h;
        switch (n2) {
            case 4: {
                float[] fArray = (float[])dataBlk.getData();
                if (fArray == null || fArray.length < n3 * n4) {
                    fArray = new float[n3 * n4];
                    dataBlk.setData(fArray);
                }
                dataBlk.scanw = this.srcBlk.w;
                dataBlk.offset = 0;
                dataBlk.progressive = this.srcBlk.progressive;
                int[] nArray = (int[])this.srcBlk.getData();
                this.fp = this.src.getFixedPoint(n);
                if (this.fp != 0) {
                    float f = 1.0f / (float)(1 << this.fp);
                    int n5 = n4 - 1;
                    int n6 = n3 * n4 - 1;
                    int n7 = this.srcBlk.offset + (n4 - 1) * this.srcBlk.scanw + n3 - 1;
                    while (n5 >= 0) {
                        int n8 = n6 - n3;
                        while (n6 > n8) {
                            fArray[n6] = (float)nArray[n7] * f;
                            --n6;
                            --n7;
                        }
                        n7 -= this.srcBlk.scanw - n3;
                        --n5;
                    }
                } else {
                    int n9 = n4 - 1;
                    int n10 = n3 * n4 - 1;
                    int n11 = this.srcBlk.offset + (n4 - 1) * this.srcBlk.scanw + n3 - 1;
                    while (n9 >= 0) {
                        int n12 = n10 - n3;
                        while (n10 > n12) {
                            fArray[n10] = nArray[n11];
                            --n10;
                            --n11;
                        }
                        n11 -= this.srcBlk.scanw - n3;
                        --n9;
                    }
                }
                break;
            }
            case 3: {
                int[] nArray = (int[])dataBlk.getData();
                if (nArray == null || nArray.length < n3 * n4) {
                    nArray = new int[n3 * n4];
                    dataBlk.setData(nArray);
                }
                dataBlk.scanw = this.srcBlk.w;
                dataBlk.offset = 0;
                dataBlk.progressive = this.srcBlk.progressive;
                float[] fArray = (float[])this.srcBlk.getData();
                if (this.fp != 0) {
                    float f = 1 << this.fp;
                    int n13 = n4 - 1;
                    int n14 = n3 * n4 - 1;
                    int n15 = this.srcBlk.offset + (n4 - 1) * this.srcBlk.scanw + n3 - 1;
                    while (n13 >= 0) {
                        int n16 = n14 - n3;
                        while (n14 > n16) {
                            nArray[n14] = fArray[n15] > 0.0f ? (int)(fArray[n15] * f + 0.5f) : (int)(fArray[n15] * f - 0.5f);
                            --n14;
                            --n15;
                        }
                        n15 -= this.srcBlk.scanw - n3;
                        --n13;
                    }
                } else {
                    int n17 = n4 - 1;
                    int n18 = n3 * n4 - 1;
                    int n19 = this.srcBlk.offset + (n4 - 1) * this.srcBlk.scanw + n3 - 1;
                    while (n17 >= 0) {
                        int n20 = n18 - n3;
                        while (n18 > n20) {
                            nArray[n18] = fArray[n19] > 0.0f ? (int)(fArray[n19] + 0.5f) : (int)(fArray[n19] - 0.5f);
                            --n18;
                            --n19;
                        }
                        n19 -= this.srcBlk.scanw - n3;
                        --n17;
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Only integer and float data are supported by JJ2000");
            }
        }
        return dataBlk;
    }
}

