/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.entropy.encoder;

import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageWriteParamJava;
import java.awt.Point;
import java.io.IOException;
import jj2000.j2k.codestream.PrecInfo;
import jj2000.j2k.codestream.writer.BitOutputBuffer;
import jj2000.j2k.codestream.writer.CodestreamWriter;
import jj2000.j2k.codestream.writer.PktEncoder;
import jj2000.j2k.entropy.Progression;
import jj2000.j2k.entropy.encoder.CBlkRateDistStats;
import jj2000.j2k.entropy.encoder.CodedCBlkDataSrcEnc;
import jj2000.j2k.entropy.encoder.EBCOTLayer;
import jj2000.j2k.entropy.encoder.LayersInfo;
import jj2000.j2k.entropy.encoder.PostCompRateAllocator;
import jj2000.j2k.util.FacilityManager;
import jj2000.j2k.util.MathUtil;
import jj2000.j2k.wavelet.analysis.SubbandAn;

public class EBCOTRateAllocator
extends PostCompRateAllocator {
    private static final boolean DO_TIMING = false;
    private long initTime;
    private long buildTime;
    private long writeTime;
    private CBlkRateDistStats[][][][][] cblks;
    private int[][][][][][] truncIdxs;
    private Point[][][] numPrec;
    private EBCOTLayer[] layers;
    private static final double LOG2 = Math.log(2.0);
    private static final int RD_SUMMARY_OFF = 24;
    private static final int RD_SUMMARY_SIZE = 64;
    private static final float FLOAT_REL_PRECISION = 1.0E-4f;
    private static final float FLOAT_ABS_PRECISION = 1.0E-10f;
    private static final int MIN_AVG_PACKET_SZ = 32;
    private int[] RDSlopesRates;
    private PktEncoder pktEnc;
    private LayersInfo lyrSpec;
    private float maxSlope;
    private float minSlope;

    public EBCOTRateAllocator(CodedCBlkDataSrcEnc codedCBlkDataSrcEnc, LayersInfo layersInfo, CodestreamWriter codestreamWriter, J2KImageWriteParamJava j2KImageWriteParamJava) {
        super(codedCBlkDataSrcEnc, layersInfo.getTotNumLayers(), codestreamWriter, j2KImageWriteParamJava);
        Point point = null;
        this.lyrSpec = layersInfo;
        this.RDSlopesRates = new int[64];
        int n = codedCBlkDataSrcEnc.getNumTiles();
        int n2 = this.getNumComps();
        this.cblks = new CBlkRateDistStats[n][n2][][][];
        this.truncIdxs = new int[n][this.numLayers][n2][][][];
        Point point2 = null;
        Point point3 = null;
        int n3 = codedCBlkDataSrcEnc.getCbULX();
        int n4 = codedCBlkDataSrcEnc.getCbULY();
        codedCBlkDataSrcEnc.setTile(0, 0);
        int n5 = 0;
        while (n5 < n) {
            point3 = codedCBlkDataSrcEnc.getNumTiles(point3);
            point2 = codedCBlkDataSrcEnc.getTile(point2);
            int n6 = this.getImgULX();
            int n7 = this.getImgULY();
            int n8 = n6 + this.getImgWidth();
            int n9 = n7 + this.getImgHeight();
            int n10 = codedCBlkDataSrcEnc.getTilePartULX();
            int n11 = codedCBlkDataSrcEnc.getTilePartULY();
            int n12 = codedCBlkDataSrcEnc.getNomTileWidth();
            int n13 = codedCBlkDataSrcEnc.getNomTileHeight();
            int n14 = point2.x == 0 ? n6 : n10 + point2.x * n12;
            int n15 = point2.y == 0 ? n7 : n11 + point2.y * n13;
            int n16 = point2.x != point3.x - 1 ? n10 + (point2.x + 1) * n12 : n8;
            int n17 = point2.y != point3.y - 1 ? n11 + (point2.y + 1) * n13 : n9;
            int n18 = 0;
            while (n18 < n2) {
                SubbandAn subbandAn = codedCBlkDataSrcEnc.getAnSubbandTree(n5, n18);
                int n19 = subbandAn.resLvl + 1;
                if (this.numPrec == null) {
                    this.numPrec = new Point[n][n2][];
                }
                if (this.numPrec[n5][n18] == null) {
                    this.numPrec[n5][n18] = new Point[n19];
                }
                int n20 = codedCBlkDataSrcEnc.getCompSubsX(n18);
                int n21 = codedCBlkDataSrcEnc.getCompSubsY(n18);
                int n22 = (int)Math.ceil((double)n14 / (double)n20);
                int n23 = (int)Math.ceil((double)n15 / (double)n21);
                int n24 = (int)Math.ceil((double)n16 / (double)n20);
                int n25 = (int)Math.ceil((double)n17 / (double)n21);
                this.cblks[n5][n18] = new CBlkRateDistStats[n19][][];
                int n26 = 0;
                while (n26 < this.numLayers) {
                    this.truncIdxs[n5][n26][n18] = new int[n19][][];
                    ++n26;
                }
                int n27 = 0;
                while (n27 < n19) {
                    int n28 = (int)Math.ceil((double)n22 / (double)(1 << n19 - 1 - n27));
                    int n29 = (int)Math.ceil((double)n23 / (double)(1 << n19 - 1 - n27));
                    int n30 = (int)Math.ceil((double)n24 / (double)(1 << n19 - 1 - n27));
                    int n31 = (int)Math.ceil((double)n25 / (double)(1 << n19 - 1 - n27));
                    double d = j2KImageWriteParamJava.getPrecinctPartition().getPPX(n5, n18, n27);
                    double d2 = j2KImageWriteParamJava.getPrecinctPartition().getPPY(n5, n18, n27);
                    this.numPrec[n5][n18][n27] = new Point();
                    this.numPrec[n5][n18][n27].x = n30 > n28 ? (int)Math.ceil((double)(n30 - n3) / d) - (int)Math.floor((double)(n28 - n3) / d) : 0;
                    this.numPrec[n5][n18][n27].y = n31 > n29 ? (int)Math.ceil((double)(n31 - n4) / d2) - (int)Math.floor((double)(n29 - n4) / d2) : 0;
                    int n32 = n27 == 0 ? 0 : 1;
                    int n33 = n27 == 0 ? 1 : 4;
                    this.cblks[n5][n18][n27] = new CBlkRateDistStats[n33][];
                    n26 = 0;
                    while (n26 < this.numLayers) {
                        this.truncIdxs[n5][n26][n18][n27] = new int[n33][];
                        ++n26;
                    }
                    int n34 = n32;
                    while (n34 < n33) {
                        SubbandAn subbandAn2 = (SubbandAn)subbandAn.getSubbandByIdx(n27, n34);
                        point = subbandAn2.numCb;
                        int n35 = point.x * point.y;
                        this.cblks[n5][n18][n27][n34] = new CBlkRateDistStats[n35];
                        n26 = 0;
                        while (n26 < this.numLayers) {
                            this.truncIdxs[n5][n26][n18][n27][n34] = new int[n35];
                            int n36 = 0;
                            while (n36 < n35) {
                                this.truncIdxs[n5][n26][n18][n27][n34][n36] = -1;
                                ++n36;
                            }
                            ++n26;
                        }
                        ++n34;
                    }
                    ++n27;
                }
                ++n18;
            }
            if (n5 != n - 1) {
                codedCBlkDataSrcEnc.nextTile();
            }
            ++n5;
        }
        this.pktEnc = new PktEncoder(codedCBlkDataSrcEnc, j2KImageWriteParamJava, this.numPrec);
    }

    public void finalize() throws Throwable {
        super.finalize();
    }

    @Override
    public void runAndWrite() throws IOException {
        this.buildAndWriteLayers();
    }

    @Override
    public void initialize() throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = this.src.getNumTiles();
        int n8 = this.src.getNumComps();
        long l = 0L;
        this.getAllCodeBlocks();
        int n9 = this.RDSlopesRates[0];
        int n10 = 0;
        while (n10 < n7) {
            int n11 = 2;
            if (((String)this.wp.getSOP().getTileDef(n10)).equalsIgnoreCase("true")) {
                n11 += 6;
            }
            if (((String)this.wp.getEPH().getTileDef(n10)).equalsIgnoreCase("true")) {
                n11 += 2;
            }
            n6 = 0;
            while (n6 < n8) {
                n5 = this.src.getAnSubbandTree((int)n10, (int)n6).resLvl + 1;
                if (!this.src.precinctPartitionUsed(n6, n10)) {
                    n9 += this.numLayers * n11 * n5;
                } else {
                    n4 = 0;
                    while (n4 < n5) {
                        n3 = this.numPrec[n10][n6][n4].x * this.numPrec[n10][n6][n4].y;
                        n9 += this.numLayers * n11 * n3;
                        ++n4;
                    }
                }
                ++n6;
            }
            ++n10;
        }
        int n12 = this.headEnc.getLength();
        float f = (float)(this.src.getImgWidth() * this.src.getImgHeight()) / 8.0f;
        n10 = 0;
        while (n10 < n7) {
            this.headEnc.reset();
            this.headEnc.encodeTilePartHeader(0, n10);
            n12 += this.headEnc.getLength();
            ++n10;
        }
        this.layers = new EBCOTLayer[this.numLayers];
        int n13 = this.numLayers - 1;
        while (n13 >= 0) {
            this.layers[n13] = new EBCOTLayer();
            --n13;
        }
        int n14 = 0;
        n10 = 0;
        while (n10 < n7) {
            n6 = 0;
            while (n6 < n8) {
                n5 = this.src.getAnSubbandTree((int)n10, (int)n6).resLvl + 1;
                if (!this.src.precinctPartitionUsed(n6, n10)) {
                    n14 += 32 * n5;
                } else {
                    n4 = 0;
                    while (n4 < n5) {
                        n3 = this.numPrec[n10][n6][n4].x * this.numPrec[n10][n6][n4].y;
                        n14 += 32 * n3;
                        ++n4;
                    }
                }
                ++n6;
            }
            ++n10;
        }
        n13 = 0;
        int n15 = 0;
        int n16 = 0;
        while (n13 < this.numLayers - 1) {
            double d = Math.floor(this.lyrSpec.getTargetBitrate(n15) * f);
            if (n15 < this.lyrSpec.getNOptPoints() - 1) {
                n2 = (int)(this.lyrSpec.getTargetBitrate(n15 + 1) * f);
                if (n2 > n9) {
                    n2 = n9;
                }
            } else {
                n2 = 1;
            }
            int n17 = this.lyrSpec.getExtraLayers(n15) + 1;
            double d2 = Math.exp(Math.log((double)n2 / d) / (double)n17);
            this.layers[n13].optimize = true;
            int n18 = 0;
            while (n18 < n17) {
                n = (int)d - n16 - n12;
                if (n < n14) {
                    d *= d2;
                    --this.numLayers;
                } else {
                    this.layers[n13].maxBytes = n16 = (int)d - n12;
                    d *= d2;
                    ++n13;
                }
                ++n18;
            }
            ++n15;
        }
        n13 = this.numLayers - 2;
        n2 = (int)(this.lyrSpec.getTotBitrate() * f) - n12;
        n = n2 - (n13 >= 0 ? this.layers[n13].maxBytes : 0);
        while (n < n14) {
            if (this.numLayers == 1) {
                if (n > 0) break;
                throw new IllegalArgumentException("Overall target bitrate too low, given the current bit stream header overhead");
            }
            --this.numLayers;
            n = n2 - (--n13 >= 0 ? this.layers[n13].maxBytes : 0);
        }
        this.layers[++n13].maxBytes = n2;
        this.layers[n13].optimize = true;
        Progression[] progressionArray = (Progression[])this.wp.getProgressionType().getDefault();
        n6 = progressionArray.length;
        n4 = 0;
        while (n4 < progressionArray.length) {
            if (progressionArray[n4].lye > this.numLayers) {
                progressionArray[n4].lye = this.numLayers;
            }
            ++n4;
        }
        if (n6 == 0) {
            throw new Error("Unable to initialize rate allocator: No default progression type has been defined.");
        }
        n4 = 0;
        while (n4 < n7) {
            if (this.wp.getProgressionType().isTileSpecified(n4)) {
                progressionArray = (Progression[])this.wp.getProgressionType().getTileDef(n4);
                n6 = progressionArray.length;
                int n19 = 0;
                while (n19 < progressionArray.length) {
                    if (progressionArray[n19].lye > this.numLayers) {
                        progressionArray[n19].lye = this.numLayers;
                    }
                    ++n19;
                }
                if (n6 == 0) {
                    throw new Error("Unable to initialize rate allocator: No default progression type has been defined.");
                }
            }
            ++n4;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void getAllCodeBlocks() {
        var10_1 = null;
        var11_2 = null;
        var14_3 = 0L;
        this.maxSlope = 0.0f;
        this.minSlope = 3.4028235E38f;
        var1_4 = this.src.getNumComps();
        var2_5 = this.src.getNumTiles();
        var18_6 = 0;
        var19_7 = 0;
        var20_8 = FacilityManager.getProgressWatch();
        this.src.setTile(0, 0);
        var5_9 = 0;
        while (var5_9 < var2_5) {
            var19_7 = 0;
            var18_6 = 0;
            var3_10 = 0;
            while (var3_10 < var1_4) {
                var16_18 = this.src.getAnSubbandTree(var5_9, var3_10);
                var4_11 = 0;
                while (var4_11 <= var16_18.resLvl) {
                    if (var4_11 == 0) {
                        var17_19 = (SubbandAn)var16_18.getSubbandByIdx(0, 0);
                        if (var17_19 != null) {
                            var18_6 += var17_19.numCb.x * var17_19.numCb.y;
                        }
                    } else {
                        var17_19 = (SubbandAn)var16_18.getSubbandByIdx(var4_11, 1);
                        if (var17_19 != null) {
                            var18_6 += var17_19.numCb.x * var17_19.numCb.y;
                        }
                        if ((var17_19 = (SubbandAn)var16_18.getSubbandByIdx(var4_11, 2)) != null) {
                            var18_6 += var17_19.numCb.x * var17_19.numCb.y;
                        }
                        if ((var17_19 = (SubbandAn)var16_18.getSubbandByIdx(var4_11, 3)) != null) {
                            var18_6 += var17_19.numCb.x * var17_19.numCb.y;
                        }
                    }
                    ++var4_11;
                }
                ++var3_10;
            }
            if (var20_8 != null) {
                var20_8.initProgressWatch(0, var18_6, "Encoding tile " + var5_9 + "...");
            }
            var3_10 = 0;
            ** GOTO lbl68
            {
                if (var20_8 != null) {
                    var20_8.updateProgressWatch(++var19_7, null);
                }
                var9_15 = var10_1.sb;
                var4_11 = var9_15.resLvl;
                var6_12 = var9_15.sbandIdx;
                var11_2 = var9_15.numCb;
                var12_16 = -1;
                var8_14 = var10_1.nVldTrunc - 1;
                while (var8_14 >= 0) {
                    var13_17 = var10_1.truncSlopes[var8_14];
                    if (var13_17 > this.maxSlope) {
                        this.maxSlope = var13_17;
                    }
                    if (var13_17 < this.minSlope) {
                        this.minSlope = var13_17;
                    }
                    var7_13 = EBCOTRateAllocator.getLimitedSIndexFromSlope(var13_17);
                    while (var7_13 > var12_16) {
                        v0 = var7_13--;
                        this.RDSlopesRates[v0] = this.RDSlopesRates[v0] + var10_1.truncRates[var10_1.truncIdxs[var8_14]];
                    }
                    var12_16 = EBCOTRateAllocator.getLimitedSIndexFromSlope(var13_17);
                    --var8_14;
                }
                this.cblks[var5_9][var3_10][var4_11][var6_12][var10_1.m * var11_2.x + var10_1.n] = var10_1;
                var10_1 = null;
                do {
                    if ((var10_1 = this.src.getNextCodeBlock(var3_10, var10_1)) != null) continue block3;
                    ++var3_10;
lbl68:
                    // 2 sources

                } while (var3_10 < var1_4);
            }
            if (var20_8 != null) {
                var20_8.terminateProgressWatch();
            }
            if (var5_9 < var2_5 - 1) {
                this.src.nextTile();
            }
            ++var5_9;
        }
    }

    private void buildAndWriteLayers() throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = 0;
        BitOutputBuffer bitOutputBuffer = null;
        byte[] byArray = null;
        int n6 = this.src.getNumComps();
        int n7 = this.src.getNumTiles();
        long l = 0L;
        float f = this.maxSlope;
        int[] nArray = new int[n7];
        int n8 = 0;
        int n9 = 0;
        while (n9 < this.numLayers) {
            int n10 = this.layers[n9].maxBytes;
            if (this.layers[n9].optimize) {
                f = this.optimizeBitstreamLayer(n9, f, n10, n8);
            } else {
                if (n9 <= 0 || n9 >= this.numLayers - 1) {
                    throw new IllegalArgumentException("The first and the last layer thresholds must be optimized");
                }
                f = this.estimateLayerThreshold(n10, this.layers[n9 - 1]);
            }
            n4 = 0;
            while (n4 < n7) {
                if (n9 == 0) {
                    this.headEnc.reset();
                    this.headEnc.encodeTilePartHeader(0, n4);
                    int n11 = n4;
                    nArray[n11] = nArray[n11] + this.headEnc.getLength();
                }
                n3 = 0;
                while (n3 < n6) {
                    boolean bl = ((String)this.wp.getSOP().getTileDef(n4)).equalsIgnoreCase("true");
                    boolean bl2 = ((String)this.wp.getEPH().getTileDef(n4)).equalsIgnoreCase("true");
                    SubbandAn subbandAn = this.src.getAnSubbandTree(n4, n3);
                    int n12 = subbandAn.resLvl + 1;
                    while (subbandAn.subb_LL != null) {
                        subbandAn = subbandAn.subb_LL;
                    }
                    n2 = 0;
                    while (n2 < n12) {
                        n5 = this.numPrec[n4][n3][n2].x * this.numPrec[n4][n3][n2].y;
                        n = 0;
                        while (n < n5) {
                            this.findTruncIndices(n9, n3, n2, n4, subbandAn, f, n);
                            bitOutputBuffer = this.pktEnc.encodePacket(n9 + 1, n3, n2, n4, this.cblks[n4][n3][n2], this.truncIdxs[n4][n9][n3][n2], bitOutputBuffer, byArray, n);
                            if (this.pktEnc.isPacketWritable()) {
                                int n13 = this.bsWriter.writePacketHead(bitOutputBuffer.getBuffer(), bitOutputBuffer.getLength(), true, bl, bl2);
                                n8 += (n13 += this.bsWriter.writePacketBody(this.pktEnc.getLastBodyBuf(), this.pktEnc.getLastBodyLen(), true, this.pktEnc.isROIinPkt(), this.pktEnc.getROILen()));
                                int n14 = n4;
                                nArray[n14] = nArray[n14] + n13;
                            }
                            ++n;
                        }
                        subbandAn = subbandAn.parent;
                        ++n2;
                    }
                    ++n3;
                }
                ++n4;
            }
            this.layers[n9].rdThreshold = f;
            this.layers[n9].actualBytes = n8;
            ++n9;
        }
        this.pktEnc.reset();
        int[] nArray2 = new int[n6];
        int n15 = 0;
        while (n15 < n7) {
            int[][] nArrayArray = new int[n6][];
            int n16 = 0;
            while (n16 < n6) {
                nArray2[n16] = this.src.getAnSubbandTree((int)n15, (int)n16).resLvl;
                nArrayArray[n16] = new int[nArray2[n16] + 1];
                ++n16;
            }
            this.headEnc.reset();
            this.headEnc.encodeTilePartHeader(nArray[n15], n15);
            this.bsWriter.commitBitstreamHeader(this.headEnc);
            Progression[] progressionArray = (Progression[])this.wp.getProgressionType().getTileDef(n15);
            n16 = 0;
            while (n16 < progressionArray.length) {
                int n17 = progressionArray[n16].lye;
                n4 = progressionArray[n16].cs;
                n3 = progressionArray[n16].ce;
                n2 = progressionArray[n16].rs;
                n = progressionArray[n16].re;
                switch (progressionArray[n16].type) {
                    case 1: {
                        this.writeResLyCompPos(n15, n2, n, n4, n3, nArrayArray, n17);
                        break;
                    }
                    case 0: {
                        this.writeLyResCompPos(n15, n2, n, n4, n3, nArrayArray, n17);
                        break;
                    }
                    case 3: {
                        this.writePosCompResLy(n15, n2, n, n4, n3, nArrayArray, n17);
                        break;
                    }
                    case 4: {
                        this.writeCompPosResLy(n15, n2, n, n4, n3, nArrayArray, n17);
                        break;
                    }
                    case 2: {
                        this.writeResPosCompLy(n15, n2, n, n4, n3, nArrayArray, n17);
                        break;
                    }
                    default: {
                        throw new Error("Unsupported bit stream progression type");
                    }
                }
                int n18 = n4;
                while (n18 < n3) {
                    int n19 = n2;
                    while (n19 < n) {
                        if (n19 <= nArray2[n18]) {
                            nArrayArray[n18][n19] = n17;
                        }
                        ++n19;
                    }
                    ++n18;
                }
                ++n16;
            }
            ++n15;
        }
    }

    public void writeResLyCompPos(int n, int n2, int n3, int n4, int n5, int[][] nArray, int n6) throws IOException {
        int n7 = this.src.getNumComps();
        int[] nArray2 = new int[n7];
        BitOutputBuffer bitOutputBuffer = null;
        byte[] byArray = null;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        while (n10 < n7) {
            nArray2[n10] = this.src.getAnSubbandTree((int)n, (int)n10).resLvl;
            if (nArray2[n10] > n9) {
                n9 = nArray2[n10];
            }
            ++n10;
        }
        int n11 = n2;
        while (n11 < n3) {
            if (n11 <= n9) {
                n10 = 100000;
                int n12 = n4;
                while (n12 < n5) {
                    if (n11 < nArray[n12].length && nArray[n12][n11] < n10) {
                        n10 = nArray[n12][n11];
                    }
                    ++n12;
                }
                n12 = n10;
                while (n12 < n6) {
                    int n13 = n4;
                    while (n13 < n5) {
                        if (n11 < nArray[n13].length && n12 >= nArray[n13][n11] && n11 <= nArray2[n13]) {
                            n8 = this.numPrec[n][n13][n11].x * this.numPrec[n][n13][n11].y;
                            int n14 = 0;
                            while (n14 < n8) {
                                boolean bl = ((String)this.wp.getSOP().getTileDef(n)).equals("true");
                                boolean bl2 = ((String)this.wp.getEPH().getTileDef(n)).equals("true");
                                SubbandAn subbandAn = this.src.getAnSubbandTree(n, n13);
                                int n15 = nArray2[n13];
                                while (n15 > n11) {
                                    subbandAn = subbandAn.subb_LL;
                                    --n15;
                                }
                                float f = this.layers[n12].rdThreshold;
                                this.findTruncIndices(n12, n13, n11, n, subbandAn, f, n14);
                                bitOutputBuffer = this.pktEnc.encodePacket(n12 + 1, n13, n11, n, this.cblks[n][n13][n11], this.truncIdxs[n][n12][n13][n11], bitOutputBuffer, byArray, n14);
                                if (this.pktEnc.isPacketWritable()) {
                                    this.bsWriter.writePacketHead(bitOutputBuffer.getBuffer(), bitOutputBuffer.getLength(), false, bl, bl2);
                                    this.bsWriter.writePacketBody(this.pktEnc.getLastBodyBuf(), this.pktEnc.getLastBodyLen(), false, this.pktEnc.isROIinPkt(), this.pktEnc.getROILen());
                                }
                                ++n14;
                            }
                        }
                        ++n13;
                    }
                    ++n12;
                }
            }
            ++n11;
        }
    }

    public void writeLyResCompPos(int n, int n2, int n3, int n4, int n5, int[][] nArray, int n6) throws IOException {
        int n7;
        this.src.getNumComps();
        BitOutputBuffer bitOutputBuffer = null;
        byte[] byArray = null;
        int n8 = 0;
        int n9 = 100000;
        int n10 = n4;
        while (n10 < n5) {
            n7 = 0;
            while (n7 < nArray.length) {
                if (nArray[n10] != null && n7 < nArray[n10].length && nArray[n10][n7] < n9) {
                    n9 = nArray[n10][n7];
                }
                ++n7;
            }
            ++n10;
        }
        n10 = n9;
        while (n10 < n6) {
            n7 = n2;
            while (n7 < n3) {
                int n11 = n4;
                while (n11 < n5) {
                    int n12 = this.src.getAnSubbandTree((int)n, (int)n11).resLvl;
                    if (n7 <= n12 && n7 < nArray[n11].length && n10 >= nArray[n11][n7]) {
                        n8 = this.numPrec[n][n11][n7].x * this.numPrec[n][n11][n7].y;
                        int n13 = 0;
                        while (n13 < n8) {
                            boolean bl = ((String)this.wp.getSOP().getTileDef(n)).equals("true");
                            boolean bl2 = ((String)this.wp.getEPH().getTileDef(n)).equals("true");
                            SubbandAn subbandAn = this.src.getAnSubbandTree(n, n11);
                            int n14 = n12;
                            while (n14 > n7) {
                                subbandAn = subbandAn.subb_LL;
                                --n14;
                            }
                            float f = this.layers[n10].rdThreshold;
                            this.findTruncIndices(n10, n11, n7, n, subbandAn, f, n13);
                            bitOutputBuffer = this.pktEnc.encodePacket(n10 + 1, n11, n7, n, this.cblks[n][n11][n7], this.truncIdxs[n][n10][n11][n7], bitOutputBuffer, byArray, n13);
                            if (this.pktEnc.isPacketWritable()) {
                                this.bsWriter.writePacketHead(bitOutputBuffer.getBuffer(), bitOutputBuffer.getLength(), false, bl, bl2);
                                this.bsWriter.writePacketBody(this.pktEnc.getLastBodyBuf(), this.pktEnc.getLastBodyLen(), false, this.pktEnc.isROIinPkt(), this.pktEnc.getROILen());
                            }
                            ++n13;
                        }
                    }
                    ++n11;
                }
                ++n7;
            }
            ++n10;
        }
    }

    public void writePosCompResLy(int n, int n2, int n3, int n4, int n5, int[][] nArray, int n6) throws IOException {
        int n7;
        PrecInfo precInfo;
        int n8;
        int n9;
        this.src.getNumComps();
        BitOutputBuffer bitOutputBuffer = null;
        byte[] byArray = null;
        Point point = this.src.getNumTiles(null);
        Point point2 = this.src.getTile(null);
        int n10 = this.src.getImgULX();
        int n11 = this.src.getImgULY();
        int n12 = n10 + this.src.getImgWidth();
        int n13 = n11 + this.src.getImgHeight();
        int n14 = this.src.getTilePartULX();
        int n15 = this.src.getTilePartULY();
        int n16 = this.src.getNomTileWidth();
        int n17 = this.src.getNomTileHeight();
        int n18 = point2.x == 0 ? n10 : n14 + point2.x * n16;
        int n19 = point2.y == 0 ? n11 : n15 + point2.y * n17;
        int n20 = point2.x != point.x - 1 ? n14 + (point2.x + 1) * n16 : n12;
        int n21 = point2.y != point.y - 1 ? n15 + (point2.y + 1) * n17 : n13;
        int n22 = 0;
        int n23 = 0;
        int n24 = 0;
        int[][] nArrayArray = new int[n5][];
        int n25 = 100000;
        int n26 = n20;
        int n27 = n21;
        int n28 = n18;
        int n29 = n19;
        int n30 = n4;
        while (n30 < n5) {
            n9 = this.src.getAnSubbandTree((int)n, (int)n30).resLvl;
            nArrayArray[n30] = new int[n9 + 1];
            n8 = n2;
            while (n8 < n3) {
                if (n8 <= n9) {
                    if (n8 < nArray[n30].length && nArray[n30][n8] < n25) {
                        n25 = nArray[n30][n8];
                    }
                    int n31 = this.numPrec[n][n30][n8].y * this.numPrec[n][n30][n8].x - 1;
                    while (n31 >= 0) {
                        precInfo = this.pktEnc.getPrecInfo(n, n30, n8, n31);
                        if (precInfo.rgulx != n18) {
                            if (precInfo.rgulx < n26) {
                                n26 = precInfo.rgulx;
                            }
                            if (precInfo.rgulx > n28) {
                                n28 = precInfo.rgulx;
                            }
                        }
                        if (precInfo.rguly != n19) {
                            if (precInfo.rguly < n27) {
                                n27 = precInfo.rguly;
                            }
                            if (precInfo.rguly > n29) {
                                n29 = precInfo.rguly;
                            }
                        }
                        if (n24 == 0) {
                            n22 = precInfo.rgw;
                            n23 = precInfo.rgh;
                        } else {
                            n22 = MathUtil.gcd(n22, precInfo.rgw);
                            n23 = MathUtil.gcd(n23, precInfo.rgh);
                        }
                        ++n24;
                        --n31;
                    }
                }
                ++n8;
            }
            ++n30;
        }
        if (n24 == 0) {
            throw new Error("Image cannot have no precinct");
        }
        n30 = (n29 - n27) / n23 + 1;
        n8 = (n28 - n26) / n22 + 1;
        int n32 = n19;
        int n33 = n18;
        int n34 = 0;
        while (n34 <= n30) {
            n7 = 0;
            while (n7 <= n8) {
                int n35 = n4;
                while (n35 < n5) {
                    n9 = this.src.getAnSubbandTree((int)n, (int)n35).resLvl;
                    int n36 = n2;
                    while (n36 < n3) {
                        if (n36 <= n9 && nArrayArray[n35][n36] < this.numPrec[n][n35][n36].x * this.numPrec[n][n35][n36].y) {
                            precInfo = this.pktEnc.getPrecInfo(n, n35, n36, nArrayArray[n35][n36]);
                            if (precInfo.rgulx == n33 && precInfo.rguly == n32) {
                                int n37 = n25;
                                while (n37 < n6) {
                                    if (n36 < nArray[n35].length && n37 >= nArray[n35][n36]) {
                                        boolean bl = ((String)this.wp.getSOP().getTileDef(n)).equals("true");
                                        boolean bl2 = ((String)this.wp.getEPH().getTileDef(n)).equals("true");
                                        SubbandAn subbandAn = this.src.getAnSubbandTree(n, n35);
                                        int n38 = n9;
                                        while (n38 > n36) {
                                            subbandAn = subbandAn.subb_LL;
                                            --n38;
                                        }
                                        float f = this.layers[n37].rdThreshold;
                                        this.findTruncIndices(n37, n35, n36, n, subbandAn, f, nArrayArray[n35][n36]);
                                        bitOutputBuffer = this.pktEnc.encodePacket(n37 + 1, n35, n36, n, this.cblks[n][n35][n36], this.truncIdxs[n][n37][n35][n36], bitOutputBuffer, byArray, nArrayArray[n35][n36]);
                                        if (this.pktEnc.isPacketWritable()) {
                                            this.bsWriter.writePacketHead(bitOutputBuffer.getBuffer(), bitOutputBuffer.getLength(), false, bl, bl2);
                                            this.bsWriter.writePacketBody(this.pktEnc.getLastBodyBuf(), this.pktEnc.getLastBodyLen(), false, this.pktEnc.isROIinPkt(), this.pktEnc.getROILen());
                                        }
                                    }
                                    ++n37;
                                }
                                int[] nArray2 = nArrayArray[n35];
                                int n39 = n36;
                                nArray2[n39] = nArray2[n39] + 1;
                            }
                        }
                        ++n36;
                    }
                    ++n35;
                }
                n33 = n7 != n8 ? n26 + n7 * n22 : n18;
                ++n7;
            }
            n32 = n34 != n30 ? n27 + n34 * n23 : n19;
            ++n34;
        }
        n34 = n4;
        while (n34 < n5) {
            n9 = this.src.getAnSubbandTree((int)n, (int)n34).resLvl;
            n7 = n2;
            while (n7 < n3) {
                if (n7 <= n9 && nArrayArray[n34][n7] < this.numPrec[n][n34][n7].x * this.numPrec[n][n34][n7].y - 1) {
                    throw new Error("JJ2000 bug: One precinct at least has not been written for resolution level " + n7 + " of component " + n34 + " in tile " + n + ".");
                }
                ++n7;
            }
            ++n34;
        }
    }

    public void writeCompPosResLy(int n, int n2, int n3, int n4, int n5, int[][] nArray, int n6) throws IOException {
        int n7;
        PrecInfo precInfo;
        int n8;
        int n9;
        this.src.getNumComps();
        BitOutputBuffer bitOutputBuffer = null;
        byte[] byArray = null;
        Point point = this.src.getNumTiles(null);
        Point point2 = this.src.getTile(null);
        int n10 = this.src.getImgULX();
        int n11 = this.src.getImgULY();
        int n12 = n10 + this.src.getImgWidth();
        int n13 = n11 + this.src.getImgHeight();
        int n14 = this.src.getTilePartULX();
        int n15 = this.src.getTilePartULY();
        int n16 = this.src.getNomTileWidth();
        int n17 = this.src.getNomTileHeight();
        int n18 = point2.x == 0 ? n10 : n14 + point2.x * n16;
        int n19 = point2.y == 0 ? n11 : n15 + point2.y * n17;
        int n20 = point2.x != point.x - 1 ? n14 + (point2.x + 1) * n16 : n12;
        int n21 = point2.y != point.y - 1 ? n15 + (point2.y + 1) * n17 : n13;
        int n22 = 0;
        int n23 = 0;
        int n24 = 0;
        int[][] nArrayArray = new int[n5][];
        int n25 = 100000;
        int n26 = n20;
        int n27 = n21;
        int n28 = n18;
        int n29 = n19;
        int n30 = n4;
        while (n30 < n5) {
            n9 = this.src.getAnSubbandTree((int)n, (int)n30).resLvl;
            n8 = n2;
            while (n8 < n3) {
                if (n8 <= n9) {
                    nArrayArray[n30] = new int[n9 + 1];
                    if (n8 < nArray[n30].length && nArray[n30][n8] < n25) {
                        n25 = nArray[n30][n8];
                    }
                    int n31 = this.numPrec[n][n30][n8].y * this.numPrec[n][n30][n8].x - 1;
                    while (n31 >= 0) {
                        precInfo = this.pktEnc.getPrecInfo(n, n30, n8, n31);
                        if (precInfo.rgulx != n18) {
                            if (precInfo.rgulx < n26) {
                                n26 = precInfo.rgulx;
                            }
                            if (precInfo.rgulx > n28) {
                                n28 = precInfo.rgulx;
                            }
                        }
                        if (precInfo.rguly != n19) {
                            if (precInfo.rguly < n27) {
                                n27 = precInfo.rguly;
                            }
                            if (precInfo.rguly > n29) {
                                n29 = precInfo.rguly;
                            }
                        }
                        if (n24 == 0) {
                            n22 = precInfo.rgw;
                            n23 = precInfo.rgh;
                        } else {
                            n22 = MathUtil.gcd(n22, precInfo.rgw);
                            n23 = MathUtil.gcd(n23, precInfo.rgh);
                        }
                        ++n24;
                        --n31;
                    }
                }
                ++n8;
            }
            ++n30;
        }
        if (n24 == 0) {
            throw new Error("Image cannot have no precinct");
        }
        n30 = (n29 - n27) / n23 + 1;
        n8 = (n28 - n26) / n22 + 1;
        int n32 = n4;
        while (n32 < n5) {
            int n33 = n19;
            int n34 = n18;
            n9 = this.src.getAnSubbandTree((int)n, (int)n32).resLvl;
            n7 = 0;
            while (n7 <= n30) {
                int n35 = 0;
                while (n35 <= n8) {
                    int n36 = n2;
                    while (n36 < n3) {
                        if (n36 <= n9 && nArrayArray[n32][n36] < this.numPrec[n][n32][n36].x * this.numPrec[n][n32][n36].y) {
                            precInfo = this.pktEnc.getPrecInfo(n, n32, n36, nArrayArray[n32][n36]);
                            if (precInfo.rgulx == n34 && precInfo.rguly == n33) {
                                int n37 = n25;
                                while (n37 < n6) {
                                    if (n36 < nArray[n32].length && n37 >= nArray[n32][n36]) {
                                        boolean bl = ((String)this.wp.getSOP().getTileDef(n)).equals("true");
                                        boolean bl2 = ((String)this.wp.getEPH().getTileDef(n)).equals("true");
                                        SubbandAn subbandAn = this.src.getAnSubbandTree(n, n32);
                                        int n38 = n9;
                                        while (n38 > n36) {
                                            subbandAn = subbandAn.subb_LL;
                                            --n38;
                                        }
                                        float f = this.layers[n37].rdThreshold;
                                        this.findTruncIndices(n37, n32, n36, n, subbandAn, f, nArrayArray[n32][n36]);
                                        bitOutputBuffer = this.pktEnc.encodePacket(n37 + 1, n32, n36, n, this.cblks[n][n32][n36], this.truncIdxs[n][n37][n32][n36], bitOutputBuffer, byArray, nArrayArray[n32][n36]);
                                        if (this.pktEnc.isPacketWritable()) {
                                            this.bsWriter.writePacketHead(bitOutputBuffer.getBuffer(), bitOutputBuffer.getLength(), false, bl, bl2);
                                            this.bsWriter.writePacketBody(this.pktEnc.getLastBodyBuf(), this.pktEnc.getLastBodyLen(), false, this.pktEnc.isROIinPkt(), this.pktEnc.getROILen());
                                        }
                                    }
                                    ++n37;
                                }
                                int[] nArray2 = nArrayArray[n32];
                                int n39 = n36;
                                nArray2[n39] = nArray2[n39] + 1;
                            }
                        }
                        ++n36;
                    }
                    n34 = n35 != n8 ? n26 + n35 * n22 : n18;
                    ++n35;
                }
                n33 = n7 != n30 ? n27 + n7 * n23 : n19;
                ++n7;
            }
            ++n32;
        }
        n32 = n4;
        while (n32 < n5) {
            n9 = this.src.getAnSubbandTree((int)n, (int)n32).resLvl;
            n7 = n2;
            while (n7 < n3) {
                if (n7 <= n9 && nArrayArray[n32][n7] < this.numPrec[n][n32][n7].x * this.numPrec[n][n32][n7].y - 1) {
                    throw new Error("JJ2000 bug: One precinct at least has not been written for resolution level " + n7 + " of component " + n32 + " in tile " + n + ".");
                }
                ++n7;
            }
            ++n32;
        }
    }

    public void writeResPosCompLy(int n, int n2, int n3, int n4, int n5, int[][] nArray, int n6) throws IOException {
        int n7;
        PrecInfo precInfo;
        int n8;
        int n9;
        this.src.getNumComps();
        BitOutputBuffer bitOutputBuffer = null;
        byte[] byArray = null;
        Point point = this.src.getNumTiles(null);
        Point point2 = this.src.getTile(null);
        int n10 = this.src.getImgULX();
        int n11 = this.src.getImgULY();
        int n12 = n10 + this.src.getImgWidth();
        int n13 = n11 + this.src.getImgHeight();
        int n14 = this.src.getTilePartULX();
        int n15 = this.src.getTilePartULY();
        int n16 = this.src.getNomTileWidth();
        int n17 = this.src.getNomTileHeight();
        int n18 = point2.x == 0 ? n10 : n14 + point2.x * n16;
        int n19 = point2.y == 0 ? n11 : n15 + point2.y * n17;
        int n20 = point2.x != point.x - 1 ? n14 + (point2.x + 1) * n16 : n12;
        int n21 = point2.y != point.y - 1 ? n15 + (point2.y + 1) * n17 : n13;
        int n22 = 0;
        int n23 = 0;
        int n24 = 0;
        int[][] nArrayArray = new int[n5][];
        int n25 = 100000;
        int n26 = n20;
        int n27 = n21;
        int n28 = n18;
        int n29 = n19;
        int n30 = n4;
        while (n30 < n5) {
            n9 = this.src.getAnSubbandTree((int)n, (int)n30).resLvl;
            nArrayArray[n30] = new int[n9 + 1];
            n8 = n2;
            while (n8 < n3) {
                if (n8 <= n9) {
                    if (n8 < nArray[n30].length && nArray[n30][n8] < n25) {
                        n25 = nArray[n30][n8];
                    }
                    int n31 = this.numPrec[n][n30][n8].y * this.numPrec[n][n30][n8].x - 1;
                    while (n31 >= 0) {
                        precInfo = this.pktEnc.getPrecInfo(n, n30, n8, n31);
                        if (precInfo.rgulx != n18) {
                            if (precInfo.rgulx < n26) {
                                n26 = precInfo.rgulx;
                            }
                            if (precInfo.rgulx > n28) {
                                n28 = precInfo.rgulx;
                            }
                        }
                        if (precInfo.rguly != n19) {
                            if (precInfo.rguly < n27) {
                                n27 = precInfo.rguly;
                            }
                            if (precInfo.rguly > n29) {
                                n29 = precInfo.rguly;
                            }
                        }
                        if (n24 == 0) {
                            n22 = precInfo.rgw;
                            n23 = precInfo.rgh;
                        } else {
                            n22 = MathUtil.gcd(n22, precInfo.rgw);
                            n23 = MathUtil.gcd(n23, precInfo.rgh);
                        }
                        ++n24;
                        --n31;
                    }
                }
                ++n8;
            }
            ++n30;
        }
        if (n24 == 0) {
            throw new Error("Image cannot have no precinct");
        }
        n30 = (n29 - n27) / n23 + 1;
        n8 = (n28 - n26) / n22 + 1;
        int n32 = n2;
        while (n32 < n3) {
            int n33 = n19;
            int n34 = n18;
            n7 = 0;
            while (n7 <= n30) {
                int n35 = 0;
                while (n35 <= n8) {
                    int n36 = n4;
                    while (n36 < n5) {
                        n9 = this.src.getAnSubbandTree((int)n, (int)n36).resLvl;
                        if (n32 <= n9 && nArrayArray[n36][n32] < this.numPrec[n][n36][n32].x * this.numPrec[n][n36][n32].y) {
                            precInfo = this.pktEnc.getPrecInfo(n, n36, n32, nArrayArray[n36][n32]);
                            if (precInfo.rgulx == n34 && precInfo.rguly == n33) {
                                int n37 = n25;
                                while (n37 < n6) {
                                    if (n32 < nArray[n36].length && n37 >= nArray[n36][n32]) {
                                        boolean bl = ((String)this.wp.getSOP().getTileDef(n)).equals("true");
                                        boolean bl2 = ((String)this.wp.getEPH().getTileDef(n)).equals("true");
                                        SubbandAn subbandAn = this.src.getAnSubbandTree(n, n36);
                                        int n38 = n9;
                                        while (n38 > n32) {
                                            subbandAn = subbandAn.subb_LL;
                                            --n38;
                                        }
                                        float f = this.layers[n37].rdThreshold;
                                        this.findTruncIndices(n37, n36, n32, n, subbandAn, f, nArrayArray[n36][n32]);
                                        bitOutputBuffer = this.pktEnc.encodePacket(n37 + 1, n36, n32, n, this.cblks[n][n36][n32], this.truncIdxs[n][n37][n36][n32], bitOutputBuffer, byArray, nArrayArray[n36][n32]);
                                        if (this.pktEnc.isPacketWritable()) {
                                            this.bsWriter.writePacketHead(bitOutputBuffer.getBuffer(), bitOutputBuffer.getLength(), false, bl, bl2);
                                            this.bsWriter.writePacketBody(this.pktEnc.getLastBodyBuf(), this.pktEnc.getLastBodyLen(), false, this.pktEnc.isROIinPkt(), this.pktEnc.getROILen());
                                        }
                                    }
                                    ++n37;
                                }
                                int[] nArray2 = nArrayArray[n36];
                                int n39 = n32;
                                nArray2[n39] = nArray2[n39] + 1;
                            }
                        }
                        ++n36;
                    }
                    n34 = n35 != n8 ? n26 + n35 * n22 : n18;
                    ++n35;
                }
                n33 = n7 != n30 ? n27 + n7 * n23 : n19;
                ++n7;
            }
            ++n32;
        }
        n32 = n4;
        while (n32 < n5) {
            n9 = this.src.getAnSubbandTree((int)n, (int)n32).resLvl;
            n7 = n2;
            while (n7 < n3) {
                if (n7 <= n9 && nArrayArray[n32][n7] < this.numPrec[n][n32][n7].x * this.numPrec[n][n32][n7].y - 1) {
                    throw new Error("JJ2000 bug: One precinct at least has not been written for resolution level " + n7 + " of component " + n32 + " in tile " + n + ".");
                }
                ++n7;
            }
            ++n32;
        }
    }

    private float optimizeBitstreamLayer(int n, float f, int n2, int n3) throws IOException {
        float f2;
        this.pktEnc.save();
        int n4 = this.src.getNumTiles();
        int n5 = this.src.getNumComps();
        BitOutputBuffer bitOutputBuffer = null;
        byte[] byArray = null;
        int n6 = 63;
        while (n6 > 0) {
            if (this.RDSlopesRates[n6] >= n2) break;
            --n6;
        }
        float f3 = EBCOTRateAllocator.getSlopeFromSIndex(n6);
        if (f3 >= f) {
            f3 = EBCOTRateAllocator.getSlopeFromSIndex(--n6);
        }
        if (n6 <= 0) {
            f3 = 0.0f;
        }
        if ((f2 = (f + f3) / 2.0f) <= f3) {
            f2 = f;
        }
        do {
            int n7 = n3;
            this.src.setTile(0, 0);
            int n8 = 0;
            while (n8 < n4) {
                int n9 = 0;
                while (n9 < n5) {
                    boolean bl = ((String)this.wp.getSOP().getTileDef(n8)).equalsIgnoreCase("true");
                    boolean bl2 = ((String)this.wp.getEPH().getTileDef(n8)).equalsIgnoreCase("true");
                    SubbandAn subbandAn = this.src.getAnSubbandTree(n8, n9);
                    int n10 = subbandAn.resLvl + 1;
                    subbandAn = (SubbandAn)subbandAn.getSubbandByIdx(0, 0);
                    int n11 = 0;
                    while (n11 < n10) {
                        int n12 = this.numPrec[n8][n9][n11].x * this.numPrec[n8][n9][n11].y;
                        int n13 = 0;
                        while (n13 < n12) {
                            this.findTruncIndices(n, n9, n11, n8, subbandAn, f2, n13);
                            bitOutputBuffer = this.pktEnc.encodePacket(n + 1, n9, n11, n8, this.cblks[n8][n9][n11], this.truncIdxs[n8][n][n9][n11], bitOutputBuffer, byArray, n13);
                            if (this.pktEnc.isPacketWritable()) {
                                byArray = this.pktEnc.getLastBodyBuf();
                                n7 += this.bsWriter.writePacketHead(bitOutputBuffer.getBuffer(), bitOutputBuffer.getLength(), true, bl, bl2);
                                n7 += this.bsWriter.writePacketBody(byArray, this.pktEnc.getLastBodyLen(), true, this.pktEnc.isROIinPkt(), this.pktEnc.getROILen());
                            }
                            ++n13;
                        }
                        subbandAn = subbandAn.parent;
                        ++n11;
                    }
                    ++n9;
                }
                ++n8;
            }
            if (n7 > n2) {
                f3 = f2;
            } else {
                f = f2;
            }
            f2 = (f + f3) / 2.0f;
            if (f2 <= f3) {
                f2 = f;
            }
            this.pktEnc.restore();
        } while (f2 < f * 0.9999f && f2 < f - 1.0E-10f);
        f2 = f2 <= 1.0E-10f ? 0.0f : f;
        return f2;
    }

    private float estimateLayerThreshold(int n, EBCOTLayer eBCOTLayer) {
        float f;
        float f2;
        float f3;
        float f4 = eBCOTLayer.rdThreshold;
        if (f4 > this.maxSlope) {
            f4 = this.maxSlope;
        }
        if (f4 < 1.0E-10f) {
            return 0.0f;
        }
        int n2 = EBCOTRateAllocator.getLimitedSIndexFromSlope(f4);
        if (n2 >= 63) {
            n2 = 62;
        }
        if (this.RDSlopesRates[n2 + 1] == 0) {
            f3 = (float)Math.log((this.RDSlopesRates[n2] << 1) + 1);
            f2 = (float)Math.log(this.RDSlopesRates[n2] + 1);
            f = (float)Math.log(eBCOTLayer.actualBytes + this.RDSlopesRates[n2] + 1);
        } else {
            f3 = (float)Math.log(this.RDSlopesRates[n2]);
            f2 = (float)Math.log(this.RDSlopesRates[n2 + 1]);
            f = (float)Math.log(eBCOTLayer.actualBytes);
        }
        float f5 = (float)Math.log(EBCOTRateAllocator.getSlopeFromSIndex(n2));
        float f6 = (float)Math.log(EBCOTRateAllocator.getSlopeFromSIndex(n2 + 1));
        float f7 = (float)Math.log(f4);
        float f8 = f3 + (f7 - f5) * (f3 - f2) / (f5 - f6);
        float f9 = f - f8;
        if (f9 < 0.0f) {
            f9 = 0.0f;
        }
        int n3 = (int)((float)n / (float)Math.exp(f9));
        n2 = 63;
        while (n2 >= 0) {
            if (this.RDSlopesRates[n2] >= n3) break;
            --n2;
        }
        if (++n2 >= 64) {
            n2 = 63;
        }
        if (n2 <= 0) {
            n2 = 1;
        }
        if (this.RDSlopesRates[n2] == 0) {
            f3 = (float)Math.log(this.RDSlopesRates[n2 - 1] + 1);
            f2 = (float)Math.log((this.RDSlopesRates[n2 - 1] << 1) + 1);
            f8 = (float)Math.log(n3 + this.RDSlopesRates[n2 - 1] + 1);
        } else {
            f3 = (float)Math.log(this.RDSlopesRates[n2]);
            f2 = (float)Math.log(this.RDSlopesRates[n2 - 1]);
            f8 = (float)Math.log(n3);
        }
        f5 = (float)Math.log(EBCOTRateAllocator.getSlopeFromSIndex(n2));
        f6 = (float)Math.log(EBCOTRateAllocator.getSlopeFromSIndex(n2 - 1));
        f7 = f5 + (f8 - f3) * (f5 - f6) / (f3 - f2);
        float f10 = (float)Math.exp(f7);
        if (f10 > f4) {
            f10 = f4;
        }
        if (f10 < 1.0E-10f) {
            f10 = 0.0f;
        }
        return f10;
    }

    private void findTruncIndices(int n, int n2, int n3, int n4, SubbandAn subbandAn, float f, int n5) {
        PrecInfo precInfo = this.pktEnc.getPrecInfo(n4, n2, n3, n5);
        SubbandAn subbandAn2 = subbandAn;
        while (subbandAn2.subb_HH != null) {
            subbandAn2 = subbandAn2.subb_HH;
        }
        int n6 = n3 == 0 ? 0 : 1;
        int n7 = n3 == 0 ? 1 : 4;
        subbandAn2 = (SubbandAn)subbandAn.getSubbandByIdx(n3, n6);
        int n8 = n6;
        while (n8 < n7) {
            int n9 = precInfo.cblk[n8] != null ? precInfo.cblk[n8].length : 0;
            int n10 = 0;
            while (n10 < n9) {
                int n11 = precInfo.cblk[n8][n10] != null ? precInfo.cblk[n8][n10].length : 0;
                int n12 = 0;
                while (n12 < n11) {
                    Point point = precInfo.cblk[n8][n10][n12].idx;
                    int n13 = point.x + point.y * subbandAn2.numCb.x;
                    CBlkRateDistStats cBlkRateDistStats = this.cblks[n4][n2][n3][n8][n13];
                    int n14 = 0;
                    while (n14 < cBlkRateDistStats.nVldTrunc) {
                        if (cBlkRateDistStats.truncSlopes[n14] < f) break;
                        ++n14;
                    }
                    this.truncIdxs[n4][n][n2][n3][n8][n13] = n14 - 1;
                    ++n12;
                }
                ++n10;
            }
            subbandAn2 = (SubbandAn)subbandAn2.nextSubband();
            ++n8;
        }
    }

    private static int getLimitedSIndexFromSlope(float f) {
        int n = (int)Math.floor(Math.log(f) / LOG2) + 24;
        if (n < 0) {
            return 0;
        }
        if (n >= 64) {
            return 63;
        }
        return n;
    }

    private static float getSlopeFromSIndex(int n) {
        return (float)Math.pow(2.0, n - 24);
    }
}

