/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.codestream.writer;

import jj2000.j2k.codestream.writer.BitOutputBuffer;
import jj2000.j2k.util.ArrayUtil;

public class TagTreeEncoder {
    protected int w;
    protected int h;
    protected int lvls;
    protected int[][] treeV;
    protected int[][] treeS;
    protected int[][] treeVbak;
    protected int[][] treeSbak;
    protected boolean saved;

    public TagTreeEncoder(int n, int n2) {
        if (n2 < 0 || n < 0) {
            throw new IllegalArgumentException();
        }
        this.init(n2, n);
        int n3 = this.treeV.length - 1;
        while (n3 >= 0) {
            ArrayUtil.intArraySet(this.treeV[n3], Integer.MAX_VALUE);
            --n3;
        }
    }

    public TagTreeEncoder(int n, int n2, int[] nArray) {
        if (n2 < 0 || n < 0 || nArray.length < n2 * n) {
            throw new IllegalArgumentException();
        }
        this.init(n2, n);
        int n3 = n2 * n - 1;
        while (n3 >= 0) {
            this.treeV[0][n3] = nArray[n3];
            --n3;
        }
        this.recalcTreeV();
    }

    public final int getWidth() {
        return this.w;
    }

    public final int getHeight() {
        return this.h;
    }

    private void init(int n, int n2) {
        this.w = n;
        this.h = n2;
        if (n == 0 || n2 == 0) {
            this.lvls = 0;
        } else {
            this.lvls = 1;
            while (n2 != 1 || n != 1) {
                n = n + 1 >> 1;
                n2 = n2 + 1 >> 1;
                ++this.lvls;
            }
        }
        this.treeV = new int[this.lvls][];
        this.treeS = new int[this.lvls][];
        n = this.w;
        n2 = this.h;
        int n3 = 0;
        while (n3 < this.lvls) {
            this.treeV[n3] = new int[n2 * n];
            this.treeS[n3] = new int[n2 * n];
            n = n + 1 >> 1;
            n2 = n2 + 1 >> 1;
            ++n3;
        }
    }

    private void recalcTreeV() {
        int n = 0;
        while (n < this.lvls - 1) {
            int n2;
            int n3;
            int n4 = this.w + (1 << n) - 1 >> n;
            int n5 = this.h + (1 << n) - 1 >> n;
            int n6 = (n5 >> 1 << 1) - 2;
            while (n6 >= 0) {
                n3 = (n4 >> 1 << 1) - 2;
                while (n3 >= 0) {
                    n2 = n6 * n4 + n3;
                    int n7 = this.treeV[n][n2] < this.treeV[n][n2 + 1] ? this.treeV[n][n2] : this.treeV[n][n2 + 1];
                    int n8 = this.treeV[n][n2 + n4] < this.treeV[n][n2 + n4 + 1] ? this.treeV[n][n2 + n4] : this.treeV[n][n2 + n4 + 1];
                    this.treeV[n + 1][(n6 >> 1) * (n4 + 1 >> 1) + (n3 >> 1)] = n7 < n8 ? n7 : n8;
                    n3 -= 2;
                }
                if (n4 % 2 != 0) {
                    n3 = n4 >> 1 << 1;
                    n2 = n6 * n4 + n3;
                    this.treeV[n + 1][(n6 >> 1) * (n4 + 1 >> 1) + (n3 >> 1)] = this.treeV[n][n2] < this.treeV[n][n2 + n4] ? this.treeV[n][n2] : this.treeV[n][n2 + n4];
                }
                n6 -= 2;
            }
            if (n5 % 2 != 0) {
                n6 = n5 >> 1 << 1;
                n3 = (n4 >> 1 << 1) - 2;
                while (n3 >= 0) {
                    n2 = n6 * n4 + n3;
                    this.treeV[n + 1][(n6 >> 1) * (n4 + 1 >> 1) + (n3 >> 1)] = this.treeV[n][n2] < this.treeV[n][n2 + 1] ? this.treeV[n][n2] : this.treeV[n][n2 + 1];
                    n3 -= 2;
                }
                if (n4 % 2 != 0) {
                    n3 = n4 >> 1 << 1;
                    this.treeV[n + 1][(n6 >> 1) * (n4 + 1 >> 1) + (n3 >> 1)] = this.treeV[n][n6 * n4 + n3];
                }
            }
            ++n;
        }
    }

    public void setValue(int n, int n2, int n3) {
        if (this.lvls == 0 || n2 < 0 || n2 >= this.w || n3 < this.treeS[this.lvls - 1][0] || this.treeV[0][n * this.w + n2] < this.treeS[this.lvls - 1][0]) {
            throw new IllegalArgumentException();
        }
        this.treeV[0][n * this.w + n2] = n3;
        int n4 = 1;
        while (n4 < this.lvls) {
            int n5 = (n >> n4) * (this.w + (1 << n4) - 1 >> n4) + (n2 >> n4);
            if (n3 >= this.treeV[n4][n5]) break;
            this.treeV[n4][n5] = n3;
            ++n4;
        }
    }

    public void setValues(int[] nArray) {
        if (this.lvls == 0) {
            throw new IllegalArgumentException();
        }
        int n = this.treeS[this.lvls - 1][0];
        int n2 = this.w * this.h - 1;
        while (n2 >= 0) {
            if ((this.treeV[0][n2] < n || nArray[n2] < n) && this.treeV[0][n2] != nArray[n2]) {
                throw new IllegalArgumentException();
            }
            this.treeV[0][n2] = nArray[n2];
            --n2;
        }
        this.recalcTreeV();
    }

    public void encode(int n, int n2, int n3, BitOutputBuffer bitOutputBuffer) {
        if (n >= this.h || n2 >= this.w || n3 < 0) {
            throw new IllegalArgumentException();
        }
        int n4 = this.lvls - 1;
        int n5 = this.treeS[n4][0];
        while (true) {
            int n6;
            int n7;
            if ((n7 = this.treeS[n4][n6 = (n >> n4) * (this.w + (1 << n4) - 1 >> n4) + (n2 >> n4)]) < n5) {
                n7 = n5;
            }
            while (n3 > n7) {
                if (this.treeV[n4][n6] > n7) {
                    bitOutputBuffer.writeBit(0);
                } else if (this.treeV[n4][n6] == n7) {
                    bitOutputBuffer.writeBit(1);
                } else {
                    n7 = n3;
                    break;
                }
                ++n7;
            }
            this.treeS[n4][n6] = n7;
            if (n4 <= 0) break;
            n5 = n7 < this.treeV[n4][n6] ? n7 : this.treeV[n4][n6];
            --n4;
        }
    }

    public void save() {
        int n;
        if (this.treeVbak == null) {
            this.treeVbak = new int[this.lvls][];
            this.treeSbak = new int[this.lvls][];
            n = this.lvls - 1;
            while (n >= 0) {
                this.treeVbak[n] = new int[this.treeV[n].length];
                this.treeSbak[n] = new int[this.treeV[n].length];
                --n;
            }
        }
        n = this.treeV.length - 1;
        while (n >= 0) {
            System.arraycopy(this.treeV[n], 0, this.treeVbak[n], 0, this.treeV[n].length);
            System.arraycopy(this.treeS[n], 0, this.treeSbak[n], 0, this.treeS[n].length);
            --n;
        }
        this.saved = true;
    }

    public void restore() {
        if (!this.saved) {
            throw new IllegalArgumentException();
        }
        int n = this.lvls - 1;
        while (n >= 0) {
            System.arraycopy(this.treeVbak[n], 0, this.treeV[n], 0, this.treeV[n].length);
            System.arraycopy(this.treeSbak[n], 0, this.treeS[n], 0, this.treeS[n].length);
            --n;
        }
    }

    public void reset() {
        int n = this.lvls - 1;
        while (n >= 0) {
            ArrayUtil.intArraySet(this.treeV[n], Integer.MAX_VALUE);
            ArrayUtil.intArraySet(this.treeS[n], 0);
            --n;
        }
        this.saved = false;
    }

    public void reset(int[] nArray) {
        int n = this.w * this.h - 1;
        while (n >= 0) {
            this.treeV[0][n] = nArray[n];
            --n;
        }
        this.recalcTreeV();
        n = this.lvls - 1;
        while (n >= 0) {
            ArrayUtil.intArraySet(this.treeS[n], 0);
            --n;
        }
        this.saved = false;
    }
}

