/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.codestream.writer;

import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageWriteParamJava;
import java.awt.Point;
import jj2000.j2k.codestream.CBlkCoordInfo;
import jj2000.j2k.codestream.PrecInfo;
import jj2000.j2k.codestream.writer.BitOutputBuffer;
import jj2000.j2k.codestream.writer.TagTreeEncoder;
import jj2000.j2k.entropy.encoder.CBlkRateDistStats;
import jj2000.j2k.entropy.encoder.CodedCBlkDataSrcEnc;
import jj2000.j2k.util.ArrayUtil;
import jj2000.j2k.util.MathUtil;
import jj2000.j2k.wavelet.analysis.SubbandAn;

public class PktEncoder {
    public static final char OPT_PREFIX = 'P';
    private static final String[][] pinfo = new String[][]{{"Psop", "[<tile idx>] true|false[ [<tile idx>] true|false ...]", "Specifies whether start of packet (SOP) markers should be used. 'true' enables, 'false' disables it.", "false"}, {"Peph", "[<tile idx>] true|false[ [<tile  idx>] true|false ...]", "Specifies whether end of packet header (EPH) markers should be  used. 'true' enables, 'false' disables it.", "false"}};
    private static final int INIT_LBLOCK = 3;
    private CodedCBlkDataSrcEnc infoSrc;
    J2KImageWriteParamJava wp;
    private TagTreeEncoder[][][][][] ttIncl;
    private TagTreeEncoder[][][][][] ttMaxBP;
    private int[][][][][] lblock;
    private int[][][][][] prevtIdxs;
    private int[][][][][] bak_lblock;
    private int[][][][][] bak_prevtIdxs;
    private byte[] lbbuf;
    private int lblen;
    private boolean saved;
    private boolean roiInPkt = false;
    private int roiLen = 0;
    private PrecInfo[][][][] ppinfo;
    private boolean packetWritable;

    public PktEncoder(CodedCBlkDataSrcEnc codedCBlkDataSrcEnc, J2KImageWriteParamJava j2KImageWriteParamJava, Point[][][] pointArray) {
        this.infoSrc = codedCBlkDataSrcEnc;
        this.wp = j2KImageWriteParamJava;
        int n = codedCBlkDataSrcEnc.getNumComps();
        int n2 = codedCBlkDataSrcEnc.getNumTiles();
        this.ttIncl = new TagTreeEncoder[n2][n][][][];
        this.ttMaxBP = new TagTreeEncoder[n2][n][][][];
        this.lblock = new int[n2][n][][][];
        this.prevtIdxs = new int[n2][n][][][];
        this.ppinfo = new PrecInfo[n2][n][][];
        codedCBlkDataSrcEnc.setTile(0, 0);
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < n) {
                SubbandAn subbandAn = codedCBlkDataSrcEnc.getAnSubbandTree(n3, n4);
                int n5 = subbandAn.resLvl;
                this.lblock[n3][n4] = new int[n5 + 1][][];
                this.ttIncl[n3][n4] = new TagTreeEncoder[n5 + 1][][];
                this.ttMaxBP[n3][n4] = new TagTreeEncoder[n5 + 1][][];
                this.prevtIdxs[n3][n4] = new int[n5 + 1][][];
                this.ppinfo[n3][n4] = new PrecInfo[n5 + 1][];
                int n6 = 0;
                while (n6 <= n5) {
                    int n7 = n6 == 0 ? 0 : 1;
                    int n8 = n6 == 0 ? 1 : 4;
                    int n9 = pointArray[n3][n4][n6].x * pointArray[n3][n4][n6].y;
                    this.ttIncl[n3][n4][n6] = new TagTreeEncoder[n9][n8];
                    this.ttMaxBP[n3][n4][n6] = new TagTreeEncoder[n9][n8];
                    this.prevtIdxs[n3][n4][n6] = new int[n8][];
                    this.lblock[n3][n4][n6] = new int[n8][];
                    this.ppinfo[n3][n4][n6] = new PrecInfo[n9];
                    this.fillPrecInfo(n3, n4, n6);
                    int n10 = n7;
                    while (n10 < n8) {
                        SubbandAn subbandAn2 = (SubbandAn)subbandAn.getSubbandByIdx(n6, n10);
                        int n11 = subbandAn2.numCb.x * subbandAn2.numCb.y;
                        this.lblock[n3][n4][n6][n10] = new int[n11];
                        ArrayUtil.intArraySet(this.lblock[n3][n4][n6][n10], 3);
                        this.prevtIdxs[n3][n4][n6][n10] = new int[n11];
                        ArrayUtil.intArraySet(this.prevtIdxs[n3][n4][n6][n10], -1);
                        ++n10;
                    }
                    ++n6;
                }
                ++n4;
            }
            if (n3 != n2 - 1) {
                codedCBlkDataSrcEnc.nextTile();
            }
            ++n3;
        }
    }

    private void fillPrecInfo(int n, int n2, int n3) {
        if (this.ppinfo[n][n2][n3].length == 0) {
            return;
        }
        Point point = this.infoSrc.getTile(null);
        Point point2 = this.infoSrc.getNumTiles(null);
        int n4 = this.infoSrc.getImgULX();
        int n5 = this.infoSrc.getImgULY();
        int n6 = n4 + this.infoSrc.getImgWidth();
        int n7 = n5 + this.infoSrc.getImgHeight();
        int n8 = this.infoSrc.getTilePartULX();
        int n9 = this.infoSrc.getTilePartULY();
        int n10 = this.infoSrc.getNomTileWidth();
        int n11 = this.infoSrc.getNomTileHeight();
        int n12 = point.x == 0 ? n4 : n8 + point.x * n10;
        int n13 = point.y == 0 ? n5 : n9 + point.y * n11;
        int n14 = point.x != point2.x - 1 ? n8 + (point.x + 1) * n10 : n6;
        int n15 = point.y != point2.y - 1 ? n9 + (point.y + 1) * n11 : n7;
        int n16 = this.infoSrc.getCompSubsX(n2);
        int n17 = this.infoSrc.getCompSubsY(n2);
        int n18 = (int)Math.ceil((double)n12 / (double)n16);
        int n19 = (int)Math.ceil((double)n13 / (double)n17);
        int n20 = (int)Math.ceil((double)n14 / (double)n16);
        int n21 = (int)Math.ceil((double)n15 / (double)n17);
        int n22 = this.infoSrc.getAnSubbandTree((int)n, (int)n2).resLvl - n3;
        int n23 = (int)Math.ceil((double)n18 / (double)(1 << n22));
        int n24 = (int)Math.ceil((double)n19 / (double)(1 << n22));
        int n25 = (int)Math.ceil((double)n20 / (double)(1 << n22));
        int n26 = (int)Math.ceil((double)n21 / (double)(1 << n22));
        int n27 = this.infoSrc.getCbULX();
        int n28 = this.infoSrc.getCbULY();
        double d = this.wp.getPrecinctPartition().getPPX(n, n2, n3);
        double d2 = this.wp.getPrecinctPartition().getPPY(n, n2, n3);
        int n29 = (int)(d / 2.0);
        int n30 = (int)(d2 / 2.0);
        int cfr_ignored_0 = this.ppinfo[n][n2][n3].length;
        int n31 = 0;
        int n32 = (int)Math.floor((double)(n24 - n28) / d2);
        int n33 = (int)Math.floor((double)(n26 - 1 - n28) / d2);
        int n34 = (int)Math.floor((double)(n23 - n27) / d);
        int n35 = (int)Math.floor((double)(n25 - 1 - n27) / d);
        SubbandAn subbandAn = this.infoSrc.getAnSubbandTree(n, n2);
        SubbandAn subbandAn2 = null;
        int n36 = (int)d << n22;
        int n37 = (int)d2 << n22;
        int n38 = n32;
        while (n38 <= n33) {
            int n39 = n34;
            while (n39 <= n35) {
                CBlkCoordInfo cBlkCoordInfo;
                int n40;
                int n41;
                int n42;
                int n43;
                int n44;
                int n45;
                int n46;
                int n47;
                int n48;
                int n49;
                int n50;
                int n51;
                int n52;
                int n53;
                int n54;
                int n55;
                int n56;
                int n57;
                int n58;
                int n59;
                int n60 = n39 == n34 && (n23 - n27) % (n16 * (int)d) != 0 ? n12 : n27 + n39 * n16 * ((int)d << n22);
                int n61 = n38 == n32 && (n24 - n28) % (n17 * (int)d2) != 0 ? n13 : n28 + n38 * n17 * ((int)d2 << n22);
                this.ppinfo[n][n2][n3][n31] = new PrecInfo(n3, (int)((double)n27 + (double)n39 * d), (int)((double)n28 + (double)n38 * d2), (int)d, (int)d2, n60, n61, n36, n37);
                if (n3 == 0) {
                    n59 = n27;
                    n58 = n28;
                    n57 = n59 + n39 * (int)d;
                    n56 = n57 + (int)d;
                    n55 = n58 + n38 * (int)d2;
                    n54 = n55 + (int)d2;
                    subbandAn2 = (SubbandAn)subbandAn.getSubbandByIdx(0, 0);
                    n53 = n57 < subbandAn2.ulcx ? subbandAn2.ulcx : n57;
                    n52 = n56 > subbandAn2.ulcx + subbandAn2.w ? subbandAn2.ulcx + subbandAn2.w : n56;
                    n51 = n55 < subbandAn2.ulcy ? subbandAn2.ulcy : n55;
                    n50 = n54 > subbandAn2.ulcy + subbandAn2.h ? subbandAn2.ulcy + subbandAn2.h : n54;
                    n49 = subbandAn2.nomCBlkW;
                    n48 = subbandAn2.nomCBlkH;
                    n47 = (int)Math.floor((double)(subbandAn2.ulcy - n58) / (double)n48);
                    n46 = (int)Math.floor((double)(n51 - n58) / (double)n48);
                    n45 = (int)Math.floor((double)(n50 - 1 - n58) / (double)n48);
                    n44 = (int)Math.floor((double)(subbandAn2.ulcx - n59) / (double)n49);
                    n43 = (int)Math.floor((double)(n53 - n59) / (double)n49);
                    n42 = (int)Math.floor((double)(n52 - 1 - n59) / (double)n49);
                    if (n52 - n53 <= 0 || n50 - n51 <= 0) {
                        this.ppinfo[n][n2][n3][n31].nblk[0] = 0;
                        this.ttIncl[n][n2][n3][n31][0] = new TagTreeEncoder(0, 0);
                        this.ttMaxBP[n][n2][n3][n31][0] = new TagTreeEncoder(0, 0);
                    } else {
                        this.ttIncl[n][n2][n3][n31][0] = new TagTreeEncoder(n45 - n46 + 1, n42 - n43 + 1);
                        this.ttMaxBP[n][n2][n3][n31][0] = new TagTreeEncoder(n45 - n46 + 1, n42 - n43 + 1);
                        this.ppinfo[n][n2][n3][n31].cblk[0] = new CBlkCoordInfo[n45 - n46 + 1][n42 - n43 + 1];
                        this.ppinfo[n][n2][n3][n31].nblk[0] = (n45 - n46 + 1) * (n42 - n43 + 1);
                        n41 = n46;
                        while (n41 <= n45) {
                            n40 = n43;
                            while (n40 <= n42) {
                                this.ppinfo[n][n2][n3][n31].cblk[0][n41 - n46][n40 - n43] = cBlkCoordInfo = new CBlkCoordInfo(n41 - n47, n40 - n44);
                                ++n40;
                            }
                            ++n41;
                        }
                    }
                } else {
                    n59 = 0;
                    n58 = n28;
                    n57 = n59 + n39 * n29;
                    n56 = n57 + n29;
                    n55 = n58 + n38 * n30;
                    n54 = n55 + n30;
                    subbandAn2 = (SubbandAn)subbandAn.getSubbandByIdx(n3, 1);
                    n53 = n57 < subbandAn2.ulcx ? subbandAn2.ulcx : n57;
                    n52 = n56 > subbandAn2.ulcx + subbandAn2.w ? subbandAn2.ulcx + subbandAn2.w : n56;
                    n51 = n55 < subbandAn2.ulcy ? subbandAn2.ulcy : n55;
                    n50 = n54 > subbandAn2.ulcy + subbandAn2.h ? subbandAn2.ulcy + subbandAn2.h : n54;
                    n49 = subbandAn2.nomCBlkW;
                    n48 = subbandAn2.nomCBlkH;
                    n47 = (int)Math.floor((double)(subbandAn2.ulcy - n58) / (double)n48);
                    n46 = (int)Math.floor((double)(n51 - n58) / (double)n48);
                    n45 = (int)Math.floor((double)(n50 - 1 - n58) / (double)n48);
                    n44 = (int)Math.floor((double)(subbandAn2.ulcx - n59) / (double)n49);
                    n43 = (int)Math.floor((double)(n53 - n59) / (double)n49);
                    n42 = (int)Math.floor((double)(n52 - 1 - n59) / (double)n49);
                    if (n52 - n53 <= 0 || n50 - n51 <= 0) {
                        this.ppinfo[n][n2][n3][n31].nblk[1] = 0;
                        this.ttIncl[n][n2][n3][n31][1] = new TagTreeEncoder(0, 0);
                        this.ttMaxBP[n][n2][n3][n31][1] = new TagTreeEncoder(0, 0);
                    } else {
                        this.ttIncl[n][n2][n3][n31][1] = new TagTreeEncoder(n45 - n46 + 1, n42 - n43 + 1);
                        this.ttMaxBP[n][n2][n3][n31][1] = new TagTreeEncoder(n45 - n46 + 1, n42 - n43 + 1);
                        this.ppinfo[n][n2][n3][n31].cblk[1] = new CBlkCoordInfo[n45 - n46 + 1][n42 - n43 + 1];
                        this.ppinfo[n][n2][n3][n31].nblk[1] = (n45 - n46 + 1) * (n42 - n43 + 1);
                        n41 = n46;
                        while (n41 <= n45) {
                            n40 = n43;
                            while (n40 <= n42) {
                                this.ppinfo[n][n2][n3][n31].cblk[1][n41 - n46][n40 - n43] = cBlkCoordInfo = new CBlkCoordInfo(n41 - n47, n40 - n44);
                                ++n40;
                            }
                            ++n41;
                        }
                    }
                    n59 = n27;
                    n58 = 0;
                    n57 = n59 + n39 * n29;
                    n56 = n57 + n29;
                    n55 = n58 + n38 * n30;
                    n54 = n55 + n30;
                    subbandAn2 = (SubbandAn)subbandAn.getSubbandByIdx(n3, 2);
                    n53 = n57 < subbandAn2.ulcx ? subbandAn2.ulcx : n57;
                    n52 = n56 > subbandAn2.ulcx + subbandAn2.w ? subbandAn2.ulcx + subbandAn2.w : n56;
                    n51 = n55 < subbandAn2.ulcy ? subbandAn2.ulcy : n55;
                    n50 = n54 > subbandAn2.ulcy + subbandAn2.h ? subbandAn2.ulcy + subbandAn2.h : n54;
                    n49 = subbandAn2.nomCBlkW;
                    n48 = subbandAn2.nomCBlkH;
                    n47 = (int)Math.floor((double)(subbandAn2.ulcy - n58) / (double)n48);
                    n46 = (int)Math.floor((double)(n51 - n58) / (double)n48);
                    n45 = (int)Math.floor((double)(n50 - 1 - n58) / (double)n48);
                    n44 = (int)Math.floor((double)(subbandAn2.ulcx - n59) / (double)n49);
                    n43 = (int)Math.floor((double)(n53 - n59) / (double)n49);
                    n42 = (int)Math.floor((double)(n52 - 1 - n59) / (double)n49);
                    if (n52 - n53 <= 0 || n50 - n51 <= 0) {
                        this.ppinfo[n][n2][n3][n31].nblk[2] = 0;
                        this.ttIncl[n][n2][n3][n31][2] = new TagTreeEncoder(0, 0);
                        this.ttMaxBP[n][n2][n3][n31][2] = new TagTreeEncoder(0, 0);
                    } else {
                        this.ttIncl[n][n2][n3][n31][2] = new TagTreeEncoder(n45 - n46 + 1, n42 - n43 + 1);
                        this.ttMaxBP[n][n2][n3][n31][2] = new TagTreeEncoder(n45 - n46 + 1, n42 - n43 + 1);
                        this.ppinfo[n][n2][n3][n31].cblk[2] = new CBlkCoordInfo[n45 - n46 + 1][n42 - n43 + 1];
                        this.ppinfo[n][n2][n3][n31].nblk[2] = (n45 - n46 + 1) * (n42 - n43 + 1);
                        n41 = n46;
                        while (n41 <= n45) {
                            n40 = n43;
                            while (n40 <= n42) {
                                this.ppinfo[n][n2][n3][n31].cblk[2][n41 - n46][n40 - n43] = cBlkCoordInfo = new CBlkCoordInfo(n41 - n47, n40 - n44);
                                ++n40;
                            }
                            ++n41;
                        }
                    }
                    n59 = 0;
                    n58 = 0;
                    n57 = n59 + n39 * n29;
                    n56 = n57 + n29;
                    n55 = n58 + n38 * n30;
                    n54 = n55 + n30;
                    subbandAn2 = (SubbandAn)subbandAn.getSubbandByIdx(n3, 3);
                    n53 = n57 < subbandAn2.ulcx ? subbandAn2.ulcx : n57;
                    n52 = n56 > subbandAn2.ulcx + subbandAn2.w ? subbandAn2.ulcx + subbandAn2.w : n56;
                    n51 = n55 < subbandAn2.ulcy ? subbandAn2.ulcy : n55;
                    n50 = n54 > subbandAn2.ulcy + subbandAn2.h ? subbandAn2.ulcy + subbandAn2.h : n54;
                    n49 = subbandAn2.nomCBlkW;
                    n48 = subbandAn2.nomCBlkH;
                    n47 = (int)Math.floor((double)(subbandAn2.ulcy - n58) / (double)n48);
                    n46 = (int)Math.floor((double)(n51 - n58) / (double)n48);
                    n45 = (int)Math.floor((double)(n50 - 1 - n58) / (double)n48);
                    n44 = (int)Math.floor((double)(subbandAn2.ulcx - n59) / (double)n49);
                    n43 = (int)Math.floor((double)(n53 - n59) / (double)n49);
                    n42 = (int)Math.floor((double)(n52 - 1 - n59) / (double)n49);
                    if (n52 - n53 <= 0 || n50 - n51 <= 0) {
                        this.ppinfo[n][n2][n3][n31].nblk[3] = 0;
                        this.ttIncl[n][n2][n3][n31][3] = new TagTreeEncoder(0, 0);
                        this.ttMaxBP[n][n2][n3][n31][3] = new TagTreeEncoder(0, 0);
                    } else {
                        this.ttIncl[n][n2][n3][n31][3] = new TagTreeEncoder(n45 - n46 + 1, n42 - n43 + 1);
                        this.ttMaxBP[n][n2][n3][n31][3] = new TagTreeEncoder(n45 - n46 + 1, n42 - n43 + 1);
                        this.ppinfo[n][n2][n3][n31].cblk[3] = new CBlkCoordInfo[n45 - n46 + 1][n42 - n43 + 1];
                        this.ppinfo[n][n2][n3][n31].nblk[3] = (n45 - n46 + 1) * (n42 - n43 + 1);
                        n41 = n46;
                        while (n41 <= n45) {
                            n40 = n43;
                            while (n40 <= n42) {
                                this.ppinfo[n][n2][n3][n31].cblk[3][n41 - n46][n40 - n43] = cBlkCoordInfo = new CBlkCoordInfo(n41 - n47, n40 - n44);
                                ++n40;
                            }
                            ++n41;
                        }
                    }
                }
                ++n39;
                ++n31;
            }
            ++n38;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BitOutputBuffer encodePacket(int n, int n2, int n3, int n4, CBlkRateDistStats[][] cBlkRateDistStatsArray, int[][] nArray, BitOutputBuffer bitOutputBuffer, byte[] byArray, int n5) {
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int[] nArray2;
        CBlkRateDistStats[] cBlkRateDistStatsArray2;
        int[] nArray3;
        SubbandAn subbandAn;
        int n12 = n3 == 0 ? 0 : 1;
        int n13 = n3 == 0 ? 1 : 4;
        Point point = null;
        SubbandAn subbandAn2 = this.infoSrc.getAnSubbandTree(n4, n2);
        this.roiInPkt = false;
        this.roiLen = 0;
        if (n5 >= this.ppinfo[n4][n2][n3].length) {
            this.packetWritable = false;
            return bitOutputBuffer;
        }
        PrecInfo precInfo = this.ppinfo[n4][n2][n3][n5];
        boolean bl = true;
        int n14 = n12;
        while (n14 < n13) {
            if (precInfo.nblk[n14] != 0) {
                bl = false;
                break;
            }
            ++n14;
        }
        if (bl) {
            this.packetWritable = true;
            if (bitOutputBuffer == null) {
                bitOutputBuffer = new BitOutputBuffer();
            } else {
                bitOutputBuffer.reset();
            }
            if (byArray == null) {
                byArray = new byte[1];
                this.lbbuf = byArray;
            }
            bitOutputBuffer.writeBit(0);
            this.lblen = 0;
            return bitOutputBuffer;
        }
        if (bitOutputBuffer == null) {
            bitOutputBuffer = new BitOutputBuffer();
        } else {
            bitOutputBuffer.reset();
        }
        this.lbbuf = null;
        this.lblen = 0;
        bitOutputBuffer.writeBit(1);
        n14 = n12;
        while (n14 < n13) {
            subbandAn = (SubbandAn)subbandAn2.getSubbandByIdx(n3, n14);
            if (precInfo.nblk[n14] != 0) {
                TagTreeEncoder tagTreeEncoder = this.ttIncl[n4][n2][n3][n5][n14];
                TagTreeEncoder tagTreeEncoder2 = this.ttMaxBP[n4][n2][n3][n5][n14];
                nArray3 = this.prevtIdxs[n4][n2][n3][n14];
                cBlkRateDistStatsArray2 = cBlkRateDistStatsArray[n14];
                nArray2 = nArray[n14];
                n11 = precInfo.cblk[n14] == null ? 0 : precInfo.cblk[n14].length;
                n10 = 0;
                while (n10 < n11) {
                    n9 = precInfo.cblk[n14][n10] == null ? 0 : precInfo.cblk[n14][n10].length;
                    n8 = 0;
                    while (n8 < n9) {
                        point = precInfo.cblk[n14][n10][n8].idx;
                        n7 = point.x + point.y * subbandAn.numCb.x;
                        if (nArray2[n7] > nArray3[n7] && nArray3[n7] < 0) {
                            tagTreeEncoder.setValue(n10, n8, n - 1);
                        }
                        if (n == 1) {
                            tagTreeEncoder2.setValue(n10, n8, cBlkRateDistStatsArray2[n7].skipMSBP);
                        }
                        ++n8;
                    }
                    ++n10;
                }
                n10 = 0;
                while (n10 < precInfo.cblk[n14].length) {
                    n8 = 0;
                    while (n8 < precInfo.cblk[n14][n10].length) {
                        point = precInfo.cblk[n14][n10][n8].idx;
                        n7 = point.x + point.y * subbandAn.numCb.x;
                        if (nArray2[n7] <= nArray3[n7]) {
                            if (nArray3[n7] >= 0) {
                                bitOutputBuffer.writeBit(0);
                            } else {
                                tagTreeEncoder.encode(n10, n8, n, bitOutputBuffer);
                            }
                        } else {
                            int n15;
                            int n16;
                            int n17;
                            int n18;
                            if (nArray3[n7] < 0) {
                                tagTreeEncoder.encode(n10, n8, n, bitOutputBuffer);
                                int n19 = cBlkRateDistStatsArray2[n7].skipMSBP + 1;
                                n18 = 1;
                                while (n18 <= n19) {
                                    tagTreeEncoder2.encode(n10, n8, n18, bitOutputBuffer);
                                    ++n18;
                                }
                                this.lblen += cBlkRateDistStatsArray2[n7].truncRates[cBlkRateDistStatsArray2[n7].truncIdxs[nArray2[n7]]];
                            } else {
                                bitOutputBuffer.writeBit(1);
                                this.lblen += cBlkRateDistStatsArray2[n7].truncRates[cBlkRateDistStatsArray2[n7].truncIdxs[nArray2[n7]]] - cBlkRateDistStatsArray2[n7].truncRates[cBlkRateDistStatsArray2[n7].truncIdxs[nArray3[n7]]];
                            }
                            int n20 = nArray3[n7] < 0 ? cBlkRateDistStatsArray2[n7].truncIdxs[nArray2[n7]] : cBlkRateDistStatsArray2[n7].truncIdxs[nArray2[n7]] - cBlkRateDistStatsArray2[n7].truncIdxs[nArray3[n7]] - 1;
                            switch (n20) {
                                case 0: {
                                    bitOutputBuffer.writeBit(0);
                                    break;
                                }
                                case 1: {
                                    bitOutputBuffer.writeBits(2, 2);
                                    break;
                                }
                                case 2: 
                                case 3: 
                                case 4: {
                                    bitOutputBuffer.writeBits(0xC | n20 - 2, 4);
                                    break;
                                }
                                default: {
                                    if (n20 <= 35) {
                                        bitOutputBuffer.writeBits(0x1E0 | n20 - 5, 9);
                                    } else {
                                        if (n20 > 163) throw new ArithmeticException("Maximum number of truncation points exceeded");
                                        bitOutputBuffer.writeBits(0xFF80 | n20 - 36, 16);
                                    }
                                }
                            }
                            n20 = 1;
                            int n21 = cBlkRateDistStatsArray2[n7].truncIdxs[nArray2[n7]];
                            n6 = nArray3[n7] < 0 ? 0 : cBlkRateDistStatsArray2[n7].truncRates[cBlkRateDistStatsArray2[n7].truncIdxs[nArray3[n7]]];
                            n18 = nArray3[n7] < 0 ? 0 : cBlkRateDistStatsArray2[n7].truncIdxs[nArray3[n7]] + 1;
                            int n22 = 0;
                            while (n18 < n21) {
                                if (cBlkRateDistStatsArray2[n7].isTermPass != null && cBlkRateDistStatsArray2[n7].isTermPass[n18]) {
                                    n6 = cBlkRateDistStatsArray2[n7].truncRates[n18] - n6;
                                    n17 = this.lblock[n4][n2][n3][n14][n7] + MathUtil.log2(n20);
                                    n22 = (n6 > 0 ? MathUtil.log2(n6) : 0) + 1;
                                    n16 = n17;
                                    while (n16 < n22) {
                                        int[] nArray4 = this.lblock[n4][n2][n3][n14];
                                        int n23 = n7;
                                        nArray4[n23] = nArray4[n23] + 1;
                                        bitOutputBuffer.writeBit(1);
                                        ++n16;
                                    }
                                    n20 = 0;
                                    n6 = cBlkRateDistStatsArray2[n7].truncRates[n18];
                                }
                                ++n18;
                                ++n20;
                            }
                            n6 = cBlkRateDistStatsArray2[n7].truncRates[n18] - n6;
                            n17 = this.lblock[n4][n2][n3][n14][n7] + MathUtil.log2(n20);
                            n22 = (n6 > 0 ? MathUtil.log2(n6) : 0) + 1;
                            n16 = n17;
                            while (n16 < n22) {
                                int[] nArray5 = this.lblock[n4][n2][n3][n14];
                                int n24 = n7;
                                nArray5[n24] = nArray5[n24] + 1;
                                bitOutputBuffer.writeBit(1);
                                ++n16;
                            }
                            bitOutputBuffer.writeBit(0);
                            n20 = 1;
                            n21 = cBlkRateDistStatsArray2[n7].truncIdxs[nArray2[n7]];
                            n6 = nArray3[n7] < 0 ? 0 : cBlkRateDistStatsArray2[n7].truncRates[cBlkRateDistStatsArray2[n7].truncIdxs[nArray3[n7]]];
                            n18 = nArray3[n7] < 0 ? 0 : cBlkRateDistStatsArray2[n7].truncIdxs[nArray3[n7]] + 1;
                            while (n18 < n21) {
                                if (cBlkRateDistStatsArray2[n7].isTermPass != null && cBlkRateDistStatsArray2[n7].isTermPass[n18]) {
                                    n6 = cBlkRateDistStatsArray2[n7].truncRates[n18] - n6;
                                    n15 = MathUtil.log2(n20) + this.lblock[n4][n2][n3][n14][n7];
                                    bitOutputBuffer.writeBits(n6, n15);
                                    n20 = 0;
                                    n6 = cBlkRateDistStatsArray2[n7].truncRates[n18];
                                }
                                ++n18;
                                ++n20;
                            }
                            n6 = cBlkRateDistStatsArray2[n7].truncRates[n18] - n6;
                            n15 = MathUtil.log2(n20) + this.lblock[n4][n2][n3][n14][n7];
                            bitOutputBuffer.writeBits(n6, n15);
                        }
                        ++n8;
                    }
                    ++n10;
                }
            }
            ++n14;
        }
        if (byArray == null || byArray.length < this.lblen) {
            byArray = new byte[this.lblen];
        }
        this.lbbuf = byArray;
        this.lblen = 0;
        n14 = n12;
        while (n14 < n13) {
            subbandAn = (SubbandAn)subbandAn2.getSubbandByIdx(n3, n14);
            nArray3 = this.prevtIdxs[n4][n2][n3][n14];
            cBlkRateDistStatsArray2 = cBlkRateDistStatsArray[n14];
            nArray2 = nArray[n14];
            int cfr_ignored_0 = nArray3.length;
            n11 = precInfo.cblk[n14] == null ? 0 : precInfo.cblk[n14].length;
            n10 = 0;
            while (n10 < n11) {
                n9 = precInfo.cblk[n14][n10] == null ? 0 : precInfo.cblk[n14][n10].length;
                n8 = 0;
                while (n8 < n9) {
                    point = precInfo.cblk[n14][n10][n8].idx;
                    n7 = point.x + point.y * subbandAn.numCb.x;
                    if (nArray2[n7] > nArray3[n7]) {
                        if (nArray3[n7] < 0) {
                            n6 = cBlkRateDistStatsArray2[n7].truncRates[cBlkRateDistStatsArray2[n7].truncIdxs[nArray2[n7]]];
                            System.arraycopy(cBlkRateDistStatsArray2[n7].data, 0, this.lbbuf, this.lblen, n6);
                        } else {
                            n6 = cBlkRateDistStatsArray2[n7].truncRates[cBlkRateDistStatsArray2[n7].truncIdxs[nArray2[n7]]] - cBlkRateDistStatsArray2[n7].truncRates[cBlkRateDistStatsArray2[n7].truncIdxs[nArray3[n7]]];
                            System.arraycopy(cBlkRateDistStatsArray2[n7].data, cBlkRateDistStatsArray2[n7].truncRates[cBlkRateDistStatsArray2[n7].truncIdxs[nArray3[n7]]], this.lbbuf, this.lblen, n6);
                        }
                        this.lblen += n6;
                        if (cBlkRateDistStatsArray2[n7].nROIcoeff != 0 && (nArray3[n7] == -1 || cBlkRateDistStatsArray2[n7].truncIdxs[nArray3[n7]] <= cBlkRateDistStatsArray2[n7].nROIcp - 1)) {
                            this.roiInPkt = true;
                            this.roiLen = this.lblen;
                        }
                        nArray3[n7] = nArray2[n7];
                    }
                    ++n8;
                }
                ++n10;
            }
            ++n14;
        }
        this.packetWritable = true;
        if (bitOutputBuffer.getLength() != 0) return bitOutputBuffer;
        throw new Error("You have found a bug in PktEncoder, method: encodePacket");
    }

    public byte[] getLastBodyBuf() {
        if (this.lbbuf == null) {
            throw new IllegalArgumentException();
        }
        return this.lbbuf;
    }

    public int getLastBodyLen() {
        return this.lblen;
    }

    public void save() {
        int n;
        int n2;
        if (this.bak_lblock == null) {
            this.bak_lblock = new int[this.ttIncl.length][][][][];
            this.bak_prevtIdxs = new int[this.ttIncl.length][][][][];
            int n3 = this.ttIncl.length - 1;
            while (n3 >= 0) {
                this.bak_lblock[n3] = new int[this.ttIncl[n3].length][][][];
                this.bak_prevtIdxs[n3] = new int[this.ttIncl[n3].length][][][];
                int n4 = this.ttIncl[n3].length - 1;
                while (n4 >= 0) {
                    this.bak_lblock[n3][n4] = new int[this.lblock[n3][n4].length][][];
                    this.bak_prevtIdxs[n3][n4] = new int[this.ttIncl[n3][n4].length][][];
                    int n5 = this.lblock[n3][n4].length - 1;
                    while (n5 >= 0) {
                        this.bak_lblock[n3][n4][n5] = new int[this.lblock[n3][n4][n5].length][];
                        this.bak_prevtIdxs[n3][n4][n5] = new int[this.prevtIdxs[n3][n4][n5].length][];
                        n2 = n5 == 0 ? 0 : 1;
                        n = n5 == 0 ? 1 : 4;
                        int n6 = n2;
                        while (n6 < n) {
                            this.bak_lblock[n3][n4][n5][n6] = new int[this.lblock[n3][n4][n5][n6].length];
                            this.bak_prevtIdxs[n3][n4][n5][n6] = new int[this.prevtIdxs[n3][n4][n5][n6].length];
                            ++n6;
                        }
                        --n5;
                    }
                    --n4;
                }
                --n3;
            }
        }
        int n7 = this.ttIncl.length - 1;
        while (n7 >= 0) {
            int n8 = this.ttIncl[n7].length - 1;
            while (n8 >= 0) {
                int[][][] nArray = this.lblock[n7][n8];
                int[][][] nArray2 = this.bak_lblock[n7][n8];
                TagTreeEncoder[][][] tagTreeEncoderArray = this.ttIncl[n7][n8];
                TagTreeEncoder[][][] tagTreeEncoderArray2 = this.ttMaxBP[n7][n8];
                int n9 = nArray.length - 1;
                while (n9 >= 0) {
                    TagTreeEncoder[][] tagTreeEncoderArray3 = tagTreeEncoderArray[n9];
                    TagTreeEncoder[][] tagTreeEncoderArray4 = tagTreeEncoderArray2[n9];
                    int[][] nArray3 = this.prevtIdxs[n7][n8][n9];
                    int[][] nArray4 = this.bak_prevtIdxs[n7][n8][n9];
                    n2 = n9 == 0 ? 0 : 1;
                    n = n9 == 0 ? 1 : 4;
                    int n10 = n2;
                    while (n10 < n) {
                        System.arraycopy(nArray[n9][n10], 0, nArray2[n9][n10], 0, nArray[n9][n10].length);
                        System.arraycopy(nArray3[n10], 0, nArray4[n10], 0, nArray3[n10].length);
                        ++n10;
                    }
                    n10 = this.ppinfo[n7][n8][n9].length - 1;
                    while (n10 >= 0) {
                        if (n10 < tagTreeEncoderArray3.length) {
                            int n11 = n2;
                            while (n11 < n) {
                                tagTreeEncoderArray3[n10][n11].save();
                                tagTreeEncoderArray4[n10][n11].save();
                                ++n11;
                            }
                        }
                        --n10;
                    }
                    --n9;
                }
                --n8;
            }
            --n7;
        }
        this.saved = true;
    }

    public void restore() {
        if (!this.saved) {
            throw new IllegalArgumentException();
        }
        this.lbbuf = null;
        int n = this.ttIncl.length - 1;
        while (n >= 0) {
            int n2 = this.ttIncl[n].length - 1;
            while (n2 >= 0) {
                int[][][] nArray = this.lblock[n][n2];
                int[][][] nArray2 = this.bak_lblock[n][n2];
                TagTreeEncoder[][][] tagTreeEncoderArray = this.ttIncl[n][n2];
                TagTreeEncoder[][][] tagTreeEncoderArray2 = this.ttMaxBP[n][n2];
                int n3 = nArray.length - 1;
                while (n3 >= 0) {
                    TagTreeEncoder[][] tagTreeEncoderArray3 = tagTreeEncoderArray[n3];
                    TagTreeEncoder[][] tagTreeEncoderArray4 = tagTreeEncoderArray2[n3];
                    int[][] nArray3 = this.prevtIdxs[n][n2][n3];
                    int[][] nArray4 = this.bak_prevtIdxs[n][n2][n3];
                    int n4 = n3 == 0 ? 0 : 1;
                    int n5 = n3 == 0 ? 1 : 4;
                    int n6 = n4;
                    while (n6 < n5) {
                        System.arraycopy(nArray2[n3][n6], 0, nArray[n3][n6], 0, nArray[n3][n6].length);
                        System.arraycopy(nArray4[n6], 0, nArray3[n6], 0, nArray3[n6].length);
                        ++n6;
                    }
                    n6 = this.ppinfo[n][n2][n3].length - 1;
                    while (n6 >= 0) {
                        if (n6 < tagTreeEncoderArray3.length) {
                            int n7 = n4;
                            while (n7 < n5) {
                                tagTreeEncoderArray3[n6][n7].restore();
                                tagTreeEncoderArray4[n6][n7].restore();
                                ++n7;
                            }
                        }
                        --n6;
                    }
                    --n3;
                }
                --n2;
            }
            --n;
        }
    }

    public void reset() {
        this.saved = false;
        this.lbbuf = null;
        int n = this.ttIncl.length - 1;
        while (n >= 0) {
            int n2 = this.ttIncl[n].length - 1;
            while (n2 >= 0) {
                int[][][] nArray = this.lblock[n][n2];
                TagTreeEncoder[][][] tagTreeEncoderArray = this.ttIncl[n][n2];
                TagTreeEncoder[][][] tagTreeEncoderArray2 = this.ttMaxBP[n][n2];
                int n3 = nArray.length - 1;
                while (n3 >= 0) {
                    TagTreeEncoder[][] tagTreeEncoderArray3 = tagTreeEncoderArray[n3];
                    TagTreeEncoder[][] tagTreeEncoderArray4 = tagTreeEncoderArray2[n3];
                    int[][] nArray2 = this.prevtIdxs[n][n2][n3];
                    int n4 = n3 == 0 ? 0 : 1;
                    int n5 = n3 == 0 ? 1 : 4;
                    int n6 = n4;
                    while (n6 < n5) {
                        ArrayUtil.intArraySet(nArray2[n6], -1);
                        ArrayUtil.intArraySet(nArray[n3][n6], 3);
                        ++n6;
                    }
                    n6 = this.ppinfo[n][n2][n3].length - 1;
                    while (n6 >= 0) {
                        if (n6 < tagTreeEncoderArray3.length) {
                            int n7 = n4;
                            while (n7 < n5) {
                                tagTreeEncoderArray3[n6][n7].reset();
                                tagTreeEncoderArray4[n6][n7].reset();
                                ++n7;
                            }
                        }
                        --n6;
                    }
                    --n3;
                }
                --n2;
            }
            --n;
        }
    }

    public boolean isPacketWritable() {
        return this.packetWritable;
    }

    public boolean isROIinPkt() {
        return this.roiInPkt;
    }

    public int getROILen() {
        return this.roiLen;
    }

    public static String[][] getParameterInfo() {
        return pinfo;
    }

    public PrecInfo getPrecInfo(int n, int n2, int n3, int n4) {
        return this.ppinfo[n][n2][n3][n4];
    }
}

