/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.codestream.writer;

import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageWriteParamJava;
import java.awt.Point;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.StringTokenizer;
import java.util.Vector;
import jj2000.j2k.codestream.Markers;
import jj2000.j2k.entropy.Progression;
import jj2000.j2k.entropy.StdEntropyCoderOptions;
import jj2000.j2k.entropy.encoder.PostCompRateAllocator;
import jj2000.j2k.image.ImgData;
import jj2000.j2k.image.Tiler;
import jj2000.j2k.io.BinaryDataOutput;
import jj2000.j2k.quantization.quantizer.StdQuantizer;
import jj2000.j2k.roi.encoder.ROIScaler;
import jj2000.j2k.util.MathUtil;
import jj2000.j2k.wavelet.analysis.AnWTFilter;
import jj2000.j2k.wavelet.analysis.ForwardWT;
import jj2000.j2k.wavelet.analysis.SubbandAn;

public class HeaderEncoder
implements Markers,
StdEntropyCoderOptions {
    private int defimgn;
    private int deftilenr;
    protected int nComp;
    private boolean enJJ2KMarkSeg = true;
    private String otherCOMMarkSeg = null;
    protected ByteArrayOutputStream baos;
    protected DataOutputStream hbuf;
    protected ImgData origSrc;
    protected boolean[] isOrigSig;
    protected PostCompRateAllocator ralloc;
    protected ForwardWT dwt;
    protected Tiler tiler;
    protected ROIScaler roiSc;
    protected J2KImageWriteParamJava wp;

    public HeaderEncoder(ImgData imgData, boolean[] blArray, ForwardWT forwardWT, Tiler tiler, J2KImageWriteParamJava j2KImageWriteParamJava, ROIScaler rOIScaler, PostCompRateAllocator postCompRateAllocator) {
        if (imgData.getNumComps() != blArray.length) {
            throw new IllegalArgumentException();
        }
        this.origSrc = imgData;
        this.isOrigSig = blArray;
        this.dwt = forwardWT;
        this.tiler = tiler;
        this.wp = j2KImageWriteParamJava;
        this.roiSc = rOIScaler;
        this.ralloc = postCompRateAllocator;
        this.baos = new ByteArrayOutputStream();
        this.hbuf = new DataOutputStream(this.baos);
        this.nComp = imgData.getNumComps();
    }

    public void reset() {
        this.baos.reset();
        this.hbuf = new DataOutputStream(this.baos);
    }

    protected byte[] getBuffer() {
        return this.baos.toByteArray();
    }

    public int getLength() {
        return this.hbuf.size();
    }

    public void writeTo(BinaryDataOutput binaryDataOutput) throws IOException {
        byte[] byArray = this.getBuffer();
        int n = this.getLength();
        int n2 = 0;
        while (n2 < n) {
            binaryDataOutput.writeByte(byArray[n2]);
            ++n2;
        }
    }

    protected int getBufferLength() {
        return this.baos.size();
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.getBuffer(), 0, this.getBufferLength());
    }

    private void writeSOC() throws IOException {
        this.hbuf.writeShort(-177);
    }

    private void writeSIZ() throws IOException {
        this.hbuf.writeShort(-175);
        int n = 38 + 3 * this.nComp;
        this.hbuf.writeShort(n);
        this.hbuf.writeShort(0);
        this.hbuf.writeInt(this.tiler.getImgWidth() + this.tiler.getImgULX());
        this.hbuf.writeInt(this.tiler.getImgHeight() + this.tiler.getImgULY());
        this.hbuf.writeInt(this.tiler.getImgULX());
        this.hbuf.writeInt(this.tiler.getImgULY());
        this.hbuf.writeInt(this.tiler.getNomTileWidth());
        this.hbuf.writeInt(this.tiler.getNomTileHeight());
        Point point = this.tiler.getTilingOrigin(null);
        this.hbuf.writeInt(point.x);
        this.hbuf.writeInt(point.y);
        this.hbuf.writeShort(this.nComp);
        int n2 = 0;
        while (n2 < this.nComp) {
            int n3 = this.origSrc.getNomRangeBits(n2) - 1;
            this.hbuf.write(n3 |= (this.isOrigSig[n2] ? 1 : 0) << 7);
            this.hbuf.write(this.tiler.getCompSubsX(n2));
            this.hbuf.write(this.tiler.getCompSubsY(n2));
            ++n2;
        }
    }

    protected void writeCOD(boolean bl, int n) throws IOException {
        AnWTFilter[][] anWTFilterArray;
        Progression[] progressionArray;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (bl) {
            n2 = (Integer)this.wp.getDecompositionLevel().getDefault();
            n4 = this.wp.getPrecinctPartition().getPPX(-1, -1, n2);
            n5 = this.wp.getPrecinctPartition().getPPY(-1, -1, n2);
            progressionArray = (Progression[])this.wp.getProgressionType().getDefault();
        } else {
            n2 = (Integer)this.wp.getDecompositionLevel().getTileDef(n);
            n4 = this.wp.getPrecinctPartition().getPPX(n, -1, n2);
            n5 = this.wp.getPrecinctPartition().getPPY(n, -1, n2);
            progressionArray = (Progression[])this.wp.getProgressionType().getTileDef(n);
        }
        boolean bl2 = n4 != 65535 || n5 != 65535;
        if (bl2) {
            n3 = n2 + 1;
        }
        this.hbuf.writeShort(-174);
        int n6 = 12 + n3;
        this.hbuf.writeShort(n6);
        int n7 = 0;
        if (bl2) {
            n7 = 1;
        }
        if (bl) {
            if (this.wp.getSOP().getDefault().toString().equalsIgnoreCase("true")) {
                n7 |= 2;
            }
        } else if (this.wp.getSOP().getTileDef(n).toString().equalsIgnoreCase("true")) {
            n7 |= 2;
        }
        if (bl) {
            if (this.wp.getEPH().getDefault().toString().equalsIgnoreCase("true")) {
                n7 |= 4;
            }
        } else if (this.wp.getEPH().getTileDef(n).toString().equalsIgnoreCase("true")) {
            n7 |= 4;
        }
        if (this.dwt.getCbULX() != 0) {
            n7 |= 8;
        }
        if (this.dwt.getCbULY() != 0) {
            n7 |= 0x10;
        }
        this.hbuf.write(n7);
        this.hbuf.write(progressionArray[0].type);
        this.hbuf.writeShort(this.ralloc.getNumLayers());
        String string = null;
        string = bl ? (String)this.wp.getComponentTransformation().getDefault() : (String)this.wp.getComponentTransformation().getTileDef(n);
        if (string.equals("none")) {
            this.hbuf.write(0);
        } else {
            this.hbuf.write(1);
        }
        this.hbuf.write(n2);
        if (bl) {
            n7 = this.wp.getCodeBlockSize().getCBlkWidth((byte)0, -1, -1);
            this.hbuf.write(MathUtil.log2(n7) - 2);
            n7 = this.wp.getCodeBlockSize().getCBlkHeight((byte)0, -1, -1);
            this.hbuf.write(MathUtil.log2(n7) - 2);
        } else {
            n7 = this.wp.getCodeBlockSize().getCBlkWidth((byte)2, n, -1);
            this.hbuf.write(MathUtil.log2(n7) - 2);
            n7 = this.wp.getCodeBlockSize().getCBlkHeight((byte)2, n, -1);
            this.hbuf.write(MathUtil.log2(n7) - 2);
        }
        n7 = 0;
        if (bl) {
            if (((String)this.wp.getBypass().getDefault()).equals("true")) {
                n7 |= 1;
            }
            if (((String)this.wp.getResetMQ().getDefault()).equals("true")) {
                n7 |= 2;
            }
            if (((String)this.wp.getTerminateOnByte().getDefault()).equals("true")) {
                n7 |= 4;
            }
            if (((String)this.wp.getCausalCXInfo().getDefault()).equals("true")) {
                n7 |= 8;
            }
            if (((String)this.wp.getMethodForMQTermination().getDefault()).equals("predict")) {
                n7 |= 0x10;
            }
            if (((String)this.wp.getCodeSegSymbol().getDefault()).equals("true")) {
                n7 |= 0x20;
            }
        } else {
            if (((String)this.wp.getBypass().getTileDef(n)).equals("true")) {
                n7 |= 1;
            }
            if (((String)this.wp.getResetMQ().getTileDef(n)).equals("true")) {
                n7 |= 2;
            }
            if (((String)this.wp.getTerminateOnByte().getTileDef(n)).equals("true")) {
                n7 |= 4;
            }
            if (((String)this.wp.getCausalCXInfo().getTileDef(n)).equals("true")) {
                n7 |= 8;
            }
            if (((String)this.wp.getMethodForMQTermination().getTileDef(n)).equals("predict")) {
                n7 |= 0x10;
            }
            if (((String)this.wp.getCodeSegSymbol().getTileDef(n)).equals("true")) {
                n7 |= 0x20;
            }
        }
        this.hbuf.write(n7);
        if (bl) {
            anWTFilterArray = (AnWTFilter[][])this.wp.getFilters().getDefault();
            this.hbuf.write(anWTFilterArray[0][0].getFilterType());
        } else {
            anWTFilterArray = (AnWTFilter[][])this.wp.getFilters().getTileDef(n);
            this.hbuf.write(anWTFilterArray[0][0].getFilterType());
        }
        if (bl2) {
            Vector[] vectorArray = null;
            vectorArray = bl ? (Vector[])this.wp.getPrecinctPartition().getDefault() : (Vector[])this.wp.getPrecinctPartition().getTileDef(n);
            int n8 = n2;
            while (n8 >= 0) {
                n7 = n8 >= vectorArray[1].size() ? ((Integer)vectorArray[1].elementAt(vectorArray[1].size() - 1)).intValue() : ((Integer)vectorArray[1].elementAt(n8)).intValue();
                int n9 = MathUtil.log2(n7) << 4 & 0xF0;
                n7 = n8 >= vectorArray[0].size() ? ((Integer)vectorArray[0].elementAt(vectorArray[0].size() - 1)).intValue() : ((Integer)vectorArray[0].elementAt(n8)).intValue();
                int n10 = MathUtil.log2(n7) & 0xF;
                this.hbuf.write(n9 | n10);
                --n8;
            }
        }
    }

    protected void writeCOC(boolean bl, int n, int n2) throws IOException {
        AnWTFilter[][] anWTFilterArray;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if (bl) {
            n3 = (Integer)this.wp.getDecompositionLevel().getCompDef(n2);
            n5 = this.wp.getPrecinctPartition().getPPX(-1, n2, n3);
            n6 = this.wp.getPrecinctPartition().getPPY(-1, n2, n3);
            Progression[] cfr_ignored_0 = (Progression[])this.wp.getProgressionType().getCompDef(n2);
        } else {
            n3 = (Integer)this.wp.getDecompositionLevel().getTileCompVal(n, n2);
            n5 = this.wp.getPrecinctPartition().getPPX(n, n2, n3);
            n6 = this.wp.getPrecinctPartition().getPPY(n, n2, n3);
            Progression[] cfr_ignored_1 = (Progression[])this.wp.getProgressionType().getTileCompVal(n, n2);
        }
        boolean bl2 = n5 != 65535 || n6 != 65535;
        if (bl2) {
            n4 = n3 + 1;
        }
        this.hbuf.writeShort(-173);
        int n7 = 8 + (this.nComp < 257 ? 1 : 2) + n4;
        this.hbuf.writeShort(n7);
        if (this.nComp < 257) {
            this.hbuf.write(n2);
        } else {
            this.hbuf.writeShort(n2);
        }
        int n8 = 0;
        if (bl2) {
            n8 = 1;
        }
        this.hbuf.write(n8);
        this.hbuf.write(n3);
        if (bl) {
            n8 = this.wp.getCodeBlockSize().getCBlkWidth((byte)1, -1, n2);
            this.hbuf.write(MathUtil.log2(n8) - 2);
            n8 = this.wp.getCodeBlockSize().getCBlkHeight((byte)1, -1, n2);
            this.hbuf.write(MathUtil.log2(n8) - 2);
        } else {
            n8 = this.wp.getCodeBlockSize().getCBlkWidth((byte)3, n, n2);
            this.hbuf.write(MathUtil.log2(n8) - 2);
            n8 = this.wp.getCodeBlockSize().getCBlkHeight((byte)3, n, n2);
            this.hbuf.write(MathUtil.log2(n8) - 2);
        }
        n8 = 0;
        if (bl) {
            if (((String)this.wp.getBypass().getCompDef(n2)).equals("true")) {
                n8 |= 1;
            }
            if (((String)this.wp.getResetMQ().getCompDef(n2)).equalsIgnoreCase("true")) {
                n8 |= 2;
            }
            if (((String)this.wp.getTerminateOnByte().getCompDef(n2)).equals("true")) {
                n8 |= 4;
            }
            if (((String)this.wp.getCausalCXInfo().getCompDef(n2)).equals("true")) {
                n8 |= 8;
            }
            if (((String)this.wp.getMethodForMQTermination().getCompDef(n2)).equals("predict")) {
                n8 |= 0x10;
            }
            if (((String)this.wp.getCodeSegSymbol().getCompDef(n2)).equals("true")) {
                n8 |= 0x20;
            }
        } else {
            if (((String)this.wp.getBypass().getTileCompVal(n, n2)).equals("true")) {
                n8 |= 1;
            }
            if (((String)this.wp.getResetMQ().getTileCompVal(n, n2)).equals("true")) {
                n8 |= 2;
            }
            if (((String)this.wp.getTerminateOnByte().getTileCompVal(n, n2)).equals("true")) {
                n8 |= 4;
            }
            if (((String)this.wp.getCausalCXInfo().getTileCompVal(n, n2)).equals("true")) {
                n8 |= 8;
            }
            if (((String)this.wp.getMethodForMQTermination().getTileCompVal(n, n2)).equals("predict")) {
                n8 |= 0x10;
            }
            if (((String)this.wp.getCodeSegSymbol().getTileCompVal(n, n2)).equals("true")) {
                n8 |= 0x20;
            }
        }
        this.hbuf.write(n8);
        if (bl) {
            anWTFilterArray = (AnWTFilter[][])this.wp.getFilters().getCompDef(n2);
            this.hbuf.write(anWTFilterArray[0][0].getFilterType());
        } else {
            anWTFilterArray = (AnWTFilter[][])this.wp.getFilters().getTileCompVal(n, n2);
            this.hbuf.write(anWTFilterArray[0][0].getFilterType());
        }
        if (bl2) {
            Vector[] vectorArray = null;
            vectorArray = bl ? (Vector[])this.wp.getPrecinctPartition().getCompDef(n2) : (Vector[])this.wp.getPrecinctPartition().getTileCompVal(n, n2);
            int n9 = n3;
            while (n9 >= 0) {
                n8 = n9 >= vectorArray[1].size() ? ((Integer)vectorArray[1].elementAt(vectorArray[1].size() - 1)).intValue() : ((Integer)vectorArray[1].elementAt(n9)).intValue();
                int n10 = MathUtil.log2(n8) << 4 & 0xF0;
                n8 = n9 >= vectorArray[0].size() ? ((Integer)vectorArray[0].elementAt(vectorArray[0].size() - 1)).intValue() : ((Integer)vectorArray[0].elementAt(n9)).intValue();
                int n11 = MathUtil.log2(n8) & 0xF;
                this.hbuf.write(n10 | n11);
                --n9;
            }
        }
    }

    protected void writeMainQCD() throws IOException {
        int n;
        int n2;
        String string = (String)this.wp.getQuantizationType().getDefault();
        float f = ((Float)this.wp.getQuantizationStep().getDefault()).floatValue();
        int n3 = (Integer)this.wp.getGuardBits().getDefault();
        boolean bl = string.equals("derived");
        boolean bl2 = string.equals("reversible");
        int n4 = (Integer)this.wp.getDecompositionLevel().getDefault();
        int n5 = this.dwt.getNumTiles();
        int n6 = this.dwt.getNumComps();
        int[] nArray = new int[2];
        boolean bl3 = true;
        int n7 = 0;
        while (n7 < n5 && bl3) {
            int n8 = 0;
            while (n8 < n6 && bl3) {
                int n9 = (Integer)this.wp.getDecompositionLevel().getTileCompVal(n7, n8);
                String string2 = (String)this.wp.getQuantizationType().getTileCompVal(n7, n8);
                if (n9 == n4 && string2.equals(string)) {
                    nArray[0] = n7;
                    nArray[1] = n8;
                    bl3 = false;
                }
                ++n8;
            }
            ++n7;
        }
        if (bl3) {
            throw new Error("Default representative for quantization type  and number of decomposition levels not found  in main QCD marker segment. You have found a JJ2000 bug.");
        }
        SubbandAn subbandAn = this.dwt.getAnSubbandTree(nArray[0], nArray[1]);
        this.defimgn = this.dwt.getNomRangeBits(nArray[1]);
        int n10 = bl2 ? 0 : (bl ? 1 : 2);
        this.hbuf.writeShort(-164);
        switch (n10) {
            case 1: {
                n2 = 1;
                break;
            }
            case 0: 
            case 2: {
                n2 = 0;
                SubbandAn subbandAn2 = subbandAn;
                subbandAn2 = (SubbandAn)subbandAn2.getSubbandByIdx(0, 0);
                n = 0;
                while (n <= n4) {
                    SubbandAn subbandAn3 = subbandAn2;
                    while (subbandAn3 != null) {
                        ++n2;
                        subbandAn3 = (SubbandAn)subbandAn3.nextSubband();
                    }
                    subbandAn2 = (SubbandAn)subbandAn2.getNextResLevel();
                    ++n;
                }
                break;
            }
            default: {
                throw new Error("Internal JJ2000 error");
            }
        }
        n = 3 + (bl2 ? n2 : 2 * n2);
        this.hbuf.writeShort(n);
        this.hbuf.write(n10 + (n3 << 5));
        switch (n10) {
            case 0: {
                SubbandAn subbandAn4 = subbandAn;
                subbandAn4 = (SubbandAn)subbandAn4.getSubbandByIdx(0, 0);
                int n11 = 0;
                while (n11 <= n4) {
                    SubbandAn subbandAn5 = subbandAn4;
                    while (subbandAn5 != null) {
                        int n12 = this.defimgn + subbandAn5.anGainExp;
                        this.hbuf.write(n12 << 3);
                        subbandAn5 = (SubbandAn)subbandAn5.nextSubband();
                    }
                    subbandAn4 = (SubbandAn)subbandAn4.getNextResLevel();
                    ++n11;
                }
                break;
            }
            case 1: {
                SubbandAn subbandAn6 = subbandAn;
                subbandAn6 = (SubbandAn)subbandAn6.getSubbandByIdx(0, 0);
                float f2 = f / (float)(1 << subbandAn6.level);
                this.hbuf.writeShort(StdQuantizer.convertToExpMantissa(f2));
                break;
            }
            case 2: {
                SubbandAn subbandAn7 = subbandAn;
                subbandAn7 = (SubbandAn)subbandAn7.getSubbandByIdx(0, 0);
                int n13 = 0;
                while (n13 <= n4) {
                    SubbandAn subbandAn8 = subbandAn7;
                    while (subbandAn8 != null) {
                        float f3 = f / (subbandAn8.l2Norm * (float)(1 << subbandAn8.anGainExp));
                        this.hbuf.writeShort(StdQuantizer.convertToExpMantissa(f3));
                        subbandAn8 = (SubbandAn)subbandAn8.nextSubband();
                    }
                    subbandAn7 = (SubbandAn)subbandAn7.getNextResLevel();
                    ++n13;
                }
                break;
            }
            default: {
                throw new Error("Internal JJ2000 error");
            }
        }
    }

    protected void writeMainQCC(int n) throws IOException {
        SubbandAn subbandAn;
        SubbandAn subbandAn2;
        int n2;
        int n3 = 0;
        int n4 = this.dwt.getNomRangeBits(n);
        String string = (String)this.wp.getQuantizationType().getCompDef(n);
        float f = ((Float)this.wp.getQuantizationStep().getCompDef(n)).floatValue();
        int n5 = (Integer)this.wp.getGuardBits().getCompDef(n);
        boolean bl = string.equals("reversible");
        boolean bl2 = string.equals("derived");
        int n6 = (Integer)this.wp.getDecompositionLevel().getCompDef(n);
        int n7 = this.dwt.getNumTiles();
        int n8 = this.dwt.getNumComps();
        boolean bl3 = true;
        int n9 = 0;
        while (n9 < n7 && bl3) {
            n2 = 0;
            while (n2 < n8 && bl3) {
                int n10 = (Integer)this.wp.getDecompositionLevel().getTileCompVal(n9, n2);
                String string2 = (String)this.wp.getQuantizationType().getTileCompVal(n9, n2);
                if (n10 == n6 && string2.equals(string)) {
                    n3 = n9;
                    bl3 = false;
                }
                ++n2;
            }
            ++n9;
        }
        if (bl3) {
            throw new Error("Default representative for quantization type  and number of decomposition levels not found  in main QCC (c=" + n + ") marker segment. " + "You have found a JJ2000 bug.");
        }
        SubbandAn subbandAn3 = this.dwt.getAnSubbandTree(n3, n);
        int n11 = bl ? 0 : (bl2 ? 1 : 2);
        this.hbuf.writeShort(-163);
        switch (n11) {
            case 1: {
                n9 = 1;
                break;
            }
            case 0: 
            case 2: {
                n9 = 0;
                subbandAn2 = subbandAn3;
                n6 = subbandAn2.resLvl;
                subbandAn2 = (SubbandAn)subbandAn2.getSubbandByIdx(0, 0);
                while (subbandAn2.resLvl != 0) {
                    subbandAn2 = subbandAn2.subb_LL;
                }
                n2 = 0;
                while (n2 <= n6) {
                    subbandAn = subbandAn2;
                    while (subbandAn != null) {
                        ++n9;
                        subbandAn = (SubbandAn)subbandAn.nextSubband();
                    }
                    subbandAn2 = (SubbandAn)subbandAn2.getNextResLevel();
                    ++n2;
                }
                break;
            }
            default: {
                throw new Error("Internal JJ2000 error");
            }
        }
        n2 = 3 + (this.nComp < 257 ? 1 : 2) + (bl ? n9 : 2 * n9);
        this.hbuf.writeShort(n2);
        if (this.nComp < 257) {
            this.hbuf.write(n);
        } else {
            this.hbuf.writeShort(n);
        }
        this.hbuf.write(n11 + (n5 << 5));
        switch (n11) {
            case 0: {
                subbandAn2 = subbandAn3;
                subbandAn2 = (SubbandAn)subbandAn2.getSubbandByIdx(0, 0);
                int n12 = 0;
                while (n12 <= n6) {
                    subbandAn = subbandAn2;
                    while (subbandAn != null) {
                        int n13 = n4 + subbandAn.anGainExp;
                        this.hbuf.write(n13 << 3);
                        subbandAn = (SubbandAn)subbandAn.nextSubband();
                    }
                    subbandAn2 = (SubbandAn)subbandAn2.getNextResLevel();
                    ++n12;
                }
                break;
            }
            case 1: {
                subbandAn2 = subbandAn3;
                subbandAn2 = (SubbandAn)subbandAn2.getSubbandByIdx(0, 0);
                float f2 = f / (float)(1 << subbandAn2.level);
                this.hbuf.writeShort(StdQuantizer.convertToExpMantissa(f2));
                break;
            }
            case 2: {
                subbandAn2 = subbandAn3;
                n6 = subbandAn2.resLvl;
                subbandAn2 = (SubbandAn)subbandAn2.getSubbandByIdx(0, 0);
                int n14 = 0;
                while (n14 <= n6) {
                    subbandAn = subbandAn2;
                    while (subbandAn != null) {
                        float f3 = f / (subbandAn.l2Norm * (float)(1 << subbandAn.anGainExp));
                        this.hbuf.writeShort(StdQuantizer.convertToExpMantissa(f3));
                        subbandAn = (SubbandAn)subbandAn.nextSubband();
                    }
                    subbandAn2 = (SubbandAn)subbandAn2.getNextResLevel();
                    ++n14;
                }
                break;
            }
            default: {
                throw new Error("Internal JJ2000 error");
            }
        }
    }

    protected void writeTileQCD(int n) throws IOException {
        SubbandAn subbandAn;
        int n2;
        SubbandAn subbandAn2;
        int n3;
        String string = (String)this.wp.getQuantizationType().getTileDef(n);
        float f = ((Float)this.wp.getQuantizationStep().getTileDef(n)).floatValue();
        int n4 = (Integer)this.wp.getDecompositionLevel().getTileDef(n);
        int n5 = this.dwt.getNumComps();
        boolean bl = true;
        int n6 = 0;
        int n7 = 0;
        while (n7 < n5 && bl) {
            int n8 = (Integer)this.wp.getDecompositionLevel().getTileCompVal(n, n7);
            String string2 = (String)this.wp.getQuantizationStep().getTileCompVal(n, n7);
            if (n8 == n4 && string2.equals(string)) {
                n6 = n7;
                bl = false;
            }
            ++n7;
        }
        if (bl) {
            throw new Error("Default representative for quantization type  and number of decomposition levels not found  in tile QCD (t=" + n + ") marker segment. " + "You have found a JJ2000 bug.");
        }
        SubbandAn subbandAn3 = this.dwt.getAnSubbandTree(n, n6);
        this.deftilenr = this.dwt.getNomRangeBits(n6);
        n7 = (Integer)this.wp.getGuardBits().getTileDef(n);
        boolean bl2 = string.equals("derived");
        boolean bl3 = string.equals("reversible");
        int n9 = bl3 ? 0 : (bl2 ? 1 : 2);
        this.hbuf.writeShort(-164);
        switch (n9) {
            case 1: {
                n3 = 1;
                break;
            }
            case 0: 
            case 2: {
                n3 = 0;
                subbandAn2 = subbandAn3;
                subbandAn2 = (SubbandAn)subbandAn2.getSubbandByIdx(0, 0);
                n2 = 0;
                while (n2 <= n4) {
                    subbandAn = subbandAn2;
                    while (subbandAn != null) {
                        ++n3;
                        subbandAn = (SubbandAn)subbandAn.nextSubband();
                    }
                    subbandAn2 = (SubbandAn)subbandAn2.getNextResLevel();
                    ++n2;
                }
                break;
            }
            default: {
                throw new Error("Internal JJ2000 error");
            }
        }
        n2 = 3 + (bl3 ? n3 : 2 * n3);
        this.hbuf.writeShort(n2);
        this.hbuf.write(n9 + (n7 << 5));
        switch (n9) {
            case 0: {
                subbandAn2 = subbandAn3;
                subbandAn2 = (SubbandAn)subbandAn2.getSubbandByIdx(0, 0);
                int n10 = 0;
                while (n10 <= n4) {
                    subbandAn = subbandAn2;
                    while (subbandAn != null) {
                        int n11 = this.deftilenr + subbandAn.anGainExp;
                        this.hbuf.write(n11 << 3);
                        subbandAn = (SubbandAn)subbandAn.nextSubband();
                    }
                    subbandAn2 = (SubbandAn)subbandAn2.getNextResLevel();
                    ++n10;
                }
                break;
            }
            case 1: {
                subbandAn2 = subbandAn3;
                subbandAn2 = (SubbandAn)subbandAn2.getSubbandByIdx(0, 0);
                float f2 = f / (float)(1 << subbandAn2.level);
                this.hbuf.writeShort(StdQuantizer.convertToExpMantissa(f2));
                break;
            }
            case 2: {
                subbandAn2 = subbandAn3;
                subbandAn2 = (SubbandAn)subbandAn2.getSubbandByIdx(0, 0);
                int n12 = 0;
                while (n12 <= n4) {
                    subbandAn = subbandAn2;
                    while (subbandAn != null) {
                        float f3 = f / (subbandAn.l2Norm * (float)(1 << subbandAn.anGainExp));
                        this.hbuf.writeShort(StdQuantizer.convertToExpMantissa(f3));
                        subbandAn = (SubbandAn)subbandAn.nextSubband();
                    }
                    subbandAn2 = (SubbandAn)subbandAn2.getNextResLevel();
                    ++n12;
                }
                break;
            }
            default: {
                throw new Error("Internal JJ2000 error");
            }
        }
    }

    protected void writeTileQCC(int n, int n2) throws IOException {
        SubbandAn subbandAn;
        int n3;
        SubbandAn subbandAn2;
        int n4;
        SubbandAn subbandAn3 = this.dwt.getAnSubbandTree(n, n2);
        int n5 = this.dwt.getNomRangeBits(n2);
        String string = (String)this.wp.getQuantizationType().getTileCompVal(n, n2);
        float f = ((Float)this.wp.getQuantizationStep().getTileCompVal(n, n2)).floatValue();
        int n6 = (Integer)this.wp.getGuardBits().getTileCompVal(n, n2);
        boolean bl = string.equals("reversible");
        boolean bl2 = string.equals("derived");
        int n7 = (Integer)this.wp.getDecompositionLevel().getTileCompVal(n, n2);
        int n8 = bl ? 0 : (bl2 ? 1 : 2);
        this.hbuf.writeShort(-163);
        switch (n8) {
            case 1: {
                n4 = 1;
                break;
            }
            case 0: 
            case 2: {
                n4 = 0;
                subbandAn2 = subbandAn3;
                n7 = subbandAn2.resLvl;
                subbandAn2 = (SubbandAn)subbandAn2.getSubbandByIdx(0, 0);
                while (subbandAn2.resLvl != 0) {
                    subbandAn2 = subbandAn2.subb_LL;
                }
                n3 = 0;
                while (n3 <= n7) {
                    subbandAn = subbandAn2;
                    while (subbandAn != null) {
                        ++n4;
                        subbandAn = (SubbandAn)subbandAn.nextSubband();
                    }
                    subbandAn2 = (SubbandAn)subbandAn2.getNextResLevel();
                    ++n3;
                }
                break;
            }
            default: {
                throw new Error("Internal JJ2000 error");
            }
        }
        n3 = 3 + (this.nComp < 257 ? 1 : 2) + (bl ? n4 : 2 * n4);
        this.hbuf.writeShort(n3);
        if (this.nComp < 257) {
            this.hbuf.write(n2);
        } else {
            this.hbuf.writeShort(n2);
        }
        this.hbuf.write(n8 + (n6 << 5));
        switch (n8) {
            case 0: {
                subbandAn2 = subbandAn3;
                subbandAn2 = (SubbandAn)subbandAn2.getSubbandByIdx(0, 0);
                int n9 = 0;
                while (n9 <= n7) {
                    subbandAn = subbandAn2;
                    while (subbandAn != null) {
                        int n10 = n5 + subbandAn.anGainExp;
                        this.hbuf.write(n10 << 3);
                        subbandAn = (SubbandAn)subbandAn.nextSubband();
                    }
                    subbandAn2 = (SubbandAn)subbandAn2.getNextResLevel();
                    ++n9;
                }
                break;
            }
            case 1: {
                subbandAn2 = subbandAn3;
                subbandAn2 = (SubbandAn)subbandAn2.getSubbandByIdx(0, 0);
                float f2 = f / (float)(1 << subbandAn2.level);
                this.hbuf.writeShort(StdQuantizer.convertToExpMantissa(f2));
                break;
            }
            case 2: {
                subbandAn2 = subbandAn3;
                n7 = subbandAn2.resLvl;
                subbandAn2 = (SubbandAn)subbandAn2.getSubbandByIdx(0, 0);
                int n11 = 0;
                while (n11 <= n7) {
                    subbandAn = subbandAn2;
                    while (subbandAn != null) {
                        float f3 = f / (subbandAn.l2Norm * (float)(1 << subbandAn.anGainExp));
                        this.hbuf.writeShort(StdQuantizer.convertToExpMantissa(f3));
                        subbandAn = (SubbandAn)subbandAn.nextSubband();
                    }
                    subbandAn2 = (SubbandAn)subbandAn2.getNextResLevel();
                    ++n11;
                }
                break;
            }
            default: {
                throw new Error("Internal JJ2000 error");
            }
        }
    }

    protected void writePOC(boolean bl, int n) throws IOException {
        int n2 = 0;
        Progression[] progressionArray = null;
        progressionArray = bl ? (Progression[])this.wp.getProgressionType().getDefault() : (Progression[])this.wp.getProgressionType().getTileDef(n);
        int n3 = this.nComp < 257 ? 1 : 2;
        this.hbuf.writeShort(-161);
        int n4 = progressionArray.length;
        n2 = 2 + n4 * (1 + n3 + 2 + 1 + n3 + 1);
        this.hbuf.writeShort(n2);
        int n5 = 0;
        while (n5 < n4) {
            this.hbuf.write(progressionArray[n5].rs);
            if (n3 == 2) {
                this.hbuf.writeShort(progressionArray[n5].cs);
            } else {
                this.hbuf.write(progressionArray[n5].cs);
            }
            this.hbuf.writeShort(progressionArray[n5].lye);
            this.hbuf.write(progressionArray[n5].re);
            if (n3 == 2) {
                this.hbuf.writeShort(progressionArray[n5].ce);
            } else {
                this.hbuf.write(progressionArray[n5].ce);
            }
            this.hbuf.write(progressionArray[n5].type);
            ++n5;
        }
    }

    public void encodeMainHeader() throws IOException {
        this.writeSOC();
        this.writeSIZ();
        boolean bl = ((String)this.wp.getTerminateOnByte().getDefault()).equals("predict");
        this.writeCOD(true, 0);
        int n = 0;
        while (n < this.nComp) {
            boolean bl2 = ((String)this.wp.getTerminateOnByte().getCompDef(n)).equals("predict");
            if (this.wp.getFilters().isCompSpecified(n) || this.wp.getDecompositionLevel().isCompSpecified(n) || this.wp.getBypass().isCompSpecified(n) || this.wp.getResetMQ().isCompSpecified(n) || this.wp.getMethodForMQTermination().isCompSpecified(n) || this.wp.getCodeSegSymbol().isCompSpecified(n) || this.wp.getCausalCXInfo().isCompSpecified(n) || this.wp.getPrecinctPartition().isCompSpecified(n) || this.wp.getCodeBlockSize().isCompSpecified(n) || bl != bl2) {
                this.writeCOC(true, 0, n);
            }
            ++n;
        }
        this.writeMainQCD();
        n = 0;
        while (n < this.nComp) {
            if (this.dwt.getNomRangeBits(n) != this.defimgn || this.wp.getQuantizationType().isCompSpecified(n) || this.wp.getQuantizationStep().isCompSpecified(n) || this.wp.getDecompositionLevel().isCompSpecified(n) || this.wp.getGuardBits().isCompSpecified(n)) {
                this.writeMainQCC(n);
            }
            ++n;
        }
        Progression[] progressionArray = (Progression[])this.wp.getProgressionType().getDefault();
        if (progressionArray.length > 1) {
            this.writePOC(true, 0);
        }
        this.writeCOM();
    }

    private void writeCOM() throws IOException {
        Object object;
        if (this.enJJ2KMarkSeg) {
            object = "Created by: JJ2000 version 4.1";
            this.hbuf.writeShort(-156);
            int n = 4 + ((String)object).length();
            this.hbuf.writeShort(n);
            this.hbuf.writeShort(1);
            byte[] byArray = ((String)object).getBytes();
            int n2 = 0;
            while (n2 < byArray.length) {
                this.hbuf.writeByte(byArray[n2]);
                ++n2;
            }
        }
        if (this.otherCOMMarkSeg != null) {
            object = new StringTokenizer(this.otherCOMMarkSeg, "#");
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string = ((StringTokenizer)object).nextToken();
                this.hbuf.writeShort(-156);
                int n = 4 + string.length();
                this.hbuf.writeShort(n);
                this.hbuf.writeShort(1);
                byte[] byArray = string.getBytes();
                int n3 = 0;
                while (n3 < byArray.length) {
                    this.hbuf.writeByte(byArray[n3]);
                    ++n3;
                }
            }
        }
    }

    private void writeRGN(int n) throws IOException {
        int n2 = 0;
        while (n2 < this.nComp) {
            this.hbuf.writeShort(-162);
            int n3 = 4 + (this.nComp < 257 ? 1 : 2);
            this.hbuf.writeShort(n3);
            if (this.nComp < 257) {
                this.hbuf.writeByte(n2);
            } else {
                this.hbuf.writeShort(n2);
            }
            this.hbuf.writeByte(0);
            this.hbuf.writeByte((Integer)this.wp.getROIs().getTileCompVal(n, n2));
            ++n2;
        }
    }

    public void encodeTilePartHeader(int n, int n2) throws IOException {
        Progression[] progressionArray;
        int n3;
        Point point = this.ralloc.getNumTiles(null);
        this.ralloc.setTile(n2 % point.x, n2 / point.x);
        this.hbuf.writeByte(-1);
        this.hbuf.writeByte(-112);
        this.hbuf.writeByte(0);
        this.hbuf.writeByte(10);
        if (n2 > 65534) {
            throw new IllegalArgumentException("Trying to write a tile-part header whose tile index is too high");
        }
        this.hbuf.writeByte(n2 >> 8);
        this.hbuf.writeByte(n2);
        int n4 = n;
        this.hbuf.writeByte(n4 >> 24);
        this.hbuf.writeByte(n4 >> 16);
        this.hbuf.writeByte(n4 >> 8);
        this.hbuf.writeByte(n4);
        this.hbuf.writeByte(0);
        this.hbuf.writeByte(1);
        int n5 = ((String)this.wp.getMethodForMQTermination().getDefault()).equals("predict");
        int n6 = ((String)this.wp.getMethodForMQTermination().getTileDef(n2)).equals("predict");
        boolean bl = false;
        if (this.wp.getFilters().isTileSpecified(n2) || this.wp.getComponentTransformation().isTileSpecified(n2) || this.wp.getDecompositionLevel().isTileSpecified(n2) || this.wp.getBypass().isTileSpecified(n2) || this.wp.getResetMQ().isTileSpecified(n2) || this.wp.getTerminateOnByte().isTileSpecified(n2) || this.wp.getCausalCXInfo().isTileSpecified(n2) || this.wp.getPrecinctPartition().isTileSpecified(n2) || this.wp.getSOP().isTileSpecified(n2) || this.wp.getCodeSegSymbol().isTileSpecified(n2) || this.wp.getProgressionType().isTileSpecified(n2) || this.wp.getEPH().isTileSpecified(n2) || this.wp.getCodeBlockSize().isTileSpecified(n2) || n5 != n6) {
            this.writeCOD(false, n2);
            bl = true;
        }
        int n7 = 0;
        while (n7 < this.nComp) {
            n3 = ((String)this.wp.getMethodForMQTermination().getTileCompVal(n2, n7)).equals("predict");
            if (this.wp.getFilters().isTileCompSpecified(n2, n7) || this.wp.getDecompositionLevel().isTileCompSpecified(n2, n7) || this.wp.getBypass().isTileCompSpecified(n2, n7) || this.wp.getResetMQ().isTileCompSpecified(n2, n7) || this.wp.getTerminateOnByte().isTileCompSpecified(n2, n7) || this.wp.getCausalCXInfo().isTileCompSpecified(n2, n7) || this.wp.getPrecinctPartition().isTileCompSpecified(n2, n7) || this.wp.getCodeSegSymbol().isTileCompSpecified(n2, n7) || this.wp.getCodeBlockSize().isTileCompSpecified(n2, n7) || n3 != n5) {
                this.writeCOC(false, n2, n7);
            } else if (bl && (this.wp.getFilters().isCompSpecified(n7) || this.wp.getDecompositionLevel().isCompSpecified(n7) || this.wp.getBypass().isCompSpecified(n7) || this.wp.getResetMQ().isCompSpecified(n7) || this.wp.getTerminateOnByte().isCompSpecified(n7) || this.wp.getCodeSegSymbol().isCompSpecified(n7) || this.wp.getCausalCXInfo().isCompSpecified(n7) || this.wp.getPrecinctPartition().isCompSpecified(n7) || this.wp.getCodeBlockSize().isCompSpecified(n7) || this.wp.getMethodForMQTermination().isCompSpecified(n7) && ((String)this.wp.getMethodForMQTermination().getCompDef(n7)).equals("predict"))) {
                this.writeCOC(false, n2, n7);
            }
            ++n7;
        }
        n7 = 0;
        if (this.wp.getQuantizationType().isTileSpecified(n2) || this.wp.getQuantizationStep().isTileSpecified(n2) || this.wp.getDecompositionLevel().isTileSpecified(n2) || this.wp.getGuardBits().isTileSpecified(n2)) {
            this.writeTileQCD(n2);
            n7 = 1;
        } else {
            this.deftilenr = this.defimgn;
        }
        n3 = 0;
        while (n3 < this.nComp) {
            if (this.dwt.getNomRangeBits(n3) != this.deftilenr || this.wp.getQuantizationType().isTileCompSpecified(n2, n3) || this.wp.getQuantizationStep().isTileCompSpecified(n2, n3) || this.wp.getDecompositionLevel().isTileCompSpecified(n2, n3) || this.wp.getGuardBits().isTileCompSpecified(n2, n3)) {
                this.writeTileQCC(n2, n3);
            } else if (n7 != 0 && (this.wp.getQuantizationType().isCompSpecified(n3) || this.wp.getQuantizationStep().isCompSpecified(n3) || this.wp.getDecompositionLevel().isCompSpecified(n3) || this.wp.getGuardBits().isCompSpecified(n3))) {
                this.writeTileQCC(n2, n3);
            }
            ++n3;
        }
        if (this.roiSc.useRoi() && !this.roiSc.getBlockAligned()) {
            this.writeRGN(n2);
        }
        if (this.wp.getProgressionType().isTileSpecified(n2) && (progressionArray = (Progression[])this.wp.getProgressionType().getTileDef(n2)).length > 1) {
            this.writePOC(false, n2);
        }
        this.hbuf.writeByte(-1);
        this.hbuf.writeByte(-109);
    }
}

