/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.codestream.reader;

import java.awt.Point;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.Vector;
import jj2000.j2k.codestream.CBlkCoordInfo;
import jj2000.j2k.codestream.PrecInfo;
import jj2000.j2k.codestream.reader.BitstreamReaderAgent;
import jj2000.j2k.codestream.reader.CBlkInfo;
import jj2000.j2k.codestream.reader.HeaderDecoder;
import jj2000.j2k.codestream.reader.PktHeaderBitReader;
import jj2000.j2k.codestream.reader.TagTreeDecoder;
import jj2000.j2k.decoder.DecoderSpecs;
import jj2000.j2k.entropy.StdEntropyCoderOptions;
import jj2000.j2k.io.RandomAccessIO;
import jj2000.j2k.util.ArrayUtil;
import jj2000.j2k.util.MathUtil;
import jj2000.j2k.wavelet.synthesis.SubbandSyn;

public class PktDecoder
implements StdEntropyCoderOptions {
    private BitstreamReaderAgent src;
    private boolean pph = false;
    private ByteArrayInputStream pphbais;
    private DecoderSpecs decSpec;
    private HeaderDecoder hd;
    private final int INIT_LBLOCK = 3;
    private PktHeaderBitReader bin;
    private RandomAccessIO ehs;
    private Point[][] numPrec;
    private int tIdx;
    private PrecInfo[][][] ppinfo;
    private int[][][][][] lblock;
    private TagTreeDecoder[][][][] ttIncl;
    private TagTreeDecoder[][][][] ttMaxBP;
    private int nl = 0;
    private int nc;
    private boolean sopUsed = false;
    private boolean ephUsed = false;
    private int pktIdx;
    private Vector[] cblks;
    private int ncb;
    private int maxCB;
    private boolean ncbQuit;
    private int tQuit;
    private int cQuit;
    private int sQuit;
    private int rQuit;
    private int xQuit;
    private int yQuit;
    private boolean isTruncMode;

    public PktDecoder(DecoderSpecs decoderSpecs, HeaderDecoder headerDecoder, RandomAccessIO randomAccessIO, BitstreamReaderAgent bitstreamReaderAgent, boolean bl, int n) {
        this.decSpec = decoderSpecs;
        this.hd = headerDecoder;
        this.ehs = randomAccessIO;
        this.isTruncMode = bl;
        this.bin = new PktHeaderBitReader(randomAccessIO);
        this.src = bitstreamReaderAgent;
        this.ncb = 0;
        this.ncbQuit = false;
        this.maxCB = n;
    }

    public CBlkInfo[][][][][] restart(int n, int[] nArray, int n2, CBlkInfo[][][][][] cBlkInfoArray, boolean bl, ByteArrayInputStream byteArrayInputStream) {
        this.nc = n;
        this.nl = n2;
        this.tIdx = this.src.getTileIdx();
        this.pph = bl;
        this.pphbais = byteArrayInputStream;
        this.sopUsed = (Boolean)this.decSpec.sops.getTileDef(this.tIdx);
        this.pktIdx = 0;
        this.ephUsed = (Boolean)this.decSpec.ephs.getTileDef(this.tIdx);
        cBlkInfoArray = new CBlkInfo[n][][][][];
        this.lblock = new int[n][][][][];
        this.ttIncl = new TagTreeDecoder[n][][][];
        this.ttMaxBP = new TagTreeDecoder[n][][][];
        this.numPrec = new Point[n][];
        this.ppinfo = new PrecInfo[n][][];
        Point point = null;
        int n3 = this.src.getCbULX();
        int n4 = this.src.getCbULY();
        int n5 = 0;
        while (n5 < n) {
            cBlkInfoArray[n5] = new CBlkInfo[nArray[n5] + 1][][][];
            this.lblock[n5] = new int[nArray[n5] + 1][][][];
            this.ttIncl[n5] = new TagTreeDecoder[nArray[n5] + 1][][];
            this.ttMaxBP[n5] = new TagTreeDecoder[nArray[n5] + 1][][];
            this.numPrec[n5] = new Point[nArray[n5] + 1];
            this.ppinfo[n5] = new PrecInfo[nArray[n5] + 1][];
            int n6 = this.src.getResULX(n5, nArray[n5]);
            int n7 = this.src.getResULY(n5, nArray[n5]);
            int n8 = n6 + this.src.getTileCompWidth(this.tIdx, n5, nArray[n5]);
            int n9 = n7 + this.src.getTileCompHeight(this.tIdx, n5, nArray[n5]);
            int n10 = 0;
            while (n10 <= nArray[n5]) {
                int n11 = (int)Math.ceil((double)n6 / (double)(1 << nArray[n5] - n10));
                int n12 = (int)Math.ceil((double)n7 / (double)(1 << nArray[n5] - n10));
                int n13 = (int)Math.ceil((double)n8 / (double)(1 << nArray[n5] - n10));
                int n14 = (int)Math.ceil((double)n9 / (double)(1 << nArray[n5] - n10));
                double d = this.getPPX(this.tIdx, n5, n10);
                double d2 = this.getPPY(this.tIdx, n5, n10);
                this.numPrec[n5][n10] = new Point();
                this.numPrec[n5][n10].x = n13 > n11 ? (int)Math.ceil((double)(n13 - n3) / d) - (int)Math.floor((double)(n11 - n3) / d) : 0;
                this.numPrec[n5][n10].y = n14 > n12 ? (int)Math.ceil((double)(n14 - n4) / d2) - (int)Math.floor((double)(n12 - n4) / d2) : 0;
                int n15 = n10 == 0 ? 0 : 1;
                int n16 = n10 == 0 ? 1 : 4;
                int n17 = this.numPrec[n5][n10].x * this.numPrec[n5][n10].y;
                this.ttIncl[n5][n10] = new TagTreeDecoder[n17][n16 + 1];
                this.ttMaxBP[n5][n10] = new TagTreeDecoder[n17][n16 + 1];
                cBlkInfoArray[n5][n10] = new CBlkInfo[n16 + 1][][];
                this.lblock[n5][n10] = new int[n16 + 1][][];
                this.ppinfo[n5][n10] = new PrecInfo[n17];
                this.fillPrecInfo(n5, n10, nArray[n5]);
                SubbandSyn subbandSyn = this.src.getSynSubbandTree(this.tIdx, n5);
                int n18 = n15;
                while (n18 < n16) {
                    SubbandSyn subbandSyn2 = (SubbandSyn)subbandSyn.getSubbandByIdx(n10, n18);
                    point = subbandSyn2.numCb;
                    cBlkInfoArray[n5][n10][n18] = new CBlkInfo[point.y][point.x];
                    this.lblock[n5][n10][n18] = new int[point.y][point.x];
                    int n19 = point.y - 1;
                    while (n19 >= 0) {
                        ArrayUtil.intArraySet(this.lblock[n5][n10][n18][n19], 3);
                        --n19;
                    }
                    ++n18;
                }
                ++n10;
            }
            ++n5;
        }
        return cBlkInfoArray;
    }

    private void fillPrecInfo(int n, int n2, int n3) {
        int n4;
        if (this.ppinfo[n][n2].length == 0) {
            return;
        }
        Point point = this.src.getTile(null);
        Point point2 = this.src.getNumTiles(null);
        int n5 = this.src.getTilePartULX();
        int n6 = this.src.getTilePartULY();
        int n7 = this.src.getNomTileWidth();
        int n8 = this.src.getNomTileHeight();
        int n9 = this.hd.getImgULX();
        int n10 = this.hd.getImgULY();
        int n11 = this.hd.getImgWidth();
        int n12 = this.hd.getImgHeight();
        int n13 = point.x == 0 ? n9 : n5 + point.x * n7;
        int n14 = n4 = point.y == 0 ? n10 : n6 + point.y * n8;
        if (point.x != point2.x - 1) {
            int cfr_ignored_0 = point.x;
        }
        if (point.y != point2.y - 1) {
            int cfr_ignored_1 = point.y;
        }
        int n15 = this.hd.getCompSubsX(n);
        int n16 = this.hd.getCompSubsY(n);
        int n17 = this.src.getResULX(n, n3);
        int n18 = this.src.getResULY(n, n3);
        int n19 = n17 + this.src.getTileCompWidth(this.tIdx, n, n3);
        int n20 = n18 + this.src.getTileCompHeight(this.tIdx, n, n3);
        int n21 = n3 - n2;
        int n22 = (int)Math.ceil((double)n17 / (double)(1 << n21));
        int n23 = (int)Math.ceil((double)n18 / (double)(1 << n21));
        int n24 = (int)Math.ceil((double)n19 / (double)(1 << n21));
        int n25 = (int)Math.ceil((double)n20 / (double)(1 << n21));
        int n26 = this.src.getCbULX();
        int n27 = this.src.getCbULY();
        double d = this.getPPX(this.tIdx, n, n2);
        double d2 = this.getPPY(this.tIdx, n, n2);
        int n28 = (int)(d / 2.0);
        int n29 = (int)(d2 / 2.0);
        int cfr_ignored_2 = this.ppinfo[n][n2].length;
        int n30 = 0;
        int n31 = (int)Math.floor((double)(n23 - n27) / d2);
        int n32 = (int)Math.floor((double)(n25 - 1 - n27) / d2);
        int n33 = (int)Math.floor((double)(n22 - n26) / d);
        int n34 = (int)Math.floor((double)(n24 - 1 - n26) / d);
        SubbandSyn subbandSyn = this.src.getSynSubbandTree(this.tIdx, n);
        SubbandSyn subbandSyn2 = null;
        int n35 = (int)d << n21;
        int n36 = (int)d2 << n21;
        int n37 = n31;
        while (n37 <= n32) {
            int n38 = n33;
            while (n38 <= n34) {
                int n39;
                int n40;
                CBlkCoordInfo cBlkCoordInfo;
                int n41;
                int n42;
                int n43;
                int n44;
                int n45;
                int n46;
                int n47;
                int n48;
                int n49;
                int n50;
                int n51;
                int n52;
                int n53;
                int n54;
                int n55;
                int n56;
                int n57;
                int n58;
                int n59;
                int n60;
                int n61 = n38 == n33 && (n22 - n26) % (n15 * (int)d) != 0 ? n13 : n26 + n38 * n15 * ((int)d << n21);
                int n62 = n37 == n31 && (n23 - n27) % (n16 * (int)d2) != 0 ? n4 : n27 + n37 * n16 * ((int)d2 << n21);
                this.ppinfo[n][n2][n30] = new PrecInfo(n2, (int)((double)n26 + (double)n38 * d), (int)((double)n27 + (double)n37 * d2), (int)d, (int)d2, n61, n62, n35, n36);
                if (n2 == 0) {
                    n60 = n26;
                    n59 = n27;
                    n58 = n60 + n38 * (int)d;
                    n57 = n58 + (int)d;
                    n56 = n59 + n37 * (int)d2;
                    n55 = n56 + (int)d2;
                    subbandSyn2 = (SubbandSyn)subbandSyn.getSubbandByIdx(0, 0);
                    n54 = n58 < subbandSyn2.ulcx ? subbandSyn2.ulcx : n58;
                    n53 = n57 > subbandSyn2.ulcx + subbandSyn2.w ? subbandSyn2.ulcx + subbandSyn2.w : n57;
                    n52 = n56 < subbandSyn2.ulcy ? subbandSyn2.ulcy : n56;
                    n51 = n55 > subbandSyn2.ulcy + subbandSyn2.h ? subbandSyn2.ulcy + subbandSyn2.h : n55;
                    n50 = subbandSyn2.nomCBlkW;
                    n49 = subbandSyn2.nomCBlkH;
                    n48 = (int)Math.floor((double)(subbandSyn2.ulcy - n59) / (double)n49);
                    n47 = (int)Math.floor((double)(n52 - n59) / (double)n49);
                    n46 = (int)Math.floor((double)(n51 - 1 - n59) / (double)n49);
                    n45 = (int)Math.floor((double)(subbandSyn2.ulcx - n60) / (double)n50);
                    n44 = (int)Math.floor((double)(n54 - n60) / (double)n50);
                    n43 = (int)Math.floor((double)(n53 - 1 - n60) / (double)n50);
                    if (n53 - n54 <= 0 || n51 - n52 <= 0) {
                        this.ppinfo[n][n2][n30].nblk[0] = 0;
                        this.ttIncl[n][n2][n30][0] = new TagTreeDecoder(0, 0);
                        this.ttMaxBP[n][n2][n30][0] = new TagTreeDecoder(0, 0);
                    } else {
                        this.ttIncl[n][n2][n30][0] = new TagTreeDecoder(n46 - n47 + 1, n43 - n44 + 1);
                        this.ttMaxBP[n][n2][n30][0] = new TagTreeDecoder(n46 - n47 + 1, n43 - n44 + 1);
                        this.ppinfo[n][n2][n30].cblk[0] = new CBlkCoordInfo[n46 - n47 + 1][n43 - n44 + 1];
                        this.ppinfo[n][n2][n30].nblk[0] = (n46 - n47 + 1) * (n43 - n44 + 1);
                        n42 = n47;
                        while (n42 <= n46) {
                            n41 = n44;
                            while (n41 <= n43) {
                                cBlkCoordInfo = new CBlkCoordInfo(n42 - n48, n41 - n45);
                                cBlkCoordInfo.ulx = n41 == n45 ? subbandSyn2.ulx : subbandSyn2.ulx + n41 * n50 - (subbandSyn2.ulcx - n60);
                                cBlkCoordInfo.uly = n42 == n48 ? subbandSyn2.uly : subbandSyn2.uly + n42 * n49 - (subbandSyn2.ulcy - n59);
                                n40 = n60 + n41 * n50;
                                n40 = n40 > subbandSyn2.ulcx ? n40 : subbandSyn2.ulcx;
                                n39 = n60 + (n41 + 1) * n50;
                                n39 = n39 > subbandSyn2.ulcx + subbandSyn2.w ? subbandSyn2.ulcx + subbandSyn2.w : n39;
                                cBlkCoordInfo.w = n39 - n40;
                                n40 = n59 + n42 * n49;
                                n40 = n40 > subbandSyn2.ulcy ? n40 : subbandSyn2.ulcy;
                                n39 = n59 + (n42 + 1) * n49;
                                n39 = n39 > subbandSyn2.ulcy + subbandSyn2.h ? subbandSyn2.ulcy + subbandSyn2.h : n39;
                                cBlkCoordInfo.h = n39 - n40;
                                this.ppinfo[n][n2][n30].cblk[0][n42 - n47][n41 - n44] = cBlkCoordInfo;
                                ++n41;
                            }
                            ++n42;
                        }
                    }
                } else {
                    n60 = 0;
                    n59 = n27;
                    n58 = n60 + n38 * n28;
                    n57 = n58 + n28;
                    n56 = n59 + n37 * n29;
                    n55 = n56 + n29;
                    subbandSyn2 = (SubbandSyn)subbandSyn.getSubbandByIdx(n2, 1);
                    n54 = n58 < subbandSyn2.ulcx ? subbandSyn2.ulcx : n58;
                    n53 = n57 > subbandSyn2.ulcx + subbandSyn2.w ? subbandSyn2.ulcx + subbandSyn2.w : n57;
                    n52 = n56 < subbandSyn2.ulcy ? subbandSyn2.ulcy : n56;
                    n51 = n55 > subbandSyn2.ulcy + subbandSyn2.h ? subbandSyn2.ulcy + subbandSyn2.h : n55;
                    n50 = subbandSyn2.nomCBlkW;
                    n49 = subbandSyn2.nomCBlkH;
                    n48 = (int)Math.floor((double)(subbandSyn2.ulcy - n59) / (double)n49);
                    n47 = (int)Math.floor((double)(n52 - n59) / (double)n49);
                    n46 = (int)Math.floor((double)(n51 - 1 - n59) / (double)n49);
                    n45 = (int)Math.floor((double)(subbandSyn2.ulcx - n60) / (double)n50);
                    n44 = (int)Math.floor((double)(n54 - n60) / (double)n50);
                    n43 = (int)Math.floor((double)(n53 - 1 - n60) / (double)n50);
                    if (n53 - n54 <= 0 || n51 - n52 <= 0) {
                        this.ppinfo[n][n2][n30].nblk[1] = 0;
                        this.ttIncl[n][n2][n30][1] = new TagTreeDecoder(0, 0);
                        this.ttMaxBP[n][n2][n30][1] = new TagTreeDecoder(0, 0);
                    } else {
                        this.ttIncl[n][n2][n30][1] = new TagTreeDecoder(n46 - n47 + 1, n43 - n44 + 1);
                        this.ttMaxBP[n][n2][n30][1] = new TagTreeDecoder(n46 - n47 + 1, n43 - n44 + 1);
                        this.ppinfo[n][n2][n30].cblk[1] = new CBlkCoordInfo[n46 - n47 + 1][n43 - n44 + 1];
                        this.ppinfo[n][n2][n30].nblk[1] = (n46 - n47 + 1) * (n43 - n44 + 1);
                        n42 = n47;
                        while (n42 <= n46) {
                            n41 = n44;
                            while (n41 <= n43) {
                                cBlkCoordInfo = new CBlkCoordInfo(n42 - n48, n41 - n45);
                                cBlkCoordInfo.ulx = n41 == n45 ? subbandSyn2.ulx : subbandSyn2.ulx + n41 * n50 - (subbandSyn2.ulcx - n60);
                                cBlkCoordInfo.uly = n42 == n48 ? subbandSyn2.uly : subbandSyn2.uly + n42 * n49 - (subbandSyn2.ulcy - n59);
                                n40 = n60 + n41 * n50;
                                n40 = n40 > subbandSyn2.ulcx ? n40 : subbandSyn2.ulcx;
                                n39 = n60 + (n41 + 1) * n50;
                                n39 = n39 > subbandSyn2.ulcx + subbandSyn2.w ? subbandSyn2.ulcx + subbandSyn2.w : n39;
                                cBlkCoordInfo.w = n39 - n40;
                                n40 = n59 + n42 * n49;
                                n40 = n40 > subbandSyn2.ulcy ? n40 : subbandSyn2.ulcy;
                                n39 = n59 + (n42 + 1) * n49;
                                n39 = n39 > subbandSyn2.ulcy + subbandSyn2.h ? subbandSyn2.ulcy + subbandSyn2.h : n39;
                                cBlkCoordInfo.h = n39 - n40;
                                this.ppinfo[n][n2][n30].cblk[1][n42 - n47][n41 - n44] = cBlkCoordInfo;
                                ++n41;
                            }
                            ++n42;
                        }
                    }
                    n60 = n26;
                    n59 = 0;
                    n58 = n60 + n38 * n28;
                    n57 = n58 + n28;
                    n56 = n59 + n37 * n29;
                    n55 = n56 + n29;
                    subbandSyn2 = (SubbandSyn)subbandSyn.getSubbandByIdx(n2, 2);
                    n54 = n58 < subbandSyn2.ulcx ? subbandSyn2.ulcx : n58;
                    n53 = n57 > subbandSyn2.ulcx + subbandSyn2.w ? subbandSyn2.ulcx + subbandSyn2.w : n57;
                    n52 = n56 < subbandSyn2.ulcy ? subbandSyn2.ulcy : n56;
                    n51 = n55 > subbandSyn2.ulcy + subbandSyn2.h ? subbandSyn2.ulcy + subbandSyn2.h : n55;
                    n50 = subbandSyn2.nomCBlkW;
                    n49 = subbandSyn2.nomCBlkH;
                    n48 = (int)Math.floor((double)(subbandSyn2.ulcy - n59) / (double)n49);
                    n47 = (int)Math.floor((double)(n52 - n59) / (double)n49);
                    n46 = (int)Math.floor((double)(n51 - 1 - n59) / (double)n49);
                    n45 = (int)Math.floor((double)(subbandSyn2.ulcx - n60) / (double)n50);
                    n44 = (int)Math.floor((double)(n54 - n60) / (double)n50);
                    n43 = (int)Math.floor((double)(n53 - 1 - n60) / (double)n50);
                    if (n53 - n54 <= 0 || n51 - n52 <= 0) {
                        this.ppinfo[n][n2][n30].nblk[2] = 0;
                        this.ttIncl[n][n2][n30][2] = new TagTreeDecoder(0, 0);
                        this.ttMaxBP[n][n2][n30][2] = new TagTreeDecoder(0, 0);
                    } else {
                        this.ttIncl[n][n2][n30][2] = new TagTreeDecoder(n46 - n47 + 1, n43 - n44 + 1);
                        this.ttMaxBP[n][n2][n30][2] = new TagTreeDecoder(n46 - n47 + 1, n43 - n44 + 1);
                        this.ppinfo[n][n2][n30].cblk[2] = new CBlkCoordInfo[n46 - n47 + 1][n43 - n44 + 1];
                        this.ppinfo[n][n2][n30].nblk[2] = (n46 - n47 + 1) * (n43 - n44 + 1);
                        n42 = n47;
                        while (n42 <= n46) {
                            n41 = n44;
                            while (n41 <= n43) {
                                cBlkCoordInfo = new CBlkCoordInfo(n42 - n48, n41 - n45);
                                cBlkCoordInfo.ulx = n41 == n45 ? subbandSyn2.ulx : subbandSyn2.ulx + n41 * n50 - (subbandSyn2.ulcx - n60);
                                cBlkCoordInfo.uly = n42 == n48 ? subbandSyn2.uly : subbandSyn2.uly + n42 * n49 - (subbandSyn2.ulcy - n59);
                                n40 = n60 + n41 * n50;
                                n40 = n40 > subbandSyn2.ulcx ? n40 : subbandSyn2.ulcx;
                                n39 = n60 + (n41 + 1) * n50;
                                n39 = n39 > subbandSyn2.ulcx + subbandSyn2.w ? subbandSyn2.ulcx + subbandSyn2.w : n39;
                                cBlkCoordInfo.w = n39 - n40;
                                n40 = n59 + n42 * n49;
                                n40 = n40 > subbandSyn2.ulcy ? n40 : subbandSyn2.ulcy;
                                n39 = n59 + (n42 + 1) * n49;
                                n39 = n39 > subbandSyn2.ulcy + subbandSyn2.h ? subbandSyn2.ulcy + subbandSyn2.h : n39;
                                cBlkCoordInfo.h = n39 - n40;
                                this.ppinfo[n][n2][n30].cblk[2][n42 - n47][n41 - n44] = cBlkCoordInfo;
                                ++n41;
                            }
                            ++n42;
                        }
                    }
                    n60 = 0;
                    n59 = 0;
                    n58 = n60 + n38 * n28;
                    n57 = n58 + n28;
                    n56 = n59 + n37 * n29;
                    n55 = n56 + n29;
                    subbandSyn2 = (SubbandSyn)subbandSyn.getSubbandByIdx(n2, 3);
                    n54 = n58 < subbandSyn2.ulcx ? subbandSyn2.ulcx : n58;
                    n53 = n57 > subbandSyn2.ulcx + subbandSyn2.w ? subbandSyn2.ulcx + subbandSyn2.w : n57;
                    n52 = n56 < subbandSyn2.ulcy ? subbandSyn2.ulcy : n56;
                    n51 = n55 > subbandSyn2.ulcy + subbandSyn2.h ? subbandSyn2.ulcy + subbandSyn2.h : n55;
                    n50 = subbandSyn2.nomCBlkW;
                    n49 = subbandSyn2.nomCBlkH;
                    n48 = (int)Math.floor((double)(subbandSyn2.ulcy - n59) / (double)n49);
                    n47 = (int)Math.floor((double)(n52 - n59) / (double)n49);
                    n46 = (int)Math.floor((double)(n51 - 1 - n59) / (double)n49);
                    n45 = (int)Math.floor((double)(subbandSyn2.ulcx - n60) / (double)n50);
                    n44 = (int)Math.floor((double)(n54 - n60) / (double)n50);
                    n43 = (int)Math.floor((double)(n53 - 1 - n60) / (double)n50);
                    if (n53 - n54 <= 0 || n51 - n52 <= 0) {
                        this.ppinfo[n][n2][n30].nblk[3] = 0;
                        this.ttIncl[n][n2][n30][3] = new TagTreeDecoder(0, 0);
                        this.ttMaxBP[n][n2][n30][3] = new TagTreeDecoder(0, 0);
                    } else {
                        this.ttIncl[n][n2][n30][3] = new TagTreeDecoder(n46 - n47 + 1, n43 - n44 + 1);
                        this.ttMaxBP[n][n2][n30][3] = new TagTreeDecoder(n46 - n47 + 1, n43 - n44 + 1);
                        this.ppinfo[n][n2][n30].cblk[3] = new CBlkCoordInfo[n46 - n47 + 1][n43 - n44 + 1];
                        this.ppinfo[n][n2][n30].nblk[3] = (n46 - n47 + 1) * (n43 - n44 + 1);
                        n42 = n47;
                        while (n42 <= n46) {
                            n41 = n44;
                            while (n41 <= n43) {
                                cBlkCoordInfo = new CBlkCoordInfo(n42 - n48, n41 - n45);
                                cBlkCoordInfo.ulx = n41 == n45 ? subbandSyn2.ulx : subbandSyn2.ulx + n41 * n50 - (subbandSyn2.ulcx - n60);
                                cBlkCoordInfo.uly = n42 == n48 ? subbandSyn2.uly : subbandSyn2.uly + n42 * n49 - (subbandSyn2.ulcy - n59);
                                n40 = n60 + n41 * n50;
                                n40 = n40 > subbandSyn2.ulcx ? n40 : subbandSyn2.ulcx;
                                n39 = n60 + (n41 + 1) * n50;
                                n39 = n39 > subbandSyn2.ulcx + subbandSyn2.w ? subbandSyn2.ulcx + subbandSyn2.w : n39;
                                cBlkCoordInfo.w = n39 - n40;
                                n40 = n59 + n42 * n49;
                                n40 = n40 > subbandSyn2.ulcy ? n40 : subbandSyn2.ulcy;
                                n39 = n59 + (n42 + 1) * n49;
                                n39 = n39 > subbandSyn2.ulcy + subbandSyn2.h ? subbandSyn2.ulcy + subbandSyn2.h : n39;
                                cBlkCoordInfo.h = n39 - n40;
                                this.ppinfo[n][n2][n30].cblk[3][n42 - n47][n41 - n44] = cBlkCoordInfo;
                                ++n41;
                            }
                            ++n42;
                        }
                    }
                }
                ++n38;
                ++n30;
            }
            ++n37;
        }
    }

    public int getNumPrecinct(int n, int n2) {
        return this.numPrec[n][n2].x * this.numPrec[n][n2].y;
    }

    public boolean readPktHead(int n, int n2, int n3, int n4, CBlkInfo[][][] cBlkInfoArray, int[] nArray) throws IOException {
        int n5;
        int n6 = this.ehs.getPos();
        if (n6 >= this.ehs.length()) {
            return true;
        }
        int n7 = this.src.getTileIdx();
        SubbandSyn subbandSyn = this.src.getSynSubbandTree(n7, n3);
        PktHeaderBitReader pktHeaderBitReader = this.pph ? new PktHeaderBitReader(this.pphbais) : this.bin;
        int n8 = n2 == 0 ? 0 : 1;
        int n9 = n2 == 0 ? 1 : 4;
        boolean bl = false;
        int n10 = n8;
        while (n10 < n9) {
            if (n4 < this.ppinfo[n3][n2].length) {
                bl = true;
            }
            ++n10;
        }
        if (!bl) {
            return false;
        }
        PrecInfo precInfo = this.ppinfo[n3][n2][n4];
        pktHeaderBitReader.sync();
        if (pktHeaderBitReader.readBit() == 0) {
            this.cblks = new Vector[n9 + 1];
            int n11 = n8;
            while (n11 < n9) {
                this.cblks[n11] = new Vector();
                ++n11;
            }
            ++this.pktIdx;
            if (this.isTruncMode && this.maxCB == -1) {
                int n12 = this.ehs.getPos() - n6;
                if (n12 > nArray[n7]) {
                    nArray[n7] = 0;
                    return true;
                }
                int n13 = n7;
                nArray[n13] = nArray[n13] - n12;
            }
            if (this.ephUsed) {
                this.readEPHMarker(pktHeaderBitReader);
            }
            return false;
        }
        if (this.cblks == null || this.cblks.length < n9 + 1) {
            this.cblks = new Vector[n9 + 1];
        }
        int n14 = n8;
        while (n14 < n9) {
            if (this.cblks[n14] == null) {
                this.cblks[n14] = new Vector();
            } else {
                this.cblks[n14].removeAllElements();
            }
            SubbandSyn subbandSyn2 = (SubbandSyn)subbandSyn.getSubbandByIdx(n2, n14);
            if (precInfo.nblk[n14] != 0) {
                TagTreeDecoder tagTreeDecoder = this.ttIncl[n3][n2][n4][n14];
                TagTreeDecoder tagTreeDecoder2 = this.ttMaxBP[n3][n2][n4][n14];
                int n15 = precInfo.cblk[n14] == null ? 0 : precInfo.cblk[n14].length;
                int n16 = 0;
                while (n16 < n15) {
                    int n17 = precInfo.cblk[n14][n16] == null ? 0 : precInfo.cblk[n14][n16].length;
                    int n18 = 0;
                    while (n18 < n17) {
                        block52: {
                            Point point = precInfo.cblk[n14][n16][n18].idx;
                            int cfr_ignored_0 = point.x + point.y * subbandSyn2.numCb.x;
                            CBlkInfo cBlkInfo = cBlkInfoArray[n14][point.y][point.x];
                            try {
                                int n19;
                                int n20;
                                int n21;
                                int n22;
                                int n23;
                                if (cBlkInfo == null || cBlkInfo.ctp == 0) {
                                    if (cBlkInfo == null) {
                                        CBlkInfo cBlkInfo2 = new CBlkInfo(precInfo.cblk[n14][n16][n18].ulx, precInfo.cblk[n14][n16][n18].uly, precInfo.cblk[n14][n16][n18].w, precInfo.cblk[n14][n16][n18].h, this.nl);
                                        cBlkInfoArray[n14][point.y][point.x] = cBlkInfo2;
                                        cBlkInfo = cBlkInfo2;
                                    }
                                    cBlkInfo.pktIdx[n] = this.pktIdx;
                                    n5 = tagTreeDecoder.update(n16, n18, n + 1, pktHeaderBitReader);
                                    if (n5 > n) break block52;
                                    n5 = 1;
                                    int n24 = 1;
                                    while (n5 >= n24) {
                                        n5 = tagTreeDecoder2.update(n16, n18, n24, pktHeaderBitReader);
                                        ++n24;
                                    }
                                    cBlkInfo.msbSkipped = n24 - 2;
                                    n23 = 1;
                                    cBlkInfo.addNTP(n, 0);
                                    ++this.ncb;
                                    if (this.maxCB != -1 && !this.ncbQuit && this.ncb == this.maxCB) {
                                        this.ncbQuit = true;
                                        this.tQuit = n7;
                                        this.cQuit = n3;
                                        this.sQuit = n14;
                                        this.rQuit = n2;
                                        this.xQuit = point.x;
                                        this.yQuit = point.y;
                                    }
                                } else {
                                    cBlkInfo.pktIdx[n] = this.pktIdx;
                                    if (pktHeaderBitReader.readBit() != 1) break block52;
                                    n23 = 1;
                                }
                                if (pktHeaderBitReader.readBit() == 1) {
                                    ++n23;
                                    if (pktHeaderBitReader.readBit() == 1) {
                                        ++n23;
                                        n5 = pktHeaderBitReader.readBits(2);
                                        n23 += n5;
                                        if (n5 == 3) {
                                            n5 = pktHeaderBitReader.readBits(5);
                                            n23 += n5;
                                            if (n5 == 31) {
                                                n23 += pktHeaderBitReader.readBits(7);
                                            }
                                        }
                                    }
                                }
                                cBlkInfo.addNTP(n, n23);
                                this.cblks[n14].addElement(precInfo.cblk[n14][n16][n18]);
                                int n25 = (Integer)this.decSpec.ecopts.getTileCompVal(n7, n3);
                                if ((n25 & 4) != 0) {
                                    n22 = n23;
                                } else if ((n25 & 1) != 0) {
                                    if (cBlkInfo.ctp <= 10) {
                                        n22 = 1;
                                    } else {
                                        n22 = 1;
                                        n21 = cBlkInfo.ctp - n23;
                                        while (n21 < cBlkInfo.ctp - 1) {
                                            if (n21 >= 9 && ((n20 = (n21 + 2) % 3) == 1 || n20 == 2)) {
                                                ++n22;
                                            }
                                            ++n21;
                                        }
                                    }
                                } else {
                                    n22 = 1;
                                }
                                while (pktHeaderBitReader.readBit() != 0) {
                                    int[] nArray2 = this.lblock[n3][n2][n14][point.y];
                                    int n26 = point.x;
                                    nArray2[n26] = nArray2[n26] + 1;
                                }
                                if (n22 == 1) {
                                    n19 = pktHeaderBitReader.readBits(this.lblock[n3][n2][n14][point.y][point.x] + MathUtil.log2(n23));
                                } else {
                                    int n27;
                                    int n28;
                                    cBlkInfo.segLen[n] = new int[n22];
                                    n19 = 0;
                                    if ((n25 & 4) != 0) {
                                        n21 = cBlkInfo.ctp - n23;
                                        n28 = 0;
                                        while (n21 < cBlkInfo.ctp) {
                                            n27 = this.lblock[n3][n2][n14][point.y][point.x];
                                            cBlkInfo.segLen[n][n28] = n5 = pktHeaderBitReader.readBits(n27);
                                            n19 += n5;
                                            ++n21;
                                            ++n28;
                                        }
                                    } else {
                                        int n29 = cBlkInfo.ctp - n23 - 1;
                                        n21 = cBlkInfo.ctp - n23;
                                        n28 = 0;
                                        while (n21 < cBlkInfo.ctp - 1) {
                                            if (n21 >= 9 && (n20 = (n21 + 2) % 3) != 0) {
                                                n27 = this.lblock[n3][n2][n14][point.y][point.x];
                                                cBlkInfo.segLen[n][n28] = n5 = pktHeaderBitReader.readBits(n27 + MathUtil.log2(n21 - n29));
                                                n19 += n5;
                                                n29 = n21;
                                                ++n28;
                                            }
                                            ++n21;
                                        }
                                        n27 = this.lblock[n3][n2][n14][point.y][point.x];
                                        n5 = pktHeaderBitReader.readBits(n27 + MathUtil.log2(n21 - n29));
                                        n19 += n5;
                                        cBlkInfo.segLen[n][n28] = n5;
                                    }
                                }
                                cBlkInfo.len[n] = n19;
                                if (this.isTruncMode && this.maxCB == -1 && (n5 = this.ehs.getPos() - n6) > nArray[n7]) {
                                    nArray[n7] = 0;
                                    if (n == 0) {
                                        cBlkInfoArray[n14][point.y][point.x] = null;
                                    } else {
                                        cBlkInfo.len[n] = 0;
                                        cBlkInfo.off[n] = 0;
                                        cBlkInfo.ctp -= cBlkInfo.ntp[n];
                                        cBlkInfo.ntp[n] = 0;
                                        cBlkInfo.pktIdx[n] = -1;
                                    }
                                    return true;
                                }
                            }
                            catch (EOFException eOFException) {
                                if (n == 0) {
                                    cBlkInfoArray[n14][point.y][point.x] = null;
                                } else {
                                    cBlkInfo.len[n] = 0;
                                    cBlkInfo.off[n] = 0;
                                    cBlkInfo.ctp -= cBlkInfo.ntp[n];
                                    cBlkInfo.ntp[n] = 0;
                                    cBlkInfo.pktIdx[n] = -1;
                                }
                                return true;
                            }
                        }
                        ++n18;
                    }
                    ++n16;
                }
            }
            ++n14;
        }
        if (this.ephUsed) {
            this.readEPHMarker(pktHeaderBitReader);
        }
        ++this.pktIdx;
        if (this.isTruncMode && this.maxCB == -1) {
            n5 = this.ehs.getPos() - n6;
            if (n5 > nArray[n7]) {
                nArray[n7] = 0;
                return true;
            }
            int n30 = n7;
            nArray[n30] = nArray[n30] - n5;
        }
        return false;
    }

    public boolean readPktBody(int n, int n2, int n3, int n4, CBlkInfo[][][] cBlkInfoArray, int[] nArray) throws IOException {
        int n5 = this.ehs.getPos();
        boolean bl = false;
        int n6 = this.src.getTileIdx();
        boolean bl2 = false;
        int n7 = n2 == 0 ? 0 : 1;
        int n8 = n2 == 0 ? 1 : 4;
        int n9 = n7;
        while (n9 < n8) {
            if (n4 < this.ppinfo[n3][n2].length) {
                bl2 = true;
            }
            ++n9;
        }
        if (!bl2) {
            return false;
        }
        n9 = n7;
        while (n9 < n8) {
            int n10 = 0;
            while (n10 < this.cblks[n9].size()) {
                Point point = ((CBlkCoordInfo)this.cblks[n9].elementAt((int)n10)).idx;
                CBlkInfo cBlkInfo = cBlkInfoArray[n9][point.y][point.x];
                cBlkInfo.off[n] = n5;
                n5 += cBlkInfo.len[n];
                try {
                    this.ehs.seek(n5);
                }
                catch (EOFException eOFException) {
                    if (n == 0) {
                        cBlkInfoArray[n9][point.y][point.x] = null;
                    } else {
                        cBlkInfo.len[n] = 0;
                        cBlkInfo.off[n] = 0;
                        cBlkInfo.ctp -= cBlkInfo.ntp[n];
                        cBlkInfo.ntp[n] = 0;
                        cBlkInfo.pktIdx[n] = -1;
                    }
                    throw new EOFException();
                }
                if (this.isTruncMode) {
                    if (bl || cBlkInfo.len[n] > nArray[n6]) {
                        if (n == 0) {
                            cBlkInfoArray[n9][point.y][point.x] = null;
                        } else {
                            cBlkInfo.len[n] = 0;
                            cBlkInfo.off[n] = 0;
                            cBlkInfo.ctp -= cBlkInfo.ntp[n];
                            cBlkInfo.ntp[n] = 0;
                            cBlkInfo.pktIdx[n] = -1;
                        }
                        bl = true;
                    }
                    if (!bl) {
                        int n11 = n6;
                        nArray[n11] = nArray[n11] - cBlkInfo.len[n];
                    }
                }
                if (this.ncbQuit && n2 == this.rQuit && n9 == this.sQuit && point.x == this.xQuit && point.y == this.yQuit && n6 == this.tQuit && n3 == this.cQuit) {
                    cBlkInfoArray[n9][point.y][point.x] = null;
                    bl = true;
                }
                ++n10;
            }
            ++n9;
        }
        this.ehs.seek(n5);
        return bl;
    }

    public final int getPPX(int n, int n2, int n3) {
        return this.decSpec.pss.getPPX(n, n2, n3);
    }

    public final int getPPY(int n, int n2, int n3) {
        return this.decSpec.pss.getPPY(n, n2, n3);
    }

    public boolean readSOPMarker(int[] nArray, int n, int n2, int n3) throws IOException {
        byte[] byArray = new byte[6];
        int n4 = this.src.getTileIdx();
        int n5 = n3 == 0 ? 0 : 1;
        int n6 = n3 == 0 ? 1 : 4;
        boolean bl = false;
        int n7 = n5;
        while (n7 < n6) {
            if (n < this.ppinfo[n2][n3].length) {
                bl = true;
            }
            ++n7;
        }
        if (!bl) {
            return false;
        }
        if (!this.sopUsed) {
            return false;
        }
        n7 = this.ehs.getPos();
        if ((short)(this.ehs.read() << 8 | this.ehs.read()) != -111) {
            this.ehs.seek(n7);
            return false;
        }
        this.ehs.seek(n7);
        if (nArray[n4] < 6) {
            return true;
        }
        int n8 = n4;
        nArray[n8] = nArray[n8] - 6;
        this.ehs.readFully(byArray, 0, 6);
        int n9 = byArray[0];
        n9 <<= 8;
        if ((n9 |= byArray[1]) != -111) {
            throw new Error("Corrupted Bitstream: Could not parse SOP marker !");
        }
        n9 = byArray[2] & 0xFF;
        n9 <<= 8;
        if ((n9 |= byArray[3] & 0xFF) != 4) {
            throw new Error("Corrupted Bitstream: Corrupted SOP marker !");
        }
        n9 = byArray[4] & 0xFF;
        n9 <<= 8;
        if (!this.pph && (n9 |= byArray[5] & 0xFF) != this.pktIdx) {
            throw new Error("Corrupted Bitstream: SOP marker out of sequence !");
        }
        if (this.pph && n9 != this.pktIdx - 1) {
            throw new Error("Corrupted Bitstream: SOP marker out of sequence !");
        }
        return false;
    }

    public void readEPHMarker(PktHeaderBitReader pktHeaderBitReader) throws IOException {
        byte[] byArray = new byte[2];
        if (pktHeaderBitReader.usebais) {
            pktHeaderBitReader.bais.read(byArray, 0, 2);
        } else {
            pktHeaderBitReader.in.readFully(byArray, 0, 2);
        }
        int n = byArray[0];
        n <<= 8;
        if ((n |= byArray[1]) != -110) {
            throw new Error("Corrupted Bitstream: Could not parse EPH marker ! ");
        }
    }

    public PrecInfo getPrecInfo(int n, int n2, int n3) {
        return this.ppinfo[n][n2][n3];
    }
}

