/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.codestream.reader;

import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReadParamJava;
import java.awt.Point;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Vector;
import javax.imageio.stream.MemoryCacheImageInputStream;
import jj2000.j2k.JJ2KExceptionHandler;
import jj2000.j2k.NoNextElementException;
import jj2000.j2k.NotImplementedError;
import jj2000.j2k.codestream.CorruptedCodestreamException;
import jj2000.j2k.codestream.HeaderInfo;
import jj2000.j2k.codestream.Markers;
import jj2000.j2k.codestream.PrecInfo;
import jj2000.j2k.codestream.ProgressionType;
import jj2000.j2k.codestream.reader.BitstreamReaderAgent;
import jj2000.j2k.codestream.reader.CBlkInfo;
import jj2000.j2k.codestream.reader.HeaderDecoder;
import jj2000.j2k.codestream.reader.PktDecoder;
import jj2000.j2k.decoder.DecoderSpecs;
import jj2000.j2k.entropy.StdEntropyCoderOptions;
import jj2000.j2k.entropy.decoder.DecLyrdCBlk;
import jj2000.j2k.io.RandomAccessIO;
import jj2000.j2k.quantization.dequantizer.StdDequantizerParams;
import jj2000.j2k.util.ArrayUtil;
import jj2000.j2k.util.FacilityManager;
import jj2000.j2k.util.MathUtil;
import jj2000.j2k.wavelet.synthesis.SubbandSyn;

public class FileBitstreamReaderAgent
extends BitstreamReaderAgent
implements Markers,
ProgressionType,
StdEntropyCoderOptions {
    private boolean isPsotEqualsZero = true;
    public PktDecoder pktDec;
    private J2KImageReadParamJava j2krparam;
    private RandomAccessIO in;
    private int nt;
    private int[][] firstPackOff;
    private int[] nBytes;
    private boolean printInfo = false;
    private int[] baknBytes;
    private int[][] tilePartLen;
    private int[] totTileLen;
    private int[] totTileHeadLen;
    private int firstTilePartHeadLen;
    private double totAllTileLen;
    private int mainHeadLen;
    private int headLen = 0;
    private int[][] tilePartHeadLen;
    private Vector pktHL;
    private boolean isTruncMode;
    private int remainingTileParts;
    private int[] tilePartsRead;
    private int totTilePartsRead = 0;
    private int[] tileParts;
    private int[] totTileParts;
    private int curTilePart;
    private int[][] tilePartNum;
    private boolean isEOCFound = false;
    private HeaderInfo hi;
    private CBlkInfo[][][][][] cbI;
    private int lQuit;
    private boolean usePOCQuit = false;
    long[][] tilePartPositions = null;
    int cdstreamStart = 0;
    int t = 0;
    int pos = -1;
    int tp = 0;
    int tptot = 0;
    int tilePartStart = 0;
    boolean rateReached = false;
    int numtp = 0;
    int maxTP = this.nt;
    int lastPos = 0;
    int maxPos = 0;

    public int getNumTileParts(int n) {
        if (this.firstPackOff == null || this.firstPackOff[n] == null) {
            throw new Error("Tile " + n + " not found in input codestream.");
        }
        return this.firstPackOff[n].length;
    }

    public CBlkInfo[][][][][] getCBlkInfo() {
        return this.cbI;
    }

    public FileBitstreamReaderAgent(HeaderDecoder headerDecoder, RandomAccessIO randomAccessIO, DecoderSpecs decoderSpecs, J2KImageReadParamJava j2KImageReadParamJava, boolean bl, HeaderInfo headerInfo) throws IOException {
        super(headerDecoder, decoderSpecs);
        this.j2krparam = j2KImageReadParamJava;
        this.printInfo = bl;
        this.hi = headerInfo;
        String string = this.printInfo ? "Codestream elements information in bytes (offset, total length, header length):\n\n" : null;
        this.tnbytes = j2KImageReadParamJava.getDecodingRate() == Double.MAX_VALUE ? Integer.MAX_VALUE : (int)(j2KImageReadParamJava.getDecodingRate() * (double)headerDecoder.getMaxCompImgWidth() * (double)headerDecoder.getMaxCompImgHeight()) / 8;
        this.isTruncMode = true;
        int n = -1;
        if (n != -1 && !this.isTruncMode) {
            throw new Error("Cannot use -parsing and -ncb_quit condition at the same time.");
        }
        this.lQuit = -1;
        this.nt = this.ntX * this.ntY;
        this.in = randomAccessIO;
        this.pktDec = new PktDecoder(decoderSpecs, headerDecoder, randomAccessIO, this, this.isTruncMode, n);
        this.tileParts = new int[this.nt];
        this.totTileParts = new int[this.nt];
        this.totTileLen = new int[this.nt];
        this.tilePartLen = new int[this.nt][];
        this.tilePartNum = new int[this.nt][];
        this.firstPackOff = new int[this.nt][];
        this.tilePartsRead = new int[this.nt];
        this.totTileHeadLen = new int[this.nt];
        this.tilePartHeadLen = new int[this.nt][];
        this.nBytes = new int[this.nt];
        this.baknBytes = new int[this.nt];
        headerDecoder.nTileParts = new int[this.nt];
        this.isTruncMode = this.isTruncMode;
        this.cdstreamStart = headerDecoder.mainHeadOff;
        this.headLen = this.mainHeadLen = this.in.getPos() - this.cdstreamStart;
        this.anbytes = n == -1 ? this.mainHeadLen : 0;
        if (this.printInfo) {
            string = String.valueOf(string) + "Main header length    : " + this.cdstreamStart + ", " + this.mainHeadLen + ", " + this.mainHeadLen + "\n";
        }
        if (this.anbytes > this.tnbytes) {
            throw new Error("Requested bitrate is too small.");
        }
        this.totAllTileLen = 0.0;
        this.remainingTileParts = this.nt;
        this.maxPos = this.lastPos = this.in.getPos();
        if (j2KImageReadParamJava.getResolution() == -1) {
            this.targetRes = decoderSpecs.dls.getMin();
        } else {
            this.targetRes = j2KImageReadParamJava.getResolution();
            if (this.targetRes < 0) {
                throw new IllegalArgumentException("Specified negative resolution level index: " + this.targetRes);
            }
        }
        int n2 = decoderSpecs.dls.getMin();
        if (this.targetRes > n2) {
            FacilityManager.getMsgLogger().printmsg(2, "Specified resolution level (" + this.targetRes + ") is larger" + " than the maximum possible. Setting it to " + n2 + " (maximum possible)");
            this.targetRes = n2;
        }
        this.initTLM();
    }

    private void initTLM() throws IOException {
        int n = this.in.getPos();
        byte[][] byArrayArray = null;
        int n2 = 0;
        try {
            short s;
            this.in.seek(this.cdstreamStart + 2);
            while ((s = this.in.readShort()) != -112) {
                int n3 = this.in.readUnsignedShort();
                if (s == -171) {
                    ++n2;
                    if (byArrayArray == null) {
                        byArrayArray = new byte[256][];
                    }
                    int n4 = this.in.read();
                    byArrayArray[n4] = new byte[n3 - 3];
                    this.in.readFully(byArrayArray[n4], 0, n3 - 3);
                    continue;
                }
                this.in.skipBytes(n3 - 2);
            }
        }
        catch (IOException iOException) {
            byArrayArray = null;
        }
        if (byArrayArray != null) {
            int n5;
            Object object;
            ArrayList[] arrayListArray = null;
            long l = this.cdstreamStart + this.mainHeadLen;
            int n6 = 0;
            int n7 = 0;
            while (n7 < n2) {
                if (byArrayArray[n7] == null) {
                    arrayListArray = null;
                    break;
                }
                if (arrayListArray == null) {
                    arrayListArray = new ArrayList[this.nt];
                }
                object = new ByteArrayInputStream(byArrayArray[n7]);
                MemoryCacheImageInputStream memoryCacheImageInputStream = new MemoryCacheImageInputStream((InputStream)object);
                try {
                    int n8 = memoryCacheImageInputStream.read();
                    n5 = n8 >> 4 & 3;
                    int n9 = n8 >> 6 & 1;
                    int n10 = byArrayArray[n7].length;
                    while (memoryCacheImageInputStream.getStreamPosition() < (long)n10) {
                        int n11 = n6;
                        switch (n5) {
                            case 1: {
                                n11 = memoryCacheImageInputStream.read();
                                break;
                            }
                            case 2: {
                                n11 = memoryCacheImageInputStream.readUnsignedShort();
                            }
                        }
                        if (arrayListArray[n11] == null) {
                            arrayListArray[n11] = new ArrayList();
                        }
                        arrayListArray[n11].add(new Long(l));
                        long l2 = 0L;
                        switch (n9) {
                            case 0: {
                                l2 = memoryCacheImageInputStream.readUnsignedShort();
                                break;
                            }
                            case 1: {
                                l2 = memoryCacheImageInputStream.readUnsignedInt();
                            }
                        }
                        l += l2;
                        if (n5 != 0) continue;
                        ++n6;
                    }
                }
                catch (IOException iOException) {}
                ++n7;
            }
            if (arrayListArray != null) {
                this.tilePartPositions = new long[this.nt][];
                n7 = 0;
                while (n7 < this.nt) {
                    if (arrayListArray[n7] == null) {
                        this.tilePartPositions = null;
                        break;
                    }
                    object = arrayListArray[n7];
                    int n12 = ((ArrayList)object).size();
                    this.tilePartPositions[n7] = new long[n12];
                    long[] lArray = this.tilePartPositions[n7];
                    n5 = 0;
                    while (n5 < n12) {
                        lArray[n5] = (Long)((ArrayList)object).get(n5);
                        ++n5;
                    }
                    ++n7;
                }
            }
        }
        this.in.seek(n);
    }

    private void initTile(int n) throws IOException {
        int n2;
        boolean bl;
        boolean bl2;
        String string;
        block32: {
            if (this.tilePartPositions == null) {
                this.in.seek(this.lastPos);
            }
            string = "";
            int n3 = -1;
            bl2 = false;
            bl = false;
            try {
                n2 = 0;
                while (this.remainingTileParts != 0 && (this.totTileParts[n] == 0 || this.tilePartsRead[n] < this.totTileParts[n])) {
                    bl2 = true;
                    if (this.tilePartPositions != null) {
                        this.in.seek((int)this.tilePartPositions[n][n2++]);
                    }
                    this.tilePartStart = this.in.getPos();
                    try {
                        this.t = this.readTilePartHeader();
                        if (this.isEOCFound) break;
                        this.tp = this.tilePartsRead[this.t];
                        if (this.isPsotEqualsZero) {
                            this.tilePartLen[this.t][this.tp] = this.in.length() - 2 - this.tilePartStart;
                        }
                    }
                    catch (EOFException eOFException) {
                        this.firstPackOff[this.t][this.tp] = this.in.length();
                        throw eOFException;
                    }
                    this.pos = this.in.getPos();
                    if (this.isTruncMode && n3 == -1 && this.pos - this.cdstreamStart > this.tnbytes) {
                        this.firstPackOff[this.t][this.tp] = this.in.length();
                        this.rateReached = true;
                        break;
                    }
                    this.firstPackOff[this.t][this.tp] = this.pos;
                    this.tilePartHeadLen[this.t][this.tp] = this.pos - this.tilePartStart;
                    if (this.printInfo) {
                        string = String.valueOf(string) + "Tile-part " + this.tp + " of tile " + this.t + " : " + this.tilePartStart + ", " + this.tilePartLen[this.t][this.tp] + ", " + this.tilePartHeadLen[this.t][this.tp] + "\n";
                    }
                    int n4 = this.t;
                    this.totTileLen[n4] = this.totTileLen[n4] + this.tilePartLen[this.t][this.tp];
                    int n5 = this.t;
                    this.totTileHeadLen[n5] = this.totTileHeadLen[n5] + this.tilePartHeadLen[this.t][this.tp];
                    this.totAllTileLen += (double)this.tilePartLen[this.t][this.tp];
                    if (this.isTruncMode) {
                        if (this.anbytes + this.tilePartLen[this.t][this.tp] > this.tnbytes) {
                            this.anbytes += this.tilePartHeadLen[this.t][this.tp];
                            this.headLen += this.tilePartHeadLen[this.t][this.tp];
                            this.rateReached = true;
                            int n6 = this.t;
                            this.nBytes[n6] = this.nBytes[n6] + (this.tnbytes - this.anbytes);
                            break;
                        }
                        this.anbytes += this.tilePartHeadLen[this.t][this.tp];
                        this.headLen += this.tilePartHeadLen[this.t][this.tp];
                        int n7 = this.t;
                        this.nBytes[n7] = this.nBytes[n7] + (this.tilePartLen[this.t][this.tp] - this.tilePartHeadLen[this.t][this.tp]);
                    } else {
                        if (this.anbytes + this.tilePartHeadLen[this.t][this.tp] > this.tnbytes) break;
                        this.anbytes += this.tilePartHeadLen[this.t][this.tp];
                        this.headLen += this.tilePartHeadLen[this.t][this.tp];
                    }
                    if (this.tptot == 0) {
                        this.firstTilePartHeadLen = this.tilePartHeadLen[this.t][this.tp];
                    }
                    int n8 = this.t;
                    this.tilePartsRead[n8] = this.tilePartsRead[n8] + 1;
                    int n9 = this.tilePartStart + this.tilePartLen[this.t][this.tp];
                    if (this.tilePartPositions == null) {
                        this.in.seek(n9);
                    }
                    if (n9 > this.maxPos) {
                        this.maxPos = n9;
                    }
                    --this.remainingTileParts;
                    --this.maxTP;
                    ++this.tptot;
                    if (!this.isPsotEqualsZero) continue;
                    if (this.remainingTileParts != 0) {
                        FacilityManager.getMsgLogger().printmsg(2, "Some tile-parts have not been found. The codestream may be corrupted.");
                    }
                    break;
                }
            }
            catch (EOFException eOFException) {
                bl = true;
                if (this.printInfo) {
                    FacilityManager.getMsgLogger().printmsg(1, string);
                }
                FacilityManager.getMsgLogger().printmsg(2, "Codestream truncated in tile " + this.t);
                n2 = this.in.length();
                if (n2 >= this.tnbytes) break block32;
                this.tnbytes = n2;
                this.trate = (float)this.tnbytes * 8.0f / (float)this.hd.getMaxCompImgWidth() / (float)this.hd.getMaxCompImgHeight();
            }
        }
        if (!bl2) {
            return;
        }
        if (!bl) {
            if (this.printInfo) {
                FacilityManager.getMsgLogger().printmsg(1, string);
            }
            if (!(this.remainingTileParts != 0 || this.isEOCFound || this.isPsotEqualsZero || this.rateReached)) {
                try {
                    n2 = this.in.getPos();
                    this.in.seek(this.maxPos);
                    if (this.in.readShort() != -39) {
                        FacilityManager.getMsgLogger().printmsg(2, "EOC marker not found. Codestream is corrupted.");
                    }
                    this.in.seek(n2);
                }
                catch (EOFException eOFException) {
                    FacilityManager.getMsgLogger().printmsg(2, "EOC marker is missing");
                }
            }
        }
        if (!this.isTruncMode) {
            this.allocateRate();
        } else if (this.remainingTileParts == 0 && !bl && this.in.getPos() >= this.tnbytes) {
            this.anbytes += 2;
        }
        if (this.tilePartPositions == null) {
            this.lastPos = this.in.getPos();
        }
        n2 = 0;
        while (n2 < this.nt) {
            this.baknBytes[n2] = this.nBytes[n2];
            if (this.printInfo) {
                FacilityManager.getMsgLogger().println(this.hi.toStringTileHeader(n2, this.tilePartLen[n2].length), 2, 2);
            }
            ++n2;
        }
    }

    private void allocateRate() throws IOException {
        int n;
        int n2 = this.tnbytes;
        if (this.remainingTileParts == 0) {
            this.anbytes += 2;
        }
        if (this.anbytes > n2) {
            throw new Error("Requested bitrate is too small for parsing");
        }
        int n3 = n = n2 - this.anbytes;
        int n4 = this.nt - 1;
        while (n4 > 0) {
            this.nBytes[n4] = (int)((double)n3 * ((double)this.totTileLen[n4] / this.totAllTileLen));
            n -= this.nBytes[n4];
            --n4;
        }
        this.nBytes[0] = n;
    }

    private int readTilePartHeader() throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        HeaderInfo.SOT sOT = this.hi.getNewSOT();
        short s = this.in.readShort();
        if (s != -112) {
            if (s == -39) {
                this.isEOCFound = true;
                return -1;
            }
            throw new CorruptedCodestreamException("SOT tag not found in tile-part start");
        }
        this.isEOCFound = false;
        sOT.lsot = n5 = this.in.readUnsignedShort();
        if (n5 != 10) {
            throw new CorruptedCodestreamException("Wrong length for SOT marker segment: " + n5);
        }
        sOT.isot = n4 = this.in.readUnsignedShort();
        if (n4 > 65534) {
            throw new CorruptedCodestreamException("Tile index too high in tile-part.");
        }
        sOT.psot = n3 = this.in.readInt();
        boolean bl = this.isPsotEqualsZero = n3 == 0;
        if (n3 < 0) {
            throw new NotImplementedError("Tile length larger than maximum supported");
        }
        sOT.tpsot = n2 = this.in.read();
        if (n2 != this.tilePartsRead[n4] || n2 < 0 || n2 > 254) {
            throw new CorruptedCodestreamException("Out of order tile-part");
        }
        sOT.tnsot = n = this.in.read();
        this.hi.sot.put("t" + n4 + "_tp" + n2, sOT);
        if (n == 0) {
            int n6;
            if (this.tileParts[n4] == 0 || this.tileParts[n4] == this.tilePartLen.length) {
                n6 = 2;
                ++this.remainingTileParts;
            } else {
                n6 = 1;
            }
            int n7 = n4;
            this.tileParts[n7] = this.tileParts[n7] + n6;
            n = this.tileParts[n4];
            FacilityManager.getMsgLogger().printmsg(2, "Header of tile-part " + n2 + " of tile " + n4 + ", does not indicate the total" + " number of tile-parts. Assuming that there are " + n + " tile-parts for this tile.");
            int[] nArray = this.tilePartLen[n4];
            this.tilePartLen[n4] = new int[n];
            int n8 = 0;
            while (n8 < n - n6) {
                this.tilePartLen[n4][n8] = nArray[n8];
                ++n8;
            }
            nArray = this.tilePartNum[n4];
            this.tilePartNum[n4] = new int[n];
            n8 = 0;
            while (n8 < n - n6) {
                this.tilePartNum[n4][n8] = nArray[n8];
                ++n8;
            }
            nArray = this.firstPackOff[n4];
            this.firstPackOff[n4] = new int[n];
            n8 = 0;
            while (n8 < n - n6) {
                this.firstPackOff[n4][n8] = nArray[n8];
                ++n8;
            }
            nArray = this.tilePartHeadLen[n4];
            this.tilePartHeadLen[n4] = new int[n];
            n8 = 0;
            while (n8 < n - n6) {
                this.tilePartHeadLen[n4][n8] = nArray[n8];
                ++n8;
            }
        } else {
            this.totTileParts[n4] = n;
            if (this.tileParts[n4] == 0) {
                this.remainingTileParts += n - 1;
                this.tileParts[n4] = n;
                this.tilePartLen[n4] = new int[n];
                this.tilePartNum[n4] = new int[n];
                this.firstPackOff[n4] = new int[n];
                this.tilePartHeadLen[n4] = new int[n];
            } else {
                if (this.tileParts[n4] > n) {
                    throw new CorruptedCodestreamException("Invalid number of tile-parts in tile " + n4 + ": " + n);
                }
                this.remainingTileParts += n - this.tileParts[n4];
                if (this.tileParts[n4] != n) {
                    int[] nArray = this.tilePartLen[n4];
                    this.tilePartLen[n4] = new int[n];
                    int n9 = 0;
                    while (n9 < this.tileParts[n4] - 1) {
                        this.tilePartLen[n4][n9] = nArray[n9];
                        ++n9;
                    }
                    nArray = this.tilePartNum[n4];
                    this.tilePartNum[n4] = new int[n];
                    n9 = 0;
                    while (n9 < this.tileParts[n4] - 1) {
                        this.tilePartNum[n4][n9] = nArray[n9];
                        ++n9;
                    }
                    nArray = this.firstPackOff[n4];
                    this.firstPackOff[n4] = new int[n];
                    n9 = 0;
                    while (n9 < this.tileParts[n4] - 1) {
                        this.firstPackOff[n4][n9] = nArray[n9];
                        ++n9;
                    }
                    nArray = this.tilePartHeadLen[n4];
                    this.tilePartHeadLen[n4] = new int[n];
                    n9 = 0;
                    while (n9 < this.tileParts[n4] - 1) {
                        this.tilePartHeadLen[n4][n9] = nArray[n9];
                        ++n9;
                    }
                }
            }
        }
        this.hd.resetHeaderMarkers();
        this.hd.nTileParts[n4] = n;
        do {
            this.hd.extractTilePartMarkSeg(this.in.readShort(), this.in, n4, n2);
        } while ((this.hd.getNumFoundMarkSeg() & 0x2000) == 0);
        this.hd.readFoundTilePartMarkSeg(n4, n2);
        this.tilePartLen[n4][n2] = n3;
        this.tilePartNum[n4][n2] = this.totTilePartsRead++;
        this.hd.setTileOfTileParts(n4);
        return n4;
    }

    private boolean readLyResCompPos(int[][] nArray, int n, int n2, int n3, int n4, int n5) throws IOException {
        int n6;
        int n7 = 10000;
        int n8 = n4;
        while (n8 < n5) {
            if (n8 < this.mdl.length) {
                n6 = n2;
                while (n6 < n3) {
                    if (nArray[n8] != null && n6 < nArray[n8].length && nArray[n8][n6] < n7) {
                        n7 = nArray[n8][n6];
                    }
                    ++n6;
                }
            }
            ++n8;
        }
        n8 = this.getTileIdx();
        boolean bl = false;
        int n9 = this.firstPackOff[n8][this.curTilePart] + this.tilePartLen[n8][this.curTilePart] - 1 - this.tilePartHeadLen[n8][this.curTilePart];
        int n10 = (Integer)this.decSpec.nls.getTileDef(n8);
        int n11 = 1;
        String string = this.printInfo ? "Tile " + this.getTileIdx() + " (tile-part:" + this.curTilePart + "): offset, length, header length\n" : null;
        boolean bl2 = false;
        if (((Boolean)this.decSpec.pphs.getTileDef(n8)).booleanValue()) {
            bl2 = true;
        }
        int n12 = n7;
        while (n12 < n) {
            int n13 = n2;
            while (n13 < n3) {
                int n14 = n4;
                while (n14 < n5) {
                    if (n14 < this.mdl.length && n13 < nArray[n14].length && n13 <= this.mdl[n14] && n12 >= nArray[n14][n13] && n12 < n10) {
                        n11 = this.pktDec.getNumPrecinct(n14, n13);
                        int n15 = 0;
                        while (n15 < n11) {
                            n6 = this.in.getPos();
                            if (bl2) {
                                this.pktDec.readPktHead(n12, n13, n14, n15, this.cbI[n14][n13], this.nBytes);
                            }
                            if (n6 > n9 && this.curTilePart < this.firstPackOff[n8].length - 1) {
                                ++this.curTilePart;
                                this.in.seek(this.firstPackOff[n8][this.curTilePart]);
                                n9 = this.in.getPos() + this.tilePartLen[n8][this.curTilePart] - 1 - this.tilePartHeadLen[n8][this.curTilePart];
                            }
                            if (bl = this.pktDec.readSOPMarker(this.nBytes, n15, n14, n13)) {
                                if (this.printInfo) {
                                    FacilityManager.getMsgLogger().printmsg(1, string);
                                }
                                return true;
                            }
                            if (!bl2) {
                                bl = this.pktDec.readPktHead(n12, n13, n14, n15, this.cbI[n14][n13], this.nBytes);
                            }
                            if (bl) {
                                if (this.printInfo) {
                                    FacilityManager.getMsgLogger().printmsg(1, string);
                                }
                                return true;
                            }
                            int n16 = this.in.getPos() - n6;
                            this.pktHL.addElement(new Integer(n16));
                            bl = this.pktDec.readPktBody(n12, n13, n14, n15, this.cbI[n14][n13], this.nBytes);
                            int n17 = this.in.getPos() - n6;
                            if (this.printInfo) {
                                string = String.valueOf(string) + " Pkt l=" + n12 + ",r=" + n13 + ",c=" + n14 + ",p=" + n15 + ": " + n6 + ", " + n17 + ", " + n16 + "\n";
                            }
                            if (bl) {
                                if (this.printInfo) {
                                    FacilityManager.getMsgLogger().printmsg(1, string);
                                }
                                return true;
                            }
                            ++n15;
                        }
                    }
                    ++n14;
                }
                ++n13;
            }
            ++n12;
        }
        if (this.printInfo) {
            FacilityManager.getMsgLogger().printmsg(1, string);
        }
        return false;
    }

    private boolean readResLyCompPos(int[][] nArray, int n, int n2, int n3, int n4, int n5) throws IOException {
        int n6;
        int n7 = this.getTileIdx();
        boolean bl = false;
        int n8 = this.firstPackOff[n7][this.curTilePart] + this.tilePartLen[n7][this.curTilePart] - 1 - this.tilePartHeadLen[n7][this.curTilePart];
        int n9 = 10000;
        int n10 = n4;
        while (n10 < n5) {
            if (n10 < this.mdl.length) {
                n6 = n2;
                while (n6 < n3) {
                    if (n6 <= this.mdl[n10] && nArray[n10] != null && n6 < nArray[n10].length && nArray[n10][n6] < n9) {
                        n9 = nArray[n10][n6];
                    }
                    ++n6;
                }
            }
            ++n10;
        }
        String string = this.printInfo ? "Tile " + this.getTileIdx() + " (tile-part:" + this.curTilePart + "): offset, length, header length\n" : null;
        n6 = (Integer)this.decSpec.nls.getTileDef(n7);
        boolean bl2 = false;
        if (((Boolean)this.decSpec.pphs.getTileDef(n7)).booleanValue()) {
            bl2 = true;
        }
        int n11 = 1;
        int n12 = n2;
        while (n12 < n3) {
            int n13 = n9;
            while (n13 < n) {
                int n14 = n4;
                while (n14 < n5) {
                    if (n14 < this.mdl.length && n12 <= this.mdl[n14] && n12 < nArray[n14].length && n13 >= nArray[n14][n12] && n13 < n6) {
                        n11 = this.pktDec.getNumPrecinct(n14, n12);
                        int n15 = 0;
                        while (n15 < n11) {
                            int n16 = this.in.getPos();
                            if (bl2) {
                                this.pktDec.readPktHead(n13, n12, n14, n15, this.cbI[n14][n12], this.nBytes);
                            }
                            if (n16 > n8 && this.curTilePart < this.firstPackOff[n7].length - 1) {
                                ++this.curTilePart;
                                this.in.seek(this.firstPackOff[n7][this.curTilePart]);
                                n8 = this.in.getPos() + this.tilePartLen[n7][this.curTilePart] - 1 - this.tilePartHeadLen[n7][this.curTilePart];
                            }
                            if (bl = this.pktDec.readSOPMarker(this.nBytes, n15, n14, n12)) {
                                if (this.printInfo) {
                                    FacilityManager.getMsgLogger().printmsg(1, string);
                                }
                                return true;
                            }
                            if (!bl2) {
                                bl = this.pktDec.readPktHead(n13, n12, n14, n15, this.cbI[n14][n12], this.nBytes);
                            }
                            if (bl) {
                                if (this.printInfo) {
                                    FacilityManager.getMsgLogger().printmsg(1, string);
                                }
                                return true;
                            }
                            int n17 = this.in.getPos() - n16;
                            this.pktHL.addElement(new Integer(n17));
                            bl = this.pktDec.readPktBody(n13, n12, n14, n15, this.cbI[n14][n12], this.nBytes);
                            int n18 = this.in.getPos() - n16;
                            if (this.printInfo) {
                                string = String.valueOf(string) + " Pkt l=" + n13 + ",r=" + n12 + ",c=" + n14 + ",p=" + n15 + ": " + n16 + ", " + n18 + ", " + n17 + "\n";
                            }
                            if (bl) {
                                if (this.printInfo) {
                                    FacilityManager.getMsgLogger().printmsg(1, string);
                                }
                                return true;
                            }
                            ++n15;
                        }
                    }
                    ++n14;
                }
                ++n13;
            }
            ++n12;
        }
        if (this.printInfo) {
            FacilityManager.getMsgLogger().printmsg(1, string);
        }
        return false;
    }

    private boolean readResPosCompLy(int[][] nArray, int n, int n2, int n3, int n4, int n5) throws IOException {
        PrecInfo precInfo;
        int n6;
        Point point = this.getNumTiles(null);
        Point point2 = this.getTile(null);
        int n7 = this.hd.getImgULX();
        int n8 = this.hd.getImgULY();
        int n9 = n7 + this.hd.getImgWidth();
        int n10 = n8 + this.hd.getImgHeight();
        int n11 = this.getTilePartULX();
        int n12 = this.getTilePartULY();
        int n13 = this.getNomTileWidth();
        int n14 = this.getNomTileHeight();
        int n15 = point2.x == 0 ? n7 : n11 + point2.x * n13;
        int n16 = point2.y == 0 ? n8 : n12 + point2.y * n14;
        int n17 = point2.x != point.x - 1 ? n11 + (point2.x + 1) * n13 : n9;
        int n18 = point2.y != point.y - 1 ? n12 + (point2.y + 1) * n14 : n10;
        int n19 = this.getTileIdx();
        int n20 = 0;
        int n21 = 0;
        int n22 = 0;
        int[][] nArrayArray = new int[n5][];
        int n23 = 100000;
        int n24 = n17;
        int n25 = n18;
        int n26 = n15;
        int n27 = n16;
        int n28 = n4;
        while (n28 < n5) {
            n6 = n2;
            while (n6 < n3) {
                if (n28 < this.mdl.length && n6 <= this.mdl[n28]) {
                    nArrayArray[n28] = new int[this.mdl[n28] + 1];
                    if (nArray[n28] != null && n6 < nArray[n28].length && nArray[n28][n6] < n23) {
                        n23 = nArray[n28][n6];
                    }
                    int n29 = this.pktDec.getNumPrecinct(n28, n6) - 1;
                    while (n29 >= 0) {
                        precInfo = this.pktDec.getPrecInfo(n28, n6, n29);
                        if (precInfo.rgulx != n15) {
                            if (precInfo.rgulx < n24) {
                                n24 = precInfo.rgulx;
                            }
                            if (precInfo.rgulx > n26) {
                                n26 = precInfo.rgulx;
                            }
                        }
                        if (precInfo.rguly != n16) {
                            if (precInfo.rguly < n25) {
                                n25 = precInfo.rguly;
                            }
                            if (precInfo.rguly > n27) {
                                n27 = precInfo.rguly;
                            }
                        }
                        if (n22 == 0) {
                            n20 = precInfo.rgw;
                            n21 = precInfo.rgh;
                        } else {
                            n20 = MathUtil.gcd(n20, precInfo.rgw);
                            n21 = MathUtil.gcd(n21, precInfo.rgh);
                        }
                        ++n22;
                        --n29;
                    }
                }
                ++n6;
            }
            ++n28;
        }
        if (n22 == 0) {
            throw new Error("Image cannot have no precinct");
        }
        n28 = (n27 - n25) / n21 + 1;
        n6 = (n26 - n24) / n20 + 1;
        boolean bl = false;
        int n30 = this.firstPackOff[n19][this.curTilePart] + this.tilePartLen[n19][this.curTilePart] - 1 - this.tilePartHeadLen[n19][this.curTilePart];
        int n31 = (Integer)this.decSpec.nls.getTileDef(n19);
        String string = this.printInfo ? "Tile " + this.getTileIdx() + " (tile-part:" + this.curTilePart + "): offset, length, header length\n" : null;
        boolean bl2 = false;
        if (((Boolean)this.decSpec.pphs.getTileDef(n19)).booleanValue()) {
            bl2 = true;
        }
        int n32 = n2;
        while (n32 < n3) {
            int n33 = n16;
            int n34 = n15;
            int n35 = 0;
            while (n35 <= n28) {
                int n36 = 0;
                while (n36 <= n6) {
                    int n37 = n4;
                    while (n37 < n5) {
                        if (n37 < this.mdl.length && n32 <= this.mdl[n37] && nArrayArray[n37][n32] < this.pktDec.getNumPrecinct(n37, n32)) {
                            precInfo = this.pktDec.getPrecInfo(n37, n32, nArrayArray[n37][n32]);
                            if (precInfo.rgulx == n34 && precInfo.rguly == n33) {
                                int n38 = n23;
                                while (n38 < n) {
                                    if (n32 < nArray[n37].length && n38 >= nArray[n37][n32] && n38 < n31) {
                                        int n39 = this.in.getPos();
                                        if (bl2) {
                                            this.pktDec.readPktHead(n38, n32, n37, nArrayArray[n37][n32], this.cbI[n37][n32], this.nBytes);
                                        }
                                        if (n39 > n30 && this.curTilePart < this.firstPackOff[n19].length - 1) {
                                            ++this.curTilePart;
                                            this.in.seek(this.firstPackOff[n19][this.curTilePart]);
                                            n30 = this.in.getPos() + this.tilePartLen[n19][this.curTilePart] - 1 - this.tilePartHeadLen[n19][this.curTilePart];
                                        }
                                        if (bl = this.pktDec.readSOPMarker(this.nBytes, nArrayArray[n37][n32], n37, n32)) {
                                            if (this.printInfo) {
                                                FacilityManager.getMsgLogger().printmsg(1, string);
                                            }
                                            return true;
                                        }
                                        if (!bl2) {
                                            bl = this.pktDec.readPktHead(n38, n32, n37, nArrayArray[n37][n32], this.cbI[n37][n32], this.nBytes);
                                        }
                                        if (bl) {
                                            if (this.printInfo) {
                                                FacilityManager.getMsgLogger().printmsg(1, string);
                                            }
                                            return true;
                                        }
                                        int n40 = this.in.getPos() - n39;
                                        this.pktHL.addElement(new Integer(n40));
                                        bl = this.pktDec.readPktBody(n38, n32, n37, nArrayArray[n37][n32], this.cbI[n37][n32], this.nBytes);
                                        int n41 = this.in.getPos() - n39;
                                        if (this.printInfo) {
                                            string = String.valueOf(string) + " Pkt l=" + n38 + ",r=" + n32 + ",c=" + n37 + ",p=" + nArrayArray[n37][n32] + ": " + n39 + ", " + n41 + ", " + n40 + "\n";
                                        }
                                        if (bl) {
                                            if (this.printInfo) {
                                                FacilityManager.getMsgLogger().printmsg(1, string);
                                            }
                                            return true;
                                        }
                                    }
                                    ++n38;
                                }
                                int[] nArray2 = nArrayArray[n37];
                                int n42 = n32;
                                nArray2[n42] = nArray2[n42] + 1;
                            }
                        }
                        ++n37;
                    }
                    n34 = n36 != n6 ? n24 + n36 * n20 : n15;
                    ++n36;
                }
                n33 = n35 != n28 ? n25 + n35 * n21 : n16;
                ++n35;
            }
            ++n32;
        }
        if (this.printInfo) {
            FacilityManager.getMsgLogger().printmsg(1, string);
        }
        return false;
    }

    private boolean readPosCompResLy(int[][] nArray, int n, int n2, int n3, int n4, int n5) throws IOException {
        PrecInfo precInfo;
        int n6;
        Point point = this.getNumTiles(null);
        Point point2 = this.getTile(null);
        int n7 = this.hd.getImgULX();
        int n8 = this.hd.getImgULY();
        int n9 = n7 + this.hd.getImgWidth();
        int n10 = n8 + this.hd.getImgHeight();
        int n11 = this.getTilePartULX();
        int n12 = this.getTilePartULY();
        int n13 = this.getNomTileWidth();
        int n14 = this.getNomTileHeight();
        int n15 = point2.x == 0 ? n7 : n11 + point2.x * n13;
        int n16 = point2.y == 0 ? n8 : n12 + point2.y * n14;
        int n17 = point2.x != point.x - 1 ? n11 + (point2.x + 1) * n13 : n9;
        int n18 = point2.y != point.y - 1 ? n12 + (point2.y + 1) * n14 : n10;
        int n19 = this.getTileIdx();
        int n20 = 0;
        int n21 = 0;
        int n22 = 0;
        int[][] nArrayArray = new int[n5][];
        int n23 = 100000;
        int n24 = n17;
        int n25 = n18;
        int n26 = n15;
        int n27 = n16;
        int n28 = n4;
        while (n28 < n5) {
            n6 = n2;
            while (n6 < n3) {
                if (n28 < this.mdl.length && n6 <= this.mdl[n28]) {
                    nArrayArray[n28] = new int[this.mdl[n28] + 1];
                    if (nArray[n28] != null && n6 < nArray[n28].length && nArray[n28][n6] < n23) {
                        n23 = nArray[n28][n6];
                    }
                    int n29 = this.pktDec.getNumPrecinct(n28, n6) - 1;
                    while (n29 >= 0) {
                        precInfo = this.pktDec.getPrecInfo(n28, n6, n29);
                        if (precInfo.rgulx != n15) {
                            if (precInfo.rgulx < n24) {
                                n24 = precInfo.rgulx;
                            }
                            if (precInfo.rgulx > n26) {
                                n26 = precInfo.rgulx;
                            }
                        }
                        if (precInfo.rguly != n16) {
                            if (precInfo.rguly < n25) {
                                n25 = precInfo.rguly;
                            }
                            if (precInfo.rguly > n27) {
                                n27 = precInfo.rguly;
                            }
                        }
                        if (n22 == 0) {
                            n20 = precInfo.rgw;
                            n21 = precInfo.rgh;
                        } else {
                            n20 = MathUtil.gcd(n20, precInfo.rgw);
                            n21 = MathUtil.gcd(n21, precInfo.rgh);
                        }
                        ++n22;
                        --n29;
                    }
                }
                ++n6;
            }
            ++n28;
        }
        if (n22 == 0) {
            throw new Error("Image cannot have no precinct");
        }
        n28 = (n27 - n25) / n21 + 1;
        n6 = (n26 - n24) / n20 + 1;
        boolean bl = false;
        int cfr_ignored_0 = this.firstPackOff[n19][this.curTilePart];
        int cfr_ignored_1 = this.tilePartLen[n19][this.curTilePart];
        int cfr_ignored_2 = this.tilePartHeadLen[n19][this.curTilePart];
        int n30 = (Integer)this.decSpec.nls.getTileDef(n19);
        String string = this.printInfo ? "Tile " + this.getTileIdx() + " (tile-part:" + this.curTilePart + "): offset, length, header length\n" : null;
        boolean bl2 = false;
        if (((Boolean)this.decSpec.pphs.getTileDef(n19)).booleanValue()) {
            bl2 = true;
        }
        int n31 = n16;
        int n32 = n15;
        int n33 = 0;
        while (n33 <= n28) {
            int n34 = 0;
            while (n34 <= n6) {
                int n35 = n4;
                while (n35 < n5) {
                    if (n35 < this.mdl.length) {
                        int n36 = n2;
                        while (n36 < n3) {
                            if (n36 <= this.mdl[n35] && nArrayArray[n35][n36] < this.pktDec.getNumPrecinct(n35, n36)) {
                                precInfo = this.pktDec.getPrecInfo(n35, n36, nArrayArray[n35][n36]);
                                if (precInfo.rgulx == n32 && precInfo.rguly == n31) {
                                    int n37 = n23;
                                    while (n37 < n) {
                                        if (n36 < nArray[n35].length && n37 >= nArray[n35][n36] && n37 < n30) {
                                            int n38 = this.in.getPos();
                                            if (bl2) {
                                                this.pktDec.readPktHead(n37, n36, n35, nArrayArray[n35][n36], this.cbI[n35][n36], this.nBytes);
                                            }
                                            if (bl = this.pktDec.readSOPMarker(this.nBytes, nArrayArray[n35][n36], n35, n36)) {
                                                if (this.printInfo) {
                                                    FacilityManager.getMsgLogger().printmsg(1, string);
                                                }
                                                return true;
                                            }
                                            if (!bl2) {
                                                bl = this.pktDec.readPktHead(n37, n36, n35, nArrayArray[n35][n36], this.cbI[n35][n36], this.nBytes);
                                            }
                                            if (bl) {
                                                if (this.printInfo) {
                                                    FacilityManager.getMsgLogger().printmsg(1, string);
                                                }
                                                return true;
                                            }
                                            int n39 = this.in.getPos() - n38;
                                            this.pktHL.addElement(new Integer(n39));
                                            bl = this.pktDec.readPktBody(n37, n36, n35, nArrayArray[n35][n36], this.cbI[n35][n36], this.nBytes);
                                            int n40 = this.in.getPos() - n38;
                                            if (this.printInfo) {
                                                string = String.valueOf(string) + " Pkt l=" + n37 + ",r=" + n36 + ",c=" + n35 + ",p=" + nArrayArray[n35][n36] + ": " + n38 + ", " + n40 + ", " + n39 + "\n";
                                            }
                                            if (bl) {
                                                if (this.printInfo) {
                                                    FacilityManager.getMsgLogger().printmsg(1, string);
                                                }
                                                return true;
                                            }
                                        }
                                        ++n37;
                                    }
                                    int[] nArray2 = nArrayArray[n35];
                                    int n41 = n36;
                                    nArray2[n41] = nArray2[n41] + 1;
                                }
                            }
                            ++n36;
                        }
                    }
                    ++n35;
                }
                n32 = n34 != n6 ? n24 + n34 * n20 : n15;
                ++n34;
            }
            n31 = n33 != n28 ? n25 + n33 * n21 : n16;
            ++n33;
        }
        if (this.printInfo) {
            FacilityManager.getMsgLogger().printmsg(1, string);
        }
        return false;
    }

    private boolean readCompPosResLy(int[][] nArray, int n, int n2, int n3, int n4, int n5) throws IOException {
        PrecInfo precInfo;
        int n6;
        Point point = this.getNumTiles(null);
        Point point2 = this.getTile(null);
        int n7 = this.hd.getImgULX();
        int n8 = this.hd.getImgULY();
        int n9 = n7 + this.hd.getImgWidth();
        int n10 = n8 + this.hd.getImgHeight();
        int n11 = this.getTilePartULX();
        int n12 = this.getTilePartULY();
        int n13 = this.getNomTileWidth();
        int n14 = this.getNomTileHeight();
        int n15 = point2.x == 0 ? n7 : n11 + point2.x * n13;
        int n16 = point2.y == 0 ? n8 : n12 + point2.y * n14;
        int n17 = point2.x != point.x - 1 ? n11 + (point2.x + 1) * n13 : n9;
        int n18 = point2.y != point.y - 1 ? n12 + (point2.y + 1) * n14 : n10;
        int n19 = this.getTileIdx();
        int n20 = 0;
        int n21 = 0;
        int n22 = 0;
        int[][] nArrayArray = new int[n5][];
        int n23 = 100000;
        int n24 = n17;
        int n25 = n18;
        int n26 = n15;
        int n27 = n16;
        int n28 = n4;
        while (n28 < n5) {
            n6 = n2;
            while (n6 < n3) {
                if (n28 < this.mdl.length && n6 <= this.mdl[n28]) {
                    nArrayArray[n28] = new int[this.mdl[n28] + 1];
                    if (nArray[n28] != null && n6 < nArray[n28].length && nArray[n28][n6] < n23) {
                        n23 = nArray[n28][n6];
                    }
                    int n29 = this.pktDec.getNumPrecinct(n28, n6) - 1;
                    while (n29 >= 0) {
                        precInfo = this.pktDec.getPrecInfo(n28, n6, n29);
                        if (precInfo.rgulx != n15) {
                            if (precInfo.rgulx < n24) {
                                n24 = precInfo.rgulx;
                            }
                            if (precInfo.rgulx > n26) {
                                n26 = precInfo.rgulx;
                            }
                        }
                        if (precInfo.rguly != n16) {
                            if (precInfo.rguly < n25) {
                                n25 = precInfo.rguly;
                            }
                            if (precInfo.rguly > n27) {
                                n27 = precInfo.rguly;
                            }
                        }
                        if (n22 == 0) {
                            n20 = precInfo.rgw;
                            n21 = precInfo.rgh;
                        } else {
                            n20 = MathUtil.gcd(n20, precInfo.rgw);
                            n21 = MathUtil.gcd(n21, precInfo.rgh);
                        }
                        ++n22;
                        --n29;
                    }
                }
                ++n6;
            }
            ++n28;
        }
        if (n22 == 0) {
            throw new Error("Image cannot have no precinct");
        }
        n28 = (n27 - n25) / n21 + 1;
        n6 = (n26 - n24) / n20 + 1;
        boolean bl = false;
        int n30 = this.firstPackOff[n19][this.curTilePart] + this.tilePartLen[n19][this.curTilePart] - 1 - this.tilePartHeadLen[n19][this.curTilePart];
        ((Integer)this.decSpec.nls.getTileDef(n19)).intValue();
        String string = this.printInfo ? "Tile " + this.getTileIdx() + " (tile-part:" + this.curTilePart + "): offset, length, header length\n" : null;
        boolean bl2 = false;
        if (((Boolean)this.decSpec.pphs.getTileDef(n19)).booleanValue()) {
            bl2 = true;
        }
        int n31 = n4;
        while (n31 < n5) {
            if (n31 < this.mdl.length) {
                int n32 = n16;
                int n33 = n15;
                int n34 = 0;
                while (n34 <= n28) {
                    int n35 = 0;
                    while (n35 <= n6) {
                        int n36 = n2;
                        while (n36 < n3) {
                            if (n36 <= this.mdl[n31] && nArrayArray[n31][n36] < this.pktDec.getNumPrecinct(n31, n36)) {
                                precInfo = this.pktDec.getPrecInfo(n31, n36, nArrayArray[n31][n36]);
                                if (precInfo.rgulx == n33 && precInfo.rguly == n32) {
                                    int n37 = n23;
                                    while (n37 < n) {
                                        if (n36 < nArray[n31].length && n37 >= nArray[n31][n36]) {
                                            int n38 = this.in.getPos();
                                            if (bl2) {
                                                this.pktDec.readPktHead(n37, n36, n31, nArrayArray[n31][n36], this.cbI[n31][n36], this.nBytes);
                                            }
                                            if (n38 > n30 && this.curTilePart < this.firstPackOff[n19].length - 1) {
                                                ++this.curTilePart;
                                                this.in.seek(this.firstPackOff[n19][this.curTilePart]);
                                                n30 = this.in.getPos() + this.tilePartLen[n19][this.curTilePart] - 1 - this.tilePartHeadLen[n19][this.curTilePart];
                                            }
                                            if (bl = this.pktDec.readSOPMarker(this.nBytes, nArrayArray[n31][n36], n31, n36)) {
                                                if (this.printInfo) {
                                                    FacilityManager.getMsgLogger().printmsg(1, string);
                                                }
                                                return true;
                                            }
                                            if (!bl2) {
                                                bl = this.pktDec.readPktHead(n37, n36, n31, nArrayArray[n31][n36], this.cbI[n31][n36], this.nBytes);
                                            }
                                            if (bl) {
                                                if (this.printInfo) {
                                                    FacilityManager.getMsgLogger().printmsg(1, string);
                                                }
                                                return true;
                                            }
                                            int n39 = this.in.getPos() - n38;
                                            this.pktHL.addElement(new Integer(n39));
                                            bl = this.pktDec.readPktBody(n37, n36, n31, nArrayArray[n31][n36], this.cbI[n31][n36], this.nBytes);
                                            int n40 = this.in.getPos() - n38;
                                            if (this.printInfo) {
                                                string = String.valueOf(string) + " Pkt l=" + n37 + ",r=" + n36 + ",c=" + n31 + ",p=" + nArrayArray[n31][n36] + ": " + n38 + ", " + n40 + ", " + n39 + "\n";
                                            }
                                            if (bl) {
                                                if (this.printInfo) {
                                                    FacilityManager.getMsgLogger().printmsg(1, string);
                                                }
                                                return true;
                                            }
                                        }
                                        ++n37;
                                    }
                                    int[] nArray2 = nArrayArray[n31];
                                    int n41 = n36;
                                    nArray2[n41] = nArray2[n41] + 1;
                                }
                            }
                            ++n36;
                        }
                        n33 = n35 != n6 ? n24 + n35 * n20 : n15;
                        ++n35;
                    }
                    n32 = n34 != n28 ? n25 + n34 * n21 : n16;
                    ++n34;
                }
            }
            ++n31;
        }
        if (this.printInfo) {
            FacilityManager.getMsgLogger().printmsg(1, string);
        }
        return false;
    }

    private void readTilePkts(int n) throws IOException {
        int n2;
        int n3;
        Object object;
        this.pktHL = new Vector();
        int n4 = this.nBytes[n];
        int n5 = (Integer)this.decSpec.nls.getTileDef(n);
        if (((Boolean)this.decSpec.pphs.getTileDef(n)).booleanValue()) {
            object = this.hd.getPackedPktHead(n);
            this.cbI = this.pktDec.restart(this.nc, this.mdl, n5, this.cbI, true, (ByteArrayInputStream)object);
        } else {
            this.cbI = this.pktDec.restart(this.nc, this.mdl, n5, this.cbI, false, null);
        }
        object = (int[][])this.decSpec.pcs.getTileDef(n);
        int n6 = object == null ? 1 : ((Object)object).length;
        int[][] nArray = new int[n6][6];
        int n7 = 0;
        nArray[0][1] = 0;
        if (object == null) {
            nArray[n7][0] = (Integer)this.decSpec.pos.getTileDef(n);
            nArray[n7][1] = n5;
            nArray[n7][2] = 0;
            nArray[n7][3] = this.decSpec.dls.getMaxInTile(n) + 1;
            nArray[n7][4] = 0;
            nArray[n7][5] = this.nc;
        } else {
            n7 = 0;
            while (n7 < n6) {
                nArray[n7][0] = (int)object[n7][5];
                nArray[n7][1] = (int)object[n7][2];
                nArray[n7][2] = (int)object[n7][0];
                nArray[n7][3] = (int)object[n7][3];
                nArray[n7][4] = (int)object[n7][1];
                nArray[n7][5] = (int)object[n7][4];
                ++n7;
            }
        }
        try {
            if (this.isTruncMode && this.firstPackOff == null || this.firstPackOff[n] == null) {
                return;
            }
            this.in.seek(this.firstPackOff[n][0]);
        }
        catch (EOFException eOFException) {
            FacilityManager.getMsgLogger().printmsg(2, "Codestream truncated in tile " + n);
            return;
        }
        this.curTilePart = 0;
        boolean bl = false;
        int n8 = this.nBytes[n];
        int[][] nArrayArray = new int[this.nc][];
        int n9 = 0;
        while (n9 < this.nc) {
            nArrayArray[n9] = new int[(Integer)this.decSpec.dls.getTileCompVal(n, n9) + 1];
            ++n9;
        }
        n9 = 0;
        while (n9 < n6) {
            int n10 = nArray[n9][1];
            int n11 = nArray[n9][2];
            int n12 = nArray[n9][3];
            int n13 = nArray[n9][4];
            int n14 = nArray[n9][5];
            switch (nArray[n9][0]) {
                case 0: {
                    bl = this.readLyResCompPos(nArrayArray, n10, n11, n12, n13, n14);
                    break;
                }
                case 1: {
                    bl = this.readResLyCompPos(nArrayArray, n10, n11, n12, n13, n14);
                    break;
                }
                case 2: {
                    bl = this.readResPosCompLy(nArrayArray, n10, n11, n12, n13, n14);
                    break;
                }
                case 3: {
                    bl = this.readPosCompResLy(nArrayArray, n10, n11, n12, n13, n14);
                    break;
                }
                case 4: {
                    bl = this.readCompPosResLy(nArrayArray, n10, n11, n12, n13, n14);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Not recognized progression type");
                }
            }
            n3 = n13;
            while (n3 < n14) {
                if (n3 < nArrayArray.length) {
                    n2 = n11;
                    while (n2 < n12) {
                        if (n2 < nArrayArray[n3].length) {
                            nArrayArray[n3][n2] = n10;
                        }
                        ++n2;
                    }
                }
                ++n3;
            }
            if (!bl && !this.usePOCQuit) {
                ++n9;
                continue;
            }
            break;
        }
        if (this.isTruncMode) {
            this.anbytes += n8 - this.nBytes[n];
            if (bl) {
                this.nBytes[n] = 0;
            }
        } else if (this.nBytes[n] < this.totTileLen[n] - this.totTileHeadLen[n]) {
            n2 = 0;
            int[] nArray2 = new int[this.pktHL.size()];
            int n15 = this.pktHL.size() - 1;
            while (n15 >= 0) {
                nArray2[n15] = (Integer)this.pktHL.elementAt(n15);
                --n15;
            }
            n3 = 0;
            n15 = 0;
            while (n15 < n5) {
                if (this.cbI != null) {
                    int n16 = this.cbI.length;
                    int n17 = 0;
                    int n18 = 0;
                    while (n18 < n16) {
                        if (this.cbI[n18] != null && this.cbI[n18].length > n17) {
                            n17 = this.cbI[n18].length;
                        }
                        ++n18;
                    }
                    n18 = 0;
                    while (n18 < n17) {
                        int n19 = 0;
                        int n20 = 0;
                        while (n20 < n16) {
                            if (this.cbI[n20] != null && this.cbI[n20][n18] != null && this.cbI[n20][n18].length > n19) {
                                n19 = this.cbI[n20][n18].length;
                            }
                            ++n20;
                        }
                        n20 = 0;
                        while (n20 < n19) {
                            if (!(n18 == 0 && n20 != 0 || n18 != 0 && n20 == 0)) {
                                int n21 = 0;
                                int n22 = 0;
                                while (n22 < n16) {
                                    if (this.cbI[n22] != null && this.cbI[n22][n18] != null && this.cbI[n22][n18][n20] != null && this.cbI[n22][n18][n20].length > n21) {
                                        n21 = this.cbI[n22][n18][n20].length;
                                    }
                                    ++n22;
                                }
                                n22 = 0;
                                while (n22 < n21) {
                                    int n23 = 0;
                                    int n24 = 0;
                                    while (n24 < n16) {
                                        if (this.cbI[n24] != null && this.cbI[n24][n18] != null && this.cbI[n24][n18][n20] != null && this.cbI[n24][n18][n20][n22] != null && this.cbI[n24][n18][n20][n22].length > n23) {
                                            n23 = this.cbI[n24][n18][n20][n22].length;
                                        }
                                        ++n24;
                                    }
                                    n24 = 0;
                                    while (n24 < n23) {
                                        int n25 = 0;
                                        while (n25 < n16) {
                                            if (this.cbI[n25] != null && this.cbI[n25][n18] != null && this.cbI[n25][n18][n20] != null && this.cbI[n25][n18][n20][n22] != null && this.cbI[n25][n18][n20][n22][n24] != null) {
                                                CBlkInfo cBlkInfo = this.cbI[n25][n18][n20][n22][n24];
                                                if (n3 == 0) {
                                                    if (this.nBytes[n] < nArray2[cBlkInfo.pktIdx[n15]]) {
                                                        n2 = 1;
                                                        n3 = 1;
                                                    } else if (n2 == 0) {
                                                        int n26 = n;
                                                        this.nBytes[n26] = this.nBytes[n26] - nArray2[cBlkInfo.pktIdx[n15]];
                                                        this.anbytes += nArray2[cBlkInfo.pktIdx[n15]];
                                                        nArray2[cBlkInfo.pktIdx[n15]] = 0;
                                                    }
                                                }
                                                if (cBlkInfo.len[n15] != 0) {
                                                    if (cBlkInfo.len[n15] < this.nBytes[n] && n3 == 0) {
                                                        int n27 = n;
                                                        this.nBytes[n27] = this.nBytes[n27] - cBlkInfo.len[n15];
                                                        this.anbytes += cBlkInfo.len[n15];
                                                    } else {
                                                        cBlkInfo.ntp[n15] = 0;
                                                        cBlkInfo.off[n15] = 0;
                                                        cBlkInfo.len[n15] = 0;
                                                        n3 = 1;
                                                    }
                                                }
                                            }
                                            ++n25;
                                        }
                                        ++n24;
                                    }
                                    ++n22;
                                }
                            }
                            ++n20;
                        }
                        ++n18;
                    }
                }
                ++n15;
            }
        } else {
            this.anbytes += this.totTileLen[n] - this.totTileHeadLen[n];
            if (n < this.getNumTiles() - 1) {
                int n28 = n + 1;
                this.nBytes[n28] = this.nBytes[n28] + (this.nBytes[n] - (this.totTileLen[n] - this.totTileHeadLen[n]));
            }
        }
        this.nBytes[n] = n4;
    }

    @Override
    public void setTile(int n, int n2) {
        int n3;
        if (n < 0 || n2 < 0 || n >= this.ntX || n2 >= this.ntY) {
            throw new IllegalArgumentException();
        }
        int n4 = n2 * this.ntX + n;
        try {
            this.initTile(n4);
        }
        catch (IOException iOException) {}
        if (n4 == 0) {
            this.anbytes = this.headLen;
            if (!this.isTruncMode) {
                this.anbytes += 2;
            }
            n3 = 0;
            while (n3 < this.nt) {
                this.nBytes[n3] = this.baknBytes[n3];
                ++n3;
            }
        }
        this.ctX = n;
        this.ctY = n2;
        n3 = n == 0 ? this.ax : this.px + n * this.ntW;
        int n5 = n2 == 0 ? this.ay : this.py + n2 * this.ntH;
        int n6 = this.nc - 1;
        while (n6 >= 0) {
            this.culx[n6] = (n3 + this.hd.getCompSubsX(n6) - 1) / this.hd.getCompSubsX(n6);
            this.culy[n6] = (n5 + this.hd.getCompSubsY(n6) - 1) / this.hd.getCompSubsY(n6);
            this.offX[n6] = (this.px + n * this.ntW + this.hd.getCompSubsX(n6) - 1) / this.hd.getCompSubsX(n6);
            this.offY[n6] = (this.py + n2 * this.ntH + this.hd.getCompSubsY(n6) - 1) / this.hd.getCompSubsY(n6);
            --n6;
        }
        this.subbTrees = new SubbandSyn[this.nc];
        this.mdl = new int[this.nc];
        this.derived = new boolean[this.nc];
        this.params = new StdDequantizerParams[this.nc];
        this.gb = new int[this.nc];
        int n7 = 0;
        while (n7 < this.nc) {
            this.derived[n7] = this.decSpec.qts.isDerived(n4, n7);
            this.params[n7] = (StdDequantizerParams)this.decSpec.qsss.getTileCompVal(n4, n7);
            this.gb[n7] = (Integer)this.decSpec.gbs.getTileCompVal(n4, n7);
            this.mdl[n7] = (Integer)this.decSpec.dls.getTileCompVal(n4, n7);
            this.subbTrees[n7] = new SubbandSyn(this.getTileCompWidth(n4, n7, this.mdl[n7]), this.getTileCompHeight(n4, n7, this.mdl[n7]), this.getResULX(n7, this.mdl[n7]), this.getResULY(n7, this.mdl[n7]), this.mdl[n7], this.decSpec.wfs.getHFilters(n4, n7), this.decSpec.wfs.getVFilters(n4, n7));
            this.initSubbandsFields(n7, this.subbTrees[n7]);
            ++n7;
        }
        try {
            this.readTilePkts(n4);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new Error("IO Error when reading tile " + n + " x " + n2);
        }
    }

    @Override
    public void nextTile() {
        if (this.ctX == this.ntX - 1 && this.ctY == this.ntY - 1) {
            throw new NoNextElementException();
        }
        if (this.ctX < this.ntX - 1) {
            this.setTile(this.ctX + 1, this.ctY);
        } else {
            this.setTile(0, this.ctY + 1);
        }
    }

    @Override
    public DecLyrdCBlk getCodeBlock(int n, int n2, int n3, SubbandSyn subbandSyn, int n4, int n5, DecLyrdCBlk decLyrdCBlk) {
        int n6;
        int n7;
        int n8;
        int n9;
        CBlkInfo cBlkInfo;
        int n10 = this.getTileIdx();
        int n11 = subbandSyn.resLvl;
        int n12 = subbandSyn.sbandIdx;
        int n13 = (Integer)this.decSpec.nls.getTileDef(n10);
        int n14 = (Integer)this.decSpec.ecopts.getTileCompVal(n10, n);
        if (n5 < 0) {
            n5 = n13 - n4 + 1;
        }
        if (this.lQuit != -1 && n4 + n5 > this.lQuit) {
            n5 = this.lQuit - n4;
        }
        int cfr_ignored_0 = this.getSynSubbandTree((int)n10, (int)n).resLvl;
        try {
            cBlkInfo = this.cbI[n][n11][n12][n2][n3];
            if (n4 < 1 || n4 > n13 || n4 + n5 - 1 > n13) {
                throw new IllegalArgumentException();
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("Code-block (t:" + n10 + ", c:" + n + ", r:" + n11 + ", s:" + n12 + ", " + n2 + "x" + n3 + ") not found in codestream");
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalArgumentException("Code-block (t:" + n10 + ", c:" + n + ", r:" + n11 + ", s:" + n12 + ", " + n2 + "x" + n3 + ") not found in bit stream");
        }
        if (decLyrdCBlk == null) {
            decLyrdCBlk = new DecLyrdCBlk();
        }
        decLyrdCBlk.m = n2;
        decLyrdCBlk.n = n3;
        decLyrdCBlk.nl = 0;
        decLyrdCBlk.dl = 0;
        decLyrdCBlk.nTrunc = 0;
        if (cBlkInfo == null) {
            decLyrdCBlk.skipMSBP = 0;
            decLyrdCBlk.prog = false;
            decLyrdCBlk.uly = 0;
            decLyrdCBlk.ulx = 0;
            decLyrdCBlk.h = 0;
            decLyrdCBlk.w = 0;
            return decLyrdCBlk;
        }
        decLyrdCBlk.skipMSBP = cBlkInfo.msbSkipped;
        decLyrdCBlk.ulx = cBlkInfo.ulx;
        decLyrdCBlk.uly = cBlkInfo.uly;
        decLyrdCBlk.w = cBlkInfo.w;
        decLyrdCBlk.h = cBlkInfo.h;
        decLyrdCBlk.ftpIdx = 0;
        int n15 = 0;
        while (n15 < cBlkInfo.len.length && cBlkInfo.len[n15] == 0) {
            decLyrdCBlk.ftpIdx += cBlkInfo.ntp[n15];
            ++n15;
        }
        n15 = n4 - 1;
        while (n15 < n4 + n5 - 1) {
            ++decLyrdCBlk.nl;
            decLyrdCBlk.dl += cBlkInfo.len[n15];
            decLyrdCBlk.nTrunc += cBlkInfo.ntp[n15];
            ++n15;
        }
        if ((n14 & 4) != 0) {
            n9 = decLyrdCBlk.nTrunc - decLyrdCBlk.ftpIdx;
        } else if ((n14 & 1) != 0) {
            if (decLyrdCBlk.nTrunc <= 10) {
                n9 = 1;
            } else {
                n9 = 1;
                n8 = decLyrdCBlk.ftpIdx;
                while (n8 < decLyrdCBlk.nTrunc) {
                    if (n8 >= 9 && ((n7 = (n8 + 2) % 3) == 1 || n7 == 2)) {
                        ++n9;
                    }
                    ++n8;
                }
            }
        } else {
            n9 = 1;
        }
        if (decLyrdCBlk.data == null || decLyrdCBlk.data.length < decLyrdCBlk.dl) {
            decLyrdCBlk.data = new byte[decLyrdCBlk.dl];
        }
        if (n9 > 1 && (decLyrdCBlk.tsLengths == null || decLyrdCBlk.tsLengths.length < n9)) {
            decLyrdCBlk.tsLengths = new int[n9];
        } else if (n9 > 1 && (n14 & 5) == 1) {
            ArrayUtil.intArraySet(decLyrdCBlk.tsLengths, 0);
        }
        int n16 = -1;
        n8 = decLyrdCBlk.ftpIdx;
        int n17 = decLyrdCBlk.ftpIdx;
        int n18 = 0;
        n15 = n4 - 1;
        while (n15 < n4 + n5 - 1) {
            n17 += cBlkInfo.ntp[n15];
            if (cBlkInfo.len[n15] != 0) {
                try {
                    this.in.seek(cBlkInfo.off[n15]);
                    this.in.readFully(decLyrdCBlk.data, n16 + 1, cBlkInfo.len[n15]);
                    n16 += cBlkInfo.len[n15];
                }
                catch (IOException iOException) {
                    JJ2KExceptionHandler.handleException(iOException);
                }
                if (n9 != 1) {
                    int n19;
                    if ((n14 & 4) != 0) {
                        n19 = 0;
                        while (n8 < n17) {
                            decLyrdCBlk.tsLengths[n18++] = cBlkInfo.segLen[n15] != null ? cBlkInfo.segLen[n15][n19] : cBlkInfo.len[n15];
                            ++n19;
                            ++n8;
                        }
                    } else {
                        n19 = 0;
                        while (n8 < n17) {
                            if (n8 >= 9 && (n7 = (n8 + 2) % 3) != 0) {
                                if (cBlkInfo.segLen[n15] != null) {
                                    int n20 = n18++;
                                    decLyrdCBlk.tsLengths[n20] = decLyrdCBlk.tsLengths[n20] + cBlkInfo.segLen[n15][n19++];
                                    int n21 = n15;
                                    cBlkInfo.len[n21] = cBlkInfo.len[n21] - cBlkInfo.segLen[n15][n19 - 1];
                                } else {
                                    int n22 = n18++;
                                    decLyrdCBlk.tsLengths[n22] = decLyrdCBlk.tsLengths[n22] + cBlkInfo.len[n15];
                                    cBlkInfo.len[n15] = 0;
                                }
                            }
                            ++n8;
                        }
                        if (cBlkInfo.segLen[n15] != null && n19 < cBlkInfo.segLen[n15].length) {
                            int n23 = n18;
                            decLyrdCBlk.tsLengths[n23] = decLyrdCBlk.tsLengths[n23] + cBlkInfo.segLen[n15][n19];
                            int n24 = n15;
                            cBlkInfo.len[n24] = cBlkInfo.len[n24] - cBlkInfo.segLen[n15][n19];
                        } else if (n18 < n9) {
                            int n25 = n18;
                            decLyrdCBlk.tsLengths[n25] = decLyrdCBlk.tsLengths[n25] + cBlkInfo.len[n15];
                            cBlkInfo.len[n15] = 0;
                        }
                    }
                }
            }
            ++n15;
        }
        if (n9 == 1 && decLyrdCBlk.tsLengths != null) {
            decLyrdCBlk.tsLengths[0] = decLyrdCBlk.dl;
        }
        if ((n6 = n4 + n5 - 1) < n13 - 1) {
            n15 = n6 + 1;
            while (n15 < n13) {
                if (cBlkInfo.len[n15] != 0) {
                    decLyrdCBlk.prog = true;
                }
                ++n15;
            }
        }
        return decLyrdCBlk;
    }
}

