/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.codestream;

import java.util.Hashtable;
import jj2000.j2k.codestream.Markers;
import jj2000.j2k.codestream.ProgressionType;
import jj2000.j2k.wavelet.FilterTypes;

public class HeaderInfo
implements Markers,
ProgressionType,
FilterTypes,
Cloneable {
    public SIZ siz;
    public Hashtable sot = new Hashtable();
    public Hashtable cod = new Hashtable();
    public Hashtable coc = new Hashtable();
    public Hashtable rgn = new Hashtable();
    public Hashtable qcd = new Hashtable();
    public Hashtable qcc = new Hashtable();
    public Hashtable poc = new Hashtable();
    public CRG crg;
    public Hashtable com = new Hashtable();
    private int ncom = 0;

    public SIZ getNewSIZ() {
        return new SIZ();
    }

    public SOT getNewSOT() {
        return new SOT();
    }

    public COD getNewCOD() {
        return new COD();
    }

    public COC getNewCOC() {
        return new COC();
    }

    public RGN getNewRGN() {
        return new RGN();
    }

    public QCD getNewQCD() {
        return new QCD();
    }

    public QCC getNewQCC() {
        return new QCC();
    }

    public POC getNewPOC() {
        return new POC();
    }

    public CRG getNewCRG() {
        return new CRG();
    }

    public COM getNewCOM() {
        ++this.ncom;
        return new COM();
    }

    public int getNumCOM() {
        return this.ncom;
    }

    public String toStringMainHeader() {
        int n = this.siz.csiz;
        String string = "" + this.siz;
        if (this.cod.get("main") != null) {
            string = String.valueOf(string) + (COD)this.cod.get("main");
        }
        int n2 = 0;
        while (n2 < n) {
            if (this.coc.get("main_c" + n2) != null) {
                string = String.valueOf(string) + (COC)this.coc.get("main_c" + n2);
            }
            ++n2;
        }
        if (this.qcd.get("main") != null) {
            string = String.valueOf(string) + (QCD)this.qcd.get("main");
        }
        n2 = 0;
        while (n2 < n) {
            if (this.qcc.get("main_c" + n2) != null) {
                string = String.valueOf(string) + (QCC)this.qcc.get("main_c" + n2);
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            if (this.rgn.get("main_c" + n2) != null) {
                string = String.valueOf(string) + (RGN)this.rgn.get("main_c" + n2);
            }
            ++n2;
        }
        if (this.poc.get("main") != null) {
            string = String.valueOf(string) + (POC)this.poc.get("main");
        }
        if (this.crg != null) {
            string = String.valueOf(string) + this.crg;
        }
        n2 = 0;
        while (n2 < this.ncom) {
            if (this.com.get("main_" + n2) != null) {
                string = String.valueOf(string) + (COM)this.com.get("main_" + n2);
            }
            ++n2;
        }
        return string;
    }

    public String toStringTileHeader(int n, int n2) {
        int n3 = this.siz.csiz;
        String string = "";
        int n4 = 0;
        while (n4 < n2) {
            string = String.valueOf(string) + "Tile-part " + n4 + ", tile " + n + ":\n";
            string = String.valueOf(string) + (SOT)this.sot.get("t" + n + "_tp" + n4);
            ++n4;
        }
        if (this.cod.get("t" + n) != null) {
            string = String.valueOf(string) + (COD)this.cod.get("t" + n);
        }
        n4 = 0;
        while (n4 < n3) {
            if (this.coc.get("t" + n + "_c" + n4) != null) {
                string = String.valueOf(string) + (COC)this.coc.get("t" + n + "_c" + n4);
            }
            ++n4;
        }
        if (this.qcd.get("t" + n) != null) {
            string = String.valueOf(string) + (QCD)this.qcd.get("t" + n);
        }
        n4 = 0;
        while (n4 < n3) {
            if (this.qcc.get("t" + n + "_c" + n4) != null) {
                string = String.valueOf(string) + (QCC)this.qcc.get("t" + n + "_c" + n4);
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < n3) {
            if (this.rgn.get("t" + n + "_c" + n4) != null) {
                string = String.valueOf(string) + (RGN)this.rgn.get("t" + n + "_c" + n4);
            }
            ++n4;
        }
        if (this.poc.get("t" + n) != null) {
            string = String.valueOf(string) + (POC)this.poc.get("t" + n);
        }
        return string;
    }

    public String toStringThNoSOT(int n, int n2) {
        int n3 = this.siz.csiz;
        String string = "";
        if (this.cod.get("t" + n) != null) {
            string = String.valueOf(string) + (COD)this.cod.get("t" + n);
        }
        int n4 = 0;
        while (n4 < n3) {
            if (this.coc.get("t" + n + "_c" + n4) != null) {
                string = String.valueOf(string) + (COC)this.coc.get("t" + n + "_c" + n4);
            }
            ++n4;
        }
        if (this.qcd.get("t" + n) != null) {
            string = String.valueOf(string) + (QCD)this.qcd.get("t" + n);
        }
        n4 = 0;
        while (n4 < n3) {
            if (this.qcc.get("t" + n + "_c" + n4) != null) {
                string = String.valueOf(string) + (QCC)this.qcc.get("t" + n + "_c" + n4);
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < n3) {
            if (this.rgn.get("t" + n + "_c" + n4) != null) {
                string = String.valueOf(string) + (RGN)this.rgn.get("t" + n + "_c" + n4);
            }
            ++n4;
        }
        if (this.poc.get("t" + n) != null) {
            string = String.valueOf(string) + (POC)this.poc.get("t" + n);
        }
        return string;
    }

    public HeaderInfo getCopy(int n) {
        HeaderInfo headerInfo = null;
        try {
            headerInfo = (HeaderInfo)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("Cannot clone HeaderInfo instance");
        }
        headerInfo.siz = this.siz.getCopy();
        if (this.cod.get("main") != null) {
            COD cOD = (COD)this.cod.get("main");
            headerInfo.cod.put("main", cOD.getCopy());
        }
        int n2 = 0;
        while (n2 < n) {
            if (this.cod.get("t" + n2) != null) {
                COD cOD = (COD)this.cod.get("t" + n2);
                headerInfo.cod.put("t" + n2, cOD.getCopy());
            }
            ++n2;
        }
        return headerInfo;
    }

    public class COC {
        public int lcoc;
        public int ccoc;
        public int scoc;
        public int spcoc_ndl;
        public int spcoc_cw;
        public int spcoc_ch;
        public int spcoc_cs;
        public int[] spcoc_t = new int[1];
        public int[] spcoc_ps;

        public String toString() {
            String string = "\n --- COC (" + this.lcoc + " bytes) ---\n";
            string = String.valueOf(string) + " Component      : " + this.ccoc + "\n";
            string = String.valueOf(string) + " Coding style   : ";
            if (this.scoc == 0) {
                string = String.valueOf(string) + "Default";
            } else {
                if ((this.scoc & 1) != 0) {
                    string = String.valueOf(string) + "Precints ";
                }
                if ((this.scoc & 2) != 0) {
                    string = String.valueOf(string) + "SOP ";
                }
                if ((this.scoc & 4) != 0) {
                    string = String.valueOf(string) + "EPH ";
                }
            }
            string = String.valueOf(string) + "\n";
            string = String.valueOf(string) + " Cblk style     : ";
            if (this.spcoc_cs == 0) {
                string = String.valueOf(string) + "Default";
            } else {
                if ((this.spcoc_cs & 1) != 0) {
                    string = String.valueOf(string) + "Bypass ";
                }
                if ((this.spcoc_cs & 2) != 0) {
                    string = String.valueOf(string) + "Reset ";
                }
                if ((this.spcoc_cs & 4) != 0) {
                    string = String.valueOf(string) + "Terminate ";
                }
                if ((this.spcoc_cs & 8) != 0) {
                    string = String.valueOf(string) + "Vert_causal ";
                }
                if ((this.spcoc_cs & 0x10) != 0) {
                    string = String.valueOf(string) + "Predict ";
                }
                if ((this.spcoc_cs & 0x20) != 0) {
                    string = String.valueOf(string) + "Seg_symb ";
                }
            }
            string = String.valueOf(string) + "\n";
            string = String.valueOf(string) + " Num. of levels : " + this.spcoc_ndl + "\n";
            string = String.valueOf(string) + " Cblk dimension : " + (1 << this.spcoc_cw + 2) + "x" + (1 << this.spcoc_ch + 2) + "\n";
            switch (this.spcoc_t[0]) {
                case 0: {
                    string = String.valueOf(string) + " Filter         : 9-7 irreversible\n";
                    break;
                }
                case 1: {
                    string = String.valueOf(string) + " Filter         : 5-3 reversible\n";
                }
            }
            if (this.spcoc_ps != null) {
                string = String.valueOf(string) + " Precincts      : ";
                int n = 0;
                while (n < this.spcoc_ps.length) {
                    string = String.valueOf(string) + (1 << (this.spcoc_ps[n] & 0xF)) + "x" + (1 << ((this.spcoc_ps[n] & 0xF0) >> 4)) + " ";
                    ++n;
                }
            }
            string = String.valueOf(string) + "\n";
            return string;
        }
    }

    public class COD
    implements Cloneable {
        public int lcod;
        public int scod;
        public int sgcod_po;
        public int sgcod_nl;
        public int sgcod_mct;
        public int spcod_ndl;
        public int spcod_cw;
        public int spcod_ch;
        public int spcod_cs;
        public int[] spcod_t = new int[1];
        public int[] spcod_ps;

        public COD getCopy() {
            COD cOD = null;
            try {
                cOD = (COD)this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new Error("Cannot clone SIZ marker segment");
            }
            return cOD;
        }

        public String toString() {
            int n;
            String string = "\n --- COD (" + this.lcod + " bytes) ---\n";
            string = String.valueOf(string) + " Coding style   : ";
            if (this.scod == 0) {
                string = String.valueOf(string) + "Default";
            } else {
                int n2;
                if ((this.scod & 1) != 0) {
                    string = String.valueOf(string) + "Precints ";
                }
                if ((this.scod & 2) != 0) {
                    string = String.valueOf(string) + "SOP ";
                }
                if ((this.scod & 4) != 0) {
                    string = String.valueOf(string) + "EPH ";
                }
                n = (this.scod & 8) != 0 ? 1 : 0;
                int n3 = n2 = (this.scod & 0x10) != 0 ? 1 : 0;
                if (n != 0 || n2 != 0) {
                    string = String.valueOf(string) + "Code-blocks offset";
                    string = String.valueOf(string) + "\n Cblk partition : " + n + "," + n2;
                }
            }
            string = String.valueOf(string) + "\n";
            string = String.valueOf(string) + " Cblk style     : ";
            if (this.spcod_cs == 0) {
                string = String.valueOf(string) + "Default";
            } else {
                if ((this.spcod_cs & 1) != 0) {
                    string = String.valueOf(string) + "Bypass ";
                }
                if ((this.spcod_cs & 2) != 0) {
                    string = String.valueOf(string) + "Reset ";
                }
                if ((this.spcod_cs & 4) != 0) {
                    string = String.valueOf(string) + "Terminate ";
                }
                if ((this.spcod_cs & 8) != 0) {
                    string = String.valueOf(string) + "Vert_causal ";
                }
                if ((this.spcod_cs & 0x10) != 0) {
                    string = String.valueOf(string) + "Predict ";
                }
                if ((this.spcod_cs & 0x20) != 0) {
                    string = String.valueOf(string) + "Seg_symb ";
                }
            }
            string = String.valueOf(string) + "\n";
            string = String.valueOf(string) + " Num. of levels : " + this.spcod_ndl + "\n";
            switch (this.sgcod_po) {
                case 0: {
                    string = String.valueOf(string) + " Progress. type : LY_RES_COMP_POS_PROG\n";
                    break;
                }
                case 1: {
                    string = String.valueOf(string) + " Progress. type : RES_LY_COMP_POS_PROG\n";
                    break;
                }
                case 2: {
                    string = String.valueOf(string) + " Progress. type : RES_POS_COMP_LY_PROG\n";
                    break;
                }
                case 3: {
                    string = String.valueOf(string) + " Progress. type : POS_COMP_RES_LY_PROG\n";
                    break;
                }
                case 4: {
                    string = String.valueOf(string) + " Progress. type : COMP_POS_RES_LY_PROG\n";
                }
            }
            string = String.valueOf(string) + " Num. of layers : " + this.sgcod_nl + "\n";
            string = String.valueOf(string) + " Cblk dimension : " + (1 << this.spcod_cw + 2) + "x" + (1 << this.spcod_ch + 2) + "\n";
            switch (this.spcod_t[0]) {
                case 0: {
                    string = String.valueOf(string) + " Filter         : 9-7 irreversible\n";
                    break;
                }
                case 1: {
                    string = String.valueOf(string) + " Filter         : 5-3 reversible\n";
                }
            }
            string = String.valueOf(string) + " Multi comp tr. : " + (this.sgcod_mct == 1) + "\n";
            if (this.spcod_ps != null) {
                string = String.valueOf(string) + " Precincts      : ";
                n = 0;
                while (n < this.spcod_ps.length) {
                    string = String.valueOf(string) + (1 << (this.spcod_ps[n] & 0xF)) + "x" + (1 << ((this.spcod_ps[n] & 0xF0) >> 4)) + " ";
                    ++n;
                }
            }
            string = String.valueOf(string) + "\n";
            return string;
        }
    }

    public class COM {
        public int lcom;
        public int rcom;
        public byte[] ccom;

        public String toString() {
            String string = "\n --- COM (" + this.lcom + " bytes) ---\n";
            if (this.rcom == 0) {
                string = String.valueOf(string) + " Registration : General use (binary values)\n";
            } else if (this.rcom == 1) {
                string = String.valueOf(string) + " Registration : General use (IS 8859-15:1999 (Latin) values)\n";
                string = String.valueOf(string) + " Text         : " + new String(this.ccom) + "\n";
            } else {
                string = String.valueOf(string) + " Registration : Unknown\n";
            }
            string = String.valueOf(string) + "\n";
            return string;
        }
    }

    public class CRG {
        public int lcrg;
        public int[] xcrg;
        public int[] ycrg;

        public String toString() {
            String string = "\n --- CRG (" + this.lcrg + " bytes) ---\n";
            int n = 0;
            while (n < this.xcrg.length) {
                string = String.valueOf(string) + " Component " + n + " offset : " + this.xcrg[n] + "," + this.ycrg[n] + "\n";
                ++n;
            }
            string = String.valueOf(string) + "\n";
            return string;
        }
    }

    public class POC {
        public int lpoc;
        public int[] rspoc;
        public int[] cspoc;
        public int[] lyepoc;
        public int[] repoc;
        public int[] cepoc;
        public int[] ppoc;

        public String toString() {
            String string = "\n --- POC (" + this.lpoc + " bytes) ---\n";
            string = String.valueOf(string) + " Chg_idx RSpoc CSpoc LYEpoc REpoc CEpoc Ppoc\n";
            int n = 0;
            while (n < this.rspoc.length) {
                string = String.valueOf(string) + "   " + n + "      " + this.rspoc[n] + "     " + this.cspoc[n] + "     " + this.lyepoc[n] + "      " + this.repoc[n] + "     " + this.cepoc[n];
                switch (this.ppoc[n]) {
                    case 0: {
                        string = String.valueOf(string) + "  LY_RES_COMP_POS_PROG\n";
                        break;
                    }
                    case 1: {
                        string = String.valueOf(string) + "  RES_LY_COMP_POS_PROG\n";
                        break;
                    }
                    case 2: {
                        string = String.valueOf(string) + "  RES_POS_COMP_LY_PROG\n";
                        break;
                    }
                    case 3: {
                        string = String.valueOf(string) + "  POS_COMP_RES_LY_PROG\n";
                        break;
                    }
                    case 4: {
                        string = String.valueOf(string) + "  COMP_POS_RES_LY_PROG\n";
                    }
                }
                ++n;
            }
            string = String.valueOf(string) + "\n";
            return string;
        }
    }

    public class QCC {
        public int lqcc;
        public int cqcc;
        public int sqcc;
        public int[][] spqcc;
        private int qType = -1;
        private int gb = -1;

        public int getQuantType() {
            if (this.qType == -1) {
                this.qType = this.sqcc & 0xFFFFFF1F;
            }
            return this.qType;
        }

        public int getNumGuardBits() {
            if (this.gb == -1) {
                this.gb = this.sqcc >> 5 & 7;
            }
            return this.gb;
        }

        public String toString() {
            String string = "\n --- QCC (" + this.lqcc + " bytes) ---\n";
            string = String.valueOf(string) + " Component      : " + this.cqcc + "\n";
            string = String.valueOf(string) + " Quant. type    : ";
            int n = this.getQuantType();
            if (n == 0) {
                string = String.valueOf(string) + "No quantization \n";
            } else if (n == 1) {
                string = String.valueOf(string) + "Scalar derived\n";
            } else if (n == 2) {
                string = String.valueOf(string) + "Scalar expounded\n";
            }
            string = String.valueOf(string) + " Guard bits     : " + this.getNumGuardBits() + "\n";
            if (n == 0) {
                string = String.valueOf(string) + " Exponents   :\n";
                int n2 = 0;
                while (n2 < this.spqcc.length) {
                    int n3 = 0;
                    while (n3 < this.spqcc[n2].length) {
                        int n4;
                        if (n2 == 0 && n3 == 0) {
                            n4 = this.spqcc[0][0] >> 3 & 0x1F;
                            string = String.valueOf(string) + "\tr=0 : " + n4 + "\n";
                        } else if (n2 != 0 && n3 > 0) {
                            n4 = this.spqcc[n2][n3] >> 3 & 0x1F;
                            string = String.valueOf(string) + "\tr=" + n2 + ",s=" + n3 + " : " + n4 + "\n";
                        }
                        ++n3;
                    }
                    ++n2;
                }
            } else {
                string = String.valueOf(string) + " Exp / Mantissa : \n";
                int n5 = 0;
                while (n5 < this.spqcc.length) {
                    int n6 = 0;
                    while (n6 < this.spqcc[n5].length) {
                        double d;
                        int n7;
                        if (n5 == 0 && n6 == 0) {
                            n7 = this.spqcc[0][0] >> 11 & 0x1F;
                            d = (-1.0f - (float)(this.spqcc[0][0] & 0x7FF) / 2048.0f) / (float)(-1 << n7);
                            string = String.valueOf(string) + "\tr=0 : " + n7 + " / " + d + "\n";
                        } else if (n5 != 0 && n6 > 0) {
                            n7 = this.spqcc[n5][n6] >> 11 & 0x1F;
                            d = (-1.0f - (float)(this.spqcc[n5][n6] & 0x7FF) / 2048.0f) / (float)(-1 << n7);
                            string = String.valueOf(string) + "\tr=" + n5 + ",s=" + n6 + " : " + n7 + " / " + d + "\n";
                        }
                        ++n6;
                    }
                    ++n5;
                }
            }
            string = String.valueOf(string) + "\n";
            return string;
        }
    }

    public class QCD {
        public int lqcd;
        public int sqcd;
        public int[][] spqcd;
        private int qType = -1;
        private int gb = -1;

        public int getQuantType() {
            if (this.qType == -1) {
                this.qType = this.sqcd & 0xFFFFFF1F;
            }
            return this.qType;
        }

        public int getNumGuardBits() {
            if (this.gb == -1) {
                this.gb = this.sqcd >> 5 & 7;
            }
            return this.gb;
        }

        public String toString() {
            String string = "\n --- QCD (" + this.lqcd + " bytes) ---\n";
            string = String.valueOf(string) + " Quant. type    : ";
            int n = this.getQuantType();
            if (n == 0) {
                string = String.valueOf(string) + "No quantization \n";
            } else if (n == 1) {
                string = String.valueOf(string) + "Scalar derived\n";
            } else if (n == 2) {
                string = String.valueOf(string) + "Scalar expounded\n";
            }
            string = String.valueOf(string) + " Guard bits     : " + this.getNumGuardBits() + "\n";
            if (n == 0) {
                string = String.valueOf(string) + " Exponents   :\n";
                int n2 = 0;
                while (n2 < this.spqcd.length) {
                    int n3 = 0;
                    while (n3 < this.spqcd[n2].length) {
                        int n4;
                        if (n2 == 0 && n3 == 0) {
                            n4 = this.spqcd[0][0] >> 3 & 0x1F;
                            string = String.valueOf(string) + "\tr=0 : " + n4 + "\n";
                        } else if (n2 != 0 && n3 > 0) {
                            n4 = this.spqcd[n2][n3] >> 3 & 0x1F;
                            string = String.valueOf(string) + "\tr=" + n2 + ",s=" + n3 + " : " + n4 + "\n";
                        }
                        ++n3;
                    }
                    ++n2;
                }
            } else {
                string = String.valueOf(string) + " Exp / Mantissa : \n";
                int n5 = 0;
                while (n5 < this.spqcd.length) {
                    int n6 = 0;
                    while (n6 < this.spqcd[n5].length) {
                        double d;
                        int n7;
                        if (n5 == 0 && n6 == 0) {
                            n7 = this.spqcd[0][0] >> 11 & 0x1F;
                            d = (-1.0f - (float)(this.spqcd[0][0] & 0x7FF) / 2048.0f) / (float)(-1 << n7);
                            string = String.valueOf(string) + "\tr=0 : " + n7 + " / " + d + "\n";
                        } else if (n5 != 0 && n6 > 0) {
                            n7 = this.spqcd[n5][n6] >> 11 & 0x1F;
                            d = (-1.0f - (float)(this.spqcd[n5][n6] & 0x7FF) / 2048.0f) / (float)(-1 << n7);
                            string = String.valueOf(string) + "\tr=" + n5 + ",s=" + n6 + " : " + n7 + " / " + d + "\n";
                        }
                        ++n6;
                    }
                    ++n5;
                }
            }
            string = String.valueOf(string) + "\n";
            return string;
        }
    }

    public class RGN {
        public int lrgn;
        public int crgn;
        public int srgn;
        public int sprgn;

        public String toString() {
            String string = "\n --- RGN (" + this.lrgn + " bytes) ---\n";
            string = String.valueOf(string) + " Component : " + this.crgn + "\n";
            string = this.srgn == 0 ? String.valueOf(string) + " ROI style : Implicit\n" : String.valueOf(string) + " ROI style : Unsupported\n";
            string = String.valueOf(string) + " ROI shift : " + this.sprgn + "\n";
            string = String.valueOf(string) + "\n";
            return string;
        }
    }

    public class SIZ
    implements Cloneable {
        public int lsiz;
        public int rsiz;
        public int xsiz;
        public int ysiz;
        public int x0siz;
        public int y0siz;
        public int xtsiz;
        public int ytsiz;
        public int xt0siz;
        public int yt0siz;
        public int csiz;
        public int[] ssiz;
        public int[] xrsiz;
        public int[] yrsiz;
        private int[] compWidth = null;
        private int maxCompWidth = -1;
        private int[] compHeight = null;
        private int maxCompHeight = -1;
        private int numTiles = -1;
        private boolean[] origSigned = null;
        private int[] origBitDepth = null;

        public int getCompImgWidth(int n) {
            if (this.compWidth == null) {
                this.compWidth = new int[this.csiz];
                int n2 = 0;
                while (n2 < this.csiz) {
                    this.compWidth[n2] = (int)(Math.ceil((double)this.xsiz / (double)this.xrsiz[n2]) - Math.ceil((double)this.x0siz / (double)this.xrsiz[n2]));
                    ++n2;
                }
            }
            return this.compWidth[n];
        }

        public int getMaxCompWidth() {
            int n;
            if (this.compWidth == null) {
                this.compWidth = new int[this.csiz];
                n = 0;
                while (n < this.csiz) {
                    this.compWidth[n] = (int)(Math.ceil((double)this.xsiz / (double)this.xrsiz[n]) - Math.ceil((double)this.x0siz / (double)this.xrsiz[n]));
                    ++n;
                }
            }
            if (this.maxCompWidth == -1) {
                n = 0;
                while (n < this.csiz) {
                    if (this.compWidth[n] > this.maxCompWidth) {
                        this.maxCompWidth = this.compWidth[n];
                    }
                    ++n;
                }
            }
            return this.maxCompWidth;
        }

        public int getCompImgHeight(int n) {
            if (this.compHeight == null) {
                this.compHeight = new int[this.csiz];
                int n2 = 0;
                while (n2 < this.csiz) {
                    this.compHeight[n2] = (int)(Math.ceil((double)this.ysiz / (double)this.yrsiz[n2]) - Math.ceil((double)this.y0siz / (double)this.yrsiz[n2]));
                    ++n2;
                }
            }
            return this.compHeight[n];
        }

        public int getMaxCompHeight() {
            int n;
            if (this.compHeight == null) {
                this.compHeight = new int[this.csiz];
                n = 0;
                while (n < this.csiz) {
                    this.compHeight[n] = (int)(Math.ceil((double)this.ysiz / (double)this.yrsiz[n]) - Math.ceil((double)this.y0siz / (double)this.yrsiz[n]));
                    ++n;
                }
            }
            if (this.maxCompHeight == -1) {
                n = 0;
                while (n < this.csiz) {
                    if (this.compHeight[n] != this.maxCompHeight) {
                        this.maxCompHeight = this.compHeight[n];
                    }
                    ++n;
                }
            }
            return this.maxCompHeight;
        }

        public int getNumTiles() {
            if (this.numTiles == -1) {
                this.numTiles = (this.xsiz - this.xt0siz + this.xtsiz - 1) / this.xtsiz * ((this.ysiz - this.yt0siz + this.ytsiz - 1) / this.ytsiz);
            }
            return this.numTiles;
        }

        public boolean isOrigSigned(int n) {
            if (this.origSigned == null) {
                this.origSigned = new boolean[this.csiz];
                int n2 = 0;
                while (n2 < this.csiz) {
                    this.origSigned[n2] = this.ssiz[n2] >>> 7 == 1;
                    ++n2;
                }
            }
            return this.origSigned[n];
        }

        public int getOrigBitDepth(int n) {
            if (this.origBitDepth == null) {
                this.origBitDepth = new int[this.csiz];
                int n2 = 0;
                while (n2 < this.csiz) {
                    this.origBitDepth[n2] = (this.ssiz[n2] & 0x7F) + 1;
                    ++n2;
                }
            }
            return this.origBitDepth[n];
        }

        public SIZ getCopy() {
            SIZ sIZ = null;
            try {
                sIZ = (SIZ)this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new Error("Cannot clone SIZ marker segment");
            }
            return sIZ;
        }

        public String toString() {
            String string = "\n --- SIZ (" + this.lsiz + " bytes) ---\n";
            string = String.valueOf(string) + " Capabilities : " + this.rsiz + "\n";
            string = String.valueOf(string) + " Image dim.   : " + (this.xsiz - this.x0siz) + "x" + (this.ysiz - this.y0siz) + ", (off=" + this.x0siz + "," + this.y0siz + ")\n";
            string = String.valueOf(string) + " Tile dim.    : " + this.xtsiz + "x" + this.ytsiz + ", (off=" + this.xt0siz + "," + this.yt0siz + ")\n";
            string = String.valueOf(string) + " Component(s) : " + this.csiz + "\n";
            string = String.valueOf(string) + " Orig. depth  : ";
            int n = 0;
            while (n < this.csiz) {
                string = String.valueOf(string) + this.getOrigBitDepth(n) + " ";
                ++n;
            }
            string = String.valueOf(string) + "\n";
            string = String.valueOf(string) + " Orig. signed : ";
            n = 0;
            while (n < this.csiz) {
                string = String.valueOf(string) + this.isOrigSigned(n) + " ";
                ++n;
            }
            string = String.valueOf(string) + "\n";
            string = String.valueOf(string) + " Subs. factor : ";
            n = 0;
            while (n < this.csiz) {
                string = String.valueOf(string) + this.xrsiz[n] + "," + this.yrsiz[n] + " ";
                ++n;
            }
            string = String.valueOf(string) + "\n";
            return string;
        }
    }

    public class SOT {
        public int lsot;
        public int isot;
        public int psot;
        public int tpsot;
        public int tnsot;

        public String toString() {
            String string = "\n --- SOT (" + this.lsot + " bytes) ---\n";
            string = String.valueOf(string) + "Tile index         : " + this.isot + "\n";
            string = String.valueOf(string) + "Tile-part length   : " + this.psot + " bytes\n";
            string = String.valueOf(string) + "Tile-part index    : " + this.tpsot + "\n";
            string = String.valueOf(string) + "Num. of tile-parts : " + this.tnsot + "\n";
            string = String.valueOf(string) + "\n";
            return string;
        }
    }
}

