/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai.tilecodec;

import com.sun.media.jai.tilecodec.TileCodecUtils;
import java.awt.image.SampleModel;
import java.io.InputStream;
import javax.media.jai.ParameterListDescriptor;
import javax.media.jai.tilecodec.JaiI18N;
import javax.media.jai.tilecodec.TileCodecDescriptor;
import javax.media.jai.tilecodec.TileCodecParameterList;
import javax.media.jai.tilecodec.TileDecoder;

public abstract class TileDecoderImpl
implements TileDecoder {
    protected String formatName;
    protected InputStream inputStream;
    protected TileCodecParameterList paramList;

    public TileDecoderImpl(String string, InputStream inputStream, TileCodecParameterList tileCodecParameterList) {
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("TileCodecDescriptorImpl0"));
        }
        if (inputStream == null) {
            throw new IllegalArgumentException(JaiI18N.getString("TileDecoderImpl0"));
        }
        TileCodecDescriptor tileCodecDescriptor = TileCodecUtils.getTileCodecDescriptor("tileDecoder", string);
        if (tileCodecParameterList == null) {
            tileCodecParameterList = tileCodecDescriptor.getDefaultParameters("tileDecoder");
        }
        if (tileCodecParameterList != null) {
            if (!tileCodecParameterList.getFormatName().equalsIgnoreCase(string)) {
                throw new IllegalArgumentException(JaiI18N.getString("TileDecoderImpl1"));
            }
            if (!tileCodecParameterList.isValidForMode("tileDecoder")) {
                throw new IllegalArgumentException(JaiI18N.getString("TileDecoderImpl2"));
            }
            if (!tileCodecParameterList.getParameterListDescriptor().equals(tileCodecDescriptor.getParameterListDescriptor("tileDecoder"))) {
                throw new IllegalArgumentException(JaiI18N.getString("TileCodec0"));
            }
            SampleModel sampleModel = null;
            if (!tileCodecDescriptor.includesSampleModelInfo()) {
                try {
                    sampleModel = (SampleModel)tileCodecParameterList.getObjectParameter("sampleModel");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new IllegalArgumentException(JaiI18N.getString("TileDecoderImpl3"));
                }
                if ((sampleModel == null || sampleModel == ParameterListDescriptor.NO_PARAMETER_DEFAULT) && tileCodecDescriptor.getParameterListDescriptor("tileDecoder").getParamDefaultValue("sampleModel") == null) {
                    throw new IllegalArgumentException(JaiI18N.getString("TileDecoderImpl4"));
                }
            }
        } else {
            ParameterListDescriptor parameterListDescriptor = tileCodecDescriptor.getParameterListDescriptor("tileDecoder");
            if (!tileCodecDescriptor.includesSampleModelInfo()) {
                throw new IllegalArgumentException(JaiI18N.getString("TileDecoderImpl5"));
            }
            if (parameterListDescriptor != null && parameterListDescriptor.getNumParameters() != 0) {
                throw new IllegalArgumentException(JaiI18N.getString("TileDecoderImpl6"));
            }
        }
        this.formatName = string;
        this.inputStream = inputStream;
        this.paramList = tileCodecParameterList;
    }

    @Override
    public String getFormatName() {
        return this.formatName;
    }

    @Override
    public TileCodecParameterList getDecodeParameterList() {
        return this.paramList;
    }

    @Override
    public InputStream getInputStream() {
        return this.inputStream;
    }
}

