/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai.remote;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.media.jai.remote.JaiI18N;
import javax.media.jai.remote.Negotiable;
import javax.media.jai.util.Range;

public class NegotiableNumericRange
implements Negotiable {
    private Range range;

    public NegotiableNumericRange(Range range) {
        if (range == null) {
            throw new IllegalArgumentException(JaiI18N.getString("NegotiableNumericRange0"));
        }
        if (!Number.class.isAssignableFrom(range.getElementClass())) {
            throw new IllegalArgumentException(JaiI18N.getString("NegotiableNumericRange1"));
        }
        this.range = range;
    }

    public Range getRange() {
        if (this.range.isEmpty()) {
            return null;
        }
        return this.range;
    }

    @Override
    public Negotiable negotiate(Negotiable negotiable) {
        if (negotiable == null) {
            return null;
        }
        if (!(negotiable instanceof NegotiableNumericRange)) {
            return null;
        }
        NegotiableNumericRange negotiableNumericRange = (NegotiableNumericRange)negotiable;
        Range range = negotiableNumericRange.getRange();
        if (range == null) {
            return null;
        }
        if (range.getElementClass() != this.range.getElementClass()) {
            return null;
        }
        Range range2 = this.range.intersect(range);
        if (range2.isEmpty()) {
            return null;
        }
        return new NegotiableNumericRange(range2);
    }

    @Override
    public Object getNegotiatedValue() {
        if (this.range.isEmpty()) {
            return null;
        }
        Number number = (Number)((Object)this.range.getMinValue());
        if (number == null) {
            Number number2 = (Number)((Object)this.range.getMaxValue());
            if (number2 == null) {
                Class clazz = this.range.getElementClass();
                if (clazz == Byte.class) {
                    return new Byte(0);
                }
                if (clazz == Short.class) {
                    return new Short(0);
                }
                if (clazz == Integer.class) {
                    return new Integer(0);
                }
                if (clazz == Long.class) {
                    return new Long(0L);
                }
                if (clazz == Float.class) {
                    return new Float(0.0f);
                }
                if (clazz == Double.class) {
                    return new Double(0.0);
                }
                if (clazz == BigInteger.class) {
                    return BigInteger.ZERO;
                }
                if (clazz == BigDecimal.class) {
                    return new BigDecimal(BigInteger.ZERO);
                }
            } else {
                return number2;
            }
        }
        return number;
    }

    @Override
    public Class getNegotiatedValueClass() {
        return this.range.getElementClass();
    }
}

