/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai.remote;

import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.media.jai.remote.JaiI18N;
import javax.media.jai.remote.Negotiable;

public class NegotiableCollection
implements Negotiable {
    private Vector elements;
    private Class elementClass;

    public NegotiableCollection(Collection collection) {
        Object e;
        if (collection == null) {
            throw new IllegalArgumentException(JaiI18N.getString("NegotiableCollection0"));
        }
        this.elements = new Vector();
        Iterator iterator = collection.iterator();
        if (iterator.hasNext()) {
            e = iterator.next();
            this.elements.add(e);
            this.elementClass = e.getClass();
        }
        while (iterator.hasNext()) {
            e = iterator.next();
            if (e.getClass() != this.elementClass) {
                throw new IllegalArgumentException(JaiI18N.getString("NegotiableCollection1"));
            }
            this.elements.add(e);
        }
    }

    public NegotiableCollection(Object[] objectArray) {
        if (objectArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("NegotiableCollection0"));
        }
        int n = objectArray.length;
        if (n != 0) {
            this.elementClass = objectArray[0].getClass();
        }
        this.elements = new Vector(n);
        int n2 = 0;
        while (n2 < n) {
            if (objectArray[n2].getClass() != this.elementClass) {
                throw new IllegalArgumentException(JaiI18N.getString("NegotiableCollection1"));
            }
            this.elements.add(objectArray[n2]);
            ++n2;
        }
    }

    public Collection getCollection() {
        if (this.elements.isEmpty()) {
            return null;
        }
        return this.elements;
    }

    @Override
    public Negotiable negotiate(Negotiable negotiable) {
        if (negotiable == null) {
            return null;
        }
        if (!(negotiable instanceof NegotiableCollection) || negotiable.getNegotiatedValueClass() != this.elementClass) {
            return null;
        }
        Vector vector = new Vector();
        Collection collection = ((NegotiableCollection)negotiable).getCollection();
        if (collection == null) {
            return null;
        }
        for (Object e : this.elements) {
            if (!collection.contains(e) || vector.contains(e)) continue;
            vector.add(e);
        }
        if (vector.isEmpty()) {
            return null;
        }
        return new NegotiableCollection(vector);
    }

    @Override
    public Object getNegotiatedValue() {
        if (this.elements != null && this.elements.size() > 0) {
            return this.elements.elementAt(0);
        }
        return null;
    }

    @Override
    public Class getNegotiatedValueClass() {
        return this.elementClass;
    }
}

