/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai.operator;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderableImage;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderableOp;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.JaiI18N;

public class PiecewiseDescriptor
extends OperationDescriptorImpl {
    private static final String[][] resources = new String[][]{{"GlobalName", "Piecewise"}, {"LocalName", "Piecewise"}, {"Vendor", "com.sun.media.jai"}, {"Description", JaiI18N.getString("PiecewiseDescriptor0")}, {"DocURL", "http://java.sun.com/products/java-media/jai/forDevelopers/jai-apidocs/javax/media/jai/operator/PiecewiseDescriptor.html"}, {"Version", JaiI18N.getString("DescriptorVersion")}, {"arg0Desc", "The breakpoint array."}};
    private static final Class[] paramClasses = new Class[]{float[][][].class};
    private static final String[] paramNames = new String[]{"breakPoints"};
    private static final Object[] paramDefaults = new Object[]{new float[][][]{new float[][]{{0.0f, 255.0f}, {0.0f, 255.0f}}}};
    private static final String[] supportedModes = new String[]{"rendered", "renderable"};

    public PiecewiseDescriptor() {
        super(resources, supportedModes, 1, paramNames, paramClasses, paramDefaults, null);
    }

    @Override
    public boolean validateArguments(String string, ParameterBlock parameterBlock, StringBuffer stringBuffer) {
        if (!super.validateArguments(string, parameterBlock, stringBuffer)) {
            return false;
        }
        if (!string.equalsIgnoreCase("rendered")) {
            return true;
        }
        RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
        float[][][] fArray = (float[][][])parameterBlock.getObjectParameter(0);
        if (fArray.length != 1 && fArray.length != renderedImage.getSampleModel().getNumBands()) {
            stringBuffer.append(String.valueOf(this.getName()) + " " + JaiI18N.getString("PiecewiseDescriptor1"));
            return false;
        }
        int n = fArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (fArray[n2].length != 2) {
                stringBuffer.append(String.valueOf(this.getName()) + " " + JaiI18N.getString("PiecewiseDescriptor2"));
                return false;
            }
            if (fArray[n2][0].length != fArray[n2][1].length) {
                stringBuffer.append(String.valueOf(this.getName()) + " " + JaiI18N.getString("PiecewiseDescriptor3"));
                return false;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            int n3 = fArray[n2][0].length - 1;
            float[] fArray2 = fArray[n2][0];
            int n4 = 0;
            while (n4 < n3) {
                if (fArray2[n4] >= fArray2[n4 + 1]) {
                    stringBuffer.append(String.valueOf(this.getName()) + " " + JaiI18N.getString("PiecewiseDescriptor4"));
                    return false;
                }
                ++n4;
            }
            ++n2;
        }
        return true;
    }

    public static RenderedOp create(RenderedImage renderedImage, float[][][] fArray, RenderingHints renderingHints) {
        ParameterBlockJAI parameterBlockJAI = new ParameterBlockJAI("Piecewise", "rendered");
        parameterBlockJAI.setSource("source0", renderedImage);
        parameterBlockJAI.setParameter("breakPoints", fArray);
        return JAI.create("Piecewise", parameterBlockJAI, renderingHints);
    }

    public static RenderableOp createRenderable(RenderableImage renderableImage, float[][][] fArray, RenderingHints renderingHints) {
        ParameterBlockJAI parameterBlockJAI = new ParameterBlockJAI("Piecewise", "renderable");
        parameterBlockJAI.setSource("source0", renderableImage);
        parameterBlockJAI.setParameter("breakPoints", fArray);
        return JAI.createRenderable("Piecewise", parameterBlockJAI, renderingHints);
    }
}

