/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai.operator;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderableImage;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderableOp;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.JaiI18N;

public class OverlayDescriptor
extends OperationDescriptorImpl {
    private static final String[][] resources = new String[][]{{"GlobalName", "Overlay"}, {"LocalName", "Overlay"}, {"Vendor", "com.sun.media.jai"}, {"Description", JaiI18N.getString("OverlayDescriptor0")}, {"DocURL", "http://java.sun.com/products/java-media/jai/forDevelopers/jai-apidocs/javax/media/jai/operator/OverlayDescriptor.html"}, {"Version", JaiI18N.getString("DescriptorVersion")}};
    private static final String[] supportedModes = new String[]{"rendered", "renderable"};

    public OverlayDescriptor() {
        super(resources, supportedModes, 2, null, null, null, null);
    }

    @Override
    protected boolean validateSources(String string, ParameterBlock parameterBlock, StringBuffer stringBuffer) {
        if (!super.validateSources(string, parameterBlock, stringBuffer)) {
            return false;
        }
        if (!string.equalsIgnoreCase("rendered")) {
            return true;
        }
        RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
        RenderedImage renderedImage2 = parameterBlock.getRenderedSource(1);
        SampleModel sampleModel = renderedImage.getSampleModel();
        SampleModel sampleModel2 = renderedImage2.getSampleModel();
        if (sampleModel.getNumBands() != sampleModel2.getNumBands() || sampleModel.getTransferType() != sampleModel2.getTransferType()) {
            stringBuffer.append(String.valueOf(this.getName()) + " " + JaiI18N.getString("OverlayDescriptor1"));
            return false;
        }
        return true;
    }

    public static RenderedOp create(RenderedImage renderedImage, RenderedImage renderedImage2, RenderingHints renderingHints) {
        ParameterBlockJAI parameterBlockJAI = new ParameterBlockJAI("Overlay", "rendered");
        parameterBlockJAI.setSource("source0", renderedImage);
        parameterBlockJAI.setSource("source1", renderedImage2);
        return JAI.create("Overlay", parameterBlockJAI, renderingHints);
    }

    public static RenderableOp createRenderable(RenderableImage renderableImage, RenderableImage renderableImage2, RenderingHints renderingHints) {
        ParameterBlockJAI parameterBlockJAI = new ParameterBlockJAI("Overlay", "renderable");
        parameterBlockJAI.setSource("source0", renderableImage);
        parameterBlockJAI.setSource("source1", renderableImage2);
        return JAI.createRenderable("Overlay", parameterBlockJAI, renderingHints);
    }
}

