/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai.operator;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderableImage;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderableOp;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.JaiI18N;

public class NotDescriptor
extends OperationDescriptorImpl {
    private static final String[][] resources = new String[][]{{"GlobalName", "Not"}, {"LocalName", "Not"}, {"Vendor", "com.sun.media.jai"}, {"Description", JaiI18N.getString("NotDescriptor0")}, {"DocURL", "http://java.sun.com/products/java-media/jai/forDevelopers/jai-apidocs/javax/media/jai/operator/NotDescriptor.html"}, {"Version", JaiI18N.getString("DescriptorVersion")}};
    private static final String[] supportedModes = new String[]{"rendered", "renderable"};

    public NotDescriptor() {
        super(resources, supportedModes, 1, null, null, null, null);
    }

    @Override
    protected boolean validateSources(String string, ParameterBlock parameterBlock, StringBuffer stringBuffer) {
        if (!super.validateSources(string, parameterBlock, stringBuffer)) {
            return false;
        }
        if (!string.equalsIgnoreCase("rendered")) {
            return true;
        }
        RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
        int n = renderedImage.getSampleModel().getDataType();
        if (n != 0 && n != 1 && n != 2 && n != 3) {
            stringBuffer.append(String.valueOf(this.getName()) + " " + JaiI18N.getString("NotDescriptor1"));
            return false;
        }
        return true;
    }

    public static RenderedOp create(RenderedImage renderedImage, RenderingHints renderingHints) {
        ParameterBlockJAI parameterBlockJAI = new ParameterBlockJAI("Not", "rendered");
        parameterBlockJAI.setSource("source0", renderedImage);
        return JAI.create("Not", parameterBlockJAI, renderingHints);
    }

    public static RenderableOp createRenderable(RenderableImage renderableImage, RenderingHints renderingHints) {
        ParameterBlockJAI parameterBlockJAI = new ParameterBlockJAI("Not", "renderable");
        parameterBlockJAI.setSource("source0", renderableImage);
        return JAI.createRenderable("Not", parameterBlockJAI, renderingHints);
    }
}

