/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai.operator;

import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderableImage;
import javax.media.jai.Histogram;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderableOp;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.JaiI18N;

public class MatchCDFDescriptor
extends OperationDescriptorImpl {
    private static final String[][] resources = new String[][]{{"GlobalName", "MatchCDF"}, {"LocalName", "MatchCDF"}, {"Vendor", "com.sun.media.jai"}, {"Description", JaiI18N.getString("MatchCDFDescriptor0")}, {"DocURL", "http://java.sun.com/products/java-media/jai/forDevelopers/jai-apidocs/javax/media/jai/operator/MatchCDFDescriptor.html"}, {"Version", JaiI18N.getString("DescriptorVersion")}, {"arg0Desc", "The desired Cumulative Distribution Function."}};
    private static final Class[] paramClasses = new Class[]{float[][].class};
    private static final String[] paramNames = new String[]{"CDF"};
    private static final Object[] paramDefaults = new Object[1];
    private static final String[] supportedModes = new String[]{"rendered", "renderable"};

    public MatchCDFDescriptor() {
        super(resources, supportedModes, 1, paramNames, paramClasses, paramDefaults, null);
    }

    @Override
    public boolean validateArguments(String string, ParameterBlock parameterBlock, StringBuffer stringBuffer) {
        int n;
        if (!super.validateArguments(string, parameterBlock, stringBuffer)) {
            return false;
        }
        if (!string.equalsIgnoreCase("rendered")) {
            return true;
        }
        RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
        Object object = (float[][])parameterBlock.getObjectParameter(0);
        Object object2 = renderedImage.getProperty("histogram");
        if (object2 == null || object2.equals(Image.UndefinedProperty)) {
            stringBuffer.append(String.valueOf(this.getName()) + " " + JaiI18N.getString("MatchCDFDescriptor1"));
            return false;
        }
        if (!(object2 instanceof Histogram)) {
            stringBuffer.append(String.valueOf(this.getName()) + " " + JaiI18N.getString("MatchCDFDescriptor2"));
            return false;
        }
        Histogram histogram = (Histogram)object2;
        int n2 = histogram.getNumBands();
        if (object == null) {
            int[] nArray = histogram.getNumBins();
            object = new float[n2][];
            int n3 = 0;
            while (n3 < n2) {
                object[n3] = new float[nArray[n3]];
                n = 0;
                while (n < nArray[n3]) {
                    object[n3][n] = (n + 1) / nArray[n3];
                    ++n;
                }
                ++n3;
            }
        }
        if (((float[][])object).length != n2) {
            stringBuffer.append(String.valueOf(this.getName()) + " " + JaiI18N.getString("MatchCDFDescriptor3"));
            return false;
        }
        int n4 = 0;
        while (n4 < n2) {
            if (object[n4].length != histogram.getNumBins(n4)) {
                stringBuffer.append(String.valueOf(this.getName()) + " " + JaiI18N.getString("MatchCDFDescriptor4"));
                return false;
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < n2) {
            float[] fArray = object[n4];
            n = fArray.length;
            if ((double)fArray[n - 1] != 1.0) {
                stringBuffer.append(String.valueOf(this.getName()) + " " + JaiI18N.getString("MatchCDFDescriptor7"));
                return false;
            }
            int n5 = 0;
            while (n5 < n) {
                if (fArray[n5] < 0.0f) {
                    stringBuffer.append(String.valueOf(this.getName()) + " " + JaiI18N.getString("MatchCDFDescriptor5"));
                    return false;
                }
                if (n5 != 0 && fArray[n5] < fArray[n5 - 1]) {
                    stringBuffer.append(String.valueOf(this.getName()) + " " + JaiI18N.getString("MatchCDFDescriptor6"));
                    return false;
                }
                ++n5;
            }
            ++n4;
        }
        return true;
    }

    public static RenderedOp create(RenderedImage renderedImage, float[][] fArray, RenderingHints renderingHints) {
        ParameterBlockJAI parameterBlockJAI = new ParameterBlockJAI("MatchCDF", "rendered");
        parameterBlockJAI.setSource("source0", renderedImage);
        parameterBlockJAI.setParameter("CDF", fArray);
        return JAI.create("MatchCDF", parameterBlockJAI, renderingHints);
    }

    public static RenderableOp createRenderable(RenderableImage renderableImage, float[][] fArray, RenderingHints renderingHints) {
        ParameterBlockJAI parameterBlockJAI = new ParameterBlockJAI("MatchCDF", "renderable");
        parameterBlockJAI.setSource("source0", renderableImage);
        parameterBlockJAI.setParameter("CDF", fArray);
        return JAI.createRenderable("MatchCDF", parameterBlockJAI, renderingHints);
    }
}

