/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai.operator;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationBicubic;
import javax.media.jai.InterpolationBicubic2;
import javax.media.jai.InterpolationBilinear;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.JaiI18N;

public class FilteredSubsampleDescriptor
extends OperationDescriptorImpl {
    private static final String[][] resources = new String[][]{{"GlobalName", "FilteredSubsample"}, {"LocalName", "FilteredSubsample"}, {"Vendor", "com.sun.media.jai"}, {"Description", JaiI18N.getString("FilteredSubsampleDescriptor0")}, {"DocURL", "http://java.sun.com/products/java-media/jai/forDevelopers/jai-apidocs/javax/media/jai/operator/FilteredSubsampleDescriptor.html"}, {"Version", "1.0"}, {"arg0Desc", "The X subsample factor."}, {"arg1Desc", "The Y subsample factor."}, {"arg2Desc", "Symmetric filter coefficients."}, {"arg3Desc", "Interpolation object."}};
    private static final Class[] paramClasses = new Class[]{Integer.class, Integer.class, float[].class, Interpolation.class};
    private static final String[] paramNames = new String[]{"scaleX", "scaleY", "qsFilterArray", "interpolation"};
    private static final Object[] paramDefaults;
    private static final String[] supportedModes;

    static {
        Object[] objectArray = new Object[4];
        objectArray[0] = new Integer(2);
        objectArray[1] = new Integer(2);
        objectArray[3] = Interpolation.getInstance(0);
        paramDefaults = objectArray;
        supportedModes = new String[]{"rendered"};
    }

    public FilteredSubsampleDescriptor() {
        super(resources, supportedModes, 1, paramNames, paramClasses, paramDefaults, null);
    }

    @Override
    protected boolean validateParameters(String string, ParameterBlock parameterBlock, StringBuffer stringBuffer) {
        Interpolation interpolation;
        if (!super.validateParameters(string, parameterBlock, stringBuffer)) {
            return false;
        }
        int n = parameterBlock.getIntParameter(0);
        int n2 = parameterBlock.getIntParameter(1);
        if (n < 1 || n2 < 1) {
            stringBuffer.append(String.valueOf(this.getName()) + " " + JaiI18N.getString("FilteredSubsampleDescriptor1"));
            return false;
        }
        float[] fArray = (float[])parameterBlock.getObjectParameter(2);
        if (fArray == null) {
            int n3;
            int n4 = n3 = n > n2 ? n : n2;
            if ((n3 & 1) == 0) {
                ++n3;
            }
            double d = (double)(n3 - 1) / 6.0;
            if (n3 == 1) {
                d = 1.0;
            }
            fArray = new float[n3 / 2 + 1];
            float f = 0.0f;
            int n5 = 0;
            while (n5 < fArray.length) {
                fArray[n5] = (float)this.gaussian(n5, d);
                f = n5 == 0 ? (f += fArray[n5]) : (f += fArray[n5] * 2.0f);
                ++n5;
            }
            n5 = 0;
            while (n5 < fArray.length) {
                int n6 = n5++;
                fArray[n6] = fArray[n6] / f;
            }
            parameterBlock.set(fArray, 2);
        }
        if (!((interpolation = (Interpolation)parameterBlock.getObjectParameter(3)) instanceof InterpolationNearest || interpolation instanceof InterpolationBilinear || interpolation instanceof InterpolationBicubic || interpolation instanceof InterpolationBicubic2)) {
            stringBuffer.append(String.valueOf(this.getName()) + " " + JaiI18N.getString("FilteredSubsampleDescriptor2"));
            return false;
        }
        return true;
    }

    private double gaussian(double d, double d2) {
        return Math.exp(-d * d / (2.0 * d2 * d2)) / d2 / Math.sqrt(Math.PI * 2);
    }

    public static RenderedOp create(RenderedImage renderedImage, Integer n, Integer n2, float[] fArray, Interpolation interpolation, RenderingHints renderingHints) {
        ParameterBlockJAI parameterBlockJAI = new ParameterBlockJAI("FilteredSubsample", "rendered");
        parameterBlockJAI.setSource("source0", renderedImage);
        parameterBlockJAI.setParameter("scaleX", n);
        parameterBlockJAI.setParameter("scaleY", n2);
        parameterBlockJAI.setParameter("qsFilterArray", fArray);
        parameterBlockJAI.setParameter("interpolation", interpolation);
        return JAI.create("FilteredSubsample", parameterBlockJAI, renderingHints);
    }
}

