/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai.operator;

import com.sun.media.jai.codec.ImageDecodeParam;
import java.awt.RenderingHints;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.InputStream;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.JaiI18N;

public class FileLoadDescriptor
extends OperationDescriptorImpl {
    private static final String[][] resources = new String[][]{{"GlobalName", "FileLoad"}, {"LocalName", "FileLoad"}, {"Vendor", "com.sun.media.jai"}, {"Description", JaiI18N.getString("FileLoadDescriptor0")}, {"DocURL", "http://java.sun.com/products/java-media/jai/forDevelopers/jai-apidocs/javax/media/jai/operator/FileLoadDescriptor.html"}, {"Version", JaiI18N.getString("DescriptorVersion")}, {"arg0Desc", JaiI18N.getString("FileLoadDescriptor1")}, {"arg1Desc", JaiI18N.getString("FileLoadDescriptor4")}, {"arg2Desc", JaiI18N.getString("FileLoadDescriptor5")}};
    private static final String[] paramNames = new String[]{"filename", "param", "checkFileLocally"};
    private static final Class[] paramClasses = new Class[]{String.class, ImageDecodeParam.class, Boolean.class};
    private static final Object[] paramDefaults;

    static {
        Object[] objectArray = new Object[3];
        objectArray[0] = NO_PARAMETER_DEFAULT;
        objectArray[2] = Boolean.TRUE;
        paramDefaults = objectArray;
    }

    public FileLoadDescriptor() {
        super(resources, 0, paramClasses, paramNames, paramDefaults);
    }

    @Override
    protected boolean validateParameters(ParameterBlock parameterBlock, StringBuffer stringBuffer) {
        if (!super.validateParameters(parameterBlock, stringBuffer)) {
            return false;
        }
        Boolean bl = (Boolean)parameterBlock.getObjectParameter(2);
        if (bl.booleanValue()) {
            String string = (String)parameterBlock.getObjectParameter(0);
            File file = new File(string);
            boolean bl2 = file.exists();
            if (!bl2) {
                InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(string);
                if (inputStream == null) {
                    stringBuffer.append("\"" + string + "\": " + JaiI18N.getString("FileLoadDescriptor2"));
                    return false;
                }
            } else if (!file.canRead()) {
                stringBuffer.append("\"" + string + "\": " + JaiI18N.getString("FileLoadDescriptor3"));
                return false;
            }
        }
        return true;
    }

    public static RenderedOp create(String string, ImageDecodeParam imageDecodeParam, Boolean bl, RenderingHints renderingHints) {
        ParameterBlockJAI parameterBlockJAI = new ParameterBlockJAI("FileLoad", "rendered");
        parameterBlockJAI.setParameter("filename", string);
        parameterBlockJAI.setParameter("param", imageDecodeParam);
        parameterBlockJAI.setParameter("checkFileLocally", bl);
        return JAI.create("FileLoad", parameterBlockJAI, renderingHints);
    }
}

