/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai.operator;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderableImage;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderableOp;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.JaiI18N;

public class CropDescriptor
extends OperationDescriptorImpl {
    private static final String[][] resources = new String[][]{{"GlobalName", "Crop"}, {"LocalName", "Crop"}, {"Vendor", "com.sun.media.jai"}, {"Description", JaiI18N.getString("CropDescriptor0")}, {"DocURL", "http://java.sun.com/products/java-media/jai/forDevelopers/jai-apidocs/javax/media/jai/operator/CropDescriptor.html"}, {"Version", JaiI18N.getString("DescriptorVersion")}, {"arg0Desc", JaiI18N.getString("CropDescriptor1")}, {"arg1Desc", JaiI18N.getString("CropDescriptor2")}, {"arg2Desc", JaiI18N.getString("CropDescriptor3")}, {"arg3Desc", JaiI18N.getString("CropDescriptor4")}};
    private static final Class[] paramClasses = new Class[]{Float.class, Float.class, Float.class, Float.class};
    private static final String[] paramNames = new String[]{"x", "y", "width", "height"};
    private static final Object[] paramDefaults = new Object[]{NO_PARAMETER_DEFAULT, NO_PARAMETER_DEFAULT, NO_PARAMETER_DEFAULT, NO_PARAMETER_DEFAULT};
    private static final String[] supportedModes = new String[]{"rendered", "renderable"};

    public CropDescriptor() {
        super(resources, supportedModes, 1, paramNames, paramClasses, paramDefaults, null);
    }

    @Override
    public boolean validateArguments(String string, ParameterBlock parameterBlock, StringBuffer stringBuffer) {
        if (!super.validateArguments(string, parameterBlock, stringBuffer)) {
            return false;
        }
        if (string.equalsIgnoreCase("rendered")) {
            return this.validateRenderedArgs(parameterBlock, stringBuffer);
        }
        if (string.equalsIgnoreCase("renderable")) {
            return this.validateRenderableArgs(parameterBlock, stringBuffer);
        }
        return true;
    }

    private boolean validateRenderedArgs(ParameterBlock parameterBlock, StringBuffer stringBuffer) {
        float f;
        float f2;
        float f3;
        float f4 = parameterBlock.getFloatParameter(0);
        Rectangle rectangle = new Rectangle2D.Float(f4, f3 = parameterBlock.getFloatParameter(1), f2 = parameterBlock.getFloatParameter(2), f = parameterBlock.getFloatParameter(3)).getBounds();
        if (rectangle.isEmpty()) {
            stringBuffer.append(String.valueOf(this.getName()) + " " + JaiI18N.getString("CropDescriptor5"));
            return false;
        }
        RenderedImage renderedImage = (RenderedImage)parameterBlock.getSource(0);
        Rectangle rectangle2 = new Rectangle(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight());
        if (!rectangle2.contains(rectangle)) {
            stringBuffer.append(String.valueOf(this.getName()) + " " + JaiI18N.getString("CropDescriptor6"));
            return false;
        }
        return true;
    }

    private boolean validateRenderableArgs(ParameterBlock parameterBlock, StringBuffer stringBuffer) {
        float f;
        float f2;
        float f3;
        float f4 = parameterBlock.getFloatParameter(0);
        Rectangle2D.Float float_ = new Rectangle2D.Float(f4, f3 = parameterBlock.getFloatParameter(1), f2 = parameterBlock.getFloatParameter(2), f = parameterBlock.getFloatParameter(3));
        if (((RectangularShape)float_).isEmpty()) {
            stringBuffer.append(String.valueOf(this.getName()) + " " + JaiI18N.getString("CropDescriptor5"));
            return false;
        }
        RenderableImage renderableImage = (RenderableImage)parameterBlock.getSource(0);
        Rectangle2D.Float float_2 = new Rectangle2D.Float(renderableImage.getMinX(), renderableImage.getMinY(), renderableImage.getWidth(), renderableImage.getHeight());
        if (!float_2.contains(float_)) {
            stringBuffer.append(String.valueOf(this.getName()) + " " + JaiI18N.getString("CropDescriptor6"));
            return false;
        }
        return true;
    }

    public static RenderedOp create(RenderedImage renderedImage, Float f, Float f2, Float f3, Float f4, RenderingHints renderingHints) {
        ParameterBlockJAI parameterBlockJAI = new ParameterBlockJAI("Crop", "rendered");
        parameterBlockJAI.setSource("source0", renderedImage);
        parameterBlockJAI.setParameter("x", f);
        parameterBlockJAI.setParameter("y", f2);
        parameterBlockJAI.setParameter("width", f3);
        parameterBlockJAI.setParameter("height", f4);
        return JAI.create("Crop", parameterBlockJAI, renderingHints);
    }

    public static RenderableOp createRenderable(RenderableImage renderableImage, Float f, Float f2, Float f3, Float f4, RenderingHints renderingHints) {
        ParameterBlockJAI parameterBlockJAI = new ParameterBlockJAI("Crop", "renderable");
        parameterBlockJAI.setSource("source0", renderableImage);
        parameterBlockJAI.setParameter("x", f);
        parameterBlockJAI.setParameter("y", f2);
        parameterBlockJAI.setParameter("width", f3);
        parameterBlockJAI.setParameter("height", f4);
        return JAI.createRenderable("Crop", parameterBlockJAI, renderingHints);
    }
}

