/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai.operator;

import java.awt.RenderingHints;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderableOp;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.JaiI18N;
import javax.media.jai.util.Range;

public class ConstantDescriptor
extends OperationDescriptorImpl {
    private static final String[][] resources = new String[][]{{"GlobalName", "Constant"}, {"LocalName", "Constant"}, {"Vendor", "com.sun.media.jai"}, {"Description", JaiI18N.getString("ConstantDescriptor0")}, {"DocURL", "http://java.sun.com/products/java-media/jai/forDevelopers/jai-apidocs/javax/media/jai/operator/ConstantDescriptor.html"}, {"Version", JaiI18N.getString("DescriptorVersion")}, {"arg0Desc", JaiI18N.getString("ConstantDescriptor1")}, {"arg1Desc", JaiI18N.getString("ConstantDescriptor2")}, {"arg2Desc", JaiI18N.getString("ConstantDescriptor3")}};
    private static final Class[] paramClasses = new Class[]{Float.class, Float.class, Number[].class};
    private static final String[] paramNames = new String[]{"width", "height", "bandValues"};
    private static final Object[] paramDefaults = new Object[]{NO_PARAMETER_DEFAULT, NO_PARAMETER_DEFAULT, NO_PARAMETER_DEFAULT};
    private static final String[] supportedModes = new String[]{"rendered", "renderable"};
    private static final Object[] validParamValues;

    static {
        Object[] objectArray = new Object[3];
        objectArray[0] = new Range(Float.class, new Float(0.0f), false, null, false);
        objectArray[1] = new Range(Float.class, new Float(0.0f), false, null, false);
        validParamValues = objectArray;
    }

    public ConstantDescriptor() {
        super(resources, supportedModes, 0, paramNames, paramClasses, paramDefaults, validParamValues);
    }

    @Override
    protected boolean validateParameters(String string, ParameterBlock parameterBlock, StringBuffer stringBuffer) {
        if (!super.validateParameters(string, parameterBlock, stringBuffer)) {
            return false;
        }
        int n = ((Number[])parameterBlock.getObjectParameter(2)).length;
        if (n < 1) {
            stringBuffer.append(String.valueOf(this.getName()) + " " + JaiI18N.getString("ConstantDescriptor4"));
            return false;
        }
        if (string.equalsIgnoreCase("rendered")) {
            int n2 = Math.round(parameterBlock.getFloatParameter(0));
            int n3 = Math.round(parameterBlock.getFloatParameter(1));
            if (n2 < 1 || n3 < 1) {
                stringBuffer.append(String.valueOf(this.getName()) + " " + JaiI18N.getString("ConstantDescriptor5"));
                return false;
            }
        } else if (string.equalsIgnoreCase("renderable")) {
            float f = parameterBlock.getFloatParameter(0);
            float f2 = parameterBlock.getFloatParameter(1);
            if (f <= 0.0f || f2 <= 0.0f) {
                stringBuffer.append(String.valueOf(this.getName()) + " " + JaiI18N.getString("ConstantDescriptor6"));
                return false;
            }
        }
        return true;
    }

    public static RenderedOp create(Float f, Float f2, Number[] numberArray, RenderingHints renderingHints) {
        ParameterBlockJAI parameterBlockJAI = new ParameterBlockJAI("Constant", "rendered");
        parameterBlockJAI.setParameter("width", f);
        parameterBlockJAI.setParameter("height", f2);
        parameterBlockJAI.setParameter("bandValues", numberArray);
        return JAI.create("Constant", parameterBlockJAI, renderingHints);
    }

    public static RenderableOp createRenderable(Float f, Float f2, Number[] numberArray, RenderingHints renderingHints) {
        ParameterBlockJAI parameterBlockJAI = new ParameterBlockJAI("Constant", "renderable");
        parameterBlockJAI.setParameter("width", f);
        parameterBlockJAI.setParameter("height", f2);
        parameterBlockJAI.setParameter("bandValues", numberArray);
        return JAI.createRenderable("Constant", parameterBlockJAI, renderingHints);
    }
}

